/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.TypeResult;
import com.oracle.svm.core.configure.ConfigurationConditionResolver;
import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.configure.LegacyReflectionConfigurationParser;
import com.oracle.svm.core.configure.NamedConfigurationTypeDescriptor;
import com.oracle.svm.core.configure.ReflectionConfigurationParserDelegate;
import com.oracle.svm.core.configure.ReflectionMetadataParser;
import com.oracle.svm.util.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.util.json.JSONParserException;

public abstract class ReflectionConfigurationParser<T>
extends ConfigurationParser {
    private static final String CONSTRUCTOR_NAME = "<init>";
    protected final ConfigurationConditionResolver conditionResolver;
    protected final ReflectionConfigurationParserDelegate<T> delegate;
    private final boolean printMissingElements;

    public ReflectionConfigurationParser(ConfigurationConditionResolver conditionResolver, ReflectionConfigurationParserDelegate<T> delegate, boolean strictConfiguration, boolean printMissingElements) {
        super(strictConfiguration);
        this.conditionResolver = conditionResolver;
        this.printMissingElements = printMissingElements;
        this.delegate = delegate;
    }

    public static <T> ReflectionConfigurationParser<T> create(String combinedFileKey, boolean strictMetadata, ReflectionConfigurationParserDelegate<T> delegate, boolean strictConfiguration, boolean printMissingElements) {
        if (strictMetadata) {
            return new ReflectionMetadataParser<T>(combinedFileKey, ConfigurationConditionResolver.identityResolver(), delegate, strictConfiguration, printMissingElements);
        }
        return new LegacyReflectionConfigurationParser<T>(ConfigurationConditionResolver.identityResolver(), delegate, strictConfiguration, printMissingElements, false);
    }

    protected void parseClassArray(List<Object> classes) {
        for (Object clazz : classes) {
            this.parseClass(ReflectionConfigurationParser.asMap(clazz, "second level of document must be class descriptor objects"));
        }
    }

    protected abstract void parseClass(EconomicMap<String, Object> var1);

    protected void registerIfNotDefault(EconomicMap<String, Object> data, boolean defaultValue, T clazz, String propertyName, Runnable register) {
        if (data.containsKey((Object)propertyName) ? ReflectionConfigurationParser.asBoolean(data.get((Object)propertyName), propertyName) : defaultValue) {
            try {
                register.run();
            }
            catch (LinkageError e) {
                this.handleMissingElement("Could not register " + this.delegate.getTypeName(clazz) + ": " + propertyName + " for reflection.", e);
            }
        }
    }

    protected void parseFields(ConfigurationCondition condition, List<Object> fields, T clazz) {
        for (Object field : fields) {
            this.parseField(condition, ReflectionConfigurationParser.asMap(field, "Elements of 'fields' array must be field descriptor objects"), clazz);
        }
    }

    private void parseField(ConfigurationCondition condition, EconomicMap<String, Object> data, T clazz) {
        this.checkAttributes(data, "reflection field descriptor object", Collections.singleton("name"), Arrays.asList("allowWrite", "allowUnsafeAccess"));
        String fieldName = ReflectionConfigurationParser.asString(data.get((Object)"name"), "name");
        boolean allowWrite = data.containsKey((Object)"allowWrite") && ReflectionConfigurationParser.asBoolean(data.get((Object)"allowWrite"), "allowWrite");
        try {
            this.delegate.registerField(condition, clazz, fieldName, allowWrite);
        }
        catch (NoSuchFieldException e) {
            this.handleMissingElement("Field " + this.formatField(clazz, fieldName) + " not found.");
        }
        catch (LinkageError e) {
            this.handleMissingElement("Could not register field " + this.formatField(clazz, fieldName) + " for reflection.", e);
        }
    }

    protected void parseMethods(ConfigurationCondition condition, boolean queriedOnly, List<Object> methods, T clazz) {
        for (Object method : methods) {
            this.parseMethod(condition, queriedOnly, ReflectionConfigurationParser.asMap(method, "Elements of 'methods' array must be method descriptor objects"), clazz);
        }
    }

    private void parseMethod(ConfigurationCondition condition, boolean queriedOnly, EconomicMap<String, Object> data, T clazz) {
        block10: {
            this.checkAttributes(data, "reflection method descriptor object", Collections.singleton("name"), Collections.singleton("parameterTypes"));
            String methodName = ReflectionConfigurationParser.asString(data.get((Object)"name"), "name");
            List<T> methodParameterTypes = null;
            Object parameterTypes = data.get((Object)"parameterTypes");
            if (parameterTypes != null && (methodParameterTypes = this.parseMethodParameters(clazz, methodName, ReflectionConfigurationParser.asList(parameterTypes, "Attribute 'parameterTypes' must be a list of type names"))) == null) {
                return;
            }
            boolean isConstructor = CONSTRUCTOR_NAME.equals(methodName);
            if (methodParameterTypes != null) {
                try {
                    if (isConstructor) {
                        this.delegate.registerConstructor(condition, queriedOnly, clazz, methodParameterTypes);
                        break block10;
                    }
                    this.delegate.registerMethod(condition, queriedOnly, clazz, methodName, methodParameterTypes);
                }
                catch (NoSuchMethodException e) {
                    this.handleMissingElement("Method " + this.formatMethod(clazz, methodName, methodParameterTypes) + " not found.");
                }
                catch (LinkageError e) {
                    this.handleMissingElement("Could not register method " + this.formatMethod(clazz, methodName, methodParameterTypes) + " for reflection.", e);
                }
            } else {
                try {
                    boolean found = isConstructor ? this.delegate.registerAllConstructors(condition, queriedOnly, clazz) : this.delegate.registerAllMethodsWithName(condition, queriedOnly, clazz, methodName);
                    if (!found) {
                        throw new JSONParserException("Method " + this.formatMethod(clazz, methodName) + " not found");
                    }
                }
                catch (LinkageError e) {
                    this.handleMissingElement("Could not register method " + this.formatMethod(clazz, methodName) + " for reflection.", e);
                }
            }
        }
    }

    private List<T> parseMethodParameters(T clazz, String methodName, List<Object> types) {
        ArrayList<T> result = new ArrayList<T>();
        for (Object type : types) {
            String typeName = ReflectionConfigurationParser.asString(type, "types");
            TypeResult<T> typeResult = this.delegate.resolveType(this.conditionResolver.alwaysTrue(), new NamedConfigurationTypeDescriptor(typeName), true);
            if (!typeResult.isPresent()) {
                this.handleMissingElement("Could not register method " + this.formatMethod(clazz, methodName) + " for reflection.", typeResult.getException());
                return null;
            }
            result.add(typeResult.get());
        }
        return result;
    }

    private static String formatError(Throwable e) {
        return e.getClass().getTypeName() + ": " + e.getMessage();
    }

    private String formatField(T clazz, String fieldName) {
        return this.delegate.getTypeName(clazz) + "." + fieldName;
    }

    private String formatMethod(T clazz, String methodName) {
        return this.formatMethod(clazz, methodName, Collections.emptyList());
    }

    private String formatMethod(T clazz, String methodName, List<T> paramTypes) {
        String parameterTypeNames = paramTypes.stream().map(this.delegate::getSimpleName).collect(Collectors.joining(", "));
        return this.delegate.getTypeName(clazz) + "." + methodName + "(" + parameterTypeNames + ")";
    }

    private void handleMissingElement(String message) {
        this.handleMissingElement(message, null);
    }

    protected void handleMissingElement(String msg, Throwable cause) {
        if (this.printMissingElements) {
            Object message = msg;
            if (cause != null) {
                message = (String)message + " Reason: " + ReflectionConfigurationParser.formatError(cause) + ".";
            }
            LogUtils.warning((String)message);
        }
    }
}

