/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.code.FrameInfoEncoder;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.debug.Assertions;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.nativeimage.ImageSingletons;

@AutomaticallyRegisteredImageSingleton
public class SubstrateCompilationDirectives {
    public static final MultiMethod.MultiMethodKey RUNTIME_COMPILED_METHOD = new MultiMethod.MultiMethodKey(){

        public String toString() {
            return "Runtime_Compiled_Method_Key";
        }
    };
    private boolean deoptInfoSealed = false;
    private boolean forceCompilationsSealed = false;
    private final Set<AnalysisMethod> forcedCompilations = ConcurrentHashMap.newKeySet();
    private final Set<AnalysisMethod> frameInformationRequired = ConcurrentHashMap.newKeySet();
    private Map<AnalysisMethod, Map<Long, DeoptSourceFrameInfo>> deoptEntries = new ConcurrentHashMap<AnalysisMethod, Map<Long, DeoptSourceFrameInfo>>();
    private final Set<AnalysisMethod> deoptForTestingMethods = ConcurrentHashMap.newKeySet();
    private final Set<AnalysisMethod> deoptInliningExcludes = ConcurrentHashMap.newKeySet();

    public static boolean isRuntimeCompiledMethod(ResolvedJavaMethod method) {
        if (method instanceof MultiMethod) {
            MultiMethod multiMethod = (MultiMethod)method;
            return multiMethod.getMultiMethodKey() == RUNTIME_COMPILED_METHOD;
        }
        return false;
    }

    public static SubstrateCompilationDirectives singleton() {
        return (SubstrateCompilationDirectives)ImageSingletons.lookup(SubstrateCompilationDirectives.class);
    }

    public void sealDeoptimizationInfo() {
        this.deoptInfoSealed = true;
    }

    public void registerForcedCompilation(ResolvedJavaMethod method) {
        assert (!this.forceCompilationsSealed);
        this.forcedCompilations.add(SubstrateCompilationDirectives.toAnalysisMethod(method));
    }

    public boolean isForcedCompilation(ResolvedJavaMethod method) {
        if (Assertions.assertionsEnabled()) {
            this.forceCompilationsSealed = true;
        }
        return this.forcedCompilations.contains(SubstrateCompilationDirectives.toAnalysisMethod(method));
    }

    public void registerFrameInformationRequired(AnalysisMethod frameMethod, AnalysisMethod deoptMethod) {
        assert (this.deoptInfoModifiable());
        this.frameInformationRequired.add(frameMethod);
        this.deoptEntries.computeIfAbsent(deoptMethod, m -> new ConcurrentHashMap());
    }

    public boolean isFrameInformationRequired(ResolvedJavaMethod method) {
        assert (this.deoptInfoQueryable());
        return this.frameInformationRequired.contains(SubstrateCompilationDirectives.toAnalysisMethod(method));
    }

    public boolean registerDeoptEntry(FrameState state, ResolvedJavaMethod method) {
        assert (this.deoptInfoModifiable());
        assert (state.bci >= 0);
        long encodedBci = FrameInfoEncoder.encodeBci(state.bci, state.duringCall(), state.rethrowException());
        Map sourceFrameInfoMap = this.deoptEntries.computeIfAbsent(SubstrateCompilationDirectives.toAnalysisMethod(method), m -> new ConcurrentHashMap());
        boolean newEntry = !sourceFrameInfoMap.containsKey(encodedBci);
        sourceFrameInfoMap.compute(encodedBci, (k, v) -> v == null ? DeoptSourceFrameInfo.create(state) : v.mergeStateInfo(state));
        return newEntry;
    }

    public void registerForDeoptTesting(ResolvedJavaMethod method) {
        assert (this.deoptInfoModifiable());
        this.deoptForTestingMethods.add((AnalysisMethod)method);
    }

    public boolean isRegisteredForDeoptTesting(ResolvedJavaMethod method) {
        assert (this.deoptInfoQueryable());
        return this.deoptForTestingMethods.contains(SubstrateCompilationDirectives.toAnalysisMethod(method));
    }

    public boolean isRegisteredDeoptTarget(ResolvedJavaMethod method) {
        assert (this.deoptInfoQueryable());
        return this.deoptEntries.containsKey(SubstrateCompilationDirectives.toAnalysisMethod(method));
    }

    public boolean isDeoptEntry(MultiMethod method, int bci, boolean duringCall, boolean rethrowException) {
        assert (this.deoptInfoQueryable());
        if (method instanceof HostedMethod && ((HostedMethod)method).getMultiMethod((MultiMethod.MultiMethodKey)MultiMethod.ORIGINAL_METHOD).compilationInfo.canDeoptForTesting()) {
            return true;
        }
        return this.isRegisteredDeoptEntry(method, bci, duringCall, rethrowException);
    }

    public boolean isRegisteredDeoptEntry(MultiMethod method, int bci, boolean duringCall, boolean rethrowException) {
        assert (this.deoptInfoQueryable());
        Map<Long, DeoptSourceFrameInfo> bciMap = this.deoptEntries.get(SubstrateCompilationDirectives.toAnalysisMethod((ResolvedJavaMethod)method));
        if (bciMap == null) {
            return false;
        }
        long encodedBci = FrameInfoEncoder.encodeBci(bci, duringCall, rethrowException);
        return bciMap.containsKey(encodedBci);
    }

    public void registerAsDeoptInlininingExclude(ResolvedJavaMethod method) {
        assert (this.deoptInfoModifiable());
        this.deoptInliningExcludes.add(SubstrateCompilationDirectives.toAnalysisMethod(method));
    }

    public boolean isDeoptInliningExclude(ResolvedJavaMethod method) {
        assert (this.deoptInfoQueryable());
        return this.deoptInliningExcludes.contains(SubstrateCompilationDirectives.toAnalysisMethod(method));
    }

    public Map<AnalysisMethod, Map<Long, DeoptSourceFrameInfo>> getDeoptEntries() {
        assert (this.deoptInfoQueryable());
        return this.deoptEntries;
    }

    private static AnalysisMethod toAnalysisMethod(ResolvedJavaMethod method) {
        if (method instanceof AnalysisMethod) {
            return (AnalysisMethod)method;
        }
        if (method instanceof HostedMethod) {
            return ((HostedMethod)method).wrapped;
        }
        throw VMError.shouldNotReachHereUnexpectedInput(method);
    }

    private boolean deoptInfoQueryable() {
        if (!SubstrateOptions.parseOnce()) {
            this.deoptInfoSealed = true;
        }
        return true;
    }

    private boolean deoptInfoModifiable() {
        return !this.deoptInfoSealed;
    }

    public void resetDeoptEntries() {
        assert (!this.deoptInfoSealed);
        assert (SubstrateOptions.parseOnce());
        ConcurrentHashMap<AnalysisMethod, Map<Long, DeoptSourceFrameInfo>> newDeoptEntries = new ConcurrentHashMap<AnalysisMethod, Map<Long, DeoptSourceFrameInfo>>();
        for (AnalysisMethod deoptForTestingMethod : this.deoptForTestingMethods) {
            AnalysisMethod key = deoptForTestingMethod.getMultiMethod(MultiMethod.DEOPT_TARGET_METHOD);
            Map<Long, DeoptSourceFrameInfo> value = this.deoptEntries.get(key);
            assert (key != null && value != null) : "Unexpected null value " + key + ", " + value;
            newDeoptEntries.put(key, value);
        }
        this.deoptEntries = newDeoptEntries;
        this.frameInformationRequired.forEach(m -> {
            assert (m.isOriginalMethod());
            AnalysisMethod deoptMethod = m.getMultiMethod(MultiMethod.DEOPT_TARGET_METHOD);
            assert (deoptMethod != null);
            this.deoptEntries.computeIfAbsent(deoptMethod, n -> new ConcurrentHashMap());
        });
    }

    public static final class DeoptSourceFrameInfo {
        public final JavaKind[] expectedKinds;
        public final int numLocals;
        public final int numStack;
        public final int numLocks;
        public static final DeoptSourceFrameInfo INVALID_DEOPT_SOURCE_FRAME = new DeoptSourceFrameInfo(null, 0, 0, 0);

        private DeoptSourceFrameInfo(JavaKind[] expectedKinds, int numLocals, int numStack, int numLocks) {
            this.expectedKinds = expectedKinds;
            this.numLocals = numLocals;
            this.numStack = numStack;
            this.numLocks = numLocks;
        }

        public static DeoptSourceFrameInfo create(FrameState state) {
            return new DeoptSourceFrameInfo(DeoptSourceFrameInfo.getKinds(state), state.localsSize(), state.stackSize(), state.locksSize());
        }

        private static JavaKind[] getKinds(FrameState state) {
            int i;
            JavaKind[] kinds = new JavaKind[state.locksSize() + state.stackSize() + state.localsSize()];
            int index = 0;
            for (i = 0; i < state.localsSize(); ++i) {
                kinds[index++] = DeoptSourceFrameInfo.getKind(state.localAt(i));
            }
            for (i = 0; i < state.stackSize(); ++i) {
                kinds[index++] = DeoptSourceFrameInfo.getKind(state.stackAt(i));
            }
            for (i = 0; i < state.locksSize(); ++i) {
                kinds[index++] = DeoptSourceFrameInfo.getKind(state.lockAt(i));
            }
            return kinds;
        }

        private static JavaKind getKind(ValueNode value) {
            if (value == null) {
                return JavaKind.Illegal;
            }
            return value.getStackKind();
        }

        public DeoptSourceFrameInfo mergeStateInfo(FrameState state) {
            boolean matchingSizes;
            if (this == INVALID_DEOPT_SOURCE_FRAME) {
                return this;
            }
            JavaKind[] otherKinds = DeoptSourceFrameInfo.getKinds(state);
            boolean bl = matchingSizes = this.numLocals == state.localsSize() && this.numStack == state.stackSize() && this.numLocks == state.locksSize() && this.expectedKinds.length == otherKinds.length;
            if (!matchingSizes) {
                return INVALID_DEOPT_SOURCE_FRAME;
            }
            for (int i = 0; i < this.expectedKinds.length; ++i) {
                JavaKind current = this.expectedKinds[i];
                JavaKind other = otherKinds[i];
                if (current == JavaKind.Illegal || current == other) continue;
                this.expectedKinds[i] = JavaKind.Illegal;
            }
            return this;
        }
    }
}

