/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.SerialGCOptions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionDescriptors;
import org.graalvm.compiler.options.OptionStability;
import org.graalvm.compiler.options.OptionType;

public class SerialGCOptions_OptionDescriptors
implements OptionDescriptors {
    public OptionDescriptor get(String value) {
        switch (value) {
            case "CollectYoungGenerationSeparately": {
                return OptionDescriptor.create((String)"CollectYoungGenerationSeparately", (OptionType)OptionType.Expert, Boolean.class, (String)"Determines if a full GC collects the young generation separately or together with the old generation. Serial GC only.", SerialGCOptions.class, (String)"CollectYoungGenerationSeparately", SerialGCOptions.CollectYoungGenerationSeparately, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "CountWriteBarriers": {
                return OptionDescriptor.create((String)"CountWriteBarriers", (OptionType)OptionType.Debug, Boolean.class, (String)"Instrument write barriers with counters. Serial GC only.", SerialGCOptions.class, (String)"CountWriteBarriers", SerialGCOptions.CountWriteBarriers, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "GreyToBlackObjRefDemographics": {
                return OptionDescriptor.create((String)"GreyToBlackObjRefDemographics", (OptionType)OptionType.Debug, Boolean.class, (String)"Develop demographics of the object references visited. Serial GC only.", SerialGCOptions.class, (String)"GreyToBlackObjRefDemographics", SerialGCOptions.GreyToBlackObjRefDemographics, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "IgnoreMaxHeapSizeWhileInVMOperation": {
                return OptionDescriptor.create((String)"IgnoreMaxHeapSizeWhileInVMOperation", (OptionType)OptionType.Expert, Boolean.class, (String)"Ignore the maximum heap size while in VM-internal code.", SerialGCOptions.class, (String)"IgnoreMaxHeapSizeWhileInVMOperation", SerialGCOptions.IgnoreMaxHeapSizeWhileInVMOperation, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ImageHeapCardMarking": {
                return OptionDescriptor.create((String)"ImageHeapCardMarking", (OptionType)OptionType.Expert, Boolean.class, (String)"Enables card marking for image heap objects, which arranges them in chunks. Automatically enabled when supported. Serial GC only.", SerialGCOptions.class, (String)"ImageHeapCardMarking", SerialGCOptions.ImageHeapCardMarking, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "InitialCollectionPolicy": {
                return OptionDescriptor.create((String)"InitialCollectionPolicy", (OptionType)OptionType.User, String.class, (String)"The garbage collection policy, either Adaptive (default) or BySpaceAndTime. Serial GC only.", SerialGCOptions.class, (String)"InitialCollectionPolicy", SerialGCOptions.InitialCollectionPolicy, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MaxHeapFree": {
                return OptionDescriptor.create((String)"MaxHeapFree", (OptionType)OptionType.User, Long.class, (String)"The maximum free bytes reserved for allocations, in bytes (0 for automatic according to GC policy). Serial GC only.", SerialGCOptions.class, (String)"MaxHeapFree", SerialGCOptions.MaxHeapFree, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MaxSurvivorSpaces": {
                return OptionDescriptor.create((String)"MaxSurvivorSpaces", (OptionType)OptionType.Expert, Integer.class, (String)"Maximum number of survivor spaces. Serial GC only.", SerialGCOptions.class, (String)"MaxSurvivorSpaces", SerialGCOptions.MaxSurvivorSpaces, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "PercentTimeInIncrementalCollection": {
                return OptionDescriptor.create((String)"PercentTimeInIncrementalCollection", (OptionType)OptionType.User, Integer.class, (String)"Percentage of total collection time that should be spent on young generation collections. Serial GC with collection policy 'BySpaceAndTime' only.", SerialGCOptions.class, (String)"PercentTimeInIncrementalCollection", SerialGCOptions.PercentTimeInIncrementalCollection, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "PrintGCSummary": {
                return OptionDescriptor.create((String)"PrintGCSummary", (OptionType)OptionType.Debug, Boolean.class, (String)"Print summary GC information after application main method returns. Serial GC only.", SerialGCOptions.class, (String)"PrintGCSummary", SerialGCOptions.PrintGCSummary, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "PrintGCTimeStamps": {
                return OptionDescriptor.create((String)"PrintGCTimeStamps", (OptionType)OptionType.Debug, Boolean.class, (String)"Deprecated. Print a time stamp at each collection, if +PrintGC or +VerboseGC. Serial GC only.", SerialGCOptions.class, (String)"PrintGCTimeStamps", SerialGCOptions.PrintGCTimeStamps, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "PrintGCTimes": {
                return OptionDescriptor.create((String)"PrintGCTimes", (OptionType)OptionType.Debug, Boolean.class, (String)"Print the time for each of the phases of each collection, if +VerboseGC. Serial GC only.", SerialGCOptions.class, (String)"PrintGCTimes", SerialGCOptions.PrintGCTimes, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "SoftRefLRUPolicyMSPerMB": {
                return OptionDescriptor.create((String)"SoftRefLRUPolicyMSPerMB", (OptionType)OptionType.Expert, Integer.class, (String)"This number of milliseconds multiplied by the free heap memory in MByte is the time span for which a soft reference will keep its referent alive after its last access. Serial GC only.", SerialGCOptions.class, (String)"SoftRefLRUPolicyMSPerMB", SerialGCOptions.SoftRefLRUPolicyMSPerMB, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "TraceHeapChunks": {
                return OptionDescriptor.create((String)"TraceHeapChunks", (OptionType)OptionType.Debug, Boolean.class, (String)"Trace heap chunks during collections, if +VerboseGC. Serial GC only.", SerialGCOptions.class, (String)"TraceHeapChunks", SerialGCOptions.TraceHeapChunks, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "VerifyAfterGC": {
                return OptionDescriptor.create((String)"VerifyAfterGC", (OptionType)OptionType.Debug, Boolean.class, (String)"Verify the heap after doing a garbage collection if VerifyHeap is enabled. Serial GC only.", SerialGCOptions.class, (String)"VerifyAfterGC", SerialGCOptions.VerifyAfterGC, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "VerifyBeforeGC": {
                return OptionDescriptor.create((String)"VerifyBeforeGC", (OptionType)OptionType.Debug, Boolean.class, (String)"Verify the heap before doing a garbage collection if VerifyHeap is enabled. Serial GC only.", SerialGCOptions.class, (String)"VerifyBeforeGC", SerialGCOptions.VerifyBeforeGC, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "VerifyReferences": {
                return OptionDescriptor.create((String)"VerifyReferences", (OptionType)OptionType.Debug, Boolean.class, (String)"Verify all object references if VerifyHeap is enabled. Serial GC only.", SerialGCOptions.class, (String)"VerifyReferences", SerialGCOptions.VerifyReferences, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "VerifyReferencesPointIntoValidChunk": {
                return OptionDescriptor.create((String)"VerifyReferencesPointIntoValidChunk", (OptionType)OptionType.Debug, Boolean.class, (String)"Verify that object references point into valid heap chunks if VerifyHeap is enabled. Serial GC only.", SerialGCOptions.class, (String)"VerifyReferencesPointIntoValidChunk", SerialGCOptions.VerifyReferencesPointIntoValidChunk, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "VerifyRememberedSet": {
                return OptionDescriptor.create((String)"VerifyRememberedSet", (OptionType)OptionType.Debug, Boolean.class, (String)"Verify the remembered set if VerifyHeap is enabled. Serial GC only.", SerialGCOptions.class, (String)"VerifyRememberedSet", SerialGCOptions.VerifyRememberedSet, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "VerifyWriteBarriers": {
                return OptionDescriptor.create((String)"VerifyWriteBarriers", (OptionType)OptionType.Debug, Boolean.class, (String)"Verify write barriers. Serial GC only.", SerialGCOptions.class, (String)"VerifyWriteBarriers", SerialGCOptions.VerifyWriteBarriers, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 20;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return SerialGCOptions_OptionDescriptors.this.get("CollectYoungGenerationSeparately");
                    }
                    case 1: {
                        return SerialGCOptions_OptionDescriptors.this.get("CountWriteBarriers");
                    }
                    case 2: {
                        return SerialGCOptions_OptionDescriptors.this.get("GreyToBlackObjRefDemographics");
                    }
                    case 3: {
                        return SerialGCOptions_OptionDescriptors.this.get("IgnoreMaxHeapSizeWhileInVMOperation");
                    }
                    case 4: {
                        return SerialGCOptions_OptionDescriptors.this.get("ImageHeapCardMarking");
                    }
                    case 5: {
                        return SerialGCOptions_OptionDescriptors.this.get("InitialCollectionPolicy");
                    }
                    case 6: {
                        return SerialGCOptions_OptionDescriptors.this.get("MaxHeapFree");
                    }
                    case 7: {
                        return SerialGCOptions_OptionDescriptors.this.get("MaxSurvivorSpaces");
                    }
                    case 8: {
                        return SerialGCOptions_OptionDescriptors.this.get("PercentTimeInIncrementalCollection");
                    }
                    case 9: {
                        return SerialGCOptions_OptionDescriptors.this.get("PrintGCSummary");
                    }
                    case 10: {
                        return SerialGCOptions_OptionDescriptors.this.get("PrintGCTimeStamps");
                    }
                    case 11: {
                        return SerialGCOptions_OptionDescriptors.this.get("PrintGCTimes");
                    }
                    case 12: {
                        return SerialGCOptions_OptionDescriptors.this.get("SoftRefLRUPolicyMSPerMB");
                    }
                    case 13: {
                        return SerialGCOptions_OptionDescriptors.this.get("TraceHeapChunks");
                    }
                    case 14: {
                        return SerialGCOptions_OptionDescriptors.this.get("VerifyAfterGC");
                    }
                    case 15: {
                        return SerialGCOptions_OptionDescriptors.this.get("VerifyBeforeGC");
                    }
                    case 16: {
                        return SerialGCOptions_OptionDescriptors.this.get("VerifyReferences");
                    }
                    case 17: {
                        return SerialGCOptions_OptionDescriptors.this.get("VerifyReferencesPointIntoValidChunk");
                    }
                    case 18: {
                        return SerialGCOptions_OptionDescriptors.this.get("VerifyRememberedSet");
                    }
                    case 19: {
                        return SerialGCOptions_OptionDescriptors.this.get("VerifyWriteBarriers");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

