/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.infrastructure.AnalysisConstantPool;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import com.oracle.svm.hosted.phases.SharedGraphBuilderPhase;
import com.oracle.svm.util.ModuleSupport;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.core.common.BootstrapMethodIntrospection;
import org.graalvm.compiler.java.BciBlockMapping;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.java.FrameStateBuilder;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.word.WordTypes;

public class AnalysisGraphBuilderPhase
extends SharedGraphBuilderPhase {
    protected final SVMHost hostVM;

    public AnalysisGraphBuilderPhase(CoreProviders providers, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext, WordTypes wordTypes, SVMHost hostVM) {
        super(providers, graphBuilderConfig, optimisticOpts, initialIntrinsicContext, wordTypes);
        this.hostVM = hostVM;
    }

    protected BytecodeParser createBytecodeParser(StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext) {
        return new AnalysisBytecodeParser((GraphBuilderPhase.Instance)this, graph, parent, method, entryBCI, intrinsicContext, this.hostVM, true);
    }

    public static class AnalysisBytecodeParser
    extends SharedGraphBuilderPhase.SharedBytecodeParser {
        private final SVMHost hostVM;
        private final boolean parseOnce = SubstrateOptions.parseOnce();

        protected AnalysisBytecodeParser(GraphBuilderPhase.Instance graphBuilderInstance, StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext, SVMHost hostVM, boolean explicitExceptionEdges) {
            super(graphBuilderInstance, graph, parent, method, entryBCI, intrinsicContext, explicitExceptionEdges);
            this.hostVM = hostVM;
        }

        protected boolean tryInvocationPlugin(CallTargetNode.InvokeKind invokeKind, ValueNode[] args, ResolvedJavaMethod targetMethod, JavaKind resultType) {
            boolean result = super.tryInvocationPlugin(invokeKind, args, targetMethod, resultType);
            if (result) {
                ((AnalysisMethod)targetMethod).registerAsIntrinsicMethod(AnalysisBytecodeParser.nonNullReason(this.graph.currentNodeSourcePosition()));
            }
            return result;
        }

        private static Object nonNullReason(Object reason) {
            return reason == null ? "Unknown invocation location." : reason;
        }

        protected boolean applyInvocationPlugin(CallTargetNode.InvokeKind invokeKind, ValueNode[] args, ResolvedJavaMethod targetMethod, JavaKind resultType, InvocationPlugin plugin) {
            Class<?> accessingClass = plugin.getClass();
            ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, accessingClass, (boolean)false, (String)"jdk.internal.vm.ci", (String[])new String[]{"jdk.vm.ci.meta"});
            ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, accessingClass, (boolean)false, (String)"jdk.internal.vm.compiler", (String[])new String[]{"org.graalvm.compiler.nodes"});
            return super.applyInvocationPlugin(invokeKind, args, targetMethod, resultType, plugin);
        }

        protected BytecodeParser.ExceptionEdgeAction getActionForInvokeExceptionEdge(InlineInvokePlugin.InlineInfo lastInlineInfo) {
            if (!this.parseOnce && !this.insideTryBlock()) {
                return BytecodeParser.ExceptionEdgeAction.OMIT;
            }
            return super.getActionForInvokeExceptionEdge(lastInlineInfo);
        }

        private boolean tryNodePluginForDynamicInvocation(BootstrapMethodIntrospection bootstrap) {
            for (NodePlugin plugin : this.graphBuilderConfig.getPlugins().getNodePlugins()) {
                Pair result = plugin.convertInvokeDynamic((GraphBuilderContext)this, bootstrap);
                if (result == null) continue;
                this.appendInvoke(CallTargetNode.InvokeKind.Static, (ResolvedJavaMethod)result.getLeft(), (ValueNode[])result.getRight(), null);
                return true;
            }
            return false;
        }

        protected void genInvokeDynamic(int cpi, int opcode) {
            BootstrapMethodIntrospection bootstrap;
            if (this.parseOnce && (bootstrap = ((AnalysisConstantPool)this.constantPool).lookupBootstrapMethodIntrospection(cpi, opcode)) != null && this.tryNodePluginForDynamicInvocation(bootstrap)) {
                return;
            }
            super.genInvokeDynamic(cpi, opcode);
        }

        protected void genStoreField(ValueNode receiver, ResolvedJavaField field, ValueNode value) {
            this.hostVM.recordFieldStore(field, this.method);
            super.genStoreField(receiver, field, value);
        }

        protected FrameStateBuilder createFrameStateForExceptionHandling(int bci) {
            AnalysisMethod aMethod;
            FrameStateBuilder dispatchState = super.createFrameStateForExceptionHandling(bci);
            if (SubstrateOptions.parseOnce() && (aMethod = (AnalysisMethod)this.method).isOriginalMethod() && !SubstrateCompilationDirectives.singleton().isRegisteredForDeoptTesting((ResolvedJavaMethod)aMethod)) {
                BciBlockMapping.BciBlock dispatchBlock = this.getDispatchBlock(bci);
                this.clearNonLiveLocals(dispatchState, dispatchBlock, true);
            }
            return dispatchState;
        }
    }
}

