/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jni;

import com.oracle.svm.core.handles.PrimitiveArrayView;
import com.oracle.svm.core.jni.headers.JNIMode;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import org.graalvm.word.PointerBase;

public class JNIThreadLocalPrimitiveArrayViews {
    private static final FastThreadLocalObject<ReferencedObjectListNode> referencedObjectsListHead = FastThreadLocalFactory.createObject(ReferencedObjectListNode.class, "JNIThreadLocalReferencedObjects.referencedObjectsListHead");

    public static PrimitiveArrayView createArrayView(Object array) {
        PrimitiveArrayView ref = PrimitiveArrayView.createForReading(array);
        referencedObjectsListHead.set(new ReferencedObjectListNode(ref, referencedObjectsListHead.get()));
        return ref;
    }

    public static <T extends PointerBase> T createArrayViewAndGetAddress(Object array) {
        return JNIThreadLocalPrimitiveArrayViews.createArrayView(array).addressOfArrayElement(0);
    }

    public static void destroyNewestArrayViewByAddress(PointerBase address, int mode) {
        ReferencedObjectListNode previous = null;
        ReferencedObjectListNode current = referencedObjectsListHead.get();
        while (current != null) {
            if (current.object.addressOfArrayElement(0) == address) {
                if (previous != null) {
                    previous.next = current.next;
                } else {
                    referencedObjectsListHead.set(current.next);
                }
                if (mode == 0 || mode == JNIMode.JNI_COMMIT()) {
                    current.object.syncToHeap();
                }
                if (mode == 0 || mode == JNIMode.JNI_ABORT()) {
                    current.object.close();
                } else {
                    current.object.untrack();
                }
                return;
            }
            previous = current;
            current = current.next;
        }
    }

    static int getCount() {
        int count = 0;
        ReferencedObjectListNode node = referencedObjectsListHead.get();
        while (node != null) {
            ++count;
            node = node.next;
        }
        return count;
    }

    private static class ReferencedObjectListNode {
        final PrimitiveArrayView object;
        ReferencedObjectListNode next;

        ReferencedObjectListNode(PrimitiveArrayView object, ReferencedObjectListNode next) {
            this.object = object;
            this.next = next;
        }
    }
}

