/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.struct.PinnedObjectField;
import com.oracle.svm.core.collections.AbstractUninterruptibleHashtable;
import com.oracle.svm.core.collections.UninterruptibleEntry;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.jfr.JfrBuffer;
import com.oracle.svm.core.jfr.JfrBufferAccess;
import com.oracle.svm.core.jfr.JfrBufferType;
import com.oracle.svm.core.jfr.JfrChunkWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import com.oracle.svm.core.jfr.JfrRepository;
import com.oracle.svm.core.jfr.JfrType;
import com.oracle.svm.core.jfr.traceid.JfrTraceIdEpoch;
import com.oracle.svm.core.locks.VMMutex;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.WordFactory;

public class JfrSymbolRepository
implements JfrRepository {
    private final VMMutex mutex = new VMMutex("jfrSymbolRepository");
    private final JfrSymbolEpochData epochData0 = new JfrSymbolEpochData();
    private final JfrSymbolEpochData epochData1 = new JfrSymbolEpochData();
    private final UninterruptibleUtils.CharReplacer dotWithSlash = new ReplaceDotWithSlash();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JfrSymbolRepository() {
    }

    public void teardown() {
        this.epochData0.teardown();
        this.epochData1.teardown();
    }

    @Uninterruptible(reason="Result is only valid until epoch changes.", callerMustBe=true)
    public long getSymbolId(String imageHeapString, boolean previousEpoch) {
        return this.getSymbolId(imageHeapString, previousEpoch, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Locking without transition and result is only valid until epoch changes.", callerMustBe=true)
    public long getSymbolId(String imageHeapString, boolean previousEpoch, boolean replaceDotWithSlash) {
        if (imageHeapString == null) {
            return 0L;
        }
        assert (Heap.getHeap().isInImageHeap(imageHeapString));
        JfrSymbol symbol = (JfrSymbol)StackValue.get(JfrSymbol.class);
        symbol.setValue(imageHeapString);
        symbol.setReplaceDotWithSlash(replaceDotWithSlash);
        long rawPointerValue = Word.objectToUntrackedPointer((Object)imageHeapString).rawValue();
        symbol.setHash(UninterruptibleUtils.Long.hashCode(rawPointerValue));
        this.mutex.lockNoTransition();
        try {
            JfrSymbolEpochData epochData = this.getEpochData(previousEpoch);
            JfrSymbol existingEntry = (JfrSymbol)epochData.table.get(symbol);
            if (existingEntry.isNonNull()) {
                long l = existingEntry.getId();
                return l;
            }
            JfrSymbol newEntry = (JfrSymbol)epochData.table.putNew(symbol);
            if (newEntry.isNull()) {
                long l = 0L;
                return l;
            }
            if (epochData.buffer.isNull()) {
                epochData.buffer = JfrBufferAccess.allocate(JfrBufferType.C_HEAP);
            }
            UninterruptibleUtils.CharReplacer charReplacer = newEntry.getReplaceDotWithSlash() ? this.dotWithSlash : null;
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initialize(data, epochData.buffer);
            JfrNativeEventWriter.putLong(data, newEntry.getId());
            JfrNativeEventWriter.putString(data, newEntry.getValue(), charReplacer);
            if (!JfrNativeEventWriter.commit(data)) {
                long l = 0L;
                return l;
            }
            ++epochData.unflushedEntries;
            epochData.buffer = data.getJfrBuffer();
            long l = newEntry.getId();
            return l;
        }
        finally {
            this.mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    public int write(JfrChunkWriter writer, boolean flushpoint) {
        this.mutex.lockNoTransition();
        try {
            JfrSymbolEpochData epochData = this.getEpochData(!flushpoint);
            int count = epochData.unflushedEntries;
            if (count != 0) {
                writer.writeCompressedLong(JfrType.Symbol.getId());
                writer.writeCompressedLong(count);
                writer.write(epochData.buffer);
            }
            epochData.clear(flushpoint);
            int n = count == 0 ? 0 : 1;
            return n;
        }
        finally {
            this.mutex.unlock();
        }
    }

    @Uninterruptible(reason="Result is only valid until epoch changes.", callerMustBe=true)
    private JfrSymbolEpochData getEpochData(boolean previousEpoch) {
        boolean epoch = previousEpoch ? JfrTraceIdEpoch.getInstance().previousEpoch() : JfrTraceIdEpoch.getInstance().currentEpoch();
        return epoch ? this.epochData0 : this.epochData1;
    }

    private static class JfrSymbolEpochData {
        private final JfrSymbolHashtable table = new JfrSymbolHashtable();
        private int unflushedEntries = 0;
        private JfrBuffer buffer;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        JfrSymbolEpochData() {
        }

        @Uninterruptible(reason="May write current epoch data.")
        void clear(boolean flushpoint) {
            if (!flushpoint) {
                this.table.clear();
            }
            this.unflushedEntries = 0;
            JfrBufferAccess.reinitialize(this.buffer);
        }

        void teardown() {
            this.table.teardown();
            this.unflushedEntries = 0;
            JfrBufferAccess.free(this.buffer);
            this.buffer = (JfrBuffer)WordFactory.nullPointer();
        }
    }

    private static class ReplaceDotWithSlash
    implements UninterruptibleUtils.CharReplacer {
        private ReplaceDotWithSlash() {
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public char replace(char ch) {
            if (ch == '.') {
                return '/';
            }
            return ch;
        }
    }

    @RawStructure
    private static interface JfrSymbol
    extends UninterruptibleEntry {
        @RawField
        public long getId();

        @RawField
        public void setId(long var1);

        @PinnedObjectField
        @RawField
        public String getValue();

        @PinnedObjectField
        @RawField
        public void setValue(String var1);

        @RawField
        public boolean getReplaceDotWithSlash();

        @RawField
        public void setReplaceDotWithSlash(boolean var1);
    }

    private static class JfrSymbolHashtable
    extends AbstractUninterruptibleHashtable {
        private static long nextId;

        private JfrSymbolHashtable() {
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected JfrSymbol[] createTable(int size) {
            return new JfrSymbol[size];
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public JfrSymbol[] getTable() {
            return (JfrSymbol[])super.getTable();
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        @SuppressFBWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"}, justification="image heap pointer comparison")
        protected boolean isEqual(UninterruptibleEntry v0, UninterruptibleEntry v1) {
            JfrSymbol a = (JfrSymbol)v0;
            JfrSymbol b = (JfrSymbol)v1;
            return a.getValue() == b.getValue() && a.getReplaceDotWithSlash() == b.getReplaceDotWithSlash();
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected UninterruptibleEntry copyToHeap(UninterruptibleEntry symbolOnStack) {
            JfrSymbol result = (JfrSymbol)this.copyToHeap(symbolOnStack, SizeOf.unsigned(JfrSymbol.class));
            if (result.isNonNull()) {
                result.setId(++nextId);
            }
            return result;
        }
    }
}

