/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.jdk.Target_sun_security_ssl_TrustStoreManager_TrustStoreDescriptor;
import com.oracle.svm.core.util.VMError;
import java.io.File;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Set;
import sun.security.ssl.SSLLogger;

final class TrustStoreManagerSupport {
    final Set<X509Certificate> buildtimeTrustedCerts;
    final KeyStore buildtimeTrustedKeyStore;

    TrustStoreManagerSupport(Set<X509Certificate> buildtimeTrustedCerts, KeyStore buildtimeTrustedKeyStore) {
        this.buildtimeTrustedCerts = buildtimeTrustedCerts;
        this.buildtimeTrustedKeyStore = buildtimeTrustedKeyStore;
    }

    static Target_sun_security_ssl_TrustStoreManager_TrustStoreDescriptor getRuntimeTrustStoreDescriptor() {
        Target_sun_security_ssl_TrustStoreManager_TrustStoreDescriptor descriptor;
        String storePropName = System.getProperty("javax.net.ssl.trustStore");
        String storePropType = System.getProperty("javax.net.ssl.trustStoreType");
        String storePropProvider = System.getProperty("javax.net.ssl.trustStoreProvider");
        String storePropPassword = System.getProperty("javax.net.ssl.trustStorePassword");
        if (storePropName == null && storePropType == null && storePropProvider == null && storePropPassword == null) {
            return null;
        }
        if (storePropName == null) {
            throw VMError.unsupportedFeature("System property javax.net.ssl.trustStore must be also set if any of javax.net.ssl.trustStore(Type|Provider|Password) are set.See https://www.graalvm.org/dev/reference-manual/native-image/dynamic-features/CertificateManagement/#runtime-options for more details about runtime certificate management.");
        }
        if (storePropType == null) {
            storePropType = KeyStore.getDefaultType();
        }
        if (storePropProvider == null) {
            storePropProvider = "";
        }
        if (storePropPassword == null) {
            storePropPassword = "";
        }
        if ((descriptor = TrustStoreManagerSupport.createTrustStoreDescriptor(storePropName, storePropType, storePropProvider, storePropPassword)) == null) {
            throw VMError.unsupportedFeature("Inaccessible trust store: " + storePropName + "See https://www.graalvm.org/dev/reference-manual/native-image/dynamic-features/CertificateManagement/#runtime-options for more details about runtime certificate management.");
        }
        return descriptor;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Target_sun_security_ssl_TrustStoreManager_TrustStoreDescriptor createTrustStoreDescriptor(String storePropName, String storePropType, String storePropProvider, String storePropPassword) {
        String temporaryName = "";
        File temporaryFile = null;
        long temporaryTime = 0L;
        if ("NONE".equals(storePropName)) {
            temporaryName = storePropName;
            return new Target_sun_security_ssl_TrustStoreManager_TrustStoreDescriptor(temporaryName, storePropType, storePropProvider, storePropPassword, temporaryFile, temporaryTime);
        }
        File f = new File(storePropName);
        if (f.isFile() && f.canRead()) {
            temporaryName = storePropName;
            temporaryFile = f;
            temporaryTime = f.lastModified();
            return new Target_sun_security_ssl_TrustStoreManager_TrustStoreDescriptor(temporaryName, storePropType, storePropProvider, storePropPassword, temporaryFile, temporaryTime);
        }
        if (!SSLLogger.isOn) return null;
        if (!SSLLogger.isOn("trustmanager")) return null;
        SSLLogger.fine("Inaccessible trust store: " + storePropName, new Object[0]);
        return null;
    }
}

