/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionDescriptors;
import org.graalvm.compiler.options.OptionStability;
import org.graalvm.compiler.options.OptionType;

public class SubstrateOptions_OptionDescriptors
implements OptionDescriptors {
    public OptionDescriptor get(String value) {
        switch (value) {
            case "AOTInline": {
                return OptionDescriptor.create((String)"AOTInline", (OptionType)OptionType.Debug, Boolean.class, (String)"Deprecated", SubstrateOptions.class, (String)"AOTInline", SubstrateOptions.AOTInline, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"");
            }
            case "AOTTrivialInline": {
                return OptionDescriptor.create((String)"AOTTrivialInline", (OptionType)OptionType.Debug, Boolean.class, (String)"Perform trivial method inlining in the AOT compiled native image", SubstrateOptions.class, (String)"AOTTrivialInline", SubstrateOptions.AOTTrivialInline, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "APIFunctionPrefix": {
                return OptionDescriptor.create((String)"APIFunctionPrefix", (OptionType)OptionType.Debug, String.class, (String)"Prefix that is added to the names of API functions.", SubstrateOptions.class, (String)"APIFunctionPrefix", SubstrateOptions.APIFunctionPrefix, (OptionStability)OptionStability.STABLE, (boolean)false, (String)"");
            }
            case "ActiveProcessorCount": {
                return OptionDescriptor.create((String)"ActiveProcessorCount", (OptionType)OptionType.Debug, Integer.class, (String)"Overwrites the available number of processors provided by the OS. Any value <= 0 means using the processor count from the OS.", SubstrateOptions.class, (String)"ActiveProcessorCount", SubstrateOptions.ActiveProcessorCount, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "AdditionalHeaderBytes": {
                return OptionDescriptor.create((String)"AdditionalHeaderBytes", (OptionType)OptionType.Debug, Integer.class, (String)"Add additional header bytes to each object, for diagnostic purposes.", SubstrateOptions.class, (String)"AdditionalHeaderBytes", SubstrateOptions.AdditionalHeaderBytes, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "AllocateInstancePrefetchLines": {
                return OptionDescriptor.create((String)"AllocateInstancePrefetchLines", (OptionType)OptionType.Debug, Integer.class, (String)"Number of cache lines to load after the object address using prefetch instructions.", SubstrateOptions.class, (String)"AllocateInstancePrefetchLines", SubstrateOptions.AllocateInstancePrefetchLines, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "AllocatePrefetchDistance": {
                return OptionDescriptor.create((String)"AllocatePrefetchDistance", (OptionType)OptionType.Debug, Integer.class, (String)"Sets the size (in bytes) of the prefetch distance for object allocation. Memory about to be written with the value of new objects is prefetched up to this distance starting from the address of the last allocated object. Each Java thread has its own allocation point.", SubstrateOptions.class, (String)"AllocatePrefetchDistance", SubstrateOptions.AllocatePrefetchDistance, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "AllocatePrefetchInstr": {
                return OptionDescriptor.create((String)"AllocatePrefetchInstr", (OptionType)OptionType.Debug, Integer.class, (String)"Sets the prefetch instruction to prefetch ahead of the allocation pointer. Possible values are from 0 to 3. The actual instructions behind the values depend on the platform.", SubstrateOptions.class, (String)"AllocatePrefetchInstr", SubstrateOptions.AllocatePrefetchInstr, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "AllocatePrefetchLines": {
                return OptionDescriptor.create((String)"AllocatePrefetchLines", (OptionType)OptionType.Debug, Integer.class, (String)"Number of cache lines to load after the array allocation using prefetch instructions.", SubstrateOptions.class, (String)"AllocatePrefetchLines", SubstrateOptions.AllocatePrefetchLines, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "AllocatePrefetchStepSize": {
                return OptionDescriptor.create((String)"AllocatePrefetchStepSize", (OptionType)OptionType.Debug, Integer.class, (String)"Sets the step size (in bytes) for sequential prefetch instructions.", SubstrateOptions.class, (String)"AllocatePrefetchStepSize", SubstrateOptions.AllocatePrefetchStepSize, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "AllocatePrefetchStyle": {
                return OptionDescriptor.create((String)"AllocatePrefetchStyle", (OptionType)OptionType.Debug, Integer.class, (String)"Generated code style for prefetch instructions: for 0 or less no prefetch instructions are generated and for 1 or more prefetch instructions are introduced after each allocation.", SubstrateOptions.class, (String)"AllocatePrefetchStyle", SubstrateOptions.AllocatePrefetchStyle, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "AllowDeprecatedBuilderClassesOnImageClasspath": {
                return OptionDescriptor.create((String)"AllowDeprecatedBuilderClassesOnImageClasspath", (OptionType)OptionType.Debug, Boolean.class, (String)"Instead of abort, only warn if image builder classes are found on the image class-path.", SubstrateOptions.class, (String)"AllowDeprecatedBuilderClassesOnImageClasspath", SubstrateOptions.AllowDeprecatedBuilderClassesOnImageClasspath, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "AllowVMInternalThreads": {
                return OptionDescriptor.create((String)"AllowVMInternalThreads", (OptionType)OptionType.Expert, Boolean.class, (String)"Determines if VM internal threads (e.g., a dedicated VM operation or reference handling thread) are allowed in this image.", SubstrateOptions.class, (String)"AllowVMInternalThreads", SubstrateOptions.AllowVMInternalThreads, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "AsyncSignalSafeDiagnostics": {
                return OptionDescriptor.create((String)"AsyncSignalSafeDiagnostics", (OptionType)OptionType.Expert, Boolean.class, (String)"Only print diagnostic output that is async signal safe.", SubstrateOptions.class, (String)"AsyncSignalSafeDiagnostics", SubstrateOptions.AsyncSignalSafeDiagnostics, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "AutomaticReferenceHandling": {
                return OptionDescriptor.create((String)"AutomaticReferenceHandling", (OptionType)OptionType.Expert, Boolean.class, (String)"Determines if the reference handling is executed automatically or manually.", SubstrateOptions.ConcealedOptions.class, (String)"AutomaticReferenceHandling", SubstrateOptions.ConcealedOptions.AutomaticReferenceHandling, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "BuildOutputBreakdowns": {
                return OptionDescriptor.create((String)"BuildOutputBreakdowns", (OptionType)OptionType.User, Boolean.class, (String)"Show code and heap breakdowns as part of the build output", SubstrateOptions.class, (String)"BuildOutputBreakdowns", SubstrateOptions.BuildOutputBreakdowns, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "BuildOutputColorful": {
                return OptionDescriptor.create((String)"BuildOutputColorful", (OptionType)OptionType.User, Boolean.class, (String)"Color build output (enabled by default if colors are supported by terminal)", SubstrateOptions.class, (String)"BuildOutputColorful", SubstrateOptions.BuildOutputColorful, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"Please use '--color' instead.");
            }
            case "BuildOutputGCWarnings": {
                return OptionDescriptor.create((String)"BuildOutputGCWarnings", (OptionType)OptionType.User, Boolean.class, (String)"Print GC warnings as part of build output", SubstrateOptions.class, (String)"BuildOutputGCWarnings", SubstrateOptions.BuildOutputGCWarnings, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "BuildOutputJSONFile": {
                return OptionDescriptor.create((String)"BuildOutputJSONFile", (OptionType)OptionType.User, LocatableMultiOptionValue.Paths.class, (String)"Print build output statistics as JSON to the specified file. The output conforms to the JSON schema located at: docs/reference-manual/native-image/assets/build-output-schema-v0.9.2.json", SubstrateOptions.class, (String)"BuildOutputJSONFile", SubstrateOptions.BuildOutputJSONFile, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "BuildOutputLinks": {
                return OptionDescriptor.create((String)"BuildOutputLinks", (OptionType)OptionType.User, Boolean.class, (String)"Show links in build output (defaults to the value of BuildOutputColorful)", SubstrateOptions.class, (String)"BuildOutputLinks", SubstrateOptions.BuildOutputLinks, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "BuildOutputPrefix": {
                return OptionDescriptor.create((String)"BuildOutputPrefix", (OptionType)OptionType.User, Boolean.class, (String)"Prefix build output with '<pid>:<image name>'", SubstrateOptions.class, (String)"BuildOutputPrefix", SubstrateOptions.BuildOutputPrefix, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "BuildOutputProgress": {
                return OptionDescriptor.create((String)"BuildOutputProgress", (OptionType)OptionType.User, Boolean.class, (String)"Report progress in build output (default is adaptive)", SubstrateOptions.class, (String)"BuildOutputProgress", SubstrateOptions.BuildOutputProgress, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "BuildOutputRecommendations": {
                return OptionDescriptor.create((String)"BuildOutputRecommendations", (OptionType)OptionType.User, Boolean.class, (String)"Show recommendations as part of the build output", SubstrateOptions.class, (String)"BuildOutputRecommendations", SubstrateOptions.BuildOutputRecommendations, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "BuildOutputSilent": {
                return OptionDescriptor.create((String)"BuildOutputSilent", (OptionType)OptionType.User, Boolean.class, (String)"Silence build output", SubstrateOptions.class, (String)"BuildOutputSilent", SubstrateOptions.BuildOutputSilent, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "CCompilerOption": {
                return OptionDescriptor.create((String)"CCompilerOption", (OptionType)OptionType.User, LocatableMultiOptionValue.Strings.class, (String)"Provide custom C compiler option used for query code compilation.", SubstrateOptions.class, (String)"CCompilerOption", SubstrateOptions.CCompilerOption, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "CCompilerPath": {
                return OptionDescriptor.create((String)"CCompilerPath", (OptionType)OptionType.User, String.class, (String)"Provide custom path to C compiler used for query code compilation and linking.", SubstrateOptions.class, (String)"CCompilerPath", SubstrateOptions.CCompilerPath, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "CLibraryPath": {
                return OptionDescriptor.create((String)"CLibraryPath", (OptionType)OptionType.Debug, LocatableMultiOptionValue.Paths.class, (String)"Search path for C libraries passed to the linker (list of comma-separated directories)", SubstrateOptions.class, (String)"CLibraryPath", SubstrateOptions.CLibraryPath, (OptionStability)OptionStability.STABLE, (boolean)false, (String)"");
            }
            case "CheckBootModuleDependencies": {
                return OptionDescriptor.create((String)"CheckBootModuleDependencies", (OptionType)OptionType.Debug, Integer.class, (String)"Temporary option to disable checking of image builder module dependencies or increasing its verbosity", SubstrateOptions.class, (String)"CheckBootModuleDependencies", SubstrateOptions.CheckBootModuleDependencies, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "CheckIsolateThreadAtEntry": {
                return OptionDescriptor.create((String)"CheckIsolateThreadAtEntry", (OptionType)OptionType.Debug, Boolean.class, (String)"At CEntryPoints check that the passed IsolateThread is valid.", SubstrateOptions.class, (String)"CheckIsolateThreadAtEntry", SubstrateOptions.CheckIsolateThreadAtEntry, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "CheckToolchain": {
                return OptionDescriptor.create((String)"CheckToolchain", (OptionType)OptionType.Expert, Boolean.class, (String)"Check if native-toolchain is known to work with native-image", SubstrateOptions.class, (String)"CheckToolchain", SubstrateOptions.CheckToolchain, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "Class": {
                return OptionDescriptor.create((String)"Class", (OptionType)OptionType.User, String.class, (String)"Class containing the default entry point method. Optional if --shared is used.", SubstrateOptions.class, (String)"Class", SubstrateOptions.Class, (OptionStability)OptionStability.STABLE, (boolean)false, (String)"");
            }
            case "CodeAlignment": {
                return OptionDescriptor.create((String)"CodeAlignment", (OptionType)OptionType.Debug, Integer.class, (String)"Alignment of AOT and JIT compiled code in bytes.", SubstrateOptions.class, (String)"CodeAlignment", SubstrateOptions.CodeAlignment, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "Color": {
                return OptionDescriptor.create((String)"Color", (OptionType)OptionType.User, String.class, (String)"Color build output ('always', 'never', or 'auto')", SubstrateOptions.class, (String)"Color", SubstrateOptions.Color, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "CompilationIsolateAddressSpaceSize": {
                return OptionDescriptor.create((String)"CompilationIsolateAddressSpaceSize", (OptionType)OptionType.Debug, Long.class, (String)"Size of the reserved address space of each compilation isolate (0: default for new isolates).", SubstrateOptions.class, (String)"CompilationIsolateAddressSpaceSize", SubstrateOptions.CompilationIsolateAddressSpaceSize, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "CompilationIsolateOptions": {
                return OptionDescriptor.create((String)"CompilationIsolateOptions", (OptionType)OptionType.Debug, String.class, (String)"Options that are passed to each compilation isolate. Individual arguments are separated by spaces. Arguments that contain spaces need to be enclosed by single quotes.", SubstrateOptions.class, (String)"CompilationIsolateOptions", SubstrateOptions.CompilationIsolateOptions, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "CompileInIsolates": {
                return OptionDescriptor.create((String)"CompileInIsolates", (OptionType)OptionType.Debug, Boolean.class, (String)"Activate runtime compilation in separate isolates (enable support during image build with option SupportCompileInIsolates).", SubstrateOptions.ConcealedOptions.class, (String)"CompileInIsolates", SubstrateOptions.ConcealedOptions.CompileInIsolates, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "CompilerBackend": {
                return OptionDescriptor.create((String)"CompilerBackend", (OptionType)OptionType.User, String.class, (String)"Backend used by the compiler", SubstrateOptions.class, (String)"CompilerBackend", SubstrateOptions.CompilerBackend, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ConfigureReflectionMetadata": {
                return OptionDescriptor.create((String)"ConfigureReflectionMetadata", (OptionType)OptionType.Expert, Boolean.class, (String)"Enable runtime instantiation of reflection objects for non-invoked methods.", SubstrateOptions.class, (String)"ConfigureReflectionMetadata", SubstrateOptions.ConfigureReflectionMetadata, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"");
            }
            case "ContendedPaddingWidth": {
                return OptionDescriptor.create((String)"ContendedPaddingWidth", (OptionType)OptionType.Debug, Integer.class, (String)"How many bytes to pad fields and classes marked @Contended with.", SubstrateOptions.class, (String)"ContendedPaddingWidth", SubstrateOptions.ContendedPaddingWidth, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DeadlockWatchdogExitOnTimeout": {
                return OptionDescriptor.create((String)"DeadlockWatchdogExitOnTimeout", (OptionType)OptionType.Expert, Boolean.class, (String)"Exit the image builder VM after printing call stacks", SubstrateOptions.class, (String)"DeadlockWatchdogExitOnTimeout", SubstrateOptions.DeadlockWatchdogExitOnTimeout, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DeadlockWatchdogInterval": {
                return OptionDescriptor.create((String)"DeadlockWatchdogInterval", (OptionType)OptionType.Expert, Integer.class, (String)"The interval in minutes between watchdog checks (0 disables the watchdog)", SubstrateOptions.class, (String)"DeadlockWatchdogInterval", SubstrateOptions.DeadlockWatchdogInterval, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DebugCodeInfoMaxDepth": {
                return OptionDescriptor.create((String)"DebugCodeInfoMaxDepth", (OptionType)OptionType.Debug, Integer.class, (String)"Specify maximum inlining depth to consider when building DebugCodeInfo", SubstrateOptions.class, (String)"DebugCodeInfoMaxDepth", SubstrateOptions.DebugCodeInfoMaxDepth, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DebugCodeInfoUseSourceMappings": {
                return OptionDescriptor.create((String)"DebugCodeInfoUseSourceMappings", (OptionType)OptionType.Debug, Boolean.class, (String)"Do not use SourceMappings for generating DebugCodeInfo (i.e. only use Infopoints)", SubstrateOptions.class, (String)"DebugCodeInfoUseSourceMappings", SubstrateOptions.DebugCodeInfoUseSourceMappings, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DebugInfoSourceCacheRoot": {
                return OptionDescriptor.create((String)"DebugInfoSourceCacheRoot", (OptionType)OptionType.Debug, String.class, (String)"Directory under which to create source file cache for Application or GraalVM classes", SubstrateOptions.class, (String)"DebugInfoSourceCacheRoot", SubstrateOptions.DebugInfoSourceCacheRoot, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DeleteLocalSymbols": {
                return OptionDescriptor.create((String)"DeleteLocalSymbols", (OptionType)OptionType.Debug, Boolean.class, (String)"Use linker option to remove all local symbols from image.", SubstrateOptions.class, (String)"DeleteLocalSymbols", SubstrateOptions.DeleteLocalSymbols, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DetectUserDirectoriesInImageHeap": {
                return OptionDescriptor.create((String)"DetectUserDirectoriesInImageHeap", (OptionType)OptionType.User, Boolean.class, (String)"When set to true, the image generator verifies that the image heap does not contain a home directory as a substring", SubstrateOptions.class, (String)"DetectUserDirectoriesInImageHeap", SubstrateOptions.DetectUserDirectoriesInImageHeap, (OptionStability)OptionStability.STABLE, (boolean)false, (String)"");
            }
            case "DiagnosticBufferSize": {
                return OptionDescriptor.create((String)"DiagnosticBufferSize", (OptionType)OptionType.Debug, Integer.class, (String)"Specifies the number of entries that diagnostic buffers have.", SubstrateOptions.class, (String)"DiagnosticBufferSize", SubstrateOptions.DiagnosticBufferSize, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DiagnosticDetails": {
                return OptionDescriptor.create((String)"DiagnosticDetails", (OptionType)OptionType.Expert, String.class, (String)"Specifies how many details are printed for certain diagnostic thunks, e.g.: 'DumpThreads:1,DumpRegisters:2'. A value of 1 will result in the maximum amount of information, higher values will print less information. By default, the most detailed output is enabled for all diagnostic thunks. Wildcards (*) are supported in the name of the diagnostic thunk.", SubstrateOptions.class, (String)"DiagnosticDetails", SubstrateOptions.DiagnosticDetails, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DisableTypeIdResultVerification": {
                return OptionDescriptor.create((String)"DisableTypeIdResultVerification", (OptionType)OptionType.Debug, Boolean.class, (String)"For internal purposes only. Disables type id result verification even when running with assertions enabled.", SubstrateOptions.class, (String)"DisableTypeIdResultVerification", SubstrateOptions.DisableTypeIdResultVerification, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DisableURLProtocols": {
                return OptionDescriptor.create((String)"DisableURLProtocols", (OptionType)OptionType.Debug, LocatableMultiOptionValue.Strings.class, (String)"List of comma separated URL protocols that must never be included.", SubstrateOptions.class, (String)"DisableURLProtocols", SubstrateOptions.DisableURLProtocols, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DumpHeapAndExit": {
                return OptionDescriptor.create((String)"DumpHeapAndExit", (OptionType)OptionType.Debug, Boolean.class, (String)"Create a heap dump and exit.", SubstrateOptions.class, (String)"DumpHeapAndExit", SubstrateOptions.DumpHeapAndExit, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DumpTargetInfo": {
                return OptionDescriptor.create((String)"DumpTargetInfo", (OptionType)OptionType.User, Boolean.class, (String)"Show native-toolchain information and image-build settings", SubstrateOptions.class, (String)"DumpTargetInfo", SubstrateOptions.DumpTargetInfo, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "EnableAllSecurityServices": {
                return OptionDescriptor.create((String)"EnableAllSecurityServices", (OptionType)OptionType.Debug, Boolean.class, (String)"Add all security service classes to the generated image.", SubstrateOptions.class, (String)"EnableAllSecurityServices", SubstrateOptions.EnableAllSecurityServices, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"");
            }
            case "EnableSignalHandling": {
                return OptionDescriptor.create((String)"EnableSignalHandling", (OptionType)OptionType.Expert, Boolean.class, (String)"Enables signal handling", SubstrateOptions.class, (String)"EnableSignalHandling", SubstrateOptions.EnableSignalHandling, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "EnableURLProtocols": {
                return OptionDescriptor.create((String)"EnableURLProtocols", (OptionType)OptionType.Debug, LocatableMultiOptionValue.Strings.class, (String)"List of comma separated URL protocols to enable.", SubstrateOptions.class, (String)"EnableURLProtocols", SubstrateOptions.EnableURLProtocols, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "EnableWildcardExpansion": {
                return OptionDescriptor.create((String)"EnableWildcardExpansion", (OptionType)OptionType.Debug, Boolean.class, (String)"Enable wildcard expansion in command line arguments on Windows.", SubstrateOptions.class, (String)"EnableWildcardExpansion", SubstrateOptions.EnableWildcardExpansion, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "EntryPointNamePrefix": {
                return OptionDescriptor.create((String)"EntryPointNamePrefix", (OptionType)OptionType.Debug, String.class, (String)"Prefix that is added to the names of entry point methods.", SubstrateOptions.class, (String)"EntryPointNamePrefix", SubstrateOptions.EntryPointNamePrefix, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "FallbackThreshold": {
                return OptionDescriptor.create((String)"FallbackThreshold", (OptionType)OptionType.Debug, Integer.class, (String)"Define when fallback-image generation should be used.", SubstrateOptions.class, (String)"FallbackThreshold", SubstrateOptions.FallbackThreshold, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "FlightRecorder": {
                return OptionDescriptor.create((String)"FlightRecorder", (OptionType)OptionType.Debug, Boolean.class, (String)"Enable Java Flight Recorder.", SubstrateOptions.class, (String)"FlightRecorder", SubstrateOptions.FlightRecorder, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "FlightRecorderLogging": {
                return OptionDescriptor.create((String)"FlightRecorderLogging", (OptionType)OptionType.Debug, String.class, (String)"Usage: -XX:FlightRecorderLogging=[tag1[+tag2...][*][=level][,...]]", (String[])new String[]{"", "When this option is not set, logging is enabled at a level of WARNING.", "When this option is set to the empty string, logging is enabled at a level of INFO.", "When this option is set to \"disable\", logging is disabled entirely.", "", "Otherwise, this option expects a comma separated list of tag combinations, each with an optional wildcard (*) and level.", "A tag combination without a level is given a default level of INFO.", "Messages with tags that match a given tag combination are set to log at that tag combination's level.", "If a tag combination does not have a wildcard, then only messages with exactly the same tags are matched.", "Otherwise, messages whose tags are a subset of the tag combination are matched.", "Specifying \"all\" instead of a tag combination matches all tag combinations.", "If more than one tag combination matches a message's tags, the rightmost one will apply.", "Messages with tags that do not have any matching tag combinations are set to log at a default level of WARNING.", "This option is case insensitive.", "", "Available log levels:", "[trace, debug, info, warning, error, off]", "", "Available log tags:", "[jfr, system, event, setting, bytecode, parser, metadata, dcmd]"}, SubstrateOptions.class, (String)"FlightRecorderLogging", SubstrateOptions.FlightRecorderLogging, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "FoldSecurityManagerGetter": {
                return OptionDescriptor.create((String)"FoldSecurityManagerGetter", (OptionType)OptionType.Expert, Boolean.class, (String)"Fold SecurityManager getter.", SubstrateOptions.class, (String)"FoldSecurityManagerGetter", SubstrateOptions.FoldSecurityManagerGetter, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ForceNoROSectionRelocations": {
                return OptionDescriptor.create((String)"ForceNoROSectionRelocations", (OptionType)OptionType.Debug, Boolean.class, (String)"Use only a writable native image heap (requires ld.gold linker)", SubstrateOptions.class, (String)"ForceNoROSectionRelocations", SubstrateOptions.ForceNoROSectionRelocations, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "GenerateBuildArtifactsFile": {
                return OptionDescriptor.create((String)"GenerateBuildArtifactsFile", (OptionType)OptionType.User, Boolean.class, (String)"Create a build-artifacts.json file in the build directory. The output conforms to the JSON schema located at: docs/reference-manual/native-image/assets/build-artifacts-schema-v0.9.0.json", SubstrateOptions.class, (String)"GenerateBuildArtifactsFile", SubstrateOptions.GenerateBuildArtifactsFile, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "GenerateDebugInfo": {
                return OptionDescriptor.create((String)"GenerateDebugInfo", (OptionType)OptionType.Debug, Integer.class, (String)"Insert debug info into the generated native image or library", SubstrateOptions.class, (String)"GenerateDebugInfo", SubstrateOptions.GenerateDebugInfo, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "HeapDumpDefaultFilenamePrefix": {
                return OptionDescriptor.create((String)"HeapDumpDefaultFilenamePrefix", (OptionType)OptionType.Debug, String.class, (String)"A prefix that is used for heap dump filenames if no heap dump filename was specified explicitly.", SubstrateOptions.class, (String)"HeapDumpDefaultFilenamePrefix", SubstrateOptions.HeapDumpDefaultFilenamePrefix, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "HeapDumpOnOutOfMemoryError": {
                return OptionDescriptor.create((String)"HeapDumpOnOutOfMemoryError", (OptionType)OptionType.Debug, Boolean.class, (String)"Dump heap to file (see HeapDumpPath) the first time the image throws java.lang.OutOfMemoryError because it ran out of Java heap.", SubstrateOptions.class, (String)"HeapDumpOnOutOfMemoryError", SubstrateOptions.HeapDumpOnOutOfMemoryError, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "HeapDumpPath": {
                return OptionDescriptor.create((String)"HeapDumpPath", (OptionType)OptionType.Debug, String.class, (String)"Path of the file or directory in which heap dumps are created. An empty value means a default file name will be used. An existing directory means the dump will be placed in the directory and have the default file name.", SubstrateOptions.class, (String)"HeapDumpPath", SubstrateOptions.HeapDumpPath, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ImageBuildID": {
                return OptionDescriptor.create((String)"ImageBuildID", (OptionType)OptionType.Debug, String.class, (String)"Image Build ID is a 128-bit UUID string generated randomly, once per bundle or digest of input args when bundles are not used.", SubstrateOptions.class, (String)"ImageBuildID", SubstrateOptions.ImageBuildID, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ImageSymbolsPrefix": {
                return OptionDescriptor.create((String)"ImageSymbolsPrefix", (OptionType)OptionType.Debug, String.class, (String)"Common prefix used by method symbols in image.", SubstrateOptions.class, (String)"ImageSymbolsPrefix", SubstrateOptions.ImageSymbolsPrefix, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ImplicitExceptionWithoutStacktraceIsFatal": {
                return OptionDescriptor.create((String)"ImplicitExceptionWithoutStacktraceIsFatal", (OptionType)OptionType.Debug, Boolean.class, (String)"Determines if implicit exceptions are fatal if they don't have a stack trace.", SubstrateOptions.class, (String)"ImplicitExceptionWithoutStacktraceIsFatal", SubstrateOptions.ImplicitExceptionWithoutStacktraceIsFatal, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "IncludeDebugHelperMethods": {
                return OptionDescriptor.create((String)"IncludeDebugHelperMethods", (OptionType)OptionType.Debug, Boolean.class, (String)"Determines if debugging-specific helper methods are embedded into the image. Those methods can be called directly from the debugger to obtain or print additional information.", SubstrateOptions.class, (String)"IncludeDebugHelperMethods", SubstrateOptions.IncludeDebugHelperMethods, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "IncludeMethodData": {
                return OptionDescriptor.create((String)"IncludeMethodData", (OptionType)OptionType.Expert, Boolean.class, (String)"Include a list of methods included in the image for runtime inspection.", SubstrateOptions.class, (String)"IncludeMethodData", SubstrateOptions.IncludeMethodData, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "IncludeNodeSourcePositions": {
                return OptionDescriptor.create((String)"IncludeNodeSourcePositions", (OptionType)OptionType.Debug, Boolean.class, (String)"Track NodeSourcePositions during runtime-compilation", SubstrateOptions.class, (String)"IncludeNodeSourcePositions", SubstrateOptions.IncludeNodeSourcePositions, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "IndirectBranchTargetMarker": {
                return OptionDescriptor.create((String)"IndirectBranchTargetMarker", (OptionType)OptionType.Expert, Boolean.class, (String)"Emit indirect branch target marker instructions.", SubstrateOptions.class, (String)"IndirectBranchTargetMarker", SubstrateOptions.IndirectBranchTargetMarker, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "InstallExitHandlers": {
                return OptionDescriptor.create((String)"InstallExitHandlers", (OptionType)OptionType.User, Boolean.class, (String)"Provide java.lang.Terminator exit handlers", SubstrateOptions.class, (String)"InstallExitHandlers", SubstrateOptions.InstallExitHandlers, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "InternalSymbolsAreGlobal": {
                return OptionDescriptor.create((String)"InternalSymbolsAreGlobal", (OptionType)OptionType.Debug, Boolean.class, (String)"Compatibility option to make symbols used for the image heap global. Using global symbols is problematic for shared libraries because the loader implicitly changes the value when the symbol is already defined in the executable loading the library. Setting this option to true preserves the broken behavior of old Native Image versions.", SubstrateOptions.class, (String)"InternalSymbolsAreGlobal", SubstrateOptions.InternalSymbolsAreGlobal, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "InternalThreadStackSize": {
                return OptionDescriptor.create((String)"InternalThreadStackSize", (OptionType)OptionType.Expert, Long.class, (String)"The size of each internal thread stack, in bytes.", SubstrateOptions.class, (String)"InternalThreadStackSize", SubstrateOptions.InternalThreadStackSize, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "JNI": {
                return OptionDescriptor.create((String)"JNI", (OptionType)OptionType.Debug, Boolean.class, (String)"Enable Java Native Interface (JNI) support.", SubstrateOptions.class, (String)"JNI", SubstrateOptions.JNI, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "JNIEnhancedErrorCodes": {
                return OptionDescriptor.create((String)"JNIEnhancedErrorCodes", (OptionType)OptionType.User, Boolean.class, (String)"JNI functions will return more specific error codes.", SubstrateOptions.class, (String)"JNIEnhancedErrorCodes", SubstrateOptions.JNIEnhancedErrorCodes, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "JNIExportSymbols": {
                return OptionDescriptor.create((String)"JNIExportSymbols", (OptionType)OptionType.User, Boolean.class, (String)"Export Invocation API symbols.", SubstrateOptions.class, (String)"JNIExportSymbols", SubstrateOptions.JNIExportSymbols, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "JNIVerboseLookupErrors": {
                return OptionDescriptor.create((String)"JNIVerboseLookupErrors", (OptionType)OptionType.User, Boolean.class, (String)"Report information about known JNI elements when lookup fails", SubstrateOptions.class, (String)"JNIVerboseLookupErrors", SubstrateOptions.JNIVerboseLookupErrors, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "LinkerRPath": {
                return OptionDescriptor.create((String)"LinkerRPath", (OptionType)OptionType.Debug, LocatableMultiOptionValue.Strings.class, (String)"Path passed to the linker as the -rpath (list of comma-separated directories)", SubstrateOptions.class, (String)"LinkerRPath", SubstrateOptions.LinkerRPath, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MaxDirectMemorySize": {
                return OptionDescriptor.create((String)"MaxDirectMemorySize", (OptionType)OptionType.Debug, Long.class, (String)"Maximum total size of NIO direct-buffer allocations", SubstrateOptions.class, (String)"MaxDirectMemorySize", SubstrateOptions.MaxDirectMemorySize, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MaxInvokesInTrivialMethod": {
                return OptionDescriptor.create((String)"MaxInvokesInTrivialMethod", (OptionType)OptionType.Debug, Integer.class, (String)"Maximum number of invokes in a method so that it is considered trivial (for testing only).", SubstrateOptions.class, (String)"MaxInvokesInTrivialMethod", SubstrateOptions.MaxInvokesInTrivialMethod, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MaxJavaStackTraceDepth": {
                return OptionDescriptor.create((String)"MaxJavaStackTraceDepth", (OptionType)OptionType.User, Integer.class, (String)"The maximum number of lines in the stack trace for Java exceptions (0 means all)", SubstrateOptions.ConcealedOptions.class, (String)"MaxJavaStackTraceDepth", SubstrateOptions.ConcealedOptions.MaxJavaStackTraceDepth, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MaxNodesAfterTrivialInlining": {
                return OptionDescriptor.create((String)"MaxNodesAfterTrivialInlining", (OptionType)OptionType.Debug, Integer.class, (String)"The maximum number of nodes in a graph allowed after trivial inlining.", SubstrateOptions.class, (String)"MaxNodesAfterTrivialInlining", SubstrateOptions.MaxNodesAfterTrivialInlining, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MaxNodesInTrivialLeafMethod": {
                return OptionDescriptor.create((String)"MaxNodesInTrivialLeafMethod", (OptionType)OptionType.Debug, Integer.class, (String)"Maximum number of nodes in a method so that it is considered trivial, if it does not have any invokes.", SubstrateOptions.class, (String)"MaxNodesInTrivialLeafMethod", SubstrateOptions.MaxNodesInTrivialLeafMethod, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MaxNodesInTrivialMethod": {
                return OptionDescriptor.create((String)"MaxNodesInTrivialMethod", (OptionType)OptionType.Debug, Integer.class, (String)"Maximum number of nodes in a method so that it is considered trivial.", SubstrateOptions.class, (String)"MaxNodesInTrivialMethod", SubstrateOptions.MaxNodesInTrivialMethod, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MaxRAM": {
                return OptionDescriptor.create((String)"MaxRAM", (OptionType)OptionType.Expert, Long.class, (String)"Physical memory size (in bytes). By default, the value is queried from the OS/container during VM startup.", SubstrateOptions.class, (String)"MaxRAM", SubstrateOptions.MaxRAM, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MaxUnrolledObjectZeroingStores": {
                return OptionDescriptor.create((String)"MaxUnrolledObjectZeroingStores", (OptionType)OptionType.Debug, Integer.class, (String)"Define the maximum number of stores for which the loop that zeroes out objects is unrolled.", SubstrateOptions.class, (String)"MaxUnrolledObjectZeroingStores", SubstrateOptions.MaxUnrolledObjectZeroingStores, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "Method": {
                return OptionDescriptor.create((String)"Method", (OptionType)OptionType.Debug, String.class, (String)"Name of the main entry point method. Optional if --shared is used.", SubstrateOptions.class, (String)"Method", SubstrateOptions.Method, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MissingRegistrationReportingMode": {
                return OptionDescriptor.create((String)"MissingRegistrationReportingMode", (OptionType)OptionType.Debug, SubstrateOptions.ReportingMode.class, (String)"Select the mode in which the missing reflection registrations will be reported.", (String[])new String[]{"Possible values are:", "\"Throw\" (default): Throw a MissingReflectionRegistrationError;", "\"Exit\": Call System.exit() to avoid accidentally catching the error;", "\"Warn\": Print a message to stdout, including a stack trace to see what caused the issue."}, SubstrateOptions.class, (String)"MissingRegistrationReportingMode", SubstrateOptions.MissingRegistrationReportingMode, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "Module": {
                return OptionDescriptor.create((String)"Module", (OptionType)OptionType.User, String.class, (String)"Module containing the class that contains the main entry point. Optional if --shared is used.", SubstrateOptions.class, (String)"Module", SubstrateOptions.Module, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MultiThreaded": {
                return OptionDescriptor.create((String)"MultiThreaded", (OptionType)OptionType.Debug, Boolean.class, (String)"Enable support for threads and and thread-local variables (disable for single-threaded implementation)", SubstrateOptions.class, (String)"MultiThreaded", SubstrateOptions.MultiThreaded, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "Name": {
                return OptionDescriptor.create((String)"Name", (OptionType)OptionType.User, String.class, (String)"Name of the output file to be generated", SubstrateOptions.class, (String)"Name", SubstrateOptions.Name, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "NeverInline": {
                return OptionDescriptor.create((String)"NeverInline", (OptionType)OptionType.Debug, LocatableMultiOptionValue.Strings.class, (String)"Pattern for disabling inlining of methods during image generation.", (String[])new String[]{"The syntax for a pattern is:", "", "  SourcePatterns = SourcePattern [\",\" SourcePatterns] .", "  SourcePattern = [ Class \".\" ] method [ \"(\" [ Parameter { \";\" Parameter } ] \")\" ] .", "  Parameter = Class | \"int\" | \"long\" | \"float\" | \"double\" | \"short\" | \"char\" | \"boolean\" .", "  Class = { package \".\" } class .", "", "Glob pattern matching (*, ?) is allowed in all parts of the source pattern.", "", "Examples of method filters:", "---------", "  visit(Argument;BlockScope)", "", "  Matches all methods named \"visit\", with the first parameter of", "  type \"Argument\", and the second parameter of type \"BlockScope\".", "  The packages of the parameter types are irrelevant.", "---------", "  arraycopy(Object;;;;)", "", "  Matches all methods named \"arraycopy\", with the first parameter", "  of type \"Object\", and four more parameters of any type. The", "  packages of the parameter types are irrelevant.", "---------", "  org.graalvm.compiler.core.graph.PostOrderNodeIterator.*", "", "  Matches all methods in the class \"org.graalvm.compiler.core.graph.PostOrderNodeIterator\".", "---------", "  *", "", "  Matches all methods in all classes", "---------", "  org.graalvm.compiler.core.graph.*.visit", "", "  Matches all methods named \"visit\" in classes in the package", "  \"org.graalvm.compiler.core.graph\".", "---------", "  arraycopy,toString", "", "  Matches all methods named \"arraycopy\" or \"toString\", meaning that ',' acts as an or operator."}, SubstrateOptions.class, (String)"NeverInline", SubstrateOptions.NeverInline, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "OmitInlinedMethodDebugLineInfo": {
                return OptionDescriptor.create((String)"OmitInlinedMethodDebugLineInfo", (OptionType)OptionType.Debug, Boolean.class, (String)"Omit generation of DebugLineInfo originating from inlined methods", SubstrateOptions.class, (String)"OmitInlinedMethodDebugLineInfo", SubstrateOptions.OmitInlinedMethodDebugLineInfo, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "Optimize": {
                return OptionDescriptor.create((String)"Optimize", (OptionType)OptionType.User, String.class, (String)"Control code optimizations: b - optimize for fastest build time, 0 - no optimizations, 1 - basic optimizations, 2 - advanced optimizations, 3 - all optimizations for best performance.", SubstrateOptions.class, (String)"Optimize", SubstrateOptions.Optimize, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "PageSize": {
                return OptionDescriptor.create((String)"PageSize", (OptionType)OptionType.Debug, Integer.class, (String)"Define PageSize of a machine that runs the image. The default = 0 (== same as host machine page size)", SubstrateOptions.class, (String)"PageSize", SubstrateOptions.PageSize, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ParseOnce": {
                return OptionDescriptor.create((String)"ParseOnce", (OptionType)OptionType.Debug, Boolean.class, (String)"When true, compiler graphs are parsed only once before static analysis. When false, compiler graphs are parsed for static analysis and again for AOT compilation.", SubstrateOptions.class, (String)"ParseOnce", SubstrateOptions.ParseOnce, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ParseOnceJIT": {
                return OptionDescriptor.create((String)"ParseOnceJIT", (OptionType)OptionType.Debug, Boolean.class, (String)"When true, each compiler graph version (DeoptTarget, AOT, JIT) needed for runtime compilation will be separately analyzed during static analysis.When false, only one version of the compiler graph (AOT) will be used in static analysis, and then three new versions will be parsed for compilation.", SubstrateOptions.class, (String)"ParseOnceJIT", SubstrateOptions.ParseOnceJIT, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ParseRuntimeOptions": {
                return OptionDescriptor.create((String)"ParseRuntimeOptions", (OptionType)OptionType.Debug, Boolean.class, (String)"Parse and consume standard options and system properties from the command line arguments when the VM is created.", SubstrateOptions.class, (String)"ParseRuntimeOptions", SubstrateOptions.ParseRuntimeOptions, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "Path": {
                return OptionDescriptor.create((String)"Path", (OptionType)OptionType.User, String.class, (String)"Directory of the image file to be generated", SubstrateOptions.class, (String)"Path", SubstrateOptions.Path, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "PinnedObjectAddressing": {
                return OptionDescriptor.create((String)"PinnedObjectAddressing", (OptionType)OptionType.Expert, Boolean.class, (String)"Allows the addresses of pinned objects to be passed to other code.", SubstrateOptions.class, (String)"PinnedObjectAddressing", SubstrateOptions.PinnedObjectAddressing, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "PreserveFramePointer": {
                return OptionDescriptor.create((String)"PreserveFramePointer", (OptionType)OptionType.Debug, Boolean.class, (String)"Saves stack base pointer on the stack on method entry.", SubstrateOptions.class, (String)"PreserveFramePointer", SubstrateOptions.PreserveFramePointer, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "RemoveUnusedSymbols": {
                return OptionDescriptor.create((String)"RemoveUnusedSymbols", (OptionType)OptionType.Debug, Boolean.class, (String)"Use linker option to prevent unreferenced symbols in image.", SubstrateOptions.class, (String)"RemoveUnusedSymbols", SubstrateOptions.RemoveUnusedSymbols, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ReportAnalysisForbiddenType": {
                return OptionDescriptor.create((String)"ReportAnalysisForbiddenType", (OptionType)OptionType.Debug, LocatableMultiOptionValue.Strings.class, (String)"Report error if <typename>[:<UsageKind>{,<UsageKind>}] is discovered during analysis (valid values for UsageKind: InHeap, Allocated, Reachable).", SubstrateOptions.class, (String)"ReportAnalysisForbiddenType", SubstrateOptions.ReportAnalysisForbiddenType, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "RunMainInNewThread": {
                return OptionDescriptor.create((String)"RunMainInNewThread", (OptionType)OptionType.Expert, Boolean.class, (String)"Initializes and runs main entry point in a new native thread.", SubstrateOptions.class, (String)"RunMainInNewThread", SubstrateOptions.RunMainInNewThread, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "RunReachabilityHandlersConcurrently": {
                return OptionDescriptor.create((String)"RunReachabilityHandlersConcurrently", (OptionType)OptionType.Expert, Boolean.class, (String)"Run reachability handlers concurrently during analysis.", SubstrateOptions.class, (String)"RunReachabilityHandlersConcurrently", SubstrateOptions.RunReachabilityHandlersConcurrently, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "SharedLibrary": {
                return OptionDescriptor.create((String)"SharedLibrary", (OptionType)OptionType.Debug, Boolean.class, (String)"Build shared library", SubstrateOptions.class, (String)"SharedLibrary", SubstrateOptions.SharedLibrary, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "SourceLevelDebug": {
                return OptionDescriptor.create((String)"SourceLevelDebug", (OptionType)OptionType.Debug, Boolean.class, (String)"Preserve the local variable information for every Java source line to allow line-by-line stepping in the debugger. Allow the lookup of Java-level method information, e.g., in stack traces.", SubstrateOptions.class, (String)"SourceLevelDebug", SubstrateOptions.SourceLevelDebug, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "SourceLevelDebugFilter": {
                return OptionDescriptor.create((String)"SourceLevelDebugFilter", (OptionType)OptionType.Debug, LocatableMultiOptionValue.Strings.class, (String)"Constrain debug info generation to the comma-separated list of package prefixes given to this option.", SubstrateOptions.class, (String)"SourceLevelDebugFilter", SubstrateOptions.SourceLevelDebugFilter, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "SpawnIsolates": {
                return OptionDescriptor.create((String)"SpawnIsolates", (OptionType)OptionType.Debug, Boolean.class, (String)"Support multiple isolates.", SubstrateOptions.class, (String)"SpawnIsolates", SubstrateOptions.SpawnIsolates, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "StackSize": {
                return OptionDescriptor.create((String)"StackSize", (OptionType)OptionType.User, Long.class, (String)"The size of each thread stack at run-time, in bytes.", SubstrateOptions.class, (String)"StackSize", SubstrateOptions.StackSize, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "StackTrace": {
                return OptionDescriptor.create((String)"StackTrace", (OptionType)OptionType.Debug, Boolean.class, (String)"Deprecated, has no effect.", SubstrateOptions.class, (String)"StackTrace", SubstrateOptions.StackTrace, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"");
            }
            case "StartFlightRecording": {
                return OptionDescriptor.create((String)"StartFlightRecording", (OptionType)OptionType.Debug, String.class, (String)"Start flight recording with options.", SubstrateOptions.class, (String)"StartFlightRecording", SubstrateOptions.StartFlightRecording, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "StaticExecutable": {
                return OptionDescriptor.create((String)"StaticExecutable", (OptionType)OptionType.Debug, Boolean.class, (String)"Build statically linked executable (requires static libc and zlib)", SubstrateOptions.class, (String)"StaticExecutable", SubstrateOptions.StaticExecutable, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "StaticExecutableWithDynamicLibC": {
                return OptionDescriptor.create((String)"StaticExecutableWithDynamicLibC", (OptionType)OptionType.Expert, Boolean.class, (String)"Builds a statically linked executable with libc dynamically linked", SubstrateOptions.class, (String)"StaticExecutableWithDynamicLibC", SubstrateOptions.StaticExecutableWithDynamicLibC, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "StaticLibStdCpp": {
                return OptionDescriptor.create((String)"StaticLibStdCpp", (OptionType)OptionType.Expert, Boolean.class, (String)"Builds image with libstdc++ statically linked into the image (if needed)", SubstrateOptions.class, (String)"StaticLibStdCpp", SubstrateOptions.StaticLibStdCpp, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "StrictQueryCodeCompilation": {
                return OptionDescriptor.create((String)"StrictQueryCodeCompilation", (OptionType)OptionType.User, Boolean.class, (String)"Use strict checks when performing query code compilation.", SubstrateOptions.class, (String)"StrictQueryCodeCompilation", SubstrateOptions.StrictQueryCodeCompilation, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "StripDebugInfo": {
                return OptionDescriptor.create((String)"StripDebugInfo", (OptionType)OptionType.Debug, Boolean.class, (String)"Use a separate file for debug info.", SubstrateOptions.class, (String)"StripDebugInfo", SubstrateOptions.StripDebugInfo, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "SupportCompileInIsolates": {
                return OptionDescriptor.create((String)"SupportCompileInIsolates", (OptionType)OptionType.Debug, Boolean.class, (String)"Support runtime compilation in separate isolates (enable at runtime with option CompileInIsolates).", SubstrateOptions.ConcealedOptions.class, (String)"SupportCompileInIsolates", SubstrateOptions.ConcealedOptions.SupportCompileInIsolates, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "TargetPlatform": {
                return OptionDescriptor.create((String)"TargetPlatform", (OptionType)OptionType.Debug, String.class, (String)"Selects native-image compilation target (in <OS>-<architecture> format). Defaults to host's OS-architecture pair.", SubstrateOptions.class, (String)"TargetPlatform", SubstrateOptions.TargetPlatform, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "TearDownFailureNanos": {
                return OptionDescriptor.create((String)"TearDownFailureNanos", (OptionType)OptionType.Debug, Long.class, (String)"The number of nanoseconds before tearing down an isolate gives a failure message.  0 implies no message.", SubstrateOptions.class, (String)"TearDownFailureNanos", SubstrateOptions.TearDownFailureNanos, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "TearDownWarningNanos": {
                return OptionDescriptor.create((String)"TearDownWarningNanos", (OptionType)OptionType.Debug, Long.class, (String)"The number of nanoseconds before and between which tearing down an isolate gives a warning message.  0 implies no warning.", SubstrateOptions.class, (String)"TearDownWarningNanos", SubstrateOptions.TearDownWarningNanos, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ThrowLinkAtBuildTimeIOExceptions": {
                return OptionDescriptor.create((String)"ThrowLinkAtBuildTimeIOExceptions", (OptionType)OptionType.Debug, Boolean.class, (String)"Instead of warning, throw IOExceptions for link-at-build-time resources at build time", SubstrateOptions.class, (String)"ThrowLinkAtBuildTimeIOExceptions", SubstrateOptions.ThrowLinkAtBuildTimeIOExceptions, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ThrowMissingRegistrationErrors": {
                return OptionDescriptor.create((String)"ThrowMissingRegistrationErrors", (OptionType)OptionType.Debug, LocatableMultiOptionValue.Strings.class, (String)"Throw Native Image-specific errors when trying to access an element that has not been registered.", (String[])new String[]{"This can happen on reflection and serialization queries, and resource access.", "If used without args, the errors will be thrown when calling the corresponding query from any class in scope of the option.", "", "Using -H:ThrowMissingRegistrationErrors without arguments is only allowed on command line or when embedded in a", "native-image.properties file of some zip/jar file on the module-path (but not on class-path).", "", "In the module path case, the option will cause all classes of the module to trigger missing registration errors.", "If used without arguments on command line all classes will trigger missing registration errors.", "", "Using -H:ThrowMissingRegistrationErrors with arguments is allowed in every scope:", "", "  1. On command line", "  2. Embedded in a native-image.properties file of some zip/jar file on module-path", "  3. Embedded in a native-image.properties file of some zip/jar file on class-path", "", "If the option is embedded in native-image.properties file in some zip/jar file all class-names", "and package-names passed to the option have to be found in the zip/jar files the option is embedded", "in. Using -H:ThrowMissingRegistrationErrors with arguments on command line does not have that restriction."}, SubstrateOptions.class, (String)"ThrowMissingRegistrationErrors", SubstrateOptions.ThrowMissingRegistrationErrors, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ThrowMissingRegistrationErrorsPaths": {
                return OptionDescriptor.create((String)"ThrowMissingRegistrationErrorsPaths", (OptionType)OptionType.Debug, LocatableMultiOptionValue.Strings.class, (String)"Trigger missing registration errors from all types in the given class or module-path entries.", (String[])new String[]{"", "This option requires arguments that are of the same type as the", "arguments passed via -p (--module-path) or -cp (--class-path):", "", "  -H:ThrowMissingRegistrationErrorsPaths <class search path of directories and zip/jar files>", "", "The given entries are searched and all classes inside are registered as -H:ThrowMissingRegistrationErrorsPaths classes.", "", "This option is only allowed to be used on command line. I.e. the option will be rejected if it is provided", "by Args of a native-image.properties file embedded in a zip/jar file."}, SubstrateOptions.class, (String)"ThrowMissingRegistrationErrorsPaths", SubstrateOptions.ThrowMissingRegistrationErrorsPaths, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "TraceClassInitialization": {
                return OptionDescriptor.create((String)"TraceClassInitialization", (OptionType)OptionType.Debug, LocatableMultiOptionValue.Strings.class, (String)"Comma-separated list of fully-qualified class names that class initialization is traced for.", SubstrateOptions.class, (String)"TraceClassInitialization", SubstrateOptions.TraceClassInitialization, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "TraceNativeToolUsage": {
                return OptionDescriptor.create((String)"TraceNativeToolUsage", (OptionType)OptionType.User, Boolean.class, (String)"Trace all native tool invocations as part of image building", SubstrateOptions.class, (String)"TraceNativeToolUsage", SubstrateOptions.TraceNativeToolUsage, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "TraceObjectInstantiation": {
                return OptionDescriptor.create((String)"TraceObjectInstantiation", (OptionType)OptionType.Debug, LocatableMultiOptionValue.Strings.class, (String)"Comma-separated list of fully-qualified class names that object instantiation is traced for.", SubstrateOptions.class, (String)"TraceObjectInstantiation", SubstrateOptions.TraceObjectInstantiation, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "TraceVMOperations": {
                return OptionDescriptor.create((String)"TraceVMOperations", (OptionType)OptionType.Debug, Boolean.class, (String)"Trace VMOperation execution.", SubstrateOptions.class, (String)"TraceVMOperations", SubstrateOptions.TraceVMOperations, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "UnlockExperimentalVMOptions": {
                return OptionDescriptor.create((String)"UnlockExperimentalVMOptions", (OptionType)OptionType.Expert, Boolean.class, (String)"Enable and disable normal processing of flags relating to experimental options.", SubstrateOptions.class, (String)"UnlockExperimentalVMOptions", SubstrateOptions.UnlockExperimentalVMOptions, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "UseCalleeSavedRegisters": {
                return OptionDescriptor.create((String)"UseCalleeSavedRegisters", (OptionType)OptionType.Debug, Boolean.class, (String)"Use callee saved registers to reduce spilling for low-frequency calls to stubs (if callee saved registers are supported by the architecture)", SubstrateOptions.class, (String)"UseCalleeSavedRegisters", SubstrateOptions.UseCalleeSavedRegisters, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "UseDedicatedVMOperationThread": {
                return OptionDescriptor.create((String)"UseDedicatedVMOperationThread", (OptionType)OptionType.Expert, Boolean.class, (String)"Determines if VM operations should be executed in a dedicated thread.", SubstrateOptions.ConcealedOptions.class, (String)"UseDedicatedVMOperationThread", SubstrateOptions.ConcealedOptions.UseDedicatedVMOperationThread, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "UseDirectCallTrampolinesALot": {
                return OptionDescriptor.create((String)"UseDirectCallTrampolinesALot", (OptionType)OptionType.Debug, Boolean.class, (String)"Force many trampolines to be needed for inter-method calls. Normally trampolines are only used when a method destination is outside the range of a pc-relative branch instruction.", SubstrateOptions.class, (String)"UseDirectCallTrampolinesALot", SubstrateOptions.UseDirectCallTrampolinesALot, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "UseEpsilonGC": {
                return OptionDescriptor.create((String)"UseEpsilonGC", (OptionType)OptionType.Debug, Boolean.class, (String)"Use a no-op GC", SubstrateOptions.class, (String)"UseEpsilonGC", SubstrateOptions.UseEpsilonGC, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "UseImagebuildDebugSections": {
                return OptionDescriptor.create((String)"UseImagebuildDebugSections", (OptionType)OptionType.Debug, Boolean.class, (String)"Emit debuginfo debug.svm.imagebuild.* sections with detailed image-build options.", SubstrateOptions.class, (String)"UseImagebuildDebugSections", SubstrateOptions.UseImagebuildDebugSections, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "UseLibC": {
                return OptionDescriptor.create((String)"UseLibC", (OptionType)OptionType.Debug, String.class, (String)"Selects the libc implementation to use. Available implementations: glibc, musl, bionic", SubstrateOptions.class, (String)"UseLibC", SubstrateOptions.UseLibC, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "UseNullRegion": {
                return OptionDescriptor.create((String)"UseNullRegion", (OptionType)OptionType.Expert, Boolean.class, (String)"Determines if a null region is present between the heap base and the image heap.", SubstrateOptions.class, (String)"UseNullRegion", SubstrateOptions.UseNullRegion, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "UseOldMethodHandleIntrinsics": {
                return OptionDescriptor.create((String)"UseOldMethodHandleIntrinsics", (OptionType)OptionType.Expert, Boolean.class, (String)"Force using legacy method handle intrinsics.", SubstrateOptions.class, (String)"UseOldMethodHandleIntrinsics", SubstrateOptions.UseOldMethodHandleIntrinsics, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "UsePerfData": {
                return OptionDescriptor.create((String)"UsePerfData", (OptionType)OptionType.Debug, Boolean.class, (String)"Flag to disable jvmstat instrumentation for performance testing.", SubstrateOptions.ConcealedOptions.class, (String)"UsePerfData", SubstrateOptions.ConcealedOptions.UsePerfData, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "UseRememberedSet": {
                return OptionDescriptor.create((String)"UseRememberedSet", (OptionType)OptionType.Expert, Boolean.class, (String)"Determines if a remembered sets is used, which is necessary for collecting the young and old generation independently.", SubstrateOptions.ConcealedOptions.class, (String)"UseRememberedSet", SubstrateOptions.ConcealedOptions.UseRememberedSet, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "UseSerialGC": {
                return OptionDescriptor.create((String)"UseSerialGC", (OptionType)OptionType.Debug, Boolean.class, (String)"Use a serial GC", SubstrateOptions.class, (String)"UseSerialGC", SubstrateOptions.UseSerialGC, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "VerifyNamingConventions": {
                return OptionDescriptor.create((String)"VerifyNamingConventions", (OptionType)OptionType.Debug, Boolean.class, (String)"Verify naming conventions during image construction.", SubstrateOptions.class, (String)"VerifyNamingConventions", SubstrateOptions.VerifyNamingConventions, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "VerifyTypes": {
                return OptionDescriptor.create((String)"VerifyTypes", (OptionType)OptionType.Debug, Boolean.class, (String)"Verify type states computed by the static analysis at run time. This is useful when diagnosing problems in the static analysis, but reduces peak performance significantly.", SubstrateOptions.class, (String)"VerifyTypes", SubstrateOptions.VerifyTypes, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 146;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return SubstrateOptions_OptionDescriptors.this.get("AOTInline");
                    }
                    case 1: {
                        return SubstrateOptions_OptionDescriptors.this.get("AOTTrivialInline");
                    }
                    case 2: {
                        return SubstrateOptions_OptionDescriptors.this.get("APIFunctionPrefix");
                    }
                    case 3: {
                        return SubstrateOptions_OptionDescriptors.this.get("ActiveProcessorCount");
                    }
                    case 4: {
                        return SubstrateOptions_OptionDescriptors.this.get("AdditionalHeaderBytes");
                    }
                    case 5: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllocateInstancePrefetchLines");
                    }
                    case 6: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllocatePrefetchDistance");
                    }
                    case 7: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllocatePrefetchInstr");
                    }
                    case 8: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllocatePrefetchLines");
                    }
                    case 9: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllocatePrefetchStepSize");
                    }
                    case 10: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllocatePrefetchStyle");
                    }
                    case 11: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllowDeprecatedBuilderClassesOnImageClasspath");
                    }
                    case 12: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllowVMInternalThreads");
                    }
                    case 13: {
                        return SubstrateOptions_OptionDescriptors.this.get("AsyncSignalSafeDiagnostics");
                    }
                    case 14: {
                        return SubstrateOptions_OptionDescriptors.this.get("AutomaticReferenceHandling");
                    }
                    case 15: {
                        return SubstrateOptions_OptionDescriptors.this.get("BuildOutputBreakdowns");
                    }
                    case 16: {
                        return SubstrateOptions_OptionDescriptors.this.get("BuildOutputColorful");
                    }
                    case 17: {
                        return SubstrateOptions_OptionDescriptors.this.get("BuildOutputGCWarnings");
                    }
                    case 18: {
                        return SubstrateOptions_OptionDescriptors.this.get("BuildOutputJSONFile");
                    }
                    case 19: {
                        return SubstrateOptions_OptionDescriptors.this.get("BuildOutputLinks");
                    }
                    case 20: {
                        return SubstrateOptions_OptionDescriptors.this.get("BuildOutputPrefix");
                    }
                    case 21: {
                        return SubstrateOptions_OptionDescriptors.this.get("BuildOutputProgress");
                    }
                    case 22: {
                        return SubstrateOptions_OptionDescriptors.this.get("BuildOutputRecommendations");
                    }
                    case 23: {
                        return SubstrateOptions_OptionDescriptors.this.get("BuildOutputSilent");
                    }
                    case 24: {
                        return SubstrateOptions_OptionDescriptors.this.get("CCompilerOption");
                    }
                    case 25: {
                        return SubstrateOptions_OptionDescriptors.this.get("CCompilerPath");
                    }
                    case 26: {
                        return SubstrateOptions_OptionDescriptors.this.get("CLibraryPath");
                    }
                    case 27: {
                        return SubstrateOptions_OptionDescriptors.this.get("CheckBootModuleDependencies");
                    }
                    case 28: {
                        return SubstrateOptions_OptionDescriptors.this.get("CheckIsolateThreadAtEntry");
                    }
                    case 29: {
                        return SubstrateOptions_OptionDescriptors.this.get("CheckToolchain");
                    }
                    case 30: {
                        return SubstrateOptions_OptionDescriptors.this.get("Class");
                    }
                    case 31: {
                        return SubstrateOptions_OptionDescriptors.this.get("CodeAlignment");
                    }
                    case 32: {
                        return SubstrateOptions_OptionDescriptors.this.get("Color");
                    }
                    case 33: {
                        return SubstrateOptions_OptionDescriptors.this.get("CompilationIsolateAddressSpaceSize");
                    }
                    case 34: {
                        return SubstrateOptions_OptionDescriptors.this.get("CompilationIsolateOptions");
                    }
                    case 35: {
                        return SubstrateOptions_OptionDescriptors.this.get("CompileInIsolates");
                    }
                    case 36: {
                        return SubstrateOptions_OptionDescriptors.this.get("CompilerBackend");
                    }
                    case 37: {
                        return SubstrateOptions_OptionDescriptors.this.get("ConfigureReflectionMetadata");
                    }
                    case 38: {
                        return SubstrateOptions_OptionDescriptors.this.get("ContendedPaddingWidth");
                    }
                    case 39: {
                        return SubstrateOptions_OptionDescriptors.this.get("DeadlockWatchdogExitOnTimeout");
                    }
                    case 40: {
                        return SubstrateOptions_OptionDescriptors.this.get("DeadlockWatchdogInterval");
                    }
                    case 41: {
                        return SubstrateOptions_OptionDescriptors.this.get("DebugCodeInfoMaxDepth");
                    }
                    case 42: {
                        return SubstrateOptions_OptionDescriptors.this.get("DebugCodeInfoUseSourceMappings");
                    }
                    case 43: {
                        return SubstrateOptions_OptionDescriptors.this.get("DebugInfoSourceCacheRoot");
                    }
                    case 44: {
                        return SubstrateOptions_OptionDescriptors.this.get("DeleteLocalSymbols");
                    }
                    case 45: {
                        return SubstrateOptions_OptionDescriptors.this.get("DetectUserDirectoriesInImageHeap");
                    }
                    case 46: {
                        return SubstrateOptions_OptionDescriptors.this.get("DiagnosticBufferSize");
                    }
                    case 47: {
                        return SubstrateOptions_OptionDescriptors.this.get("DiagnosticDetails");
                    }
                    case 48: {
                        return SubstrateOptions_OptionDescriptors.this.get("DisableTypeIdResultVerification");
                    }
                    case 49: {
                        return SubstrateOptions_OptionDescriptors.this.get("DisableURLProtocols");
                    }
                    case 50: {
                        return SubstrateOptions_OptionDescriptors.this.get("DumpHeapAndExit");
                    }
                    case 51: {
                        return SubstrateOptions_OptionDescriptors.this.get("DumpTargetInfo");
                    }
                    case 52: {
                        return SubstrateOptions_OptionDescriptors.this.get("EnableAllSecurityServices");
                    }
                    case 53: {
                        return SubstrateOptions_OptionDescriptors.this.get("EnableSignalHandling");
                    }
                    case 54: {
                        return SubstrateOptions_OptionDescriptors.this.get("EnableURLProtocols");
                    }
                    case 55: {
                        return SubstrateOptions_OptionDescriptors.this.get("EnableWildcardExpansion");
                    }
                    case 56: {
                        return SubstrateOptions_OptionDescriptors.this.get("EntryPointNamePrefix");
                    }
                    case 57: {
                        return SubstrateOptions_OptionDescriptors.this.get("FallbackThreshold");
                    }
                    case 58: {
                        return SubstrateOptions_OptionDescriptors.this.get("FlightRecorder");
                    }
                    case 59: {
                        return SubstrateOptions_OptionDescriptors.this.get("FlightRecorderLogging");
                    }
                    case 60: {
                        return SubstrateOptions_OptionDescriptors.this.get("FoldSecurityManagerGetter");
                    }
                    case 61: {
                        return SubstrateOptions_OptionDescriptors.this.get("ForceNoROSectionRelocations");
                    }
                    case 62: {
                        return SubstrateOptions_OptionDescriptors.this.get("GenerateBuildArtifactsFile");
                    }
                    case 63: {
                        return SubstrateOptions_OptionDescriptors.this.get("GenerateDebugInfo");
                    }
                    case 64: {
                        return SubstrateOptions_OptionDescriptors.this.get("HeapDumpDefaultFilenamePrefix");
                    }
                    case 65: {
                        return SubstrateOptions_OptionDescriptors.this.get("HeapDumpOnOutOfMemoryError");
                    }
                    case 66: {
                        return SubstrateOptions_OptionDescriptors.this.get("HeapDumpPath");
                    }
                    case 67: {
                        return SubstrateOptions_OptionDescriptors.this.get("ImageBuildID");
                    }
                    case 68: {
                        return SubstrateOptions_OptionDescriptors.this.get("ImageSymbolsPrefix");
                    }
                    case 69: {
                        return SubstrateOptions_OptionDescriptors.this.get("ImplicitExceptionWithoutStacktraceIsFatal");
                    }
                    case 70: {
                        return SubstrateOptions_OptionDescriptors.this.get("IncludeDebugHelperMethods");
                    }
                    case 71: {
                        return SubstrateOptions_OptionDescriptors.this.get("IncludeMethodData");
                    }
                    case 72: {
                        return SubstrateOptions_OptionDescriptors.this.get("IncludeNodeSourcePositions");
                    }
                    case 73: {
                        return SubstrateOptions_OptionDescriptors.this.get("IndirectBranchTargetMarker");
                    }
                    case 74: {
                        return SubstrateOptions_OptionDescriptors.this.get("InstallExitHandlers");
                    }
                    case 75: {
                        return SubstrateOptions_OptionDescriptors.this.get("InternalSymbolsAreGlobal");
                    }
                    case 76: {
                        return SubstrateOptions_OptionDescriptors.this.get("InternalThreadStackSize");
                    }
                    case 77: {
                        return SubstrateOptions_OptionDescriptors.this.get("JNI");
                    }
                    case 78: {
                        return SubstrateOptions_OptionDescriptors.this.get("JNIEnhancedErrorCodes");
                    }
                    case 79: {
                        return SubstrateOptions_OptionDescriptors.this.get("JNIExportSymbols");
                    }
                    case 80: {
                        return SubstrateOptions_OptionDescriptors.this.get("JNIVerboseLookupErrors");
                    }
                    case 81: {
                        return SubstrateOptions_OptionDescriptors.this.get("LinkerRPath");
                    }
                    case 82: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxDirectMemorySize");
                    }
                    case 83: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxInvokesInTrivialMethod");
                    }
                    case 84: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxJavaStackTraceDepth");
                    }
                    case 85: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxNodesAfterTrivialInlining");
                    }
                    case 86: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxNodesInTrivialLeafMethod");
                    }
                    case 87: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxNodesInTrivialMethod");
                    }
                    case 88: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxRAM");
                    }
                    case 89: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxUnrolledObjectZeroingStores");
                    }
                    case 90: {
                        return SubstrateOptions_OptionDescriptors.this.get("Method");
                    }
                    case 91: {
                        return SubstrateOptions_OptionDescriptors.this.get("MissingRegistrationReportingMode");
                    }
                    case 92: {
                        return SubstrateOptions_OptionDescriptors.this.get("Module");
                    }
                    case 93: {
                        return SubstrateOptions_OptionDescriptors.this.get("MultiThreaded");
                    }
                    case 94: {
                        return SubstrateOptions_OptionDescriptors.this.get("Name");
                    }
                    case 95: {
                        return SubstrateOptions_OptionDescriptors.this.get("NeverInline");
                    }
                    case 96: {
                        return SubstrateOptions_OptionDescriptors.this.get("OmitInlinedMethodDebugLineInfo");
                    }
                    case 97: {
                        return SubstrateOptions_OptionDescriptors.this.get("Optimize");
                    }
                    case 98: {
                        return SubstrateOptions_OptionDescriptors.this.get("PageSize");
                    }
                    case 99: {
                        return SubstrateOptions_OptionDescriptors.this.get("ParseOnce");
                    }
                    case 100: {
                        return SubstrateOptions_OptionDescriptors.this.get("ParseOnceJIT");
                    }
                    case 101: {
                        return SubstrateOptions_OptionDescriptors.this.get("ParseRuntimeOptions");
                    }
                    case 102: {
                        return SubstrateOptions_OptionDescriptors.this.get("Path");
                    }
                    case 103: {
                        return SubstrateOptions_OptionDescriptors.this.get("PinnedObjectAddressing");
                    }
                    case 104: {
                        return SubstrateOptions_OptionDescriptors.this.get("PreserveFramePointer");
                    }
                    case 105: {
                        return SubstrateOptions_OptionDescriptors.this.get("RemoveUnusedSymbols");
                    }
                    case 106: {
                        return SubstrateOptions_OptionDescriptors.this.get("ReportAnalysisForbiddenType");
                    }
                    case 107: {
                        return SubstrateOptions_OptionDescriptors.this.get("RunMainInNewThread");
                    }
                    case 108: {
                        return SubstrateOptions_OptionDescriptors.this.get("RunReachabilityHandlersConcurrently");
                    }
                    case 109: {
                        return SubstrateOptions_OptionDescriptors.this.get("SharedLibrary");
                    }
                    case 110: {
                        return SubstrateOptions_OptionDescriptors.this.get("SourceLevelDebug");
                    }
                    case 111: {
                        return SubstrateOptions_OptionDescriptors.this.get("SourceLevelDebugFilter");
                    }
                    case 112: {
                        return SubstrateOptions_OptionDescriptors.this.get("SpawnIsolates");
                    }
                    case 113: {
                        return SubstrateOptions_OptionDescriptors.this.get("StackSize");
                    }
                    case 114: {
                        return SubstrateOptions_OptionDescriptors.this.get("StackTrace");
                    }
                    case 115: {
                        return SubstrateOptions_OptionDescriptors.this.get("StartFlightRecording");
                    }
                    case 116: {
                        return SubstrateOptions_OptionDescriptors.this.get("StaticExecutable");
                    }
                    case 117: {
                        return SubstrateOptions_OptionDescriptors.this.get("StaticExecutableWithDynamicLibC");
                    }
                    case 118: {
                        return SubstrateOptions_OptionDescriptors.this.get("StaticLibStdCpp");
                    }
                    case 119: {
                        return SubstrateOptions_OptionDescriptors.this.get("StrictQueryCodeCompilation");
                    }
                    case 120: {
                        return SubstrateOptions_OptionDescriptors.this.get("StripDebugInfo");
                    }
                    case 121: {
                        return SubstrateOptions_OptionDescriptors.this.get("SupportCompileInIsolates");
                    }
                    case 122: {
                        return SubstrateOptions_OptionDescriptors.this.get("TargetPlatform");
                    }
                    case 123: {
                        return SubstrateOptions_OptionDescriptors.this.get("TearDownFailureNanos");
                    }
                    case 124: {
                        return SubstrateOptions_OptionDescriptors.this.get("TearDownWarningNanos");
                    }
                    case 125: {
                        return SubstrateOptions_OptionDescriptors.this.get("ThrowLinkAtBuildTimeIOExceptions");
                    }
                    case 126: {
                        return SubstrateOptions_OptionDescriptors.this.get("ThrowMissingRegistrationErrors");
                    }
                    case 127: {
                        return SubstrateOptions_OptionDescriptors.this.get("ThrowMissingRegistrationErrorsPaths");
                    }
                    case 128: {
                        return SubstrateOptions_OptionDescriptors.this.get("TraceClassInitialization");
                    }
                    case 129: {
                        return SubstrateOptions_OptionDescriptors.this.get("TraceNativeToolUsage");
                    }
                    case 130: {
                        return SubstrateOptions_OptionDescriptors.this.get("TraceObjectInstantiation");
                    }
                    case 131: {
                        return SubstrateOptions_OptionDescriptors.this.get("TraceVMOperations");
                    }
                    case 132: {
                        return SubstrateOptions_OptionDescriptors.this.get("UnlockExperimentalVMOptions");
                    }
                    case 133: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseCalleeSavedRegisters");
                    }
                    case 134: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseDedicatedVMOperationThread");
                    }
                    case 135: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseDirectCallTrampolinesALot");
                    }
                    case 136: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseEpsilonGC");
                    }
                    case 137: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseImagebuildDebugSections");
                    }
                    case 138: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseLibC");
                    }
                    case 139: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseNullRegion");
                    }
                    case 140: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseOldMethodHandleIntrinsics");
                    }
                    case 141: {
                        return SubstrateOptions_OptionDescriptors.this.get("UsePerfData");
                    }
                    case 142: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseRememberedSet");
                    }
                    case 143: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseSerialGC");
                    }
                    case 144: {
                        return SubstrateOptions_OptionDescriptors.this.get("VerifyNamingConventions");
                    }
                    case 145: {
                        return SubstrateOptions_OptionDescriptors.this.get("VerifyTypes");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

