/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.MissingRegistrationSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.util.ExitStatus;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class MissingRegistrationUtils {
    public static final String ERROR_EMPHASIS_INDENT = "   ";
    private static final int CONTEXT_LINES = 4;
    private static final Set<String> seenOutputs = SubstrateOptions.MissingRegistrationReportingMode.getValue() == SubstrateOptions.ReportingMode.Warn ? ConcurrentHashMap.newKeySet() : null;

    public static boolean throwMissingRegistrationErrors() {
        return SubstrateOptions.ThrowMissingRegistrationErrors.hasBeenSet();
    }

    public static SubstrateOptions.ReportingMode missingRegistrationReportingMode() {
        return SubstrateOptions.MissingRegistrationReportingMode.getValue();
    }

    public static void report(Error exception, StackTraceElement responsibleClass) {
        if (responsibleClass != null && !MissingRegistrationSupport.singleton().reportMissingRegistrationErrors(responsibleClass)) {
            return;
        }
        switch (MissingRegistrationUtils.missingRegistrationReportingMode()) {
            case Throw: {
                throw exception;
            }
            case Exit: {
                exception.printStackTrace(System.out);
                System.exit(ExitStatus.MISSING_METADATA.getValue());
                break;
            }
            case ExitTest: {
                throw new ExitException(exception);
            }
            case Warn: {
                String output;
                StackTraceElement[] stackTrace = exception.getStackTrace();
                int printed = 0;
                StackTraceElement entryPoint = null;
                StringBuilder sb = new StringBuilder(exception.toString());
                sb.append("\n");
                for (StackTraceElement stackTraceElement : stackTrace) {
                    if (printed == 0) {
                        String moduleName = stackTraceElement.getModuleName();
                        if (moduleName != null && (moduleName.equals("java.base") || moduleName.startsWith("org.graalvm"))) {
                            entryPoint = stackTraceElement;
                        } else {
                            MissingRegistrationUtils.printLine(sb, entryPoint);
                            ++printed;
                        }
                    }
                    if (printed > 0) {
                        MissingRegistrationUtils.printLine(sb, stackTraceElement);
                        ++printed;
                    }
                    if (printed >= 4) break;
                }
                if (seenOutputs.isEmpty()) {
                    System.out.println("Note: this run will print partial stack traces of the locations where a " + exception.getClass().toString() + " would be thrown when the -H:+ThrowMissingRegistrationErrors option is set. The trace stops at the first entry of JDK code and provides 4 lines of context.");
                }
                if (!seenOutputs.add(output = sb.toString())) break;
                System.out.print(output);
            }
        }
    }

    private static void printLine(StringBuilder sb, Object object) {
        sb.append("  ").append(object).append(System.lineSeparator());
    }

    public static final class ExitException
    extends Error {
        private static final long serialVersionUID = -3638940737396726143L;

        public ExitException(Throwable cause) {
            super(cause);
        }
    }
}

