/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysisPolicy;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ReachabilityRegistrationNode;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedElement;
import java.util.Map;
import java.util.Set;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.FullInfopointNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.ValueAnchorNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.java.AbstractNewObjectNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.spi.ValueProxy;
import org.graalvm.compiler.nodes.virtual.AllocatedObjectNode;
import org.graalvm.compiler.nodes.virtual.CommitAllocationNode;
import org.graalvm.compiler.nodes.virtual.VirtualArrayNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.replacements.nodes.MethodHandleWithExceptionNode;
import org.graalvm.nativeimage.AnnotationAccess;

public class InlineBeforeAnalysisPolicyUtils {
    private static final Class<? extends Annotation> COMPILED_LAMBDA_FORM_ANNOTATION = ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.invoke.LambdaForm$Compiled");
    private static final Class<?> INVOKERS_CLASS = ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.invoke.Invokers");
    private static final Map<Class<?>, Set<String>> IGNORED_METHOD_HANDLE_METHODS = Map.of(MethodHandle.class, Set.of("bindTo"), MethodHandles.class, Set.of("dropArguments", "filterReturnValue", "foldArguments", "insertArguments"), INVOKERS_CLASS, Set.of("spreadInvoker"));
    private AnalysisType methodHandleType;
    private AnalysisType varHandleGuardsType;

    public static boolean inliningAllowed(SVMHost hostVM, GraphBuilderContext b, ResolvedJavaMethod method) {
        AnalysisMethod callee;
        AnalysisMethod caller = (AnalysisMethod)b.getMethod();
        if (hostVM.neverInlineTrivial(caller, callee = (AnalysisMethod)method)) {
            return false;
        }
        if (AnnotationAccess.isAnnotationPresent((AnnotatedElement)callee, Fold.class) || AnnotationAccess.isAnnotationPresent((AnnotatedElement)callee, Node.NodeIntrinsic.class)) {
            return false;
        }
        if (AnnotationAccess.isAnnotationPresent((AnnotatedElement)callee, RestrictHeapAccess.class)) {
            return false;
        }
        if (!Uninterruptible.Utils.inliningAllowed((AnnotatedElement)caller, (AnnotatedElement)callee)) {
            return false;
        }
        return !callee.getReturnsAllInstantiatedTypes();
    }

    public boolean alwaysInlineInvoke(AnalysisMetaAccess metaAccess, ResolvedJavaMethod method) {
        return false;
    }

    public AccumulativeInlineScope createAccumulativeInlineScope(AccumulativeInlineScope outer, AnalysisMetaAccess metaAccess, ResolvedJavaMethod method, boolean[] constArgsWithReceiver, boolean intrinsifiedMethodHandle) {
        AccumulativeCounters accumulativeCounters;
        int depth;
        if (outer == null) {
            depth = 1;
            accumulativeCounters = AccumulativeCounters.create(null);
        } else if (!outer.accumulativeCounters.inMethodHandleIntrinsification && (intrinsifiedMethodHandle || this.isMethodHandleIntrinsificationRoot(metaAccess, method, constArgsWithReceiver))) {
            depth = outer.inliningDepth + 1;
            accumulativeCounters = AccumulativeCounters.createForMethodHandleIntrinsification(outer.accumulativeCounters);
        } else if (outer.accumulativeCounters.inMethodHandleIntrinsification && !InlineBeforeAnalysisPolicyUtils.inlineForMethodHandleIntrinsification(method)) {
            depth = outer.inliningDepth + 1;
            accumulativeCounters = AccumulativeCounters.create(outer.accumulativeCounters);
        } else {
            depth = outer.inliningDepth + 1;
            accumulativeCounters = outer.accumulativeCounters;
        }
        return new AccumulativeInlineScope(accumulativeCounters, depth);
    }

    private boolean isMethodHandleIntrinsificationRoot(AnalysisMetaAccess metaAccess, ResolvedJavaMethod method, boolean[] constArgsWithReceiver) {
        return (this.isVarHandleMethod(metaAccess, method) || this.hasConstantMethodHandleParameter(metaAccess, method, constArgsWithReceiver)) && !InlineBeforeAnalysisPolicyUtils.isIgnoredMethodHandleMethod(method);
    }

    private boolean hasConstantMethodHandleParameter(AnalysisMetaAccess metaAccess, ResolvedJavaMethod method, boolean[] constArgsWithReceiver) {
        if (this.methodHandleType == null) {
            this.methodHandleType = metaAccess.lookupJavaType(MethodHandle.class);
        }
        for (int i = 0; i < constArgsWithReceiver.length; ++i) {
            if (!constArgsWithReceiver[i] || !this.methodHandleType.isAssignableFrom(InlineBeforeAnalysisPolicyUtils.getParameterType(method, i))) continue;
            return true;
        }
        return false;
    }

    private static ResolvedJavaType getParameterType(ResolvedJavaMethod method, int index) {
        int i = index;
        if (!method.isStatic()) {
            if (i == 0) {
                return method.getDeclaringClass();
            }
            --i;
        }
        return (ResolvedJavaType)method.getSignature().getParameterType(i, null);
    }

    private boolean isVarHandleMethod(AnalysisMetaAccess metaAccess, ResolvedJavaMethod method) {
        if (this.varHandleGuardsType == null) {
            this.varHandleGuardsType = metaAccess.lookupJavaType(ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.invoke.VarHandleGuards"));
        }
        return method.getDeclaringClass().equals(this.varHandleGuardsType);
    }

    private static boolean isIgnoredMethodHandleMethod(ResolvedJavaMethod method) {
        Class declaringClass = OriginalClassProvider.getJavaClass((ResolvedJavaType)method.getDeclaringClass());
        Set<String> ignoredMethods = IGNORED_METHOD_HANDLE_METHODS.get(declaringClass);
        return ignoredMethods != null && ignoredMethods.contains(method.getName());
    }

    private static boolean inlineForMethodHandleIntrinsification(ResolvedJavaMethod method) {
        String className = method.getDeclaringClass().toJavaName(true);
        if (className.startsWith("java.lang.invoke") && !className.contains("InvokerBytecodeGenerator")) {
            return true;
        }
        return className.equals("sun.invoke.util.ValueConversions");
    }

    protected boolean shouldOmitIntermediateMethodInState(ResolvedJavaMethod method) {
        return method.isAnnotationPresent(COMPILED_LAMBDA_FORM_ANNOTATION);
    }

    static final class AccumulativeCounters {
        int maxNodes;
        int maxInvokes;
        final int maxInliningDepth;
        final boolean inMethodHandleIntrinsification;
        int numNodes = 0;
        int numInvokes = 0;

        static AccumulativeCounters create(AccumulativeCounters outer) {
            int maxDepth = outer != null ? outer.maxInliningDepth : Options.InlineBeforeAnalysisAllowedDepth.getValue();
            return new AccumulativeCounters(Options.InlineBeforeAnalysisAllowedNodes.getValue(), Options.InlineBeforeAnalysisAllowedInvokes.getValue(), maxDepth, false);
        }

        static AccumulativeCounters createForMethodHandleIntrinsification(AccumulativeCounters outer) {
            return new AccumulativeCounters(Options.InlineBeforeAnalysisMethodHandleAllowedNodes.getValue(), Options.InlineBeforeAnalysisMethodHandleAllowedInvokes.getValue(), outer.maxInliningDepth, true);
        }

        private AccumulativeCounters(int maxNodes, int maxInvokes, int maxInliningDepth, boolean inMethodHandleIntrinsification) {
            this.maxNodes = maxNodes;
            this.maxInvokes = maxInvokes;
            this.maxInliningDepth = maxInliningDepth;
            this.inMethodHandleIntrinsification = inMethodHandleIntrinsification;
        }
    }

    public final class AccumulativeInlineScope
    extends InlineBeforeAnalysisPolicy.AbstractPolicyScope {
        final AccumulativeCounters accumulativeCounters;
        int numNodes;
        int numInvokes;

        AccumulativeInlineScope(AccumulativeCounters accumulativeCounters, int inliningDepth) {
            super(inliningDepth);
            this.numNodes = 0;
            this.numInvokes = 0;
            this.accumulativeCounters = accumulativeCounters;
        }

        public boolean allowAbort() {
            return true;
        }

        public void commitCalleeScope(InlineBeforeAnalysisPolicy.AbstractPolicyScope callee) {
            AccumulativeInlineScope calleeScope = (AccumulativeInlineScope)callee;
            if (this.accumulativeCounters != calleeScope.accumulativeCounters) {
                assert (this.accumulativeCounters.inMethodHandleIntrinsification != calleeScope.accumulativeCounters.inMethodHandleIntrinsification);
                this.accumulativeCounters.maxNodes += calleeScope.numNodes;
                this.accumulativeCounters.maxInvokes += calleeScope.numInvokes;
                this.accumulativeCounters.numNodes += calleeScope.numNodes;
                this.accumulativeCounters.numInvokes += calleeScope.numInvokes;
            }
            this.numNodes += calleeScope.numNodes;
            this.numInvokes += calleeScope.numInvokes;
        }

        public void abortCalleeScope(InlineBeforeAnalysisPolicy.AbstractPolicyScope callee) {
            AccumulativeInlineScope calleeScope = (AccumulativeInlineScope)callee;
            if (this.accumulativeCounters == calleeScope.accumulativeCounters) {
                this.accumulativeCounters.numNodes -= calleeScope.numNodes;
                this.accumulativeCounters.numInvokes -= calleeScope.numInvokes;
            } else assert (this.accumulativeCounters.inMethodHandleIntrinsification != calleeScope.accumulativeCounters.inMethodHandleIntrinsification);
        }

        public boolean processNode(AnalysisMetaAccess metaAccess, ResolvedJavaMethod method, Node node) {
            if (node instanceof StartNode || node instanceof ParameterNode || node instanceof ReturnNode || node instanceof UnwindNode || node instanceof CallTargetNode || node instanceof MethodHandleWithExceptionNode) {
                throw VMError.shouldNotReachHere("Node must not be visible to policy: " + node.getClass().getTypeName());
            }
            if (InlineBeforeAnalysisPolicyUtils.this.alwaysInlineInvoke(metaAccess, method)) {
                return true;
            }
            if (this.inliningDepth > this.accumulativeCounters.maxInliningDepth) {
                return false;
            }
            if (node instanceof FullInfopointNode || node instanceof ValueProxy || node instanceof ValueAnchorNode || node instanceof FrameState || node instanceof AbstractBeginNode || node instanceof AbstractEndNode) {
                return true;
            }
            if (node instanceof ConstantNode || node instanceof LogicConstantNode) {
                return true;
            }
            if (node instanceof ReachabilityRegistrationNode) {
                return true;
            }
            boolean allow = true;
            if (node instanceof AbstractNewObjectNode) {
                ValueNode newArrayLength;
                if (node instanceof NewArrayNode && (newArrayLength = ((NewArrayNode)node).length()).isJavaConstant() && newArrayLength.asJavaConstant().asInt() == 0) {
                    return true;
                }
                allow = false;
            } else if (node instanceof VirtualObjectNode) {
                int newArrayLength;
                if (node instanceof VirtualArrayNode && (newArrayLength = ((VirtualArrayNode)node).entryCount()) == 0) {
                    return true;
                }
                allow = false;
            } else if (node instanceof CommitAllocationNode || node instanceof AllocatedObjectNode) {
                return true;
            }
            if (node instanceof Invoke) {
                if (this.accumulativeCounters.numInvokes >= this.accumulativeCounters.maxInvokes) {
                    return false;
                }
                ++this.numInvokes;
                ++this.accumulativeCounters.numInvokes;
            }
            if (this.accumulativeCounters.numNodes >= this.accumulativeCounters.maxNodes) {
                return false;
            }
            ++this.numNodes;
            ++this.accumulativeCounters.numNodes;
            return allow || this.accumulativeCounters.inMethodHandleIntrinsification;
        }

        public String toString() {
            return "AccumulativeInlineScope: " + this.numNodes + "/" + this.numInvokes + " (" + this.accumulativeCounters.numNodes + "/" + this.accumulativeCounters.numInvokes + ")";
        }
    }

    public static class AlwaysInlineScope
    extends InlineBeforeAnalysisPolicy.AbstractPolicyScope {
        public AlwaysInlineScope(int inliningDepth) {
            super(inliningDepth);
        }

        public boolean allowAbort() {
            return false;
        }

        public void commitCalleeScope(InlineBeforeAnalysisPolicy.AbstractPolicyScope callee) {
        }

        public void abortCalleeScope(InlineBeforeAnalysisPolicy.AbstractPolicyScope callee) {
        }

        public boolean processNode(AnalysisMetaAccess metaAccess, ResolvedJavaMethod method, Node node) {
            return true;
        }

        public String toString() {
            return "AlwaysInlineScope";
        }
    }

    public static class Options {
        public static final HostedOptionKey<Integer> InlineBeforeAnalysisAllowedNodes = new HostedOptionKey<Integer>(1);
        public static final HostedOptionKey<Integer> InlineBeforeAnalysisAllowedInvokes = new HostedOptionKey<Integer>(1);
        public static final HostedOptionKey<Integer> InlineBeforeAnalysisAllowedDepth = new HostedOptionKey<Integer>(20);
        public static final HostedOptionKey<Integer> InlineBeforeAnalysisMethodHandleAllowedNodes = new HostedOptionKey<Integer>(100);
        public static final HostedOptionKey<Integer> InlineBeforeAnalysisMethodHandleAllowedInvokes = new HostedOptionKey<Integer>(20);
    }
}

