/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jni;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.infrastructure.WrappedSignature;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionKind;
import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.jni.JNIJavaCallWrapperHolder;
import com.oracle.svm.hosted.code.FactoryMethodSupport;
import com.oracle.svm.hosted.code.NonBytecodeMethod;
import com.oracle.svm.hosted.code.SimpleSignature;
import com.oracle.svm.hosted.jni.JNIGraphKit;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.util.List;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.IndirectCallTargetNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.ObjectEqualsNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.word.WordTypes;

public class JNIJavaCallWrapperMethod
extends NonBytecodeMethod {
    private static final Constructor<InstantiationException> INSTANTIATION_EXCEPTION_CONSTRUCTOR = ReflectionUtil.lookupConstructor(InstantiationException.class, (Class[])new Class[0]);
    private final Signature targetSignature;

    public static SimpleSignature getGeneralizedSignatureForTarget(ResolvedJavaMethod targetMethod, MetaAccessProvider originalMetaAccess) {
        ResolvedJavaType objectType = originalMetaAccess.lookupJavaType(Object.class);
        JavaType[] paramTypes = targetMethod.getSignature().toParameterTypes(null);
        for (int i = 0; i < paramTypes.length; ++i) {
            if (!paramTypes[i].getJavaKind().isObject()) continue;
            paramTypes[i] = objectType;
        }
        JavaKind returnKind = targetMethod.getSignature().getReturnKind();
        if (targetMethod.isConstructor()) {
            returnKind = JavaKind.Object;
        } else if (returnKind.isNumericInteger() || returnKind == JavaKind.Void) {
            returnKind = JavaKind.Long;
        }
        ResolvedJavaType returnType = returnKind.isObject() ? objectType : originalMetaAccess.lookupJavaType(returnKind.toJavaClass());
        return new SimpleSignature(paramTypes, (JavaType)returnType);
    }

    protected JNIJavaCallWrapperMethod(SimpleSignature targetSignature, MetaAccessProvider metaAccess, WordTypes wordTypes) {
        super("invoke_" + targetSignature.getIdentifier(), true, metaAccess.lookupJavaType(JNIJavaCallWrapperHolder.class), JNIJavaCallWrapperMethod.createSignature(targetSignature, metaAccess, wordTypes), JNIJavaCallWrapperHolder.getConstantPool(metaAccess));
        this.targetSignature = targetSignature;
    }

    private static SimpleSignature createSignature(Signature targetSignature, MetaAccessProvider originalMetaAccess, WordTypes wordTypes) {
        JavaKind wordKind = wordTypes.getWordKind();
        int count = targetSignature.getParameterCount(false);
        JavaKind[] args = new JavaKind[3 + count];
        args[0] = wordKind;
        args[1] = wordKind;
        args[2] = JavaKind.Boolean.getStackKind();
        for (int i = 0; i < count; ++i) {
            JavaKind kind = targetSignature.getParameterKind(i);
            if (kind.isObject()) {
                kind = wordKind;
            }
            args[3 + i] = kind.getStackKind();
        }
        JavaKind returnKind = targetSignature.getReturnKind();
        if (returnKind.isObject()) {
            returnKind = wordKind;
        }
        return SimpleSignature.fromKinds(args, returnKind, originalMetaAccess);
    }

    @Override
    public SimpleSignature getSignature() {
        return (SimpleSignature)super.getSignature();
    }

    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        ValueNode[] args;
        UniverseMetaAccess metaAccess = (UniverseMetaAccess)providers.getMetaAccess();
        JNIGraphKit kit = new JNIGraphKit(debug, providers, method, purpose);
        AnalysisMetaAccess aMetaAccess = (AnalysisMetaAccess)(metaAccess instanceof AnalysisMetaAccess ? metaAccess : metaAccess.getWrapped());
        WrappedSignature invokeSignature = aMetaAccess.getUniverse().lookup(this.targetSignature, this.getDeclaringClass());
        if (metaAccess instanceof HostedMetaAccess) {
            invokeSignature = new WrappedSignature(metaAccess.getUniverse(), (Signature)invokeSignature, this.getDeclaringClass());
        }
        JavaKind wordKind = providers.getWordTypes().getWordKind();
        int slotIndex = 0;
        ValueNode receiverOrClassHandle = kit.loadLocal(slotIndex, wordKind);
        InvokeWithExceptionNode receiverOrClass = kit.unboxHandle(receiverOrClassHandle);
        ValueNode methodId = kit.loadLocal(slotIndex += wordKind.getSlotCount(), wordKind);
        slotIndex += wordKind.getSlotCount();
        ValueNode nonVirtual = kit.loadLocal(slotIndex, JavaKind.Boolean.getStackKind());
        ValueNode returnValue = this.createCall(kit, (Signature)invokeSignature, methodId, (ValueNode)receiverOrClass, nonVirtual, args = JNIJavaCallWrapperMethod.loadAndUnboxArguments(kit, providers, (Signature)invokeSignature, slotIndex += JavaKind.Boolean.getStackKind().getSlotCount()));
        JavaKind returnKind = returnValue.getStackKind();
        if (returnKind.isObject()) {
            returnValue = kit.boxObjectInLocalHandle(returnValue);
        }
        kit.createReturn(returnValue, returnKind);
        return kit.finalizeGraph();
    }

    private ValueNode createCall(JNIGraphKit kit, Signature invokeSignature, ValueNode methodId, ValueNode receiverOrClass, ValueNode nonVirtual, ValueNode[] args) {
        ValueNode declaringClass = kit.getDeclaringClassForMethod(methodId);
        if (!invokeSignature.getReturnKind().isObject()) {
            return JNIJavaCallWrapperMethod.createRegularMethodCall(kit, invokeSignature, methodId, receiverOrClass, nonVirtual, args);
        }
        InvokeWithExceptionNode newObjectAddress = kit.getNewObjectAddress(methodId);
        kit.startIf(IntegerEqualsNode.create((ValueNode)newObjectAddress, (ValueNode)kit.createWord(0L), (NodeView)NodeView.DEFAULT), ProfileData.BranchProbabilityData.unknown());
        kit.thenPart();
        ValueNode methodReturnValue = JNIJavaCallWrapperMethod.createRegularMethodCall(kit, invokeSignature, methodId, receiverOrClass, nonVirtual, args);
        kit.elsePart();
        ValueNode receiverOrCreatedObject = this.createNewObjectOrConstructorCall(kit, invokeSignature, methodId, declaringClass, (ValueNode)newObjectAddress, receiverOrClass, args);
        AbstractMergeNode merge = kit.endIf();
        return JNIJavaCallWrapperMethod.mergeValues(kit, merge, kit.bci(), methodReturnValue, receiverOrCreatedObject);
    }

    private static ValueNode createRegularMethodCall(JNIGraphKit kit, Signature invokeSignature, ValueNode methodId, ValueNode receiverOrClass, ValueNode nonVirtual, ValueNode[] args) {
        InvokeWithExceptionNode methodAddress = kit.getJavaCallAddress(methodId, receiverOrClass, nonVirtual);
        InvokeWithExceptionNode isStatic = kit.isStaticMethod(methodId);
        kit.startIf(IntegerEqualsNode.create((ValueNode)isStatic, (ValueNode)kit.createInt(0), (NodeView)NodeView.DEFAULT), ProfileData.BranchProbabilityData.unknown());
        kit.thenPart();
        ValueNode nonstaticResult = JNIJavaCallWrapperMethod.createMethodCallWithReceiver(kit, invokeSignature, (ValueNode)methodAddress, receiverOrClass, args);
        kit.elsePart();
        ValueNode staticResult = JNIJavaCallWrapperMethod.createMethodCall(kit, invokeSignature.getReturnType(null), invokeSignature.toParameterTypes(null), (ValueNode)methodAddress, args);
        AbstractMergeNode merge = kit.endIf();
        return JNIJavaCallWrapperMethod.mergeValues(kit, merge, kit.bci(), nonstaticResult, staticResult);
    }

    protected ValueNode createNewObjectOrConstructorCall(JNIGraphKit kit, Signature invokeSignature, ValueNode methodId, ValueNode declaringClass, ValueNode newObjectAddress, ValueNode receiverOrClass, ValueNode[] args) {
        ObjectEqualsNode isNewObjectCall = (ObjectEqualsNode)kit.unique((FloatingNode)new ObjectEqualsNode(receiverOrClass, declaringClass));
        kit.startIf((LogicNode)isNewObjectCall, BranchProbabilityNode.FAST_PATH_PROFILE);
        kit.thenPart();
        ValueNode createdObject = JNIJavaCallWrapperMethod.createNewObjectCall(kit, invokeSignature, newObjectAddress, args);
        kit.elsePart();
        this.createConstructorCall(kit, invokeSignature, methodId, declaringClass, receiverOrClass, args);
        AbstractMergeNode merge = kit.endIf();
        return JNIJavaCallWrapperMethod.mergeValues(kit, merge, kit.bci(), createdObject, receiverOrClass);
    }

    protected ValueNode createConstructorCall(JNIGraphKit kit, Signature invokeSignature, ValueNode methodId, ValueNode declaringClass, ValueNode receiverOrClass, ValueNode[] args) {
        InvokeWithExceptionNode methodAddress = kit.getJavaCallAddress(methodId, receiverOrClass, (ValueNode)kit.createInt(1));
        return JNIJavaCallWrapperMethod.createMethodCallWithReceiver(kit, invokeSignature, (ValueNode)methodAddress, receiverOrClass, args);
    }

    private static ValueNode createMethodCallWithReceiver(JNIGraphKit kit, Signature invokeSignature, ValueNode methodAddress, ValueNode receiver, ValueNode[] args) {
        ValueNode[] argsWithReceiver = new ValueNode[1 + args.length];
        argsWithReceiver[0] = kit.maybeCreateExplicitNullCheck(receiver);
        System.arraycopy(args, 0, argsWithReceiver, 1, args.length);
        JavaType[] paramTypes = invokeSignature.toParameterTypes((JavaType)kit.getMetaAccess().lookupJavaType(Object.class));
        return JNIJavaCallWrapperMethod.createMethodCall(kit, invokeSignature.getReturnType(null), paramTypes, methodAddress, argsWithReceiver);
    }

    private static ValueNode createNewObjectCall(JNIGraphKit kit, Signature invokeSignature, ValueNode newObjectAddress, ValueNode[] args) {
        ConstantNode abstractTypeSentinel = kit.createWord(-1L);
        kit.startIf(IntegerEqualsNode.create((ValueNode)newObjectAddress, (ValueNode)abstractTypeSentinel, (NodeView)NodeView.DEFAULT), BranchProbabilityNode.SLOW_PATH_PROFILE);
        kit.thenPart();
        ResolvedJavaMethod exceptionCtor = kit.getMetaAccess().lookupJavaMethod(INSTANTIATION_EXCEPTION_CONSTRUCTOR);
        ResolvedJavaMethod throwMethod = FactoryMethodSupport.singleton().lookup((UniverseMetaAccess)kit.getMetaAccess(), exceptionCtor, true);
        kit.createInvokeWithExceptionAndUnwind(throwMethod, CallTargetNode.InvokeKind.Static, kit.getFrameState(), kit.bci(), new ValueNode[0]);
        kit.append((Node)new LoweredDeadEndNode());
        kit.endIf();
        return JNIJavaCallWrapperMethod.createMethodCall(kit, invokeSignature.getReturnType(null), invokeSignature.toParameterTypes(null), newObjectAddress, args);
    }

    private static ValueNode createMethodCall(JNIGraphKit kit, JavaType returnType, JavaType[] paramTypes, ValueNode methodAddress, ValueNode[] args) {
        StampPair returnStamp = StampFactory.forDeclaredType((Assumptions)kit.getAssumptions(), (JavaType)returnType, (boolean)false);
        IndirectCallTargetNode callTarget = new IndirectCallTargetNode(methodAddress, args, returnStamp, paramTypes, null, (CallingConvention.Type)SubstrateCallingConventionKind.Java.toType(true), CallTargetNode.InvokeKind.Static);
        InvokeWithExceptionNode invoke = kit.startInvokeWithException((CallTargetNode)callTarget, kit.getFrameState(), kit.bci());
        kit.exceptionPart();
        ExceptionObjectNode exception = kit.exceptionObject();
        kit.append((Node)new UnwindNode((ValueNode)exception));
        kit.endInvokeWithException();
        return invoke;
    }

    private static ValueNode mergeValues(JNIGraphKit kit, AbstractMergeNode merge, int bci, ValueNode ... values) {
        Stamp stamp = StampTool.meet(List.of(values));
        ValueNode returnValue = (ValueNode)kit.getGraph().addWithoutUnique((Node)new ValuePhiNode(stamp, merge, values));
        JavaKind returnKind = returnValue.getStackKind();
        kit.getFrameState().push(returnKind, returnValue);
        merge.setStateAfter(kit.getFrameState().create(bci, (StateSplit)merge));
        kit.getFrameState().pop(returnKind);
        return returnValue;
    }

    private static ValueNode[] loadAndUnboxArguments(JNIGraphKit kit, HostedProviders providers, Signature invokeSignature, int firstSlotIndex) {
        int slotIndex = firstSlotIndex;
        int count = invokeSignature.getParameterCount(false);
        ValueNode[] args = new ValueNode[count];
        for (int i = 0; i < args.length; ++i) {
            JavaKind kind;
            ResolvedJavaType type = (ResolvedJavaType)invokeSignature.getParameterType(i, null);
            JavaKind loadKind = kind = type.getJavaKind();
            if (kind.isObject()) {
                loadKind = providers.getWordTypes().getWordKind();
            } else if (kind != kind.getStackKind()) {
                loadKind = kind.getStackKind();
            }
            ValueNode value = kit.loadLocal(slotIndex, loadKind);
            if (kind.isObject()) {
                value = kit.unboxHandle(value);
                value = kit.checkObjectType(value, type, false);
            } else if (kind != loadKind) {
                value = kit.maskNumericIntBytes(value, kind);
            }
            args[i] = value;
            slotIndex += loadKind.getSlotCount();
        }
        return args;
    }

    public static class Factory {
        public JNIJavaCallWrapperMethod create(SimpleSignature targetSignature, MetaAccessProvider originalMetaAccess, WordTypes wordTypes) {
            return new JNIJavaCallWrapperMethod(targetSignature, originalMetaAccess, wordTypes);
        }

        public boolean canInvokeConstructorOnObject(ResolvedJavaMethod constructor, MetaAccessProvider originalMetaAccess) {
            return true;
        }
    }
}

