/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.svm.hosted.annotation.AnnotationMemberValue;
import com.oracle.svm.hosted.annotation.AnnotationMetadata;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import jdk.internal.reflect.ConstantPool;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import sun.reflect.annotation.ExceptionProxy;

public final class AnnotationArrayValue
extends AnnotationMemberValue {
    private static final AnnotationArrayValue EMPTY_ARRAY_VALUE = new AnnotationArrayValue(new AnnotationMemberValue[0]);
    private final AnnotationMemberValue[] elements;

    static AnnotationArrayValue extract(ByteBuffer buf, ConstantPool cp, Class<?> container, boolean skip) {
        int length = buf.getShort() & 0xFFFF;
        if (length == 0) {
            return EMPTY_ARRAY_VALUE;
        }
        AnnotationMemberValue[] elements = new AnnotationMemberValue[length];
        for (int i = 0; i < length; ++i) {
            elements[i] = AnnotationMemberValue.extract(buf, cp, container, skip);
        }
        return skip ? null : new AnnotationArrayValue(elements);
    }

    AnnotationArrayValue(Class<?> elementType, Object[] values) {
        this.elements = new AnnotationMemberValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.elements[i] = AnnotationMemberValue.from(elementType, values[i]);
        }
    }

    private AnnotationArrayValue(AnnotationMemberValue ... elements) {
        this.elements = elements;
    }

    public int getElementCount() {
        return this.elements.length;
    }

    public void forEachElement(Consumer<AnnotationMemberValue> callback) {
        for (AnnotationMemberValue element : this.elements) {
            callback.accept(element);
        }
    }

    @Override
    public List<Class<?>> getTypes() {
        ArrayList types = new ArrayList();
        for (AnnotationMemberValue element : this.elements) {
            types.addAll(element.getTypes());
        }
        return types;
    }

    @Override
    public List<String> getStrings() {
        ArrayList<String> strings = new ArrayList<String>();
        for (AnnotationMemberValue element : this.elements) {
            strings.addAll(element.getStrings());
        }
        return strings;
    }

    @Override
    public List<JavaConstant> getExceptionProxies(SnippetReflectionProvider snippetReflection) {
        ArrayList<JavaConstant> exceptionProxies = new ArrayList<JavaConstant>();
        for (AnnotationMemberValue element : this.elements) {
            exceptionProxies.addAll(element.getExceptionProxies(snippetReflection));
        }
        return exceptionProxies;
    }

    @Override
    public char getTag() {
        return '[';
    }

    @Override
    public Object get(Class<?> memberType) {
        Class<?> componentType = memberType.getComponentType();
        Object result = Array.newInstance(memberType.getComponentType(), this.elements.length);
        char tag = '\u0000';
        boolean typeMismatch = false;
        for (int i = 0; i < this.elements.length; ++i) {
            Object value = this.elements[i].get(componentType);
            if (value instanceof ExceptionProxy) {
                typeMismatch = true;
                tag = this.elements[i].getTag();
                continue;
            }
            Array.set(result, i, value);
        }
        if (typeMismatch) {
            return AnnotationMetadata.createAnnotationTypeMismatchExceptionProxy("Array with component tag: " + (Serializable)(tag == '\u0000' ? "0" : Character.valueOf(tag)));
        }
        return AnnotationMetadata.checkResult(result, memberType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationArrayValue that = (AnnotationArrayValue)o;
        return Arrays.equals(this.elements, that.elements);
    }

    public int hashCode() {
        return Arrays.hashCode(this.elements);
    }
}

