/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.graal.pointsto.util.ParallelExecutionException;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.svm.core.FallbackExecutor;
import com.oracle.svm.core.JavaMainWrapper;
import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.ExitStatus;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.ImageSingletonsSupportImpl;
import com.oracle.svm.hosted.NativeImageClassLoader;
import com.oracle.svm.hosted.NativeImageClassLoaderPostProcessing;
import com.oracle.svm.hosted.NativeImageClassLoaderSupport;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.NativeImageSystemClassLoader;
import com.oracle.svm.hosted.ProgressReporter;
import com.oracle.svm.hosted.analysis.NativeImagePointsToAnalysis;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.image.AbstractImage;
import com.oracle.svm.hosted.option.HostedOptionParser;
import com.oracle.svm.util.ClassUtil;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.runtime.JVMCI;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.core.riscv64.ShadowedRISCV64;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;

public class NativeImageGeneratorRunner {
    private volatile NativeImageGenerator generator;
    public static final String IMAGE_BUILDER_ARG_FILE_OPTION = "--image-args-file=";

    public static void main(String[] args) {
        new NativeImageGeneratorRunner().start(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start(String[] args) {
        int exitStatus;
        List<String> arguments = new ArrayList<String>(Arrays.asList(args));
        arguments = NativeImageGeneratorRunner.extractDriverArguments(arguments);
        String[] classPath = NativeImageGeneratorRunner.extractImagePathEntries(arguments, "-imagecp");
        String[] modulePath = NativeImageGeneratorRunner.extractImagePathEntries(arguments, "-imagemp");
        final String keepAliveFile = NativeImageGeneratorRunner.extractKeepAliveFile(arguments);
        TimerTask timerTask = null;
        if (keepAliveFile != null) {
            timerTask = new TimerTask(){
                Path file;
                int fileHashCode;
                {
                    this.file = Paths.get(keepAliveFile, new String[0]);
                    this.fileHashCode = 0;
                }

                @Override
                public void run() {
                    try {
                        int currentFileHashCode = Arrays.hashCode(Files.readAllBytes(this.file));
                        if (this.fileHashCode == 0) {
                            this.fileHashCode = currentFileHashCode;
                        } else if (currentFileHashCode != this.fileHashCode) {
                            throw new RuntimeException();
                        }
                    }
                    catch (Exception e) {
                        System.exit(ExitStatus.WATCHDOG_EXIT.getValue());
                    }
                }
            };
            java.util.Timer timer = new java.util.Timer("native-image pid watcher");
            timer.scheduleAtFixedRate(timerTask, 0L, 1000L);
        }
        ClassLoader applicationClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ImageClassLoader imageClassLoader = NativeImageGeneratorRunner.installNativeImageClassLoader(classPath, modulePath, arguments);
            List<String> remainingArguments = imageClassLoader.classLoaderSupport.getRemainingArguments();
            if (!remainingArguments.isEmpty()) {
                throw UserError.abort("Unknown options: %s", String.join((CharSequence)" ", remainingArguments));
            }
            Integer checkDependencies = (Integer)SubstrateOptions.CheckBootModuleDependencies.getValue(imageClassLoader.classLoaderSupport.getParsedHostedOptions());
            if (checkDependencies > 0) {
                NativeImageGeneratorRunner.checkBootModuleDependencies(checkDependencies > 1);
            }
            exitStatus = this.build(imageClassLoader);
        }
        catch (UserError.UserException e) {
            NativeImageGeneratorRunner.reportUserError(e.getMessage());
            exitStatus = ExitStatus.BUILDER_ERROR.getValue();
        }
        catch (InterruptImageBuilding e) {
            if (e.getReason().isPresent()) {
                if (!e.getReason().get().isEmpty()) {
                    LogUtils.info((String)e.getReason().get());
                }
                exitStatus = ExitStatus.OK.getValue();
            } else {
                exitStatus = ExitStatus.BUILDER_INTERRUPT_WITHOUT_REASON.getValue();
            }
        }
        catch (Throwable err) {
            NativeImageGeneratorRunner.reportFatalError(err);
            exitStatus = ExitStatus.BUILDER_ERROR.getValue();
        }
        finally {
            NativeImageGeneratorRunner.uninstallNativeImageClassLoader();
            Thread.currentThread().setContextClassLoader(applicationClassLoader);
            if (timerTask != null) {
                timerTask.cancel();
            }
        }
        System.exit(exitStatus);
    }

    private static void checkBootModuleDependencies(boolean verbose) {
        Set<Module> allModules = ModuleLayer.boot().modules();
        List<Module> builderModules = allModules.stream().filter(m -> m.isNamed() && m.getName().startsWith("org.graalvm.nativeimage.")).toList();
        LinkedHashSet<Module> transitiveBuilderModules = new LinkedHashSet<Module>();
        for (Module module : builderModules) {
            NativeImageGeneratorRunner.transitiveReaders(module, allModules, transitiveBuilderModules);
        }
        if (verbose) {
            System.out.println(transitiveBuilderModules.stream().map(Module::getName).collect(Collectors.joining("\n", "All builder modules: \n", "\n")));
        }
        LinkedHashSet<Module> modulesBuilderDependsOn = new LinkedHashSet<Module>();
        for (Module builderModule : transitiveBuilderModules) {
            NativeImageGeneratorRunner.transitiveRequires(verbose, builderModule, allModules, modulesBuilderDependsOn);
        }
        modulesBuilderDependsOn.removeAll(transitiveBuilderModules);
        if (verbose) {
            System.out.println(modulesBuilderDependsOn.stream().map(Module::getName).collect(Collectors.joining("\n", "All modules the builder modules depend on: \n", "\n")));
        }
        Set<String> set = Set.of("java.base", "java.management", "java.logging", "java.sql", "java.xml", "java.transaction.xa", "jdk.management", "java.compiler", "jdk.jfr", "jdk.zipfs", "jdk.management.jfr");
        Set unexpectedBuilderDependencies = modulesBuilderDependsOn.stream().map(Module::getName).collect(Collectors.toSet());
        unexpectedBuilderDependencies.removeAll(set);
        if (!unexpectedBuilderDependencies.isEmpty()) {
            throw VMError.shouldNotReachHere("Unexpected image builder module-dependencies: " + String.join((CharSequence)", ", unexpectedBuilderDependencies));
        }
    }

    private static void transitiveReaders(Module readModule, Set<Module> potentialReaders, Set<Module> actualReaders) {
        for (Module potentialReader : potentialReaders) {
            if (!potentialReader.canRead(readModule) || !actualReaders.add(potentialReader)) continue;
            NativeImageGeneratorRunner.transitiveReaders(potentialReader, potentialReaders, actualReaders);
        }
    }

    private static void transitiveRequires(boolean verbose, Module requiringModule, Set<Module> potentialNeededModules, Set<Module> actualNeededModules) {
        for (Module potentialNeedModule : potentialNeededModules) {
            if (!requiringModule.canRead(potentialNeedModule) || potentialNeedModule.getName().startsWith("jdk.internal.vm.c") || potentialNeedModule.getName().startsWith("org.graalvm.") || potentialNeedModule.getName().startsWith("com.oracle.graal.") || potentialNeedModule.getName().startsWith("com.oracle.truffle.") || potentialNeedModule.getName().startsWith("com.oracle.svm.shadowed.") || !actualNeededModules.add(potentialNeedModule)) continue;
            if (verbose) {
                System.out.println(requiringModule + " reads " + potentialNeedModule);
            }
            NativeImageGeneratorRunner.transitiveRequires(verbose, potentialNeedModule, potentialNeededModules, actualNeededModules);
        }
    }

    public static void uninstallNativeImageClassLoader() {
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        if (loader instanceof NativeImageSystemClassLoader) {
            ((NativeImageSystemClassLoader)loader).setNativeImageClassLoader(null);
        }
    }

    public static ImageClassLoader installNativeImageClassLoader(String[] classpath, String[] modulepath, List<String> arguments) {
        NativeImageSystemClassLoader nativeImageSystemClassLoader = NativeImageSystemClassLoader.singleton();
        NativeImageClassLoaderSupport nativeImageClassLoaderSupport = new NativeImageClassLoaderSupport(nativeImageSystemClassLoader.defaultSystemClassLoader, classpath, modulepath);
        nativeImageClassLoaderSupport.setupHostedOptionParser(arguments);
        for (NativeImageClassLoaderPostProcessing postProcessing : ServiceLoader.load(NativeImageClassLoaderPostProcessing.class)) {
            postProcessing.apply(nativeImageClassLoaderSupport);
        }
        NativeImageClassLoader nativeImageClassLoader = nativeImageClassLoaderSupport.getClassLoader();
        Thread.currentThread().setContextClassLoader(nativeImageClassLoader);
        nativeImageSystemClassLoader.setNativeImageClassLoader(nativeImageClassLoader);
        NativeImageGenerator.setSystemPropertiesForImageEarly();
        return new ImageClassLoader(NativeImageGenerator.getTargetPlatform(nativeImageClassLoader), nativeImageClassLoaderSupport);
    }

    public static List<String> extractDriverArguments(List<String> args) {
        ArrayList result = args.stream().filter(arg -> !arg.startsWith(IMAGE_BUILDER_ARG_FILE_OPTION)).collect(Collectors.toCollection(ArrayList::new));
        Optional<String> argsFile = args.stream().filter(arg -> arg.startsWith(IMAGE_BUILDER_ARG_FILE_OPTION)).findFirst();
        if (argsFile.isPresent()) {
            String argFilePath = argsFile.get().substring(IMAGE_BUILDER_ARG_FILE_OPTION.length());
            try {
                String options = new String(Files.readAllBytes(Paths.get(argFilePath, new String[0])));
                result.addAll(Arrays.asList(options.split("\u0000")));
            }
            catch (IOException e) {
                throw VMError.shouldNotReachHere("Exception occurred during image builder argument file processing", e);
            }
        }
        return result;
    }

    public static String[] extractImagePathEntries(List<String> arguments, String pathPrefix) {
        int cpArgIndex = arguments.indexOf(pathPrefix);
        String msgTail = " '" + pathPrefix + " <Path entries separated by File.pathSeparator>' argument.";
        if (cpArgIndex == -1) {
            return new String[0];
        }
        arguments.remove(cpArgIndex);
        try {
            String imageClasspath = arguments.remove(cpArgIndex);
            return imageClasspath.split(File.pathSeparator, Integer.MAX_VALUE);
        }
        catch (IndexOutOfBoundsException e) {
            throw UserError.abort("Missing path entries for %s", msgTail);
        }
    }

    public static String extractKeepAliveFile(List<String> arguments) {
        int cpIndex = arguments.indexOf("-keepalive");
        if (cpIndex >= 0) {
            if (cpIndex + 1 >= arguments.size()) {
                throw UserError.abort("Path to keep-alive file must be provided after the '%s' argument", "-keepalive");
            }
            arguments.remove(cpIndex);
            String pidStr = arguments.get(cpIndex);
            arguments.remove(cpIndex);
            return pidStr;
        }
        return null;
    }

    private static void reportToolUserError(String msg) {
        NativeImageGeneratorRunner.reportUserError("native-image " + msg);
    }

    private static boolean isValidArchitecture() {
        Architecture originalTargetArch = GraalAccess.getOriginalTarget().arch;
        return originalTargetArch instanceof AMD64 || originalTargetArch instanceof AArch64 || ShadowedRISCV64.instanceOf((Architecture)originalTargetArch);
    }

    private static boolean isValidOperatingSystem() {
        return OS.LINUX.isCurrent() || OS.DARWIN.isCurrent() || OS.WINDOWS.isCurrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int buildImage(ImageClassLoader classLoader) {
        if (!NativeImageGeneratorRunner.verifyValidJavaVersionAndPlatform()) {
            return ExitStatus.BUILDER_ERROR.getValue();
        }
        HostedOptionParser optionParser = classLoader.classLoaderSupport.getHostedOptionParser();
        OptionValues parsedHostedOptions = classLoader.classLoaderSupport.getParsedHostedOptions();
        String imageName = (String)SubstrateOptions.Name.getValue(parsedHostedOptions);
        TimerCollection timerCollection = new TimerCollection();
        Timer totalTimer = timerCollection.get(TimerCollection.Registry.TOTAL);
        if (((Boolean)NativeImageOptions.ListCPUFeatures.getValue(parsedHostedOptions)).booleanValue()) {
            NativeImageGeneratorRunner.printCPUFeatures(classLoader.platform);
            return ExitStatus.OK.getValue();
        }
        ForkJoinPool analysisExecutor = null;
        ForkJoinPool compilationExecutor = null;
        ProgressReporter reporter = new ProgressReporter(parsedHostedOptions);
        Throwable vmError = null;
        boolean wasSuccessfulBuild = false;
        try (Timer.StopTimer ignored = totalTimer.start();){
            Timer classlistTimer = timerCollection.get(TimerCollection.Registry.CLASSLIST);
            try (Timer.StopTimer ignored1 = classlistTimer.start();){
                classLoader.loadAllClasses();
            }
            DebugContext debug = new DebugContext.Builder(parsedHostedOptions, (DebugHandlersFactory)new GraalDebugHandlersFactory(GraalAccess.getOriginalSnippetReflection())).build();
            if (imageName.length() == 0) {
                throw UserError.abort("No output file name specified. Use '%s'", SubstrateOptionsParser.commandArgument(SubstrateOptions.Name, "<output-file>"));
            }
            try {
                HashMap<Method, CEntryPointData> entryPoints = new HashMap<Method, CEntryPointData>();
                Pair<Method, CEntryPointData> mainEntryPointData = Pair.empty();
                JavaMainWrapper.JavaMainSupport javaMainSupport = null;
                boolean isStaticExecutable = (Boolean)SubstrateOptions.StaticExecutable.getValue(parsedHostedOptions);
                boolean isSharedLibrary = (Boolean)SubstrateOptions.SharedLibrary.getValue(parsedHostedOptions);
                if (isStaticExecutable && isSharedLibrary) {
                    throw UserError.abort("Cannot pass both option: %s and %s", SubstrateOptionsParser.commandArgument(SubstrateOptions.SharedLibrary, "+"), SubstrateOptionsParser.commandArgument(SubstrateOptions.StaticExecutable, "+"));
                }
                AbstractImage.NativeImageKind imageKind = isSharedLibrary ? AbstractImage.NativeImageKind.SHARED_LIBRARY : (isStaticExecutable ? AbstractImage.NativeImageKind.STATIC_EXECUTABLE : AbstractImage.NativeImageKind.EXECUTABLE);
                String className = (String)SubstrateOptions.Class.getValue(parsedHostedOptions);
                String moduleName = (String)SubstrateOptions.Module.getValue(parsedHostedOptions);
                if (imageKind.isExecutable && moduleName.isEmpty() && className.isEmpty()) {
                    throw UserError.abort("Must specify main entry point class when building %s native image. Use '%s'.", new Object[]{imageKind, SubstrateOptionsParser.commandArgument(SubstrateOptions.Class, "<fully-qualified-class-name>")});
                }
                reporter.printStart(imageName, imageKind);
                if (!className.isEmpty() || !moduleName.isEmpty()) {
                    Method mainEntryPoint;
                    Class<?> mainClass;
                    try {
                        Module mainModule = null;
                        if (!moduleName.isEmpty()) {
                            mainModule = classLoader.findModule(moduleName).orElseThrow(() -> UserError.abort("Module " + moduleName + " for mainclass not found.", new Object[0]));
                        }
                        if (className.isEmpty()) {
                            className = classLoader.getMainClassFromModule(mainModule).orElseThrow(() -> UserError.abort("Module %s does not have a ModuleMainClass attribute, use -m <module>/<main-class>", moduleName));
                        }
                        if ((mainClass = classLoader.forName(className, mainModule)) == null) {
                            throw UserError.abort(classLoader.getMainClassNotFoundErrorMessage(className), new Object[0]);
                        }
                    }
                    catch (ClassNotFoundException ex) {
                        throw UserError.abort(classLoader.getMainClassNotFoundErrorMessage(className), new Object[0]);
                    }
                    catch (UnsupportedClassVersionError ex) {
                        if (ex.getMessage().contains("compiled by a more recent version of the Java Runtime")) {
                            throw UserError.abort("Unable to load '%s' due to a Java version mismatch.%nPlease take one of the following actions:%n 1) Recompile the source files for your application using Java %s, then try running native-image again%n 2) Use a version of native-image corresponding to the version of Java with which you compiled the source files for your application%n%nRoot cause: %s", className, Runtime.version().feature(), ex);
                        }
                        throw UserError.abort(ex.getMessage(), new Object[0]);
                    }
                    String mainEntryPointName = (String)SubstrateOptions.Method.getValue(parsedHostedOptions);
                    if (mainEntryPointName.isEmpty()) {
                        throw UserError.abort("Must specify main entry point method when building %s native image. Use '%s'.", new Object[]{imageKind, SubstrateOptionsParser.commandArgument(SubstrateOptions.Method, "<method-name>")});
                    }
                    try {
                        mainEntryPoint = mainClass.getDeclaredMethod(mainEntryPointName, Integer.TYPE, CCharPointerPointer.class);
                    }
                    catch (NoSuchMethodException ignored2) {
                        Method javaMainMethod;
                        if ("main".equals(mainEntryPointName) && JavaMainWrapper.instanceMainMethodSupported()) {
                            try {
                                Class mainMethodFinder = ReflectionUtil.lookupClass((boolean)false, (String)"jdk.internal.misc.MainMethodFinder");
                                Method findMainMethod = ReflectionUtil.lookupMethod((Class)mainMethodFinder, (String)"findMainMethod", (Class[])new Class[]{Class.class});
                                javaMainMethod = (Method)findMainMethod.invoke(null, mainClass);
                            }
                            catch (InvocationTargetException ex) {
                                assert (ex.getTargetException() instanceof NoSuchMethodException);
                                throw UserError.abort(ex.getCause(), "Method '%s.%s' is declared as the main entry point but it can not be found. Make sure that class '%s' is on the classpath and that non-private method '%s()' or '%s(String[])'.", mainClass.getName(), mainEntryPointName, mainClass.getName(), mainEntryPointName, mainEntryPointName);
                            }
                        }
                        try {
                            javaMainMethod = ReflectionUtil.lookupMethod(mainClass, (String)mainEntryPointName, (Class[])new Class[]{String[].class});
                            int mainMethodModifiers = javaMainMethod.getModifiers();
                            if (!Modifier.isStatic(mainMethodModifiers)) {
                                throw UserError.abort("Java main method '%s.%s(String[])' is not static.", mainClass.getName(), mainEntryPointName);
                            }
                            if (!Modifier.isPublic(mainMethodModifiers)) {
                                throw UserError.abort("Java main method '%s.%s(String[])' is not public.", mainClass.getName(), mainEntryPointName);
                            }
                        }
                        catch (ReflectionUtil.ReflectionUtilError ex) {
                            throw UserError.abort(ex.getCause(), "Method '%s.%s' is declared as the main entry point but it can not be found. Make sure that class '%s' is on the classpath and that method '%s(String[])' exists in that class.", mainClass.getName(), mainEntryPointName, mainClass.getName(), mainEntryPointName);
                        }
                        if (javaMainMethod.getReturnType() != Void.TYPE) {
                            throw UserError.abort("Java main method '%s.%s(%s)' does not have the return type 'void'.", mainClass.getName(), mainEntryPointName, javaMainMethod.getParameterCount() == 1 ? "String[]" : "");
                        }
                        javaMainSupport = this.createJavaMainSupport(javaMainMethod, classLoader);
                        mainEntryPoint = this.getMainEntryMethod(classLoader);
                    }
                    this.verifyMainEntryPoint(mainEntryPoint);
                    mainEntryPointData = this.createMainEntryPointData(imageKind, mainEntryPoint);
                }
                boolean numberOfHelpingThreads = true;
                int numberOfThreads = (Integer)NativeImageOptions.NumberOfThreads.getValue(parsedHostedOptions);
                int numberOfAnalysisThreads = NativeImageOptions.getNumberOfAnalysisThreads(numberOfThreads, parsedHostedOptions) - 1;
                int numberOfCompilationThreads = numberOfThreads - 1;
                analysisExecutor = NativeImagePointsToAnalysis.createExecutor((DebugContext)debug, (int)numberOfAnalysisThreads);
                compilationExecutor = NativeImagePointsToAnalysis.createExecutor((DebugContext)debug, (int)numberOfCompilationThreads);
                this.generator = this.createImageGenerator(classLoader, optionParser, mainEntryPointData, reporter);
                this.generator.run(entryPoints, javaMainSupport, imageName, imageKind, SubstitutionProcessor.IDENTITY, compilationExecutor, analysisExecutor, optionParser.getRuntimeOptionNames(), timerCollection);
                wasSuccessfulBuild = true;
            }
            finally {
                if (!wasSuccessfulBuild) {
                    reporter.printUnsuccessfulInitializeEnd();
                }
            }
        }
        catch (InterruptImageBuilding e) {
            if (analysisExecutor != null) {
                analysisExecutor.shutdownNow();
            }
            if (compilationExecutor != null) {
                compilationExecutor.shutdownNow();
            }
            throw e;
        }
        catch (FallbackFeature.FallbackImageRequest e) {
            if (FallbackExecutor.class.getName().equals(SubstrateOptions.Class.getValue())) {
                NativeImageGeneratorRunner.reportFatalError(e, "FallbackImageRequest while building fallback image.");
                int classlistTimer = ExitStatus.BUILDER_ERROR.getValue();
                return classlistTimer;
            }
            NativeImageGeneratorRunner.reportUserException(e, parsedHostedOptions, LogUtils::warning);
            int classlistTimer = ExitStatus.FALLBACK_IMAGE.getValue();
            return classlistTimer;
        }
        catch (AnalysisError.ParsingError e) {
            NativeImageGeneratorRunner.reportFatalError(e);
            int classlistTimer = ExitStatus.BUILDER_ERROR.getValue();
            return classlistTimer;
        }
        catch (AnalysisError | UserError.UserException e) {
            NativeImageGeneratorRunner.reportUserError(e, parsedHostedOptions);
            int classlistTimer = ExitStatus.BUILDER_ERROR.getValue();
            return classlistTimer;
        }
        catch (ParallelExecutionException pee) {
            boolean hasUserError = false;
            for (Throwable exception : pee.getExceptions()) {
                if (exception instanceof UserError.UserException) {
                    NativeImageGeneratorRunner.reportUserError(exception, parsedHostedOptions);
                    hasUserError = true;
                    continue;
                }
                if (exception instanceof AnalysisError && !(exception instanceof AnalysisError.ParsingError)) {
                    NativeImageGeneratorRunner.reportUserError(exception, parsedHostedOptions);
                    hasUserError = true;
                    continue;
                }
                if (!(exception.getCause() instanceof UserError.UserException)) continue;
                NativeImageGeneratorRunner.reportUserError(exception.getCause(), parsedHostedOptions);
                hasUserError = true;
            }
            if (hasUserError) {
                int n = ExitStatus.BUILDER_ERROR.getValue();
                return n;
            }
            if (pee.getExceptions().size() > 1) {
                System.err.println(pee.getExceptions().size() + " fatal errors detected:");
            }
            for (Throwable exception : pee.getExceptions()) {
                NativeImageGeneratorRunner.reportFatalError(exception);
            }
            int n = ExitStatus.BUILDER_ERROR.getValue();
            return n;
        }
        catch (Throwable e) {
            vmError = e;
            int n = ExitStatus.BUILDER_ERROR.getValue();
            return n;
        }
        finally {
            this.reportEpilog(imageName, reporter, classLoader, vmError, parsedHostedOptions);
            NativeImageGenerator.clearSystemPropertiesForImage();
            ImageSingletonsSupportImpl.HostedManagement.clear();
        }
        return ExitStatus.OK.getValue();
    }

    protected void reportEpilog(String imageName, ProgressReporter reporter, ImageClassLoader classLoader, Throwable vmError, OptionValues parsedHostedOptions) {
        reporter.printEpilog(Optional.ofNullable(imageName), Optional.ofNullable(this.generator), classLoader, Optional.ofNullable(vmError), parsedHostedOptions);
    }

    protected NativeImageGenerator createImageGenerator(ImageClassLoader classLoader, HostedOptionParser optionParser, Pair<Method, CEntryPointData> mainEntryPointData, ProgressReporter reporter) {
        return new NativeImageGenerator(classLoader, optionParser, mainEntryPointData, reporter);
    }

    protected Pair<Method, CEntryPointData> createMainEntryPointData(AbstractImage.NativeImageKind imageKind, Method mainEntryPoint) {
        Class<?>[] pt = mainEntryPoint.getParameterTypes();
        if (pt.length != 2 || pt[0] != Integer.TYPE || pt[1] != CCharPointerPointer.class || mainEntryPoint.getReturnType() != Integer.TYPE) {
            throw UserError.abort("Main entry point must have signature 'int main(int argc, CCharPointerPointer argv)'.", new Object[0]);
        }
        Pair mainEntryPointData = Pair.create((Object)mainEntryPoint, (Object)CEntryPointData.create(mainEntryPoint, imageKind.mainEntryPointName));
        return mainEntryPointData;
    }

    protected Method getMainEntryMethod(ImageClassLoader classLoader) throws NoSuchMethodException {
        return JavaMainWrapper.class.getDeclaredMethod("run", Integer.TYPE, CCharPointerPointer.class);
    }

    protected JavaMainWrapper.JavaMainSupport createJavaMainSupport(Method javaMainMethod, ImageClassLoader classLoader) throws IllegalAccessException {
        return new JavaMainWrapper.JavaMainSupport(javaMainMethod);
    }

    protected void verifyMainEntryPoint(Method mainEntryPoint) {
        CEntryPoint annotation = mainEntryPoint.getAnnotation(CEntryPoint.class);
        if (annotation == null) {
            throw UserError.abort("Entry point must have the '@%s' annotation", CEntryPoint.class.getSimpleName());
        }
    }

    public static boolean verifyValidJavaVersionAndPlatform() {
        if (!NativeImageGeneratorRunner.isValidArchitecture()) {
            NativeImageGeneratorRunner.reportToolUserError("Runs on AMD64, AArch64 and RISCV64 only. Detected architecture: " + ClassUtil.getUnqualifiedName(GraalAccess.getOriginalTarget().arch.getClass()));
        }
        if (!NativeImageGeneratorRunner.isValidOperatingSystem()) {
            NativeImageGeneratorRunner.reportToolUserError("Runs on Linux, Mac OS X and Windows only. Detected OS: " + System.getProperty("os.name"));
            return false;
        }
        return true;
    }

    public static void printCPUFeatures(Platform platform) {
        StringBuilder message = new StringBuilder();
        Architecture arch = JVMCI.getRuntime().getHostJVMCIBackend().getTarget().arch;
        if (NativeImageGenerator.includedIn(platform, Platform.AMD64.class)) {
            message.append("All AMD64 CPUFeatures: ").append(Arrays.toString(AMD64.CPUFeature.values()));
            if (arch instanceof AMD64) {
                message.append(System.lineSeparator()).append("Host machine AMD64 CPUFeatures: ").append(((AMD64)arch).getFeatures().toString());
            }
        } else {
            assert (NativeImageGenerator.includedIn(platform, Platform.AARCH64.class));
            message.append("All AArch64 CPUFeatures: ").append(Arrays.toString(AArch64.CPUFeature.values()));
            if (arch instanceof AArch64) {
                message.append(System.lineSeparator()).append("Host machine AArch64 CPUFeatures: ").append(((AArch64)arch).getFeatures().toString());
            }
        }
        System.out.println(message);
    }

    protected static void reportFatalError(Throwable e) {
        System.err.print("Fatal error: ");
        e.printStackTrace();
    }

    protected static void reportFatalError(Throwable e, String msg) {
        System.err.print("Fatal error: " + msg);
        e.printStackTrace();
    }

    public static void reportUserError(String msg) {
        System.err.println("Error: " + msg);
    }

    public static void reportUserError(Throwable e, OptionValues parsedHostedOptions) {
        NativeImageGeneratorRunner.reportUserException(e, parsedHostedOptions, NativeImageGeneratorRunner::reportUserError);
    }

    private static void reportUserException(Throwable e, OptionValues parsedHostedOptions, Consumer<String> report) {
        if (e instanceof UserError.UserException) {
            UserError.UserException ue = (UserError.UserException)e;
            for (String message : ue.getMessages()) {
                report.accept(message);
            }
        } else {
            report.accept(e.getMessage());
        }
        if (parsedHostedOptions != null && ((Boolean)NativeImageOptions.ReportExceptionStackTraces.getValue(parsedHostedOptions)).booleanValue()) {
            e.printStackTrace();
        }
    }

    public int build(ImageClassLoader imageClassLoader) {
        return this.buildImage(imageClassLoader);
    }

    public static class JDK9Plus {
        public static void main(String[] args) {
            JDK9Plus.setModuleAccesses();
            NativeImageGeneratorRunner.main(args);
        }

        public static void setModuleAccesses() {
            ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, null, (boolean)false, (String)"org.graalvm.word", (String[])new String[0]);
            ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, null, (boolean)false, (String)"org.graalvm.nativeimage", (String[])new String[0]);
            ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, null, (boolean)false, (String)"org.graalvm.collections", (String[])new String[0]);
            ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, null, (boolean)false, (String)"org.graalvm.polyglot", (String[])new String[0]);
            ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, null, (boolean)false, (String)"org.graalvm.truffle", (String[])new String[0]);
            ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, null, (boolean)false, (String)"jdk.internal.vm.ci", (String[])new String[0]);
            ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, null, (boolean)false, (String)"jdk.internal.vm.compiler", (String[])new String[0]);
            ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, null, (boolean)true, (String)"jdk.internal.vm.compiler.management", (String[])new String[0]);
            ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, null, (boolean)true, (String)"com.oracle.graal.graal_enterprise", (String[])new String[0]);
            ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, null, (boolean)false, (String)"java.base", (String[])new String[]{"jdk.internal.loader"});
            ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, null, (boolean)false, (String)"java.base", (String[])new String[]{"jdk.internal.misc"});
            ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, null, (boolean)false, (String)"java.base", (String[])new String[]{"sun.text.spi"});
            ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, null, (boolean)false, (String)"java.base", (String[])new String[]{"jdk.internal.org.objectweb.asm"});
            ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, null, (boolean)false, (String)"java.base", (String[])new String[]{"sun.reflect.annotation"});
            ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, null, (boolean)false, (String)"java.base", (String[])new String[]{"sun.security.jca"});
            ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, null, (boolean)false, (String)"jdk.jdeps", (String[])new String[]{"com.sun.tools.classfile"});
            ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, null, (boolean)false, (String)"org.graalvm.truffle.runtime", (String[])new String[0]);
            ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, null, (boolean)false, (String)"org.graalvm.truffle.compiler", (String[])new String[0]);
            ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, null, (boolean)true, (String)"com.oracle.truffle.enterprise", (String[])new String[0]);
        }
    }
}

