/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.sampler;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jdk.management.SubstrateThreadMXBean;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.sampler.JfrExecutionSampler;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.sampler.SamplerBuffer;
import com.oracle.svm.core.sampler.SamplerBufferAccess;
import com.oracle.svm.core.sampler.SamplerBufferStack;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.UnmanagedMemorySupport;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class SamplerBufferPool {
    private final VMMutex mutex = new VMMutex("SamplerBufferPool");
    private final SamplerBufferStack availableBuffers = new SamplerBufferStack();
    private final SamplerBufferStack fullBuffers = new SamplerBufferStack();
    private int bufferCount;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SamplerBufferPool() {
    }

    public void teardown() {
        this.clear(this.availableBuffers);
        this.clear(this.fullBuffers);
        assert (this.bufferCount == 0);
    }

    private void clear(SamplerBufferStack stack) {
        SamplerBuffer buffer;
        while (!(buffer = stack.popBuffer()).isNull()) {
            this.free(buffer);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isLockedByCurrentThread() {
        return this.availableBuffers.isLockedByCurrentThread() || this.fullBuffers.isLockedByCurrentThread();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public SamplerBuffer acquireBuffer(boolean allowAllocation) {
        SamplerBuffer buffer = this.availableBuffers.popBuffer();
        if (buffer.isNull() && allowAllocation) {
            buffer = SubstrateJVM.getSamplerBufferPool().tryAllocateBuffer();
        }
        return buffer;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void releaseBuffer(SamplerBuffer buffer) {
        SamplerBufferAccess.reinitialize(buffer);
        this.availableBuffers.pushBuffer(buffer);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void pushFullBuffer(SamplerBuffer buffer) {
        this.fullBuffers.pushBuffer(buffer);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public SamplerBuffer popFullBuffer() {
        return this.fullBuffers.popBuffer();
    }

    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    public void adjustBufferCount() {
        block6: {
            this.mutex.lockNoTransition();
            try {
                int diff = this.diff();
                if (diff > 0) {
                    for (int i = 0; i < diff; ++i) {
                        if (this.allocateAndPush()) continue;
                        break block6;
                    }
                    break block6;
                }
                for (int i = diff; i < 0; ++i) {
                    if (this.popAndFree()) continue;
                    break;
                }
            }
            finally {
                this.mutex.unlock();
            }
        }
    }

    public int getBufferCount() {
        return this.bufferCount;
    }

    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    private SamplerBuffer tryAllocateBuffer() {
        this.mutex.lockNoTransition();
        try {
            SamplerBuffer samplerBuffer = this.tryAllocateBuffer0();
            return samplerBuffer;
        }
        finally {
            this.mutex.unlock();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private boolean allocateAndPush() {
        assert (this.bufferCount >= 0);
        SamplerBuffer buffer = this.tryAllocateBuffer0();
        if (buffer.isNonNull()) {
            this.availableBuffers.pushBuffer(buffer);
            return true;
        }
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private SamplerBuffer tryAllocateBuffer0() {
        UnsignedWord headerSize = SamplerBufferAccess.getHeaderSize();
        UnsignedWord dataSize = WordFactory.unsigned((long)SubstrateJVM.getThreadLocal().getThreadLocalBufferSize());
        SamplerBuffer result = (SamplerBuffer)((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).malloc(headerSize.add(dataSize));
        if (result.isNonNull()) {
            ++this.bufferCount;
            result.setSize(dataSize);
            result.setNext((SamplerBuffer)WordFactory.nullPointer());
            SamplerBufferAccess.reinitialize(result);
        }
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private boolean popAndFree() {
        assert (this.bufferCount > 0);
        SamplerBuffer buffer = this.availableBuffers.popBuffer();
        if (buffer.isNonNull()) {
            this.free(buffer);
            return true;
        }
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void free(SamplerBuffer buffer) {
        ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).free((PointerBase)buffer);
        --this.bufferCount;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private int diff() {
        if (JfrExecutionSampler.singleton().isSampling()) {
            double buffersToCache = (double)((SubstrateThreadMXBean)ImageSingletons.lookup(SubstrateThreadMXBean.class)).getThreadCount() * 1.5 + 0.5;
            return (int)buffersToCache - this.bufferCount;
        }
        return -this.bufferCount;
    }
}

