/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.VarHandleInfo;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import jdk.internal.misc.Unsafe;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class VarHandleFeature
implements InternalFeature {
    private final Map<Class<?>, VarHandleInfo> infos = new HashMap();
    private final ConcurrentMap<Object, Boolean> processedVarHandles = new ConcurrentHashMap<Object, Boolean>();
    private Consumer<Field> markAsUnsafeAccessed;

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        try {
            for (String typeName : new String[]{"Booleans", "Bytes", "Chars", "Doubles", "Floats", "Ints", "Longs", "Shorts", "References"}) {
                this.buildInfo(false, "receiverType", Class.forName("java.lang.invoke.VarHandle" + typeName + "$FieldInstanceReadOnly"), Class.forName("java.lang.invoke.VarHandle" + typeName + "$FieldInstanceReadWrite"));
                this.buildInfo(true, "base", Class.forName("java.lang.invoke.VarHandle" + typeName + "$FieldStaticReadOnly"), Class.forName("java.lang.invoke.VarHandle" + typeName + "$FieldStaticReadWrite"));
            }
            Class<?> staticAccessorClass = Class.forName("java.lang.invoke.DirectMethodHandle$StaticAccessor");
            this.infos.put(staticAccessorClass, new VarHandleInfo(true, VarHandleFeature.createOffsetFieldGetter(staticAccessorClass, "staticOffset"), VarHandleFeature.createTypeFieldGetter(staticAccessorClass, "staticBase")));
            Class<?> accessorClass = Class.forName("java.lang.invoke.DirectMethodHandle$Accessor");
            Function<Object, Class<?>> accessorTypeGetter = obj -> ((MethodHandle)obj).type().parameterType(0);
            this.infos.put(accessorClass, new VarHandleInfo(false, VarHandleFeature.createOffsetFieldGetter(accessorClass, "fieldOffset"), accessorTypeGetter));
        }
        catch (ClassNotFoundException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    private void buildInfo(boolean isStatic, String typeFieldName, Class<?> readOnlyClass, Class<?> readWriteClass) {
        ToLongFunction<Object> offsetGetter = VarHandleFeature.createOffsetFieldGetter(readOnlyClass, "fieldOffset");
        Function<Object, Class<?>> typeGetter = VarHandleFeature.createTypeFieldGetter(readOnlyClass, typeFieldName);
        VarHandleInfo readOnlyInfo = new VarHandleInfo(isStatic, offsetGetter, typeGetter);
        this.infos.put(readOnlyClass, readOnlyInfo);
        this.infos.put(readWriteClass, readOnlyInfo);
    }

    private static ToLongFunction<Object> createOffsetFieldGetter(Class<?> clazz, String offsetFieldName) {
        Field offsetField = ReflectionUtil.lookupField(clazz, (String)offsetFieldName);
        return obj -> {
            try {
                return offsetField.getLong(obj);
            }
            catch (IllegalAccessException e) {
                throw VMError.shouldNotReachHere(e);
            }
        };
    }

    private static Function<Object, Class<?>> createTypeFieldGetter(Class<?> clazz, String typeFieldName) {
        Field typeField = ReflectionUtil.lookupField(clazz, (String)typeFieldName);
        return obj -> {
            try {
                return (Class)typeField.get(obj);
            }
            catch (IllegalAccessException e) {
                throw VMError.shouldNotReachHere(e);
            }
        };
    }

    Field findVarHandleField(Object varHandle) {
        Class<?> type;
        VarHandleInfo info = this.infos.get(varHandle.getClass());
        long originalFieldOffset = info.offsetGetter.applyAsLong(varHandle);
        for (Class<?> cur = type = info.typeGetter.apply(varHandle); cur != null; cur = cur.getSuperclass()) {
            for (Field field : cur.getDeclaredFields()) {
                long fieldOffset;
                if (Modifier.isStatic(field.getModifiers()) != info.isStatic) continue;
                long l = fieldOffset = info.isStatic ? Unsafe.getUnsafe().staticFieldOffset(field) : Unsafe.getUnsafe().objectFieldOffset(field);
                if (fieldOffset != originalFieldOffset) continue;
                return field;
            }
            if (info.isStatic) break;
        }
        throw VMError.shouldNotReachHere("Could not find field referenced in VarHandle: " + type + ", offset = " + originalFieldOffset + ", isStatic = " + info.isStatic);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        this.markAsUnsafeAccessed = arg_0 -> ((Feature.BeforeAnalysisAccess)access).registerAsUnsafeAccessed(arg_0);
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.markAsUnsafeAccessed = null;
    }

    public void registerHeapVarHandle(VarHandle varHandle) {
        this.processReachableHandle(varHandle);
    }

    public void registerHeapMethodHandle(MethodHandle directMethodHandle) {
        this.processReachableHandle(directMethodHandle);
    }

    private Object processReachableHandle(Object obj) {
        Field field;
        VarHandleInfo info = this.infos.get(obj.getClass());
        if (info != null && this.processedVarHandles.putIfAbsent(obj, true) == null && this.processedVarHandles.putIfAbsent(field = this.findVarHandleField(obj), true) == null) {
            VMError.guarantee(this.markAsUnsafeAccessed != null, "New VarHandle found after static analysis");
            this.markAsUnsafeAccessed.accept(field);
        }
        return obj;
    }
}

