/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.jdk.BuildStackTraceVisitor;
import com.oracle.svm.core.jdk.GetCallerClassVisitor;
import com.oracle.svm.core.jdk.GetClassContextVisitor;
import com.oracle.svm.core.jdk.GetLatestUserDefinedClassLoaderVisitor;
import com.oracle.svm.core.jdk.InternalVMMethod;
import com.oracle.svm.core.jdk.LambdaFormHiddenMethod;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.LoomSupport;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.Target_java_lang_Thread;
import com.oracle.svm.core.thread.Target_jdk_internal_vm_Continuation;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VirtualThreads;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;

public class StackTraceUtils {
    private static final Class<?>[] NO_CLASSES = new Class[0];
    private static final StackTraceElement[] NO_ELEMENTS = new StackTraceElement[0];

    public static StackTraceElement[] getStackTrace(boolean filterExceptions, Pointer startSP, Pointer endSP) {
        BuildStackTraceVisitor visitor = new BuildStackTraceVisitor(filterExceptions, SubstrateOptions.maxJavaStackTraceDepth());
        StackTraceUtils.visitCurrentThreadStackFrames(startSP, endSP, visitor);
        return visitor.trace.toArray(NO_ELEMENTS);
    }

    public static void visitCurrentThreadStackFrames(Pointer startSP, Pointer endSP, StackFrameVisitor visitor) {
        JavaStackWalker.walkCurrentThread(startSP, endSP, visitor);
    }

    @NeverInline(value="Potentially starting a stack walk in the caller frame")
    public static StackTraceElement[] getStackTraceAtSafepoint(Thread thread) {
        assert (VMOperation.isInProgressAtSafepoint());
        if (VirtualThreads.isSupported()) {
            return VirtualThreads.singleton().getVirtualOrPlatformThreadStackTraceAtSafepoint(thread, KnownIntrinsics.readCallerStackPointer());
        }
        return PlatformThreads.getStackTraceAtSafepoint(thread, KnownIntrinsics.readCallerStackPointer());
    }

    public static StackTraceElement[] getThreadStackTraceAtSafepoint(IsolateThread isolateThread, Pointer endSP) {
        assert (VMOperation.isInProgressAtSafepoint());
        BuildStackTraceVisitor visitor = new BuildStackTraceVisitor(false, SubstrateOptions.maxJavaStackTraceDepth());
        JavaStackWalker.walkThread(isolateThread, endSP, visitor, null);
        return visitor.trace.toArray(NO_ELEMENTS);
    }

    public static StackTraceElement[] getThreadStackTraceAtSafepoint(Pointer startSP, Pointer endSP, CodePointer startIP) {
        assert (VMOperation.isInProgressAtSafepoint());
        BuildStackTraceVisitor visitor = new BuildStackTraceVisitor(false, SubstrateOptions.maxJavaStackTraceDepth());
        JavaStackWalker.walkThreadAtSafepoint(startSP, endSP, startIP, visitor);
        return visitor.trace.toArray(NO_ELEMENTS);
    }

    public static Class<?>[] getClassContext(int skip, Pointer startSP) {
        GetClassContextVisitor visitor = new GetClassContextVisitor(skip);
        JavaStackWalker.walkCurrentThread(startSP, visitor);
        return visitor.trace.toArray(NO_CLASSES);
    }

    public static Class<?> getCallerClass(Pointer startSP, boolean showLambdaFrames) {
        return StackTraceUtils.getCallerClass(startSP, showLambdaFrames, 0, true);
    }

    public static Class<?> getCallerClass(Pointer startSP, boolean showLambdaFrames, int depth, boolean ignoreFirst) {
        GetCallerClassVisitor visitor = new GetCallerClassVisitor(showLambdaFrames, depth, ignoreFirst);
        JavaStackWalker.walkCurrentThread(startSP, visitor);
        return visitor.result;
    }

    public static boolean shouldShowFrame(FrameInfoQueryResult frameInfo, boolean showLambdaFrames, boolean showReflectFrames, boolean showHiddenFrames) {
        String name;
        if (showHiddenFrames) {
            return true;
        }
        Class<?> clazz = frameInfo.getSourceClass();
        if (clazz == null) {
            return false;
        }
        if (DynamicHub.fromClass(clazz).isVMInternal()) {
            return false;
        }
        if (!showLambdaFrames && DynamicHub.fromClass(clazz).isLambdaFormHidden()) {
            return false;
        }
        if (!showReflectFrames && (clazz == Method.class && "invoke".equals(frameInfo.getSourceMethodName()) || clazz == Constructor.class && "newInstance".equals(frameInfo.getSourceMethodName()) || clazz == Class.class && "newInstance".equals(frameInfo.getSourceMethodName()))) {
            return false;
        }
        return !LoomSupport.isEnabled() || clazz != Target_jdk_internal_vm_Continuation.class || !(name = frameInfo.getSourceMethodName()).startsWith("enter") && !name.startsWith("yield");
    }

    public static boolean shouldShowFrame(MetaAccessProvider metaAccess, ResolvedJavaMethod method, boolean showLambdaFrames, boolean showReflectFrames, boolean showHiddenFrames) {
        if (showHiddenFrames) {
            return true;
        }
        ResolvedJavaType clazz = method.getDeclaringClass();
        if (AnnotationAccess.isAnnotationPresent((AnnotatedElement)clazz, InternalVMMethod.class)) {
            return false;
        }
        if (!showLambdaFrames && AnnotationAccess.isAnnotationPresent((AnnotatedElement)clazz, LambdaFormHiddenMethod.class)) {
            return false;
        }
        return showReflectFrames || !(clazz.equals(metaAccess.lookupJavaType(Method.class)) && "invoke".equals(method.getName()) || clazz.equals(metaAccess.lookupJavaType(Constructor.class)) && "newInstance".equals(method.getName())) && (!clazz.equals(metaAccess.lookupJavaType(Class.class)) || !"newInstance".equals(method.getName()));
    }

    public static boolean ignoredBySecurityStackWalk(MetaAccessProvider metaAccess, ResolvedJavaMethod method) {
        return !StackTraceUtils.shouldShowFrame(metaAccess, method, true, false, false);
    }

    public static ClassLoader latestUserDefinedClassLoader(Pointer startSP) {
        GetLatestUserDefinedClassLoaderVisitor visitor = new GetLatestUserDefinedClassLoaderVisitor();
        JavaStackWalker.walkCurrentThread(startSP, visitor);
        return visitor.result;
    }

    public static StackTraceElement[] asyncGetStackTrace(Thread thread) {
        GetStackTraceOperation vmOp = new GetStackTraceOperation(thread);
        vmOp.enqueue();
        return vmOp.result;
    }

    private static class GetStackTraceOperation
    extends JavaVMOperation {
        private final Thread thread;
        StackTraceElement[] result;

        GetStackTraceOperation(Thread thread) {
            super(VMOperationInfos.get(GetStackTraceOperation.class, "Get stack trace", VMOperation.SystemEffect.SAFEPOINT));
            this.thread = thread;
        }

        @Override
        protected void operate() {
            this.result = this.thread.isAlive() ? StackTraceUtils.getStackTraceAtSafepoint(this.thread) : Target_java_lang_Thread.EMPTY_STACK_TRACE;
        }
    }
}

