/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.InjectAccessors;
import com.oracle.svm.core.annotate.KeepOriginal;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.classinitialization.ClassInitializationInfo;
import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.heap.UnknownPrimitiveField;
import com.oracle.svm.core.hub.ClassForNameSupport;
import com.oracle.svm.core.hub.DynamicHubCompanion;
import com.oracle.svm.core.hub.HubType;
import com.oracle.svm.core.hub.Hybrid;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.hub.PredefinedClassesSupport;
import com.oracle.svm.core.hub.ReferenceType;
import com.oracle.svm.core.hub.Target_java_lang_Class_AnnotationData;
import com.oracle.svm.core.hub.Target_java_lang_Class_EnclosingMethodInfo;
import com.oracle.svm.core.hub.Target_java_lang_Class_ReflectionData;
import com.oracle.svm.core.hub.Target_java_lang_PublicMethods_MethodList;
import com.oracle.svm.core.hub.Target_jdk_internal_reflect_ReflectionFactory;
import com.oracle.svm.core.jdk.JDK19OrLater;
import com.oracle.svm.core.jdk.JDK21OrLater;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.reflect.MissingReflectionRegistrationUtils;
import com.oracle.svm.core.reflect.ReflectionMetadataDecoder;
import com.oracle.svm.core.reflect.Target_java_lang_reflect_RecordComponent;
import com.oracle.svm.core.reflect.Target_jdk_internal_reflect_ConstantPool;
import com.oracle.svm.core.util.LazyFinalReference;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.constant.Constable;
import java.lang.constant.ConstantDesc;
import java.lang.invoke.TypeDescriptor;
import java.lang.ref.SoftReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.security.AccessController;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;
import jdk.internal.reflect.ReflectionFactory;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.impl.InternalPlatform;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.repository.ClassRepository;

@Hybrid
@Substitute
@TargetClass(value=Class.class)
@SuppressFBWarnings(value={"Se"}, justification="DynamicHub must implement Serializable for compatibility with java.lang.Class, not because of actual serialization")
public final class DynamicHub
implements AnnotatedElement,
Type,
GenericDeclaration,
Serializable,
TypeDescriptor.OfField<DynamicHub>,
Constable {
    @Substitute
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final Class<?> hostedJavaClass;
    private String name;
    private final int hubType;
    private final byte referenceType;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private int layoutEncoding;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private int typeID;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private short typeCheckStart;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private short typeCheckRange;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private short typeCheckSlot;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private short monitorOffset;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private short optionalIdentityHashOffset;
    private final short flags;
    private static final int IS_PRIMITIVE_FLAG_BIT = 0;
    private static final int IS_INTERFACE_FLAG_BIT = 1;
    private static final int IS_HIDDEN_FLAG_BIT = 2;
    private static final int IS_RECORD_FLAG_BIT = 3;
    private static final int ASSERTION_STATUS_FLAG_BIT = 4;
    private static final int HAS_DEFAULT_METHODS_FLAG_BIT = 5;
    private static final int DECLARES_DEFAULT_METHODS_FLAG_BIT = 6;
    private static final int IS_SEALED_FLAG_BIT = 7;
    private static final int IS_VM_INTERNAL_FLAG_BIT = 8;
    private static final int IS_LAMBDA_FORM_HIDDEN_BIT = 9;
    private static final int IS_LINKED_BIT = 10;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private byte additionalFlags;
    private static final int IS_INSTANTIATED_BIT = 0;
    private static final int CAN_INSTANTIATE_AS_INSTANCE_BIT = 1;
    private static final int IS_PROXY_CLASS_BIT = 2;
    private static final int IS_REGISTERED_FOR_SERIALIZATION = 3;
    private final int modifiers;
    private final DynamicHub superHub;
    @Substitute
    private final DynamicHub componentType;
    private DynamicHub arrayHub;
    private final Object declaringClass;
    private Object interfacesEncoding;
    private Object enumConstantsReference;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private int referenceMapIndex;
    private SharedType metaType;
    private final String sourceFileName;
    private ClassInitializationInfo classInitializationInfo;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    @Hybrid.TypeIDSlots
    private short[] typeCheckSlots;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    @Hybrid.Array
    private CFunctionPointer[] vtable;
    private Module module;
    private final Class<?> nestHost;
    private final String simpleBinaryName;
    private final DynamicHubCompanion companion;
    private String signature;
    @Substitute
    @InjectAccessors(value=ClassLoaderAccessors.class)
    private ClassLoader classLoader;
    @Substitute
    @InjectAccessors(value=ReflectionDataAccessors.class)
    private SoftReference<Target_java_lang_Class_ReflectionData<?>> reflectionData;
    @Substitute
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private int classRedefinedCount;
    @Substitute
    @InjectAccessors(value=AnnotationDataAccessors.class)
    private Target_java_lang_Class_AnnotationData annotationData;
    @Substitute
    @InjectAccessors(value=AnnotationTypeAccessors.class)
    private AnnotationType annotationType;
    @Substitute
    private static final long serialVersionUID = 3206093459760846163L;
    @Substitute
    @InjectAccessors(value=CachedConstructorAccessors.class)
    private Constructor<?> cachedConstructor;
    @UnknownObjectField(canBeNull=true, availability=BuildPhaseProvider.AfterCompilation.class)
    private DynamicHubMetadata hubMetadata;
    @UnknownObjectField(canBeNull=true, availability=BuildPhaseProvider.AfterCompilation.class)
    private ReflectionMetadata reflectionMetadata;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public DynamicHub(Class<?> hostedJavaClass, String name, int hubType, ReferenceType referenceType, DynamicHub superType, DynamicHub componentHub, String sourceFileName, int modifiers, ClassLoader classLoader, boolean isHidden, boolean isRecord, Class<?> nestHost, boolean assertionStatus, boolean hasDefaultMethods, boolean declaresDefaultMethods, boolean isSealed, boolean isVMInternal, boolean isLambdaFormHidden, boolean isLinked, String simpleBinaryName, Object declaringClass) {
        this.hostedJavaClass = hostedJavaClass;
        this.module = hostedJavaClass.getModule();
        this.name = name;
        this.hubType = hubType;
        this.referenceType = referenceType.getValue();
        this.superHub = superType;
        this.componentType = componentHub;
        this.sourceFileName = sourceFileName;
        this.modifiers = modifiers;
        this.nestHost = nestHost;
        this.simpleBinaryName = simpleBinaryName;
        this.declaringClass = declaringClass;
        this.flags = NumUtil.safeToUShort((int)(DynamicHub.makeFlag(0, hostedJavaClass.isPrimitive()) | DynamicHub.makeFlag(1, hostedJavaClass.isInterface()) | DynamicHub.makeFlag(2, isHidden) | DynamicHub.makeFlag(3, isRecord) | DynamicHub.makeFlag(4, assertionStatus) | DynamicHub.makeFlag(5, hasDefaultMethods) | DynamicHub.makeFlag(6, declaresDefaultMethods) | DynamicHub.makeFlag(7, isSealed) | DynamicHub.makeFlag(8, isVMInternal) | DynamicHub.makeFlag(9, isLambdaFormHidden) | DynamicHub.makeFlag(10, isLinked)));
        this.companion = new DynamicHubCompanion(hostedJavaClass, classLoader);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static int makeFlag(int flagBit, boolean value) {
        int flagMask = 1 << flagBit;
        return value ? flagMask : 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isFlagSet(byte flags, int flagBit) {
        int flagMask = 1 << flagBit;
        return (flags & flagMask) != 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isFlagSet(short flags, int flagBit) {
        int flagMask = 1 << flagBit;
        return (flags & flagMask) != 0;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setClassInitializationInfo(ClassInitializationInfo classInitializationInfo) {
        this.classInitializationInfo = classInitializationInfo;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setData(int layoutEncoding, int typeID, int monitorOffset, int optionalIdentityHashOffset, short typeCheckStart, short typeCheckRange, short typeCheckSlot, short[] typeCheckSlots, CFunctionPointer[] vtable, long referenceMapIndex, boolean isInstantiated, boolean canInstantiateAsInstance, boolean isProxyClass, boolean isRegisteredForSerialization) {
        assert (this.vtable == null) : "Initialization must be called only once";
        assert (isInstantiated || !canInstantiateAsInstance);
        if (LayoutEncoding.isPureInstance(layoutEncoding)) {
            ObjectLayout ol = ConfigurationValues.getObjectLayout();
            assert (!ol.hasFixedIdentityHashField() ? optionalIdentityHashOffset > 0 : optionalIdentityHashOffset == ol.getFixedIdentityHashOffset());
        } else assert (optionalIdentityHashOffset == -1);
        this.layoutEncoding = layoutEncoding;
        this.typeID = typeID;
        this.monitorOffset = NumUtil.safeToShort((int)monitorOffset);
        this.optionalIdentityHashOffset = NumUtil.safeToShort((int)optionalIdentityHashOffset);
        this.typeCheckStart = typeCheckStart;
        this.typeCheckRange = typeCheckRange;
        this.typeCheckSlot = typeCheckSlot;
        this.typeCheckSlots = typeCheckSlots;
        this.vtable = vtable;
        if ((long)((int)referenceMapIndex) != referenceMapIndex) {
            throw VMError.shouldNotReachHere("Reference map index not within integer range, need to switch field from int to long");
        }
        this.referenceMapIndex = (int)referenceMapIndex;
        this.additionalFlags = NumUtil.safeToUByte((int)(DynamicHub.makeFlag(0, isInstantiated) | DynamicHub.makeFlag(1, canInstantiateAsInstance) | DynamicHub.makeFlag(2, isProxyClass) | DynamicHub.makeFlag(3, isRegisteredForSerialization)));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setArrayHub(DynamicHub arrayHub) {
        assert ((this.arrayHub == null || this.arrayHub == arrayHub) && arrayHub != null);
        assert (arrayHub.getComponentHub() == this);
        this.arrayHub = arrayHub;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setInterfacesEncoding(Object interfacesEncoding) {
        this.interfacesEncoding = interfacesEncoding;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Object getInterfacesEncoding() {
        return this.interfacesEncoding;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public boolean shouldInitEnumConstants() {
        return this.enumConstantsReference == null;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void initEnumConstants(Enum<?>[] enumConstants) {
        this.enumConstantsReference = enumConstants;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void initEnumConstantsAtRuntime(Class<?> enumClass) {
        try {
            Method values = ReflectionUtil.lookupMethod(enumClass, (String)"values", (Class[])new Class[0]);
            this.enumConstantsReference = new LazyFinalReference<Object>(() -> DynamicHub.initEnumConstantsAtRuntime(values));
        }
        catch (ReflectionUtil.ReflectionUtilError e) {
            this.enumConstantsReference = null;
        }
        catch (NoClassDefFoundError e) {
            String message = e.getMessage();
            this.enumConstantsReference = new LazyFinalReference<Object>(() -> DynamicHub.throwNoClassDefFoundErrorAtRuntime(message));
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setSignature(String signature) {
        this.signature = signature;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public String getSignature() {
        return this.signature;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setHubMetadata(int enclosingMethodInfoIndex, int annotationsIndex, int typeAnnotationsIndex, int classesEncodingIndex, int permittedSubclassesEncodingIndex, int nestMembersEncodingIndex, int signersEncodingIndex) {
        this.hubMetadata = new DynamicHubMetadata(enclosingMethodInfoIndex, annotationsIndex, typeAnnotationsIndex, classesEncodingIndex, permittedSubclassesEncodingIndex, nestMembersEncodingIndex, signersEncodingIndex);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setReflectionMetadata(int fieldsEncodingIndex, int methodsEncodingIndex, int constructorsEncodingIndex, int recordComponentsEncodingIndex, int classFlags) {
        this.reflectionMetadata = new ReflectionMetadata(fieldsEncodingIndex, methodsEncodingIndex, constructorsEncodingIndex, recordComponentsEncodingIndex, classFlags);
    }

    private void checkClassFlag(int mask, String methodName) {
        if (MissingRegistrationUtils.throwMissingRegistrationErrors() && !this.isClassFlagSet(mask)) {
            MissingReflectionRegistrationUtils.forBulkQuery(DynamicHub.toClass(this), methodName);
        }
    }

    private boolean isClassFlagSet(int mask) {
        return this.reflectionMetadata != null && (this.reflectionMetadata.classFlags & mask) != 0;
    }

    private static Object initEnumConstantsAtRuntime(Method values) {
        try {
            return values.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return null;
        }
    }

    private static Object throwNoClassDefFoundErrorAtRuntime(String message) {
        throw new NoClassDefFoundError(message);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setMetaType(SharedType metaType) {
        this.metaType = metaType;
    }

    public boolean hasDefaultMethods() {
        return DynamicHub.isFlagSet(this.flags, 5);
    }

    public boolean declaresDefaultMethods() {
        return DynamicHub.isFlagSet(this.flags, 6);
    }

    public ClassInitializationInfo getClassInitializationInfo() {
        return this.classInitializationInfo;
    }

    public boolean isInitialized() {
        return this.classInitializationInfo.isInitialized();
    }

    public void ensureInitialized() {
        EnsureClassInitializedNode.ensureClassInitialized(DynamicHub.toClass(this));
    }

    public SharedType getMetaType() {
        return this.metaType;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public String getSourceFileName() {
        return this.sourceFileName;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getLayoutEncoding() {
        return this.layoutEncoding;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getTypeID() {
        return this.typeID;
    }

    public short getTypeCheckSlot() {
        return this.typeCheckSlot;
    }

    public short getTypeCheckStart() {
        return this.typeCheckStart;
    }

    public short getTypeCheckRange() {
        return this.typeCheckRange;
    }

    public int getMonitorOffset() {
        return this.monitorOffset;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    int getOptionalIdentityHashOffset() {
        ObjectLayout ol = ConfigurationValues.getObjectLayout();
        if (ol.hasFixedIdentityHashField()) {
            return ol.getFixedIdentityHashOffset();
        }
        return this.optionalIdentityHashOffset;
    }

    public DynamicHub getSuperHub() {
        return this.superHub;
    }

    public DynamicHub getComponentHub() {
        return this.componentType;
    }

    public DynamicHub getArrayHub() {
        return this.arrayHub;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getReferenceMapIndex() {
        return this.referenceMapIndex;
    }

    public boolean isInstantiated() {
        return DynamicHub.isFlagSet(this.additionalFlags, 0);
    }

    public boolean canInstantiateAsInstance() {
        return DynamicHub.isFlagSet(this.additionalFlags, 1);
    }

    public boolean isProxyClass() {
        return DynamicHub.isFlagSet(this.additionalFlags, 2);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static DynamicHub fromClass(Class<?> clazz) {
        return SubstrateUtil.cast(clazz, DynamicHub.class);
    }

    public DynamicHubCompanion getCompanion() {
        return this.companion;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Class<?> toClass(DynamicHub hub) {
        return SubstrateUtil.cast(hub, Class.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Class<?> getHostedJavaClass() {
        return this.hostedJavaClass;
    }

    @Substitute
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public String getName() {
        return this.name;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getHubType() {
        return this.hubType;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInstanceClass() {
        return HubType.isInstance(this.hubType);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isPodInstanceClass() {
        return HubType.isPodInstance(this.hubType);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isReferenceInstanceClass() {
        return HubType.isReferenceInstance(this.hubType);
    }

    @Override
    @Substitute
    public boolean isArray() {
        throw VMError.shouldNotReachHere("Intrinsified in StandardGraphBuilderPlugins.");
    }

    public boolean hubIsArray() {
        return HubType.isArray(this.hubType);
    }

    @Substitute
    public boolean isInterface() {
        return DynamicHub.isFlagSet(this.flags, 1);
    }

    @Override
    @Substitute
    public boolean isPrimitive() {
        return DynamicHub.isFlagSet(this.flags, 0);
    }

    @Substitute
    public int getModifiers() {
        return this.modifiers;
    }

    public int getClassAccessFlags() {
        return this.reflectionMetadata != null ? this.reflectionMetadata.classFlags & 0x1FFF : this.modifiers;
    }

    @Substitute
    private Object getComponentType() {
        return this.componentType;
    }

    @Substitute
    private Object getSuperclass() {
        return this.superHub;
    }

    @Substitute
    private boolean isInstance(Object obj) {
        throw VMError.shouldNotReachHere("Intrinsified in StandardGraphBuilderPlugins.");
    }

    @Substitute
    private Object cast(Object obj) {
        throw VMError.shouldNotReachHere("Intrinsified in StandardGraphBuilderPlugins.");
    }

    @Substitute
    private boolean isAssignableFrom(Class<?> cls) {
        throw VMError.shouldNotReachHere("Intrinsified in StandardGraphBuilderPlugins.");
    }

    @Substitute
    private boolean isAnnotation() {
        return this.isInterface() && this.getInterfaces().length == 1 && DynamicHub.toClass(this.getInterfaces()[0]) == Annotation.class;
    }

    @Substitute
    private boolean isEnum() {
        return this.getSuperclass() == Enum.class;
    }

    @KeepOriginal
    private native Enum<?>[] getEnumConstants();

    @Substitute
    public Enum<?>[] getEnumConstantsShared() {
        if (this.enumConstantsReference instanceof LazyFinalReference) {
            return (Enum[])((LazyFinalReference)this.enumConstantsReference).get();
        }
        return (Enum[])this.enumConstantsReference;
    }

    @KeepOriginal
    public native URL getResource(String var1);

    @Substitute
    public InputStream getResourceAsStream(String resourceName) {
        String resolvedName = this.resolveName(resourceName);
        return Resources.singleton().createInputStream(this.module, resolvedName);
    }

    @KeepOriginal
    private native String resolveName(String var1);

    @KeepOriginal
    private native boolean isOpenToCaller(String var1, Class<?> var2);

    @Substitute
    public ClassLoader getClassLoader() {
        return this.companion.getClassLoader();
    }

    @KeepOriginal
    private native ClassLoader getClassLoader0();

    public boolean isLoaded() {
        return this.companion.hasClassLoader();
    }

    void setClassLoaderAtRuntime(ClassLoader loader) {
        this.companion.setClassLoader(loader);
    }

    @KeepOriginal
    private native String getSimpleName();

    @KeepOriginal
    private native String getSimpleName0();

    @KeepOriginal
    private native String getCanonicalName();

    @KeepOriginal
    private native String getCanonicalName0();

    @Override
    @KeepOriginal
    public native String getTypeName();

    @KeepOriginal
    private native String getSimpleBinaryName();

    @KeepOriginal
    private native <U> Class<? extends U> asSubclass(Class<U> var1);

    @KeepOriginal
    private native boolean isAnonymousClass();

    @KeepOriginal
    @TargetElement(onlyWith={JDK21OrLater.class})
    private native boolean isUnnamedClass();

    @Substitute
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isHidden() {
        return DynamicHub.isFlagSet(this.flags, 2);
    }

    @Substitute
    public boolean isRecord() {
        return DynamicHub.isFlagSet(this.flags, 3);
    }

    @Substitute
    public boolean isSealed() {
        return DynamicHub.isFlagSet(this.flags, 7);
    }

    public boolean isVMInternal() {
        return DynamicHub.isFlagSet(this.flags, 8);
    }

    public boolean isLambdaFormHidden() {
        return DynamicHub.isFlagSet(this.flags, 9);
    }

    public boolean isLinked() {
        return DynamicHub.isFlagSet(this.flags, 10);
    }

    public boolean isRegisteredForSerialization() {
        return DynamicHub.isFlagSet(this.additionalFlags, 3);
    }

    @KeepOriginal
    private native boolean isLocalClass();

    @KeepOriginal
    private native boolean isMemberClass();

    @KeepOriginal
    private native boolean isLocalOrAnonymousClass();

    @KeepOriginal
    private native Class<?> getEnclosingClass();

    @KeepOriginal
    private native Class<?> getDeclaringClass();

    @Substitute
    private Class<?> getDeclaringClass0() {
        if (this.declaringClass == null) {
            return null;
        }
        if (this.declaringClass instanceof Class) {
            PredefinedClassesSupport.throwIfUnresolvable((Class)this.declaringClass, this.getClassLoader0());
            return (Class)this.declaringClass;
        }
        if (this.declaringClass instanceof LinkageError) {
            throw (LinkageError)this.declaringClass;
        }
        throw VMError.shouldNotReachHereUnexpectedInput(this.declaringClass);
    }

    @KeepOriginal
    public native DynamicHub[] getInterfaces();

    @KeepOriginal
    private native DynamicHub[] getInterfaces(boolean var1);

    @KeepOriginal
    public native Object newInstance() throws Throwable;

    @Override
    @KeepOriginal
    public native <T extends Annotation> T getAnnotation(Class<T> var1);

    @Override
    @Substitute
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    @Override
    @KeepOriginal
    public native Annotation[] getAnnotations();

    @Override
    @Substitute
    public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
        DynamicHub superClass;
        Annotation[] result = this.getDeclaredAnnotationsByType(annotationClass);
        if (result.length == 0 && AnnotationAccess.isAnnotationPresent(annotationClass, Inherited.class) && (superClass = (DynamicHub)this.getSuperclass()) != null) {
            result = superClass.getAnnotationsByType(annotationClass);
        }
        return result;
    }

    @Override
    @KeepOriginal
    public native Annotation[] getDeclaredAnnotations();

    @KeepOriginal
    public native <A extends Annotation> A[] getDeclaredAnnotationsByType(Class<A> var1);

    @Override
    @KeepOriginal
    public native <T extends Annotation> T getDeclaredAnnotation(Class<T> var1);

    @Substitute
    private Field[] getFields() {
        this.checkClassFlag(65536, "getFields");
        return DynamicHub.copyFields(this.privateGetPublicFields());
    }

    @Substitute
    @CallerSensitive
    public Method[] getMethods() throws SecurityException {
        this.checkClassFlag(262144, "getMethods");
        return DynamicHub.copyMethods(this.privateGetPublicMethods());
    }

    @Substitute
    private Constructor<?>[] getConstructors() {
        this.checkClassFlag(0x100000, "getConstructors");
        return DynamicHub.copyConstructors(this.privateGetDeclaredConstructors(true));
    }

    @Substitute
    public Field getField(String fieldName) throws NoSuchFieldException, SecurityException {
        Objects.requireNonNull(fieldName);
        Field field = this.getField0(fieldName);
        this.checkField(fieldName, field, true);
        return DynamicHub.getReflectionFactory().copyField(field);
    }

    private void checkField(String fieldName, Field field, boolean publicOnly) throws NoSuchFieldException {
        boolean throwMissingErrors = MissingRegistrationUtils.throwMissingRegistrationErrors();
        Class<?> clazz = DynamicHub.toClass(this);
        if (field == null) {
            if (throwMissingErrors && !this.allElementsRegistered(publicOnly, 131072, 65536)) {
                MissingReflectionRegistrationUtils.forField(clazz, fieldName);
            }
            throw new NoSuchFieldException(fieldName);
        }
        ReflectionMetadataDecoder decoder = (ReflectionMetadataDecoder)ImageSingletons.lookup(ReflectionMetadataDecoder.class);
        int fieldModifiers = field.getModifiers();
        boolean negative = decoder.isNegative(fieldModifiers);
        boolean hiding = decoder.isHiding(fieldModifiers);
        if (throwMissingErrors && hiding) {
            MissingReflectionRegistrationUtils.forField(clazz, fieldName);
        }
        if (negative || hiding) {
            throw new NoSuchFieldException(fieldName);
        }
    }

    @Substitute
    private Method getMethod(String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Objects.requireNonNull(methodName);
        Method method = this.getMethod0(methodName, parameterTypes);
        this.checkMethod(methodName, parameterTypes, method, true);
        return DynamicHub.getReflectionFactory().copyMethod(method);
    }

    private void checkMethod(String methodName, Class<?>[] parameterTypes, Executable method, boolean publicOnly) throws NoSuchMethodException {
        boolean throwMissingErrors = MissingRegistrationUtils.throwMissingRegistrationErrors();
        Class<?> clazz = DynamicHub.toClass(this);
        if (method == null) {
            if (throwMissingErrors && !this.allElementsRegistered(publicOnly, 524288, 262144)) {
                MissingReflectionRegistrationUtils.forMethod(clazz, methodName, parameterTypes);
            }
            throw new NoSuchMethodException(this.methodToString(methodName, parameterTypes));
        }
        ReflectionMetadataDecoder decoder = (ReflectionMetadataDecoder)ImageSingletons.lookup(ReflectionMetadataDecoder.class);
        int methodModifiers = method.getModifiers();
        boolean negative = decoder.isNegative(methodModifiers);
        boolean hiding = decoder.isHiding(methodModifiers);
        if (throwMissingErrors && hiding) {
            MissingReflectionRegistrationUtils.forMethod(clazz, methodName, parameterTypes);
        }
        if (negative || hiding) {
            throw new NoSuchMethodException(this.methodToString(methodName, parameterTypes));
        }
    }

    private boolean allElementsRegistered(boolean publicOnly, int allDeclaredElementsFlag, int allPublicElementsFlag) {
        return this.isClassFlagSet(allDeclaredElementsFlag) || publicOnly && this.isClassFlagSet(allPublicElementsFlag);
    }

    @KeepOriginal
    private native Constructor<?> getConstructor(Class<?> ... var1);

    @Substitute
    public Class<?>[] getDeclaredClasses() throws SecurityException {
        this.checkClassFlag(0x800000, "getDeclaredClasses");
        return this.getDeclaredClasses0();
    }

    @Substitute
    public Class<?>[] getClasses() {
        this.checkClassFlag(0x400000, "getClasses");
        return AccessController.doPrivileged(() -> {
            ArrayList list = new ArrayList();
            for (DynamicHub currentClass = this; currentClass != null; currentClass = currentClass.getSuperHub()) {
                for (Class<?> m : currentClass.getDeclaredClasses0()) {
                    if (!Modifier.isPublic(m.getModifiers())) continue;
                    list.add(m);
                }
            }
            return list.toArray(new Class[0]);
        });
    }

    @Substitute
    private Field[] getDeclaredFields() {
        this.checkClassFlag(131072, "getDeclaredFields");
        return DynamicHub.copyFields(this.privateGetDeclaredFields(false));
    }

    @Substitute
    @CallerSensitive
    public Method[] getDeclaredMethods() throws SecurityException {
        this.checkClassFlag(524288, "getDeclaredMethods");
        return DynamicHub.copyMethods(this.privateGetDeclaredMethods(false));
    }

    @Substitute
    private Constructor<?>[] getDeclaredConstructors() {
        this.checkClassFlag(0x200000, "getDeclaredConstructors");
        return DynamicHub.copyConstructors(this.privateGetDeclaredConstructors(false));
    }

    @Substitute
    public Field getDeclaredField(String fieldName) throws NoSuchFieldException, SecurityException {
        Objects.requireNonNull(fieldName);
        Field field = DynamicHub.searchFields(this.privateGetDeclaredFields(false), fieldName);
        this.checkField(fieldName, field, false);
        return DynamicHub.getReflectionFactory().copyField(field);
    }

    @Substitute
    @CallerSensitive
    public Method getDeclaredMethod(String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        Objects.requireNonNull(methodName);
        Method method = DynamicHub.searchMethods(this.privateGetDeclaredMethods(false), methodName, parameterTypes);
        this.checkMethod(methodName, parameterTypes, method, false);
        return DynamicHub.getReflectionFactory().copyMethod(method);
    }

    @KeepOriginal
    private native Constructor<?> getDeclaredConstructor(Class<?> ... var1);

    @KeepOriginal
    private native Constructor<?>[] privateGetDeclaredConstructors(boolean var1);

    @KeepOriginal
    private native Field[] privateGetDeclaredFields(boolean var1);

    @KeepOriginal
    private native Method[] privateGetDeclaredMethods(boolean var1);

    @KeepOriginal
    private native Field[] privateGetPublicFields();

    @KeepOriginal
    native Method[] privateGetPublicMethods();

    @KeepOriginal
    private native Target_java_lang_reflect_RecordComponent[] getRecordComponents();

    @Substitute
    private Target_java_lang_reflect_RecordComponent[] getRecordComponents0() {
        this.checkClassFlag(0x1000000, "getRecordComponents");
        if (this.reflectionMetadata == null || this.reflectionMetadata.recordComponentsEncodingIndex == -1) {
            throw VMError.unsupportedFeature("Record components not available for record class " + this.getTypeName() + ". All record component accessor methods of this record class must be included in the reflection configuration at image build time, then this method can be called.");
        }
        return ((ReflectionMetadataDecoder)ImageSingletons.lookup(ReflectionMetadataDecoder.class)).parseRecordComponents(this, this.reflectionMetadata.recordComponentsEncodingIndex);
    }

    @KeepOriginal
    private native Class<?>[] getPermittedSubclasses();

    @Substitute
    private void checkMemberAccess(SecurityManager sm, int which, Class<?> caller, boolean checkProxyInterfaces) {
    }

    @Substitute
    private void checkPackageAccess(SecurityManager sm, ClassLoader ccl, boolean checkProxyInterfaces) {
    }

    @Substitute
    private static ReflectionFactory getReflectionFactory() {
        return Target_jdk_internal_reflect_ReflectionFactory.getReflectionFactory();
    }

    @KeepOriginal
    private static native Field searchFields(Field[] var0, String var1);

    @KeepOriginal
    private static native Method searchMethods(Method[] var0, String var1, Class<?>[] var2);

    @Substitute
    private Constructor<?> getConstructor0(Class<?>[] parameterTypes, int which) throws NoSuchMethodException {
        ReflectionFactory fact = DynamicHub.getReflectionFactory();
        Constructor<?>[] constructors = this.privateGetDeclaredConstructors(which == 0);
        Constructor<?> candidate = null;
        for (Constructor<?> constructor : constructors) {
            if (!DynamicHub.arrayContentsEq(parameterTypes, fact.getExecutableSharedParameterTypes(constructor))) continue;
            candidate = constructor;
        }
        this.checkMethod("<init>", parameterTypes, candidate, which == 0);
        return candidate;
    }

    @KeepOriginal
    private static native boolean arrayContentsEq(Object[] var0, Object[] var1);

    @Substitute
    private static Field[] copyFields(Field[] original) {
        Field[] arg = DynamicHub.filterFields(original);
        Field[] out = new Field[arg.length];
        ReflectionFactory fact = DynamicHub.getReflectionFactory();
        for (int i = 0; i < arg.length; ++i) {
            out[i] = fact.copyField(arg[i]);
        }
        return out;
    }

    @Substitute
    private static Method[] copyMethods(Method[] original) {
        Method[] arg = DynamicHub.filterMethods(original);
        Method[] out = new Method[arg.length];
        ReflectionFactory fact = DynamicHub.getReflectionFactory();
        for (int i = 0; i < arg.length; ++i) {
            out[i] = fact.copyMethod(arg[i]);
        }
        return out;
    }

    @Substitute
    private static Constructor<?>[] copyConstructors(Constructor<?>[] original) {
        Constructor<?>[] arg = DynamicHub.filterConstructors(original);
        Constructor[] out = new Constructor[arg.length];
        ReflectionFactory fact = DynamicHub.getReflectionFactory();
        for (int i = 0; i < arg.length; ++i) {
            out[i] = fact.copyConstructor(arg[i]);
        }
        return out;
    }

    @Override
    @KeepOriginal
    public native TypeVariable<?>[] getTypeParameters();

    @KeepOriginal
    public native Type[] getGenericInterfaces();

    @KeepOriginal
    public native Type getGenericSuperclass();

    @KeepOriginal
    public native AnnotatedType getAnnotatedSuperclass();

    @KeepOriginal
    public native AnnotatedType[] getAnnotatedInterfaces();

    @KeepOriginal
    private native Method getEnclosingMethod();

    @KeepOriginal
    private native Constructor<?> getEnclosingConstructor();

    @Substitute
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    private static Class<?> forName(String className) throws Throwable {
        return DynamicHub.forName(className, Reflection.getCallerClass());
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    private static Class<?> forName(String className, Class<?> caller) throws Throwable {
        return DynamicHub.forName(className, true, caller.getClassLoader(), caller);
    }

    @Substitute
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    private static Class<?> forName(Module module, String className) throws Throwable {
        return DynamicHub.forName(module, className, Reflection.getCallerClass());
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    private static Class<?> forName(Module module, String className, Class<?> caller) throws Throwable {
        try {
            return DynamicHub.forName(className, false, caller.getClassLoader(), caller);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Substitute
    private static Class<?> forName(String name, boolean initialize, ClassLoader loader) throws Throwable {
        return DynamicHub.forName(name, initialize, loader, Reflection.getCallerClass());
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    private static Class<?> forName(String name, boolean initialize, ClassLoader loader, Class<?> caller) throws Throwable {
        Class<?> result;
        if (name == null) {
            throw new NullPointerException();
        }
        try {
            result = ClassForNameSupport.forName(name, loader);
        }
        catch (ClassNotFoundException e) {
            if (loader != null && PredefinedClassesSupport.hasBytecodeClasses()) {
                result = loader.loadClass(name);
            }
            throw e;
        }
        if (initialize) {
            DynamicHub.fromClass(result).ensureInitialized();
        }
        return result;
    }

    @KeepOriginal
    private native Package getPackage();

    @Substitute
    public String getPackageName() {
        if (SubstrateUtil.HOSTED) {
            return this.computePackageName();
        }
        return this.companion.getPackageName(this);
    }

    String computePackageName() {
        String cn;
        int dot;
        String pn = null;
        DynamicHub me = this;
        while (me.hubIsArray()) {
            me = (DynamicHub)me.getComponentType();
        }
        pn = me.isPrimitive() ? "java.lang" : ((dot = (cn = me.getName()).lastIndexOf(46)) != -1 ? cn.substring(0, dot).intern() : "");
        return pn;
    }

    @Substitute
    public String toString() {
        return (this.isInterface() ? "interface " : (this.isPrimitive() ? "" : "class ")) + this.getName();
    }

    @KeepOriginal
    public native String toGenericString();

    @KeepOriginal
    public native boolean isSynthetic();

    @Substitute
    public Object[] getSigners() {
        if (this.isPrimitive()) {
            return null;
        }
        this.checkClassFlag(0x8000000, "getSigners");
        if (this.hubMetadata == null || this.hubMetadata.signersEncodingIndex == -1) {
            return null;
        }
        return ((ReflectionMetadataDecoder)ImageSingletons.lookup(ReflectionMetadataDecoder.class)).parseObjects(this.hubMetadata.signersEncodingIndex);
    }

    @Substitute
    public ProtectionDomain getProtectionDomain() {
        return this.companion.getProtectionDomain();
    }

    @Substitute
    private ProtectionDomain protectionDomain() {
        return this.getProtectionDomain();
    }

    void setProtectionDomainAtRuntime(ProtectionDomain protectionDomain) {
        this.companion.setProtectionDomain(protectionDomain);
    }

    @Substitute
    public boolean desiredAssertionStatus() {
        return DynamicHub.isFlagSet(this.flags, 4);
    }

    @Substitute
    public Module getModule() {
        return this.module;
    }

    @Substitute
    public String methodToString(String nameArg, Class<?>[] argTypes) {
        return DynamicHub.describeMethod(this.getName() + "." + nameArg + "(", argTypes, ")");
    }

    private static String describeMethod(String prefix, Class<?>[] argTypes, String suffix) {
        StringJoiner sj = new StringJoiner(", ", prefix, suffix);
        if (argTypes != null) {
            for (Class<?> c : argTypes) {
                sj.add(c == null ? "null" : c.getName());
            }
        }
        return sj.toString();
    }

    @KeepOriginal
    private native <T> Target_java_lang_Class_ReflectionData<T> reflectionData();

    @KeepOriginal
    private native boolean isTopLevelClass();

    @Substitute
    private String getSimpleBinaryName0() {
        return this.simpleBinaryName;
    }

    @Substitute
    List<Method> getDeclaredPublicMethods(String methodName, Class<?> ... parameterTypes) {
        this.checkClassFlag(786432, "getMethods or getDeclaredMethods");
        Method[] methods = DynamicHub.filterMethods(this.privateGetDeclaredMethods(true));
        ReflectionFactory factory = DynamicHub.getReflectionFactory();
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : methods) {
            if (!method.getName().equals(methodName) || !Arrays.equals(factory.getExecutableSharedParameterTypes(method), parameterTypes)) continue;
            result.add(factory.copyMethod(method));
        }
        return result;
    }

    @Substitute
    public Class<?> getNestHost() {
        return this.nestHost;
    }

    @Substitute
    public boolean isNestmateOf(Class<?> c) {
        return this.nestHost == DynamicHub.fromClass(c).nestHost;
    }

    @KeepOriginal
    public native Class<?>[] getNestMembers();

    @Override
    @Substitute
    public DynamicHub componentType() {
        return this.componentType;
    }

    @Override
    @Substitute
    public DynamicHub arrayType() {
        if (DynamicHub.toClass(this) == Void.TYPE) {
            throw new UnsupportedOperationException(new IllegalArgumentException());
        }
        if (this.arrayHub == null) {
            MissingReflectionRegistrationUtils.forClass(this.getTypeName() + "[]");
        }
        return this.arrayHub;
    }

    @KeepOriginal
    private native Class<?> elementType();

    @Override
    @KeepOriginal
    public native String descriptorString();

    @Override
    @KeepOriginal
    public native Optional<? extends ConstantDesc> describeConstable();

    @KeepOriginal
    private static native String typeVarBounds(TypeVariable<?> var0);

    @Delete
    private static native void registerNatives();

    @Delete
    static native Class<?> getPrimitiveClass(String var0);

    @Substitute
    private Object[] getEnclosingMethod0() {
        if (this.hubMetadata == null || this.hubMetadata.enclosingMethodInfoIndex == -1) {
            return null;
        }
        Object[] enclosingMethod = ((ReflectionMetadataDecoder)ImageSingletons.lookup(ReflectionMetadataDecoder.class)).parseEnclosingMethod(this.hubMetadata.enclosingMethodInfoIndex);
        if (enclosingMethod != null) {
            PredefinedClassesSupport.throwIfUnresolvable((Class)enclosingMethod[0], this.getClassLoader0());
        }
        return enclosingMethod;
    }

    @Substitute
    private DynamicHub[] getInterfaces0() {
        if (this.interfacesEncoding == null) {
            return new DynamicHub[0];
        }
        if (this.interfacesEncoding instanceof DynamicHub) {
            return new DynamicHub[]{(DynamicHub)this.interfacesEncoding};
        }
        return (DynamicHub[])this.interfacesEncoding;
    }

    @Substitute
    private void setSigners(Object[] signers) {
        throw VMError.unsupportedFeature("Class metadata cannot be changed at run time");
    }

    @Delete
    private native ProtectionDomain getProtectionDomain0();

    @Substitute
    private String getGenericSignature0() {
        return this.signature;
    }

    @Substitute
    byte[] getRawAnnotations() {
        if (this.hubMetadata == null || this.hubMetadata.annotationsIndex == -1) {
            return null;
        }
        return ((ReflectionMetadataDecoder)ImageSingletons.lookup(ReflectionMetadataDecoder.class)).parseByteArray(this.hubMetadata.annotationsIndex);
    }

    @Substitute
    byte[] getRawTypeAnnotations() {
        if (this.hubMetadata == null || this.hubMetadata.typeAnnotationsIndex == -1) {
            return null;
        }
        return ((ReflectionMetadataDecoder)ImageSingletons.lookup(ReflectionMetadataDecoder.class)).parseByteArray(this.hubMetadata.typeAnnotationsIndex);
    }

    @Substitute
    Target_jdk_internal_reflect_ConstantPool getConstantPool() {
        return new Target_jdk_internal_reflect_ConstantPool();
    }

    @Substitute
    private Field[] getDeclaredFields0(boolean publicOnly) {
        if (this.reflectionMetadata == null || this.reflectionMetadata.fieldsEncodingIndex == -1) {
            return new Field[0];
        }
        return ((ReflectionMetadataDecoder)ImageSingletons.lookup(ReflectionMetadataDecoder.class)).parseFields(this, this.reflectionMetadata.fieldsEncodingIndex, publicOnly);
    }

    @Substitute
    private Method[] getDeclaredMethods0(boolean publicOnly) {
        if (this.reflectionMetadata == null || this.reflectionMetadata.methodsEncodingIndex == -1) {
            return new Method[0];
        }
        return ((ReflectionMetadataDecoder)ImageSingletons.lookup(ReflectionMetadataDecoder.class)).parseMethods(this, this.reflectionMetadata.methodsEncodingIndex, publicOnly);
    }

    @Substitute
    private Constructor<?>[] getDeclaredConstructors0(boolean publicOnly) {
        if (this.reflectionMetadata == null || this.reflectionMetadata.constructorsEncodingIndex == -1) {
            return new Constructor[0];
        }
        return ((ReflectionMetadataDecoder)ImageSingletons.lookup(ReflectionMetadataDecoder.class)).parseConstructors(this, this.reflectionMetadata.constructorsEncodingIndex, publicOnly);
    }

    @Substitute
    private Class<?>[] getDeclaredClasses0() {
        Class<?>[] declaredClasses;
        if (this.hubMetadata == null || this.hubMetadata.classesEncodingIndex == -1) {
            return new Class[0];
        }
        for (Class<?> clazz : declaredClasses = ((ReflectionMetadataDecoder)ImageSingletons.lookup(ReflectionMetadataDecoder.class)).parseClasses(this.hubMetadata.classesEncodingIndex)) {
            PredefinedClassesSupport.throwIfUnresolvable(clazz, this.getClassLoader0());
        }
        return declaredClasses;
    }

    @Delete
    private static native boolean desiredAssertionStatus0(Class<?> var0);

    @Delete
    private native Class<?> getNestHost0();

    @Substitute
    private Class<?>[] getNestMembers0() {
        Class<?>[] nestMembers;
        this.checkClassFlag(0x4000000, "getNestMembers");
        if (this.hubMetadata == null || this.hubMetadata.nestMembersEncodingIndex == -1) {
            return new Class[]{DynamicHub.toClass(this)};
        }
        for (Class<?> clazz : nestMembers = ((ReflectionMetadataDecoder)ImageSingletons.lookup(ReflectionMetadataDecoder.class)).parseClasses(this.hubMetadata.nestMembersEncodingIndex)) {
            PredefinedClassesSupport.throwIfUnresolvable(clazz, this.getClassLoader0());
        }
        return nestMembers;
    }

    @Delete
    private native String initClassName();

    @KeepOriginal
    private static native Class<?> toClass(Type var0);

    @Substitute
    private ClassRepository getGenericInfo() {
        return this.companion.getGenericInfo(this);
    }

    ClassRepository computeGenericInfo() {
        String genericSignature = this.getGenericSignature0();
        if (genericSignature == null) {
            return ClassRepository.NONE;
        }
        return ClassRepository.make(genericSignature, this.getFactory());
    }

    @KeepOriginal
    private native Target_java_lang_Class_EnclosingMethodInfo getEnclosingMethodInfo();

    @KeepOriginal
    private native boolean hasEnclosingMethodInfo();

    @KeepOriginal
    private native <T> Target_java_lang_Class_ReflectionData<T> newReflectionData(SoftReference<Target_java_lang_Class_ReflectionData<T>> var1, int var2);

    @KeepOriginal
    private native Target_java_lang_Class_AnnotationData annotationData();

    @KeepOriginal
    private native Target_java_lang_Class_AnnotationData createAnnotationData(int var1);

    @Substitute
    private Class<?>[] getPermittedSubclasses0() {
        Class<?>[] permittedSubclasses;
        if (!this.isSealed()) {
            return null;
        }
        this.checkClassFlag(0x2000000, "getPermittedSubclasses");
        if (this.hubMetadata == null || this.hubMetadata.permittedSubclassesEncodingIndex == -1) {
            return new Class[0];
        }
        for (Class<?> clazz : permittedSubclasses = ((ReflectionMetadataDecoder)ImageSingletons.lookup(ReflectionMetadataDecoder.class)).parseClasses(this.hubMetadata.permittedSubclassesEncodingIndex)) {
            PredefinedClassesSupport.throwIfUnresolvable(clazz, this.getClassLoader0());
        }
        return permittedSubclasses;
    }

    @KeepOriginal
    private native GenericsFactory getFactory();

    @KeepOriginal
    private native Method getMethod0(String var1, Class<?>[] var2);

    @KeepOriginal
    private static native void addAll(Collection<Field> var0, Field[] var1);

    @KeepOriginal
    private native Target_java_lang_PublicMethods_MethodList getMethodsRecursive(String var1, Class<?>[] var2, boolean var3);

    @KeepOriginal
    private native Field getField0(String var1);

    @KeepOriginal
    native AnnotationType getAnnotationType();

    @KeepOriginal
    static native byte[] getExecutableTypeAnnotationBytes(Executable var0);

    @KeepOriginal
    private native boolean isDirectSubType(Class<?> var1);

    @KeepOriginal
    native boolean casAnnotationType(AnnotationType var1, AnnotationType var2);

    private static Field[] filterFields(Field ... fields) {
        ArrayList<Field> filtered = new ArrayList<Field>();
        ReflectionMetadataDecoder decoder = (ReflectionMetadataDecoder)ImageSingletons.lookup(ReflectionMetadataDecoder.class);
        for (Field field : fields) {
            int modifiers = field.getModifiers();
            if (decoder.isHiding(modifiers) || decoder.isNegative(modifiers)) continue;
            filtered.add(field);
        }
        return filtered.toArray(new Field[0]);
    }

    private static Method[] filterMethods(Method ... methods) {
        ArrayList<Method> filtered = new ArrayList<Method>();
        ReflectionMetadataDecoder decoder = (ReflectionMetadataDecoder)ImageSingletons.lookup(ReflectionMetadataDecoder.class);
        for (Method method : methods) {
            int modifiers = method.getModifiers();
            if (decoder.isHiding(modifiers) || decoder.isNegative(modifiers)) continue;
            filtered.add(method);
        }
        return filtered.toArray(new Method[0]);
    }

    private static Constructor<?>[] filterConstructors(Constructor<?> ... constructors) {
        ArrayList filtered = new ArrayList();
        ReflectionMetadataDecoder decoder = (ReflectionMetadataDecoder)ImageSingletons.lookup(ReflectionMetadataDecoder.class);
        for (Constructor<?> constructor : constructors) {
            if (decoder.isNegative(constructor.getModifiers())) continue;
            filtered.add(constructor);
        }
        return filtered.toArray(new Constructor[0]);
    }

    public void setJrfEventConfiguration(Object configuration) {
        this.companion.setJfrEventConfiguration(configuration);
    }

    public Object getJfrEventConfiguration() {
        return this.companion.getJfrEventConfiguration();
    }

    public ReflectionMetadataDecoder.FieldDescriptor[] getReachableFields() {
        if (this.reflectionMetadata == null || this.reflectionMetadata.fieldsEncodingIndex == -1) {
            return new ReflectionMetadataDecoder.FieldDescriptor[0];
        }
        return ((ReflectionMetadataDecoder)ImageSingletons.lookup(ReflectionMetadataDecoder.class)).parseReachableFields(this, this.reflectionMetadata.fieldsEncodingIndex);
    }

    public ReflectionMetadataDecoder.MethodDescriptor[] getReachableMethods() {
        if (this.reflectionMetadata == null || this.reflectionMetadata.methodsEncodingIndex == -1) {
            return new ReflectionMetadataDecoder.MethodDescriptor[0];
        }
        return ((ReflectionMetadataDecoder)ImageSingletons.lookup(ReflectionMetadataDecoder.class)).parseReachableMethods(this, this.reflectionMetadata.methodsEncodingIndex);
    }

    public ReflectionMetadataDecoder.ConstructorDescriptor[] getReachableConstructors() {
        if (this.reflectionMetadata == null || this.reflectionMetadata.constructorsEncodingIndex == -1) {
            return new ReflectionMetadataDecoder.ConstructorDescriptor[0];
        }
        return ((ReflectionMetadataDecoder)ImageSingletons.lookup(ReflectionMetadataDecoder.class)).parseReachableConstructors(this, this.reflectionMetadata.constructorsEncodingIndex);
    }

    private static final class DynamicHubMetadata {
        final int enclosingMethodInfoIndex;
        final int annotationsIndex;
        final int typeAnnotationsIndex;
        final int classesEncodingIndex;
        final int permittedSubclassesEncodingIndex;
        final int nestMembersEncodingIndex;
        final int signersEncodingIndex;

        private DynamicHubMetadata(int enclosingMethodInfoIndex, int annotationsIndex, int typeAnnotationsIndex, int classesEncodingIndex, int permittedSubclassesEncodingIndex, int nestMembersEncodingIndex, int signersEncodingIndex) {
            this.enclosingMethodInfoIndex = enclosingMethodInfoIndex;
            this.annotationsIndex = annotationsIndex;
            this.typeAnnotationsIndex = typeAnnotationsIndex;
            this.classesEncodingIndex = classesEncodingIndex;
            this.permittedSubclassesEncodingIndex = permittedSubclassesEncodingIndex;
            this.nestMembersEncodingIndex = nestMembersEncodingIndex;
            this.signersEncodingIndex = signersEncodingIndex;
        }
    }

    private static final class ReflectionMetadata {
        final int fieldsEncodingIndex;
        final int methodsEncodingIndex;
        final int constructorsEncodingIndex;
        final int recordComponentsEncodingIndex;
        final int classFlags;

        private ReflectionMetadata(int fieldsEncodingIndex, int methodsEncodingIndex, int constructorsEncodingIndex, int recordComponentsEncodingIndex, int classFlags) {
            this.fieldsEncodingIndex = fieldsEncodingIndex;
            this.methodsEncodingIndex = methodsEncodingIndex;
            this.constructorsEncodingIndex = constructorsEncodingIndex;
            this.recordComponentsEncodingIndex = recordComponentsEncodingIndex;
            this.classFlags = classFlags;
        }
    }

    private static class CachedConstructorAccessors {
        private CachedConstructorAccessors() {
        }

        private static Constructor<?> getCachedConstructor(DynamicHub that) {
            that.ensureInitialized();
            return that.companion.getCachedConstructor();
        }

        private static void setCachedConstructor(DynamicHub that, Constructor<?> value) {
            that.companion.setCachedConstructor(value);
        }
    }

    private static class AnnotationTypeAccessors {
        private AnnotationTypeAccessors() {
        }

        private static AnnotationType getAnnotationType(DynamicHub that) {
            return that.companion.getAnnotationType();
        }
    }

    private static class AnnotationDataAccessors {
        private AnnotationDataAccessors() {
        }

        private static Target_java_lang_Class_AnnotationData getAnnotationData(DynamicHub that) {
            return that.companion.getAnnotationData();
        }
    }

    private static class ClassLoaderAccessors {
        private ClassLoaderAccessors() {
        }

        private static ClassLoader getClassLoader(DynamicHub that) {
            return that.companion.getClassLoader();
        }
    }

    private static class ReflectionDataAccessors {
        private ReflectionDataAccessors() {
        }

        private static SoftReference<Target_java_lang_Class_ReflectionData<?>> getReflectionData(DynamicHub that) {
            return that.companion.getReflectionData();
        }
    }
}

