/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunkLogging;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.SerialGCOptions;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.heap.OutOfMemoryUtil;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.UnsignedUtils;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

final class HeapChunkProvider {
    private final UninterruptibleUtils.AtomicPointer<AlignedHeapChunk.AlignedHeader> unusedAlignedChunks = new UninterruptibleUtils.AtomicPointer();
    private final UninterruptibleUtils.AtomicUnsigned bytesInUnusedAlignedChunks = new UninterruptibleUtils.AtomicUnsigned();
    private static final OutOfMemoryError ALIGNED_OUT_OF_MEMORY_ERROR = new OutOfMemoryError("Could not allocate an aligned heap chunk");
    private static final OutOfMemoryError UNALIGNED_OUT_OF_MEMORY_ERROR = new OutOfMemoryError("Could not allocate an unaligned heap chunk");

    @Platforms(value={Platform.HOSTED_ONLY.class})
    HeapChunkProvider() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getBytesInUnusedChunks() {
        return (UnsignedWord)this.bytesInUnusedAlignedChunks.get();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    AlignedHeapChunk.AlignedHeader produceAlignedChunk() {
        UnsignedWord chunkSize = HeapParameters.getAlignedHeapChunkSize();
        AlignedHeapChunk.AlignedHeader result = this.popUnusedAlignedChunk();
        if (result.isNull()) {
            result = (AlignedHeapChunk.AlignedHeader)CommittedMemoryProvider.get().allocateAlignedChunk(chunkSize, HeapParameters.getAlignedHeapChunkAlignment());
            if (result.isNull()) {
                throw OutOfMemoryUtil.reportOutOfMemoryError(ALIGNED_OUT_OF_MEMORY_ERROR);
            }
            AlignedHeapChunk.initialize(result, chunkSize);
        }
        assert (HeapChunk.getTopOffset(result).equal(AlignedHeapChunk.getObjectsStartOffset()));
        assert (HeapChunk.getEndOffset(result).equal(chunkSize));
        if (HeapParameters.getZapProducedHeapChunks()) {
            HeapChunkProvider.zap(result, (WordBase)HeapParameters.getProducedHeapChunkZapWord());
        }
        return result;
    }

    void freeExcessAlignedChunks() {
        assert (VMOperation.isGCInProgress());
        this.consumeAlignedChunks((AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer(), false);
    }

    void consumeAlignedChunks(AlignedHeapChunk.AlignedHeader firstChunk, boolean keepAll) {
        assert (VMOperation.isGCInProgress());
        assert (firstChunk.isNull() || HeapChunk.getPrevious(firstChunk).isNull()) : "prev must be null";
        UnsignedWord maxChunksToKeep = (UnsignedWord)WordFactory.zero();
        UnsignedWord unusedChunksToFree = (UnsignedWord)WordFactory.zero();
        if (keepAll) {
            maxChunksToKeep = UnsignedUtils.MAX_VALUE;
        } else {
            UnsignedWord freeListBytes = this.getBytesInUnusedChunks();
            UnsignedWord reserveBytes = GCImpl.getPolicy().getMaximumFreeAlignedChunksSize();
            UnsignedWord maxHeapFree = WordFactory.unsigned((long)SerialGCOptions.MaxHeapFree.getValue());
            if (maxHeapFree.aboveThan(0)) {
                reserveBytes = UnsignedUtils.min(reserveBytes, maxHeapFree);
            }
            if (freeListBytes.belowThan(reserveBytes)) {
                maxChunksToKeep = reserveBytes.subtract(freeListBytes).unsignedDivide(HeapParameters.getAlignedHeapChunkSize());
            } else {
                unusedChunksToFree = freeListBytes.subtract(reserveBytes).unsignedDivide(HeapParameters.getAlignedHeapChunkSize());
            }
        }
        AlignedHeapChunk.AlignedHeader cur = firstChunk;
        while (cur.isNonNull() && maxChunksToKeep.aboveThan(0)) {
            AlignedHeapChunk.AlignedHeader next = HeapChunk.getNext(cur);
            HeapChunkProvider.cleanAlignedChunk(cur);
            this.pushUnusedAlignedChunk(cur);
            maxChunksToKeep = maxChunksToKeep.subtract(1);
            cur = next;
        }
        HeapChunkProvider.freeAlignedChunkList(cur);
        this.freeUnusedAlignedChunksAtSafepoint(unusedChunksToFree);
    }

    private static void cleanAlignedChunk(AlignedHeapChunk.AlignedHeader alignedChunk) {
        assert (VMOperation.isGCInProgress());
        AlignedHeapChunk.reset(alignedChunk);
        if (HeapParameters.getZapConsumedHeapChunks()) {
            HeapChunkProvider.zap(alignedChunk, (WordBase)HeapParameters.getConsumedHeapChunkZapWord());
        }
    }

    private void pushUnusedAlignedChunk(AlignedHeapChunk.AlignedHeader chunk) {
        assert (VMOperation.isGCInProgress());
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            VMThreads.guaranteeOwnsThreadMutex("Should hold the lock when pushing to the global list.");
        }
        HeapChunk.setNext(chunk, this.unusedAlignedChunks.get());
        this.unusedAlignedChunks.set(chunk);
        this.bytesInUnusedAlignedChunks.addAndGet(HeapParameters.getAlignedHeapChunkSize());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private AlignedHeapChunk.AlignedHeader popUnusedAlignedChunk() {
        AlignedHeapChunk.AlignedHeader result = this.popUnusedAlignedChunkUninterruptibly();
        if (result.isNull()) {
            return (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer();
        }
        this.bytesInUnusedAlignedChunks.subtractAndGet(HeapParameters.getAlignedHeapChunkSize());
        return result;
    }

    @Uninterruptible(reason="Must not be interrupted by competing pushes.")
    private AlignedHeapChunk.AlignedHeader popUnusedAlignedChunkUninterruptibly() {
        AlignedHeapChunk.AlignedHeader next;
        AlignedHeapChunk.AlignedHeader result;
        do {
            if (!(result = this.unusedAlignedChunks.get()).isNull()) continue;
            return (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer();
        } while (!this.unusedAlignedChunks.compareAndSet(result, next = HeapChunk.getNext(result)));
        HeapChunk.setNext(result, (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer());
        return result;
    }

    private void freeUnusedAlignedChunksAtSafepoint(UnsignedWord count) {
        assert (VMOperation.isGCInProgress());
        if (count.equal(0)) {
            return;
        }
        AlignedHeapChunk.AlignedHeader chunk = this.unusedAlignedChunks.get();
        UnsignedWord released = (UnsignedWord)WordFactory.zero();
        while (chunk.isNonNull() && released.belowThan(count)) {
            AlignedHeapChunk.AlignedHeader next = HeapChunk.getNext(chunk);
            HeapChunkProvider.freeAlignedChunk(chunk);
            chunk = next;
            released = released.add(1);
        }
        this.unusedAlignedChunks.set(chunk);
        this.bytesInUnusedAlignedChunks.subtractAndGet(released.multiply(HeapParameters.getAlignedHeapChunkSize()));
    }

    UnalignedHeapChunk.UnalignedHeader produceUnalignedChunk(UnsignedWord objectSize) {
        UnsignedWord chunkSize = UnalignedHeapChunk.getChunkSizeForObject(objectSize);
        UnalignedHeapChunk.UnalignedHeader result = (UnalignedHeapChunk.UnalignedHeader)CommittedMemoryProvider.get().allocateUnalignedChunk(chunkSize);
        if (result.isNull()) {
            throw OutOfMemoryUtil.reportOutOfMemoryError(UNALIGNED_OUT_OF_MEMORY_ERROR);
        }
        UnalignedHeapChunk.initialize(result, chunkSize);
        assert (objectSize.belowOrEqual(HeapChunk.availableObjectMemory(result))) : "UnalignedHeapChunk insufficient for requested object";
        if (!CommittedMemoryProvider.get().areUnalignedChunksZeroed() && HeapParameters.getZapProducedHeapChunks()) {
            HeapChunkProvider.zap(result, (WordBase)HeapParameters.getProducedHeapChunkZapWord());
        }
        return result;
    }

    public static boolean areUnalignedChunksZeroed() {
        return CommittedMemoryProvider.get().areUnalignedChunksZeroed();
    }

    static void consumeUnalignedChunks(UnalignedHeapChunk.UnalignedHeader firstChunk) {
        assert (VMOperation.isGCInProgress());
        HeapChunkProvider.freeUnalignedChunkList(firstChunk);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void zap(HeapChunk.Header<?> chunk, WordBase value) {
        Pointer start = HeapChunk.getTopPointer(chunk);
        Pointer limit = HeapChunk.getEndPointer(chunk);
        Pointer p = start;
        while (p.belowThan((UnsignedWord)limit)) {
            p.writeWord(0, value);
            p = p.add(FrameAccess.wordSize());
        }
    }

    void logFreeChunks(Log log) {
        HeapChunkLogging.logChunks(log, this.unusedAlignedChunks.get(), "F", true);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void tearDown() {
        HeapChunkProvider.freeAlignedChunkList(this.unusedAlignedChunks.get());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static void freeAlignedChunkList(AlignedHeapChunk.AlignedHeader first) {
        AlignedHeapChunk.AlignedHeader chunk = first;
        while (chunk.isNonNull()) {
            AlignedHeapChunk.AlignedHeader next = HeapChunk.getNext(chunk);
            HeapChunkProvider.freeAlignedChunk(chunk);
            chunk = next;
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static void freeUnalignedChunkList(UnalignedHeapChunk.UnalignedHeader first) {
        UnalignedHeapChunk.UnalignedHeader chunk = first;
        while (chunk.isNonNull()) {
            UnalignedHeapChunk.UnalignedHeader next = HeapChunk.getNext(chunk);
            HeapChunkProvider.freeUnalignedChunk(chunk);
            chunk = next;
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void freeAlignedChunk(AlignedHeapChunk.AlignedHeader chunk) {
        CommittedMemoryProvider.get().freeAlignedChunk(chunk, HeapParameters.getAlignedHeapChunkSize(), HeapParameters.getAlignedHeapChunkAlignment());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void freeUnalignedChunk(UnalignedHeapChunk.UnalignedHeader chunk) {
        CommittedMemoryProvider.get().freeUnalignedChunk(chunk, HeapChunkProvider.unalignedChunkSize(chunk));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord unalignedChunkSize(UnalignedHeapChunk.UnalignedHeader chunk) {
        return HeapChunk.getEndOffset(chunk);
    }
}

