/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c.function;

import com.oracle.svm.core.util.VMError;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.graalvm.nativeimage.AnnotationAccess;

public final class CEntryPointErrors {
    @Description(value="No error occurred.")
    public static final int NO_ERROR = 0;
    @Description(value="An unspecified error occurred.")
    public static final int UNSPECIFIED = 1;
    @Description(value="An argument was NULL.")
    public static final int NULL_ARGUMENT = 2;
    @Description(value="Memory allocation failed, the OS is probably out of memory.")
    public static final int ALLOCATION_FAILED = 3;
    @Description(value="The specified thread is not attached to the isolate.")
    public static final int UNATTACHED_THREAD = 4;
    @Description(value="The specified isolate is unknown.")
    public static final int UNINITIALIZED_ISOLATE = 5;
    @Description(value="Locating the image file failed.")
    public static final int LOCATE_IMAGE_FAILED = 6;
    @Description(value="Opening the located image file failed.")
    public static final int OPEN_IMAGE_FAILED = 7;
    @Description(value="Mapping the heap from the image file into memory failed.")
    public static final int MAP_HEAP_FAILED = 8;
    @Description(value="Reserving address space for the new isolate failed.")
    public static final int RESERVE_ADDRESS_SPACE_FAILED = 801;
    @Description(value="The image heap does not fit in the available address space.")
    public static final int INSUFFICIENT_ADDRESS_SPACE = 802;
    @Description(value="Setting the protection of the heap memory failed.")
    public static final int PROTECT_HEAP_FAILED = 9;
    @Description(value="The version of the specified isolate parameters is unsupported.")
    public static final int UNSUPPORTED_ISOLATE_PARAMETERS_VERSION = 10;
    @Description(value="Initialization of threading in the isolate failed.")
    public static final int THREADING_INITIALIZATION_FAILED = 11;
    @Description(value="Some exception is not caught.")
    public static final int UNCAUGHT_EXCEPTION = 12;
    @Description(value="Initialization the isolate failed.")
    public static final int ISOLATE_INITIALIZATION_FAILED = 13;
    @Description(value="Opening the located auxiliary image file failed.")
    public static final int OPEN_AUX_IMAGE_FAILED = 14;
    @Description(value="Reading the opened auxiliary image file failed.")
    public static final int READ_AUX_IMAGE_META_FAILED = 15;
    @Description(value="Mapping the auxiliary image file into memory failed.")
    public static final int MAP_AUX_IMAGE_FAILED = 16;
    @Description(value="Insufficient memory for the auxiliary image.")
    public static final int INSUFFICIENT_AUX_IMAGE_MEMORY = 17;
    @Description(value="Auxiliary images are not supported on this platform or edition.")
    public static final int AUX_IMAGE_UNSUPPORTED = 18;
    @Description(value="Releasing the isolate's address space failed.")
    public static final int FREE_ADDRESS_SPACE_FAILED = 19;
    @Description(value="Releasing the isolate's image heap memory failed.")
    public static final int FREE_IMAGE_HEAP_FAILED = 20;
    @Description(value="The auxiliary image was built from a different primary image.")
    public static final int AUX_IMAGE_PRIMARY_IMAGE_MISMATCH = 21;
    @Description(value="The isolate arguments could not be parsed.")
    public static final int ARGUMENT_PARSING_FAILED = 22;
    @Description(value="Current target does not support the following CPU features that are required by the image.")
    public static final int CPU_FEATURE_CHECK_FAILED = 23;
    @Description(value="Image page size is incompatible with run-time page size. Rebuild image with -H:PageSize=[pagesize] to set appropriately.")
    public static final int PAGE_SIZE_CHECK_FAILED = 24;
    @Description(value="Creating an in-memory file for the GOT failed.")
    public static final int DYNAMIC_METHOD_ADDRESS_RESOLUTION_GOT_FD_CREATE_FAILED = 25;
    @Description(value="Resizing the in-memory file for the GOT failed.")
    public static final int DYNAMIC_METHOD_ADDRESS_RESOLUTION_GOT_FD_RESIZE_FAILED = 26;
    @Description(value="Mapping and populating the in-memory file for the GOT failed.")
    public static final int DYNAMIC_METHOD_ADDRESS_RESOLUTION_GOT_FD_MAP_FAILED = 27;
    @Description(value="Mapping the GOT before an isolate's heap failed (no mapping).")
    public static final int DYNAMIC_METHOD_ADDRESS_RESOLUTION_GOT_MMAP_FAILED = 28;
    @Description(value="Mapping the GOT before an isolate's heap failed (wrong mapping).")
    public static final int DYNAMIC_METHOD_ADDRESS_RESOLUTION_GOT_WRONG_MMAP = 29;
    @Description(value="Mapping the GOT before an isolate's heap failed (invalid file).")
    public static final int DYNAMIC_METHOD_ADDRESS_RESOLUTION_GOT_FD_INVALID = 30;
    @Description(value="Could not create unique GOT file even after retrying.")
    public static final int DYNAMIC_METHOD_ADDRESS_RESOLUTION_GOT_UNIQUE_FILE_CREATE_FAILED = 31;
    @Description(value="Could not determine the stack boundaries.")
    public static final int UNKNOWN_STACK_BOUNDARIES = 32;
    private static final String[] DESCRIPTIONS;

    private CEntryPointErrors() {
    }

    public static String getDescription(int code) {
        String result = null;
        if (code >= 0 && code < DESCRIPTIONS.length) {
            result = DESCRIPTIONS[code];
        }
        if (result == null) {
            return "(Unknown error)";
        }
        return result;
    }

    static {
        try {
            String[] array = new String[16];
            int maxValue = 0;
            for (Field field : CEntryPointErrors.class.getDeclaredFields()) {
                if (!field.getType().equals(Integer.TYPE)) continue;
                int value = field.getInt(null);
                String description = ((Description)AnnotationAccess.getAnnotation((AnnotatedElement)field, Description.class)).value();
                if ((maxValue = Math.max(value, maxValue)) >= array.length) {
                    array = Arrays.copyOf(array, 2 * maxValue);
                }
                array[value] = description;
            }
            DESCRIPTIONS = Arrays.copyOf(array, maxValue + 1);
        }
        catch (IllegalAccessException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface Description {
        public String value();
    }
}

