/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.IsolateListenerSupport;
import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.RegisterDumper;
import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.graal.nodes.WriteCurrentVMThreadNode;
import com.oracle.svm.core.graal.snippets.CEntryPointSnippets;
import com.oracle.svm.core.graal.stackvalue.UnsafeLateStackValue;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.VMThreadLocalMTSupport;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public abstract class SubstrateSegfaultHandler {
    private boolean installed;

    @Fold
    public static SubstrateSegfaultHandler singleton() {
        return (SubstrateSegfaultHandler)ImageSingletons.lookup(SubstrateSegfaultHandler.class);
    }

    public static boolean isInstalled() {
        return SubstrateSegfaultHandler.singleton().installed;
    }

    public void install() {
        this.installInternal();
        this.installed = true;
    }

    protected abstract void installInternal();

    protected abstract void printSignalInfo(Log var1, PointerBase var2);

    @Uninterruptible(reason="Thread state not set up yet.")
    protected static boolean tryEnterIsolate(RegisterDumper.Context context) {
        Isolate isolate = SingleIsolateSegfaultSetup.singleton().getIsolate();
        if (isolate.rawValue() != -1L) {
            int error = CEntryPointSnippets.enterAttachFromCrashHandler(isolate);
            return error == 0;
        }
        if (!SubstrateOptions.useLLVMBackend()) {
            if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
                PointerBase heapBase = RegisterDumper.singleton().getHeapBase(context);
                CEntryPointSnippets.setHeapBase(heapBase);
            }
            if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
                PointerBase threadPointer = RegisterDumper.singleton().getThreadPointer(context);
                WriteCurrentVMThreadNode.writeCurrentVMThread((IsolateThread)threadPointer);
            }
            return Isolates.checkIsolate(isolate = VMThreads.IsolateTL.get()) == 0 && (SubstrateOptions.SpawnIsolates.getValue() == false || isolate.equal((ComparableWord)KnownIntrinsics.heapBase()));
        }
        return false;
    }

    @Uninterruptible(reason="prologue")
    public static void enterIsolateAsyncSignalSafe(Isolate isolate) {
        int error = CEntryPointSnippets.enterFromCrashHandler(isolate);
        if (error != 0) {
            int isolateThreadSize = VMThreadLocalMTSupport.singleton().vmThreadSize;
            IsolateThread structForUnattachedThread = (IsolateThread)UnsafeLateStackValue.get(isolateThreadSize);
            UnmanagedMemoryUtil.fill((Pointer)structForUnattachedThread, WordFactory.unsigned((int)isolateThreadSize), (byte)0);
            CEntryPointSnippets.initializeIsolateThreadForCrashHandler(isolate, structForUnattachedThread);
        }
    }

    @Uninterruptible(reason="Must be uninterruptible until we get immune to safepoints.")
    public static void dump(PointerBase signalInfo, RegisterDumper.Context context) {
        Pointer sp = (Pointer)RegisterDumper.singleton().getSP(context);
        CodePointer ip = (CodePointer)RegisterDumper.singleton().getIP(context);
        SubstrateSegfaultHandler.dump(sp, ip, signalInfo, context);
    }

    @Uninterruptible(reason="Must be uninterruptible until we get immune to safepoints.", calleeMustBe=false)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in segfault handler.")
    public static void dump(Pointer sp, CodePointer ip, PointerBase signalInfo, RegisterDumper.Context context) {
        VMThreads.SafepointBehavior.preventSafepoints();
        StackOverflowCheck.singleton().disableStackOverflowChecksForFatalError();
        SubstrateSegfaultHandler.dumpInterruptibly(sp, ip, signalInfo, context);
    }

    private static void dumpInterruptibly(Pointer sp, CodePointer ip, PointerBase signalInfo, RegisterDumper.Context context) {
        LogHandler logHandler = (LogHandler)ImageSingletons.lookup(LogHandler.class);
        Log log = Log.enterFatalContext(logHandler, ip, "[ [ SegfaultHandler caught a segfault. ] ]", null);
        if (log != null) {
            log.newline();
            log.string("[ [ SegfaultHandler caught a segfault in thread ").zhex((WordBase)CurrentIsolate.getCurrentThread()).string(" ] ]").newline();
            if (signalInfo.isNonNull()) {
                ((SubstrateSegfaultHandler)ImageSingletons.lookup(SubstrateSegfaultHandler.class)).printSignalInfo(log, signalInfo);
            }
            boolean printedDiagnostics = SubstrateDiagnostics.printFatalError(log, sp, ip, context, false);
            if (SubstrateSegfaultHandler.isInstalled() && printedDiagnostics) {
                log.string("Segfault detected, aborting process. ").string("Use '-XX:-InstallSegfaultHandler' to disable the segfault handler at run time and create a core dump instead. ").string("Rebuild with '-R:-InstallSegfaultHandler' to disable the handler permanently at build time.").newline().newline();
            }
        }
        logHandler.fatalError();
    }

    protected static void printSegfaultAddressInfo(Log log, long addr) {
        log.zhex(addr);
        if (addr != 0L) {
            long delta = addr - CurrentIsolate.getIsolate().rawValue();
            String sign = delta >= 0L ? "+" : "-";
            log.string(" (heapBase ").string(sign).string(" ").signed(Math.abs(delta)).string(")");
        }
    }

    static class SingleIsolateSegfaultSetup
    implements IsolateListenerSupport.IsolateListener {
        private static final CGlobalData<Pointer> baseIsolate = CGlobalDataFactory.createWord();

        SingleIsolateSegfaultSetup() {
        }

        @Fold
        public static SingleIsolateSegfaultSetup singleton() {
            return (SingleIsolateSegfaultSetup)ImageSingletons.lookup(SingleIsolateSegfaultSetup.class);
        }

        @Override
        @Uninterruptible(reason="Thread state not yet set up.")
        public void afterCreateIsolate(Isolate isolate) {
            PointerBase value = (PointerBase)baseIsolate.get().compareAndSwapWord(0, (WordBase)((Isolate)WordFactory.zero()), (WordBase)isolate, LocationIdentity.ANY_LOCATION);
            if (!value.isNull()) {
                baseIsolate.get().writeWord(0, (WordBase)WordFactory.signed((int)-1));
            }
        }

        @Uninterruptible(reason="Thread state not yet set up.")
        public Isolate getIsolate() {
            return (Isolate)baseIsolate.get().readWord(0);
        }
    }

    public static class Options {
        static final RuntimeOptionKey<Boolean> InstallSegfaultHandler = new RuntimeOptionKey<Object>(null, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    }
}

