/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.annotation.AnnotationWrapper;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public class InjectedFieldsType
implements ResolvedJavaType,
OriginalClassProvider,
AnnotationWrapper {
    private final ResolvedJavaType original;
    private final ResolvedJavaField[][] instanceFields;

    public InjectedFieldsType(ResolvedJavaType original) {
        this.original = original;
        this.instanceFields = new ResolvedJavaField[][]{original.getInstanceFields(false), original.getInstanceFields(true)};
    }

    public ResolvedJavaType getOriginal() {
        return this.original;
    }

    public void addInjectedField(ResolvedJavaField field) {
        for (int i = 0; i < this.instanceFields.length; ++i) {
            ResolvedJavaField[] newFields = (ResolvedJavaField[])Arrays.copyOf(this.instanceFields[i], this.instanceFields[i].length + 1, ResolvedJavaField[].class);
            newFields[newFields.length - 1] = field;
            this.instanceFields[i] = newFields;
        }
    }

    public ResolvedJavaField[] getInstanceFields(boolean includeSuperclasses) {
        return this.instanceFields[includeSuperclasses ? 1 : 0];
    }

    public String getName() {
        return this.original.getName();
    }

    public JavaKind getJavaKind() {
        return this.original.getJavaKind();
    }

    public ResolvedJavaType resolve(ResolvedJavaType accessingClass) {
        return this;
    }

    public boolean hasFinalizer() {
        return this.original.hasFinalizer();
    }

    public Assumptions.AssumptionResult<Boolean> hasFinalizableSubclass() {
        return this.original.hasFinalizableSubclass();
    }

    public boolean isInterface() {
        return this.original.isInterface();
    }

    public boolean isInstanceClass() {
        return this.original.isInstanceClass();
    }

    public boolean isArray() {
        return this.original.isArray();
    }

    public boolean isPrimitive() {
        return this.original.isPrimitive();
    }

    public boolean isEnum() {
        return this.original.isEnum();
    }

    public int getModifiers() {
        return this.original.getModifiers();
    }

    public boolean isInitialized() {
        return this.original.isInitialized();
    }

    public void initialize() {
        this.original.initialize();
    }

    public boolean isAssignableFrom(ResolvedJavaType other) {
        return this.original.isAssignableFrom(other);
    }

    public boolean isInstance(JavaConstant obj) {
        return this.original.isInstance(obj);
    }

    public ResolvedJavaType getSuperclass() {
        return this.original.getSuperclass();
    }

    public ResolvedJavaType[] getInterfaces() {
        return this.original.getInterfaces();
    }

    public ResolvedJavaType findLeastCommonAncestor(ResolvedJavaType otherType) {
        return this.original.findLeastCommonAncestor(otherType);
    }

    public ResolvedJavaType getSingleImplementor() {
        return this.original.getSingleImplementor();
    }

    public Assumptions.AssumptionResult<ResolvedJavaType> findLeafConcreteSubtype() {
        return this.original.findLeafConcreteSubtype();
    }

    public ResolvedJavaType getComponentType() {
        return this.original.getComponentType();
    }

    public ResolvedJavaType getArrayClass() {
        return this.original.getArrayClass();
    }

    public ResolvedJavaMethod resolveConcreteMethod(ResolvedJavaMethod method, ResolvedJavaType callerType) {
        return this.original.resolveConcreteMethod(method, callerType);
    }

    public ResolvedJavaMethod resolveMethod(ResolvedJavaMethod method, ResolvedJavaType callerType) {
        return this.original.resolveMethod(method, callerType);
    }

    public Assumptions.AssumptionResult<ResolvedJavaMethod> findUniqueConcreteMethod(ResolvedJavaMethod method) {
        return this.original.findUniqueConcreteMethod(method);
    }

    public ResolvedJavaField[] getStaticFields() {
        return this.original.getStaticFields();
    }

    @Override
    public AnnotatedElement getAnnotationRoot() {
        return this.original;
    }

    public ResolvedJavaField findInstanceFieldWithOffset(long offset, JavaKind expectedKind) {
        return this.original.findInstanceFieldWithOffset(offset, expectedKind);
    }

    public String getSourceFileName() {
        return this.original.getSourceFileName();
    }

    public boolean isLocal() {
        return this.original.isLocal();
    }

    public boolean isMember() {
        return this.original.isMember();
    }

    public ResolvedJavaType getEnclosingType() {
        return this.original.getEnclosingType();
    }

    public ResolvedJavaMethod[] getDeclaredConstructors() {
        return this.getDeclaredConstructors(true);
    }

    public ResolvedJavaMethod[] getDeclaredConstructors(boolean forceLink) {
        VMError.guarantee(!forceLink, "only use getDeclaredConstructors without forcing to link, because linking can throw LinkageError");
        return this.original.getDeclaredConstructors(forceLink);
    }

    public ResolvedJavaMethod[] getDeclaredMethods() {
        return this.getDeclaredMethods(true);
    }

    public ResolvedJavaMethod[] getDeclaredMethods(boolean forceLink) {
        VMError.guarantee(!forceLink, "only use getDeclaredMethods without forcing to link, because linking can throw LinkageError");
        return this.original.getDeclaredMethods(forceLink);
    }

    public ResolvedJavaMethod getClassInitializer() {
        return this.original.getClassInitializer();
    }

    public boolean isLinked() {
        return this.original.isLinked();
    }

    public void link() {
        this.original.link();
    }

    public boolean hasDefaultMethods() {
        return this.original.hasDefaultMethods();
    }

    public boolean declaresDefaultMethods() {
        return this.original.declaresDefaultMethods();
    }

    public boolean isCloneableWithAllocation() {
        throw JVMCIError.unimplemented();
    }

    public ResolvedJavaType getHostClass() {
        return this.original.getHostClass();
    }

    public Class<?> getJavaClass() {
        return OriginalClassProvider.getJavaClass((ResolvedJavaType)this.original);
    }

    public String toString() {
        return "InjectedFieldsType<" + this.original.toString() + ">";
    }
}

