/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.snippets;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.snippets.ExceptionUnwind;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.hosted.FeatureImpl;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.InternalPlatform;

@AutomaticallyRegisteredFeature
@Platforms(value={InternalPlatform.NATIVE_ONLY.class})
final class ExceptionUnwindFeature
implements InternalFeature {
    ExceptionUnwindFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        for (SnippetRuntime.SubstrateForeignCallDescriptor descriptor : ExceptionUnwind.FOREIGN_CALLS) {
            access.getBigBang().addRootMethod((AnalysisMethod)descriptor.findMethod((MetaAccessProvider)access.getMetaAccess()), true, (Object)("Exception foreign calls, registered in " + ExceptionUnwindFeature.class), new MultiMethod.MultiMethodKey[0]);
        }
    }

    @Override
    public void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(ExceptionUnwind.FOREIGN_CALLS);
    }
}

