/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.reflect.serialize;

import com.oracle.graal.pointsto.phases.NoClassInitializationPlugin;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.configure.ConfigurationFile;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.configure.SerializationConfigurationParser;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.hosted.ConfigurationTypeResolver;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.config.ConfigurationParserUtils;
import com.oracle.svm.hosted.reflect.ReflectionFeature;
import com.oracle.svm.hosted.reflect.proxy.DynamicProxyFeature;
import com.oracle.svm.hosted.reflect.proxy.ProxyRegistry;
import com.oracle.svm.hosted.reflect.serialize.SerializationBuilder;
import com.oracle.svm.hosted.reflect.serialize.SerializationDenyRegistry;
import com.oracle.svm.util.ClassUtil;
import com.oracle.svm.util.ReflectionUtil;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.java.LambdaUtils;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.ClassInitializationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;
import org.graalvm.compiler.replacements.MethodHandlePlugin;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.RuntimeSerializationSupport;

@AutomaticallyRegisteredFeature
public class SerializationFeature
implements InternalFeature {
    final Set<Class<?>> capturingClasses = ConcurrentHashMap.newKeySet();
    private SerializationBuilder serializationBuilder;
    private SerializationDenyRegistry serializationDenyRegistry;
    private int loadedConfigurations;

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return List.of(ReflectionFeature.class, DynamicProxyFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess a) {
        FeatureImpl.AfterRegistrationAccessImpl access = (FeatureImpl.AfterRegistrationAccessImpl)a;
        ImageClassLoader imageClassLoader = access.getImageClassLoader();
        ConfigurationTypeResolver typeResolver = new ConfigurationTypeResolver("serialization configuration", imageClassLoader);
        this.serializationDenyRegistry = new SerializationDenyRegistry(typeResolver);
        this.serializationBuilder = new SerializationBuilder(this.serializationDenyRegistry, access, typeResolver, (ProxyRegistry)ImageSingletons.lookup(ProxyRegistry.class));
        ImageSingletons.add(RuntimeSerializationSupport.class, (Object)this.serializationBuilder);
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        ImageClassLoader imageClassLoader = access.getImageClassLoader();
        Boolean strictConfiguration = ConfigurationFiles.Options.StrictConfiguration.getValue();
        SerializationConfigurationParser parser = SerializationConfigurationParser.create(true, this.serializationBuilder, strictConfiguration);
        this.loadedConfigurations = ConfigurationParserUtils.parseAndRegisterConfigurationsFromCombinedFile(parser, imageClassLoader, "serialization");
        SerializationConfigurationParser denyCollectorParser = SerializationConfigurationParser.create(false, this.serializationDenyRegistry, strictConfiguration);
        ConfigurationParserUtils.parseAndRegisterConfigurations((ConfigurationParser)denyCollectorParser, imageClassLoader, "serialization", ConfigurationFiles.Options.SerializationDenyConfigurationFiles, ConfigurationFiles.Options.SerializationDenyConfigurationResources, ConfigurationFile.SERIALIZATION_DENY.getFileName());
        SerializationConfigurationParser legacyParser = SerializationConfigurationParser.create(false, this.serializationBuilder, strictConfiguration);
        this.loadedConfigurations += ConfigurationParserUtils.parseAndRegisterConfigurations((ConfigurationParser)legacyParser, imageClassLoader, "serialization", ConfigurationFiles.Options.SerializationConfigurationFiles, ConfigurationFiles.Options.SerializationConfigurationResources, ConfigurationFile.SERIALIZATION.getFileName());
    }

    private static GraphBuilderConfiguration buildLambdaParserConfig() {
        GraphBuilderConfiguration.Plugins plugins = new GraphBuilderConfiguration.Plugins(new InvocationPlugins());
        plugins.setClassInitializationPlugin((ClassInitializationPlugin)new NoClassInitializationPlugin());
        plugins.prependNodePlugin((NodePlugin)new MethodHandlePlugin(GraalAccess.getOriginalProviders().getConstantReflection().getMethodHandleAccess(), false));
        return GraphBuilderConfiguration.getDefault((GraphBuilderConfiguration.Plugins)plugins).withEagerResolving(true);
    }

    private static StructuredGraph createMethodGraph(ResolvedJavaMethod method, GraphBuilderPhase lambdaParserPhase, OptionValues options) {
        DebugContext.Description description = new DebugContext.Description((Object)method, ClassUtil.getUnqualifiedName(method.getClass()) + ":" + method.getName());
        DebugContext debug = new DebugContext.Builder(options, (DebugHandlersFactory)new GraalDebugHandlersFactory(GraalAccess.getOriginalSnippetReflection())).description(description).build();
        HighTierContext context = new HighTierContext(GraalAccess.getOriginalProviders(), null, OptimisticOptimizations.NONE);
        StructuredGraph graph = new StructuredGraph.Builder(debug.getOptions(), debug).method(method).recordInlinedMethods(false).build();
        try (DebugContext.Scope ignored = debug.scope((Object)"ParsingToMaterializeLambdas");){
            lambdaParserPhase.apply(graph, (Object)context);
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        return graph;
    }

    private static Class<?> getLambdaClassFromMemberField(Constant constant) {
        ResolvedJavaType constantType = GraalAccess.getOriginalProviders().getMetaAccess().lookupJavaType((JavaConstant)constant);
        if (constantType == null) {
            return null;
        }
        ResolvedJavaField[] fields = constantType.getInstanceFields(true);
        ResolvedJavaField targetField = null;
        for (ResolvedJavaField field : fields) {
            if (!field.getName().equals("member")) continue;
            targetField = field;
            break;
        }
        if (targetField == null) {
            return null;
        }
        JavaConstant fieldValue = GraalAccess.getOriginalProviders().getConstantReflection().readFieldValue(targetField, (JavaConstant)constant);
        Member memberField = (Member)GraalAccess.getOriginalProviders().getSnippetReflection().asObject(Member.class, fieldValue);
        return memberField.getDeclaringClass();
    }

    private static Class<?> getLambdaClassFromConstantNode(ConstantNode constantNode) {
        Constant constant = constantNode.getValue();
        Class<?> lambdaClass = SerializationFeature.getLambdaClassFromMemberField(constant);
        if (lambdaClass == null) {
            return null;
        }
        return lambdaClass.getName().contains(LambdaUtils.LAMBDA_CLASS_NAME_SUBSTRING) ? lambdaClass : null;
    }

    private static void registerLambdasFromConstantNodesInGraph(StructuredGraph graph, SerializationBuilder serializationBuilder) {
        NodeIterable constantNodes = ConstantNode.getConstantNodes((StructuredGraph)graph);
        for (ConstantNode cNode : constantNodes) {
            Class<?> lambdaClass = SerializationFeature.getLambdaClassFromConstantNode(cNode);
            if (lambdaClass == null || !Serializable.class.isAssignableFrom(lambdaClass)) continue;
            RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod(lambdaClass, (String)"writeReplace", (Class[])new Class[0])});
            SerializationBuilder.registerSerializationUIDElements(lambdaClass, false);
            serializationBuilder.serializationSupport.registerSerializationTargetClass(lambdaClass);
        }
    }

    private static void registerLambdasFromMethod(ResolvedJavaMethod method, SerializationBuilder serializationBuilder, OptionValues options) {
        GraphBuilderPhase lambdaParserPhase = new GraphBuilderPhase(SerializationFeature.buildLambdaParserConfig());
        StructuredGraph graph = SerializationFeature.createMethodGraph(method, lambdaParserPhase, options);
        SerializationFeature.registerLambdasFromConstantNodesInGraph(graph, serializationBuilder);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        this.serializationBuilder.flushConditionalConfiguration(access);
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        FeatureImpl.DuringAnalysisAccessImpl impl = (FeatureImpl.DuringAnalysisAccessImpl)access;
        OptionValues options = impl.getBigBang().getOptions();
        this.serializationBuilder.flushConditionalConfiguration(access);
        MetaAccessProvider metaAccess = GraalAccess.getOriginalProviders().getMetaAccess();
        this.capturingClasses.parallelStream().map(arg_0 -> ((MetaAccessProvider)metaAccess).lookupJavaType(arg_0)).flatMap(SerializationFeature::allExecutablesDeclaredInClass).filter(m -> m.getCode() != null).forEach(m -> SerializationFeature.registerLambdasFromMethod(m, this.serializationBuilder, options));
        this.capturingClasses.clear();
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.serializationBuilder.afterAnalysis();
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        FallbackFeature.FallbackImageRequest serializationFallback;
        if (ImageSingletons.contains(FallbackFeature.class) && (serializationFallback = ((FallbackFeature)ImageSingletons.lookup(FallbackFeature.class)).serializationFallback) != null && this.loadedConfigurations == 0) {
            throw serializationFallback;
        }
    }

    private static Stream<? extends ResolvedJavaMethod> allExecutablesDeclaredInClass(ResolvedJavaType t) {
        return Stream.concat(Stream.concat(Arrays.stream(t.getDeclaredMethods(false)), Arrays.stream(t.getDeclaredConstructors(false))), t.getClassInitializer() == null ? Stream.empty() : Stream.of(t.getClassInitializer()));
    }
}

