/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.util.VMError;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@Platforms(value={Platform.HOSTED_ONLY.class})
@AutomaticallyRegisteredFeature
class HostedMethodNameFactory
implements InternalFeature {
    Map<String, Integer> methodNameCount = new ConcurrentHashMap<String, Integer>();
    Set<String> uniqueShortNames = ConcurrentHashMap.newKeySet();

    HostedMethodNameFactory() {
    }

    Pair<String, String> createNames(Function<Integer, Pair<String, String>> nameGenerator) {
        Pair<String, String> result = nameGenerator.apply(0);
        int collisionCount = this.methodNameCount.merge((String)result.getRight(), 0, (oldValue, value) -> oldValue + 1);
        if (collisionCount != 0) {
            result = nameGenerator.apply(collisionCount);
        }
        boolean added = this.uniqueShortNames.add((String)result.getRight());
        VMError.guarantee(added, "failed to generate uniqueShortName for HostedMethod: %s", result.getRight());
        return result;
    }

    public void afterCompilation(Feature.AfterCompilationAccess access) {
        this.methodNameCount = null;
        this.uniqueShortNames = null;
    }
}

