/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.infrastructure.OriginalFieldProvider;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaField;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.hosted.meta.HostedElement;
import com.oracle.svm.hosted.meta.HostedType;
import java.lang.reflect.Field;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaTypeProfile;

public class HostedField
extends HostedElement
implements OriginalFieldProvider,
SharedField,
WrappedJavaField {
    public final AnalysisField wrapped;
    private final HostedType holder;
    private final HostedType type;
    protected int location;
    private final JavaTypeProfile typeProfile;
    static final int LOC_UNMATERIALIZED_STATIC_CONSTANT = -10;

    public HostedField(AnalysisField wrapped, HostedType holder, HostedType type, JavaTypeProfile typeProfile) {
        this.wrapped = wrapped;
        this.holder = holder;
        this.type = type;
        this.typeProfile = typeProfile;
        this.location = -1;
    }

    public AnalysisField getWrapped() {
        return this.wrapped;
    }

    public JavaTypeProfile getFieldTypeProfile() {
        return this.typeProfile;
    }

    protected void setLocation(int location) {
        assert (this.location == -1);
        assert (location >= 0);
        this.location = location;
    }

    protected void setUnmaterializedStaticConstant() {
        assert (this.location == -1 && this.isStatic());
        this.location = -10;
    }

    public boolean hasLocation() {
        return this.location >= 0;
    }

    @Override
    public int getLocation() {
        return this.location;
    }

    @Override
    public boolean isAccessed() {
        return this.wrapped.isAccessed();
    }

    @Override
    public boolean isReachable() {
        return this.wrapped.isReachable();
    }

    public boolean isRead() {
        return this.wrapped.isRead();
    }

    @Override
    public boolean isWritten() {
        return this.wrapped.isWritten();
    }

    @Override
    public boolean isValueAvailable() {
        return this.wrapped.isValueAvailable();
    }

    public String getName() {
        return this.wrapped.getName();
    }

    public HostedType getType() {
        return this.type;
    }

    public int getModifiers() {
        return this.wrapped.getModifiers();
    }

    public int getOffset() {
        return this.getLocation();
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    public HostedType getDeclaringClass() {
        return this.holder;
    }

    public boolean isInternal() {
        return this.wrapped.isInternal();
    }

    public boolean isSynthetic() {
        return this.wrapped.isSynthetic();
    }

    public String toString() {
        return "HostedField<" + this.format("%h.%n") + " -> " + this.wrapped.toString() + ", location: " + this.location + ">";
    }

    @Override
    public JavaKind getStorageKind() {
        return this.getType().getStorageKind();
    }

    public Field getJavaField() {
        return this.wrapped.getJavaField();
    }
}

