/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.heap;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.heap.dump.HProfType;
import com.oracle.svm.core.heap.dump.HeapDumpMetadata;
import com.oracle.svm.core.heap.dump.HeapDumpSupportImpl;
import com.oracle.svm.core.heap.dump.HeapDumping;
import com.oracle.svm.core.heapdump.HeapDumpUtils;
import com.oracle.svm.core.heapdump.HeapDumpWriter;
import com.oracle.svm.core.heapdump.HeapDumpWriterImpl;
import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.os.RawFileOperationSupport;
import com.oracle.svm.core.util.ByteArrayReader;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.heap.HeapDumpHostedUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.compiler.core.common.util.TypeConversion;
import org.graalvm.compiler.core.common.util.UnsafeArrayTypeWriter;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.HeapDumpSupport;

@AutomaticallyRegisteredFeature
public class HeapDumpFeature
implements InternalFeature {
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return !Platform.includedIn(Platform.WINDOWS.class);
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        if (HeapDumpFeature.useLegacyImplementation()) {
            com.oracle.svm.core.heapdump.HeapDumpSupportImpl heapDumpSupport = new com.oracle.svm.core.heapdump.HeapDumpSupportImpl();
            ImageSingletons.add(HeapDumpSupport.class, (Object)heapDumpSupport);
            ImageSingletons.add(HeapDumping.class, (Object)heapDumpSupport);
            ImageSingletons.add(HeapDumpUtils.class, (Object)new HeapDumpUtils());
            ImageSingletons.add(HeapDumpWriter.class, (Object)new HeapDumpWriterImpl());
        } else {
            HeapDumpMetadata metadata = new HeapDumpMetadata();
            HeapDumpSupportImpl heapDumpSupport = new HeapDumpSupportImpl(metadata);
            ImageSingletons.add(HeapDumpSupport.class, (Object)heapDumpSupport);
            ImageSingletons.add(HeapDumping.class, (Object)heapDumpSupport);
            ImageSingletons.add(HeapDumpMetadata.class, (Object)metadata);
        }
    }

    public static boolean useLegacyImplementation() {
        return !RawFileOperationSupport.isPresent();
    }

    public void afterCompilation(Feature.AfterCompilationAccess access) {
        FeatureImpl.AfterCompilationAccessImpl accessImpl = (FeatureImpl.AfterCompilationAccessImpl)access;
        if (HeapDumpFeature.useLegacyImplementation()) {
            byte[] fieldMap = HeapDumpHostedUtils.dumpFieldsMap(accessImpl.getTypes());
            HeapDumpUtils.getHeapDumpUtils().setFieldsMap(fieldMap);
            access.registerAsImmutable((Object)fieldMap);
        } else {
            byte[] metadata = HeapDumpFeature.encodeMetadata(accessImpl.getTypes());
            HeapDumpMetadata.singleton().setData(metadata);
            access.registerAsImmutable((Object)metadata);
        }
    }

    private static byte[] encodeMetadata(Collection<? extends SharedType> types) {
        int maxTypeId = types.stream().mapToInt(t -> t.getHub().getTypeID()).max().orElse(0);
        assert (maxTypeId > 0);
        UnsafeArrayTypeWriter output = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        HeapDumpFeature.encodeMetadata(output, types, maxTypeId);
        int length = TypeConversion.asS4((long)output.getBytesWritten());
        return output.toArray(new byte[length]);
    }

    private static void encodeMetadata(UnsafeArrayTypeWriter output, Collection<? extends SharedType> types, int maxTypeId) {
        long totalFieldCountOffset = output.getBytesWritten();
        output.putS4(0L);
        long classCountOffset = output.getBytesWritten();
        output.putS4(0L);
        long fieldNameCountOffset = output.getBytesWritten();
        output.putS4(0L);
        output.putUV((long)maxTypeId);
        int totalFieldCount = 0;
        int classCount = 0;
        EconomicMap fieldNames = EconomicMap.create();
        for (SharedType sharedType : types) {
            if (!sharedType.isInstanceClass()) continue;
            ArrayList<SharedField> instanceFields = HeapDumpFeature.collectFields(sharedType.getInstanceFields(false));
            ArrayList<SharedField> staticFields = HeapDumpFeature.collectFields(sharedType.getStaticFields());
            if (instanceFields.size() == 0 && staticFields.size() == 0) continue;
            ++classCount;
            totalFieldCount += instanceFields.size() + staticFields.size();
            output.putUV((long)sharedType.getHub().getTypeID());
            output.putUV((long)instanceFields.size());
            output.putUV((long)staticFields.size());
            for (SharedField field : instanceFields) {
                HeapDumpFeature.encodeField(field, output, (EconomicMap<String, Integer>)fieldNames);
            }
            for (SharedField field : staticFields) {
                HeapDumpFeature.encodeField(field, output, (EconomicMap<String, Integer>)fieldNames);
            }
        }
        output.patchS4((long)totalFieldCount, totalFieldCountOffset);
        output.patchS4((long)classCount, classCountOffset);
        output.patchS4((long)fieldNames.size(), fieldNameCountOffset);
        int index = 0;
        MapCursor mapCursor = fieldNames.getEntries();
        while (mapCursor.advance()) {
            assert ((Integer)mapCursor.getValue() == index);
            byte[] utf8 = ((String)mapCursor.getKey()).getBytes(StandardCharsets.UTF_8);
            output.putUV((long)utf8.length);
            for (byte b : utf8) {
                output.putS1((long)b);
            }
            ++index;
        }
    }

    private static ArrayList<SharedField> collectFields(ResolvedJavaField[] input) {
        ArrayList<SharedField> result = new ArrayList<SharedField>();
        for (ResolvedJavaField f : input) {
            SharedField field;
            if (!(f instanceof SharedField) || (field = (SharedField)f).getLocation() < 0) continue;
            result.add(field);
        }
        result.sort(Comparator.comparingInt(SharedField::getLocation));
        return result;
    }

    private static void encodeField(SharedField field, UnsafeArrayTypeWriter output, EconomicMap<String, Integer> fieldNames) {
        int location = field.getLocation();
        assert (location >= 0);
        output.putU1((long)HeapDumpFeature.getType(field).ordinal());
        output.putUV((long)HeapDumpFeature.addFieldName(field.getName(), fieldNames));
        output.putUV((long)location);
    }

    private static int addFieldName(String fieldName, EconomicMap<String, Integer> fieldNames) {
        Integer fieldNameIndex = (Integer)fieldNames.get((Object)fieldName);
        if (fieldNameIndex != null) {
            return fieldNameIndex;
        }
        int result = fieldNames.size();
        fieldNames.put((Object)fieldName, (Object)result);
        return result;
    }

    private static HProfType getType(SharedField field) {
        return switch (field.getStorageKind()) {
            case JavaKind.Object -> HProfType.NORMAL_OBJECT;
            case JavaKind.Boolean -> HProfType.BOOLEAN;
            case JavaKind.Char -> HProfType.CHAR;
            case JavaKind.Float -> HProfType.FLOAT;
            case JavaKind.Double -> HProfType.DOUBLE;
            case JavaKind.Byte -> HProfType.BYTE;
            case JavaKind.Short -> HProfType.SHORT;
            case JavaKind.Int -> HProfType.INT;
            case JavaKind.Long -> HProfType.LONG;
            default -> throw VMError.shouldNotReachHere("Unexpected storage kind.");
        };
    }
}

