/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.config;

import com.oracle.svm.core.TypeResult;
import com.oracle.svm.core.configure.ConfigurationTypeDescriptor;
import com.oracle.svm.core.configure.NamedConfigurationTypeDescriptor;
import com.oracle.svm.core.configure.ProxyConfigurationTypeDescriptor;
import com.oracle.svm.core.configure.ReflectionConfigurationParserDelegate;
import com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.config.JNIRegistryAdapter;
import com.oracle.svm.hosted.config.ReflectionRegistryAdapter;
import com.oracle.svm.util.ClassUtil;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.ReflectionRegistry;
import org.graalvm.nativeimage.impl.RuntimeJNIAccessSupport;
import org.graalvm.nativeimage.impl.RuntimeProxyCreationSupport;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;
import org.graalvm.nativeimage.impl.RuntimeSerializationSupport;

public class RegistryAdapter
implements ReflectionConfigurationParserDelegate<Class<?>> {
    protected final ReflectionRegistry registry;
    private final ImageClassLoader classLoader;

    public static RegistryAdapter create(ReflectionRegistry registry, RuntimeProxyCreationSupport proxySupport, RuntimeSerializationSupport serializationSupport, RuntimeJNIAccessSupport jniSupport, ImageClassLoader classLoader) {
        if (registry instanceof RuntimeReflectionSupport) {
            return new ReflectionRegistryAdapter((RuntimeReflectionSupport)registry, proxySupport, serializationSupport, jniSupport, classLoader);
        }
        if (registry instanceof RuntimeJNIAccessSupport) {
            return new JNIRegistryAdapter(registry, classLoader);
        }
        return new RegistryAdapter(registry, classLoader);
    }

    RegistryAdapter(ReflectionRegistry registry, ImageClassLoader classLoader) {
        this.registry = registry;
        this.classLoader = classLoader;
    }

    @Override
    public void registerType(ConfigurationCondition condition, Class<?> type) {
        this.registry.register(condition, new Class[]{type});
    }

    @Override
    public TypeResult<Class<?>> resolveType(ConfigurationCondition condition, ConfigurationTypeDescriptor typeDescriptor, boolean allowPrimitives) {
        switch (typeDescriptor.getDescriptorType()) {
            case NAMED: {
                NamedConfigurationTypeDescriptor namedDescriptor = (NamedConfigurationTypeDescriptor)typeDescriptor;
                return this.classLoader.findClass(namedDescriptor.name(), allowPrimitives);
            }
            case PROXY: {
                return this.resolveProxyType((ProxyConfigurationTypeDescriptor)typeDescriptor);
            }
        }
        throw VMError.shouldNotReachHere("Unknown type descriptor kind: %s", new Object[]{typeDescriptor.getDescriptorType()});
    }

    private TypeResult<Class<?>> resolveProxyType(ProxyConfigurationTypeDescriptor typeDescriptor) {
        String typeName = typeDescriptor.toString();
        List<TypeResult> interfaceResults = typeDescriptor.interfaceNames().stream().map(name -> {
            NamedConfigurationTypeDescriptor typeDescriptor1 = new NamedConfigurationTypeDescriptor((String)name);
            return this.classLoader.findClass(typeDescriptor1.name(), false);
        }).toList();
        ArrayList<Class> interfaces = new ArrayList<Class>();
        for (TypeResult intf : interfaceResults) {
            if (!intf.isPresent()) {
                return TypeResult.forException(typeName, intf.getException());
            }
            interfaces.add((Class)intf.get());
        }
        try {
            DynamicProxyRegistry proxyRegistry = (DynamicProxyRegistry)ImageSingletons.lookup(DynamicProxyRegistry.class);
            Class<?> proxyClass = proxyRegistry.getProxyClassHosted((Class[])interfaces.toArray(Class[]::new));
            return TypeResult.forType(typeName, proxyClass);
        }
        catch (Throwable t) {
            return TypeResult.forException(typeName, t);
        }
    }

    @Override
    public void registerPublicClasses(ConfigurationCondition condition, Class<?> type) {
    }

    @Override
    public void registerDeclaredClasses(ConfigurationCondition condition, Class<?> type) {
    }

    @Override
    public void registerRecordComponents(ConfigurationCondition condition, Class<?> type) {
    }

    @Override
    public void registerPermittedSubclasses(ConfigurationCondition condition, Class<?> type) {
    }

    @Override
    public void registerNestMembers(ConfigurationCondition condition, Class<?> type) {
    }

    @Override
    public void registerSigners(ConfigurationCondition condition, Class<?> type) {
    }

    @Override
    public void registerPublicFields(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        this.registry.register(condition, false, type.getFields());
    }

    @Override
    public void registerDeclaredFields(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        this.registry.register(condition, false, type.getDeclaredFields());
    }

    @Override
    public void registerPublicMethods(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        this.registry.register(condition, queriedOnly, (Executable[])type.getMethods());
    }

    @Override
    public void registerDeclaredMethods(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        this.registry.register(condition, queriedOnly, (Executable[])type.getDeclaredMethods());
    }

    @Override
    public void registerPublicConstructors(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        this.registry.register(condition, queriedOnly, (Executable[])type.getConstructors());
    }

    @Override
    public void registerDeclaredConstructors(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        this.registry.register(condition, queriedOnly, (Executable[])type.getDeclaredConstructors());
    }

    @Override
    public void registerField(ConfigurationCondition condition, Class<?> type, String fieldName, boolean allowWrite, boolean jniAccessible) throws NoSuchFieldException {
        this.registerField(condition, allowWrite, jniAccessible, type.getDeclaredField(fieldName));
    }

    protected void registerField(ConfigurationCondition condition, boolean allowWrite, boolean jniAccessible, Field field) {
        this.registry.register(condition, allowWrite, new Field[]{field});
    }

    @Override
    public boolean registerAllMethodsWithName(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type, String methodName) {
        Method[] methods;
        boolean found = false;
        for (Method method : methods = type.getDeclaredMethods()) {
            if (!((Executable)method).getName().equals(methodName)) continue;
            this.registerExecutable(condition, queriedOnly, jniAccessible, method);
            found = true;
        }
        return found;
    }

    @Override
    public boolean registerAllConstructors(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        Executable[] methods = type.getDeclaredConstructors();
        this.registerExecutable(condition, queriedOnly, jniAccessible, methods);
        return methods.length > 0;
    }

    @Override
    public void registerUnsafeAllocated(ConfigurationCondition condition, Class<?> type) {
        if (!(type.isArray() || type.isInterface() || Modifier.isAbstract(type.getModifiers()))) {
            this.registry.register(condition, true, type);
        }
    }

    @Override
    public void registerMethod(ConfigurationCondition condition, boolean queriedOnly, Class<?> type, String methodName, List<Class<?>> methodParameterTypes, boolean jniAccessible) throws NoSuchMethodException {
        Method method;
        Class<?>[] parameterTypesArray = RegistryAdapter.getParameterTypes(methodParameterTypes);
        try {
            method = type.getDeclaredMethod(methodName, parameterTypesArray);
        }
        catch (NoClassDefFoundError e) {
            try {
                method = type.getMethod(methodName, parameterTypesArray);
            }
            catch (Throwable ignored) {
                throw e;
            }
        }
        this.registerExecutable(condition, queriedOnly, jniAccessible, method);
    }

    @Override
    public void registerConstructor(ConfigurationCondition condition, boolean queriedOnly, Class<?> type, List<Class<?>> methodParameterTypes, boolean jniAccessible) throws NoSuchMethodException {
        Class<?>[] parameterTypesArray = RegistryAdapter.getParameterTypes(methodParameterTypes);
        this.registerExecutable(condition, queriedOnly, jniAccessible, type.getDeclaredConstructor(parameterTypesArray));
    }

    static Class<?>[] getParameterTypes(List<Class<?>> methodParameterTypes) {
        return (Class[])methodParameterTypes.toArray(Class[]::new);
    }

    protected void registerExecutable(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Executable ... executable) {
        this.registry.register(condition, queriedOnly, executable);
    }

    @Override
    public void registerAsSerializable(ConfigurationCondition condition, Class<?> clazz) {
    }

    @Override
    public void registerAsJniAccessed(ConfigurationCondition condition, Class<?> clazz) {
    }

    @Override
    public String getTypeName(Class<?> type) {
        return type.getTypeName();
    }

    @Override
    public String getSimpleName(Class<?> type) {
        return ClassUtil.getUnqualifiedName(type);
    }
}

