/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.Uninterruptible;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class VMError {
    public static final String msgShouldNotReachHere = "should not reach here";
    public static final String msgShouldNotReachHereSubstitution = "should not reach here: substitution reached at runtime";
    public static final String msgShouldNotReachHereUnexpectedInput = "should not reach here: unexpected input could not be handled";
    public static final String msgShouldNotReachHereOverrideInChild = "should not reach here: method should have been overridden in child";
    public static final String msgShouldNotReachHereAtRuntime = "should not reach here: this code is expected to be unreachable at runtime";
    public static final String msgShouldNotReachHereUnsupportedPlatform = "should not reach here: unsupported platform";
    public static final String msgUnimplemented = "unimplemented";
    public static final String msgUnimplementedIntentionally = "unimplemented: this method has intentionally not been implemented";

    public static RuntimeException shouldNotReachHere(String msg) {
        throw new HostedError(msg);
    }

    public static RuntimeException shouldNotReachHere(Throwable ex) {
        throw new HostedError(ex);
    }

    public static RuntimeException shouldNotReachHere(String msg, Throwable cause) {
        throw new HostedError(msg, cause);
    }

    public static RuntimeException shouldNotReachHereSubstitution() {
        throw new HostedError(msgShouldNotReachHereSubstitution);
    }

    public static RuntimeException shouldNotReachHereUnexpectedInput(Object input) {
        throw new HostedError("should not reach here: unexpected input could not be handled: " + input);
    }

    public static RuntimeException shouldNotReachHereOverrideInChild() {
        throw new HostedError(msgShouldNotReachHereOverrideInChild);
    }

    public static RuntimeException shouldNotReachHereAtRuntime() {
        throw new HostedError(msgShouldNotReachHereAtRuntime);
    }

    public static RuntimeException unsupportedPlatform() {
        throw VMError.shouldNotReachHere(msgShouldNotReachHereUnsupportedPlatform);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void guarantee(boolean condition) {
        if (!condition) {
            throw VMError.shouldNotReachHere("guarantee failed");
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void guarantee(boolean condition, String msg) {
        if (!condition) {
            throw VMError.shouldNotReachHere(msg);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static RuntimeException shouldNotReachHere(String msg, Object ... args) {
        throw VMError.shouldNotReachHere(String.format(msg, VMError.formatArguments(args)));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void guarantee(boolean condition, String msg, Object arg1) {
        if (!condition) {
            throw VMError.shouldNotReachHere(msg, arg1);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void guarantee(boolean condition, String msg, Object arg1, Object arg2) {
        if (!condition) {
            throw VMError.shouldNotReachHere(msg, arg1, arg2);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void guarantee(boolean condition, String msg, Object arg1, Object arg2, Object arg3) {
        if (!condition) {
            throw VMError.shouldNotReachHere(msg, arg1, arg2, arg3);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void guarantee(boolean condition, String msg, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (!condition) {
            throw VMError.shouldNotReachHere(msg, arg1, arg2, arg3, arg4);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void guarantee(boolean condition, String msg, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (!condition) {
            throw VMError.shouldNotReachHere(msg, arg1, arg2, arg3, arg4, arg5);
        }
    }

    public static RuntimeException unimplemented(String msg) {
        throw new UnsupportedOperationException(msg);
    }

    public static RuntimeException intentionallyUnimplemented() {
        throw new UnsupportedOperationException(msgUnimplementedIntentionally);
    }

    public static RuntimeException unsupportedFeature(String msg) {
        throw new HostedError("UNSUPPORTED FEATURE: " + msg);
    }

    public static boolean hostedError(Throwable t) {
        return t instanceof HostedError;
    }

    static Object[] formatArguments(Object ... args) {
        Object[] newArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            newArgs[i] = arg instanceof ResolvedJavaType ? ((ResolvedJavaType)arg).toJavaName(true) : (arg instanceof ResolvedJavaMethod ? ((ResolvedJavaMethod)arg).format("%H.%n(%p)") : (arg instanceof ResolvedJavaField ? ((ResolvedJavaField)arg).format("%H.%n") : arg));
        }
        return newArgs;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static final class HostedError
    extends Error {
        private static final long serialVersionUID = 1574347086891451263L;

        HostedError(String msg) {
            super(msg);
        }

        HostedError(Throwable ex) {
            super(ex);
        }

        HostedError(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

