/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.methodhandles;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.invoke.MethodHandleUtils;
import com.oracle.svm.core.invoke.Target_java_lang_invoke_MemberName;
import com.oracle.svm.core.methodhandles.Target_java_lang_invoke_MethodHandle;
import com.oracle.svm.core.methodhandles.Target_java_lang_invoke_MethodHandleNatives_Constants;
import com.oracle.svm.core.methodhandles.Util_java_lang_invoke_MethodHandleNatives;
import com.oracle.svm.core.reflect.SubstrateMethodAccessor;
import com.oracle.svm.core.reflect.target.Target_java_lang_reflect_AccessibleObject;
import com.oracle.svm.core.reflect.target.Target_java_lang_reflect_Method;
import com.oracle.svm.core.reflect.target.Target_jdk_internal_reflect_MethodAccessor;
import com.oracle.svm.core.util.VMError;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.Wrapper;

final class Util_java_lang_invoke_MethodHandle {
    Util_java_lang_invoke_MethodHandle() {
    }

    static Object linkTo(boolean hasReceiver, Object ... args) throws Throwable {
        assert (args.length > 0);
        Target_java_lang_invoke_MemberName memberName = (Target_java_lang_invoke_MemberName)args[args.length - 1];
        MethodType methodType = memberName.getMethodType();
        if (hasReceiver) {
            methodType = methodType.insertParameterTypes(0, memberName.getDeclaringClass());
        }
        return MethodHandleUtils.cast(Util_java_lang_invoke_MethodHandle.invokeInternal(memberName, methodType, Arrays.copyOf(args, args.length - 1)), methodType.returnType());
    }

    static Object invokeInternal(Target_java_lang_invoke_MemberName memberName, MethodType methodType, Object ... args) throws Throwable {
        Object srcWrapper;
        if (memberName.reflectAccess == null && memberName.intrinsic == null) {
            Util_java_lang_invoke_MethodHandleNatives.resolve(memberName, null, false);
        }
        if (memberName.intrinsic != null) {
            assert (memberName.reflectAccess == null);
            return memberName.intrinsic.execute(args);
        }
        if (memberName.isField()) {
            Target_java_lang_reflect_AccessibleObject executable = SubstrateUtil.cast(memberName.reflectAccess, Target_java_lang_reflect_AccessibleObject.class);
            boolean oldOverride = executable.override;
            executable.override = true;
            try {
                Field field = (Field)memberName.reflectAccess;
                byte refKind = memberName.getReferenceKind();
                if (Modifier.isStatic(field.getModifiers())) {
                    if (refKind == Target_java_lang_invoke_MethodHandleNatives_Constants.REF_getStatic) {
                        assert ((args == null || args.length == 0) && field.canAccess(null));
                        Object object = field.get(null);
                        return object;
                    }
                    if (refKind == Target_java_lang_invoke_MethodHandleNatives_Constants.REF_putStatic) {
                        assert (args.length == 1 && field.canAccess(null));
                        Object value = args[0];
                        field.set(null, value);
                        Object var8_19 = null;
                        return var8_19;
                    }
                    throw VMError.shouldNotReachHere("Wrong reference kind for static field access: " + memberName.getReferenceKind());
                }
                if (refKind == Target_java_lang_invoke_MethodHandleNatives_Constants.REF_getField) {
                    assert (args.length == 1 && field.canAccess(args[0]));
                    Object receiver = args[0];
                    Object object = field.get(receiver);
                    return object;
                }
                if (refKind == Target_java_lang_invoke_MethodHandleNatives_Constants.REF_putField) {
                    assert (args.length == 2 && field.canAccess(args[0]));
                    Object receiver = args[0];
                    Object value = args[1];
                    field.set(receiver, value);
                    Object var9_24 = null;
                    return var9_24;
                }
                throw VMError.shouldNotReachHere("Wrong reference kind for instance field access: " + memberName.getReferenceKind());
            }
            finally {
                executable.override = oldOverride;
            }
        }
        assert (args.length == methodType.parameterCount());
        for (int i = 0; i < args.length; ++i) {
            Wrapper destWrapper;
            TypeDescriptor.OfField expectedParamType = methodType.parameterType(i);
            if (!((Class)expectedParamType).isPrimitive() || (destWrapper = Wrapper.forPrimitiveType(expectedParamType)) == (srcWrapper = Wrapper.forWrapperType(args[i].getClass()))) continue;
            Target_java_lang_invoke_MethodHandle typeConverter = SubstrateUtil.cast(ValueConversions.convertPrimitive(srcWrapper, destWrapper), Target_java_lang_invoke_MethodHandle.class);
            args[i] = typeConverter.invokeBasic(args[i]);
        }
        Target_java_lang_reflect_AccessibleObject executable = SubstrateUtil.cast(memberName.reflectAccess, Target_java_lang_reflect_AccessibleObject.class);
        boolean oldOverride = executable.override;
        executable.override = true;
        try {
            if (memberName.isConstructor()) {
                Constructor constructor = (Constructor)memberName.reflectAccess;
                assert (constructor.canAccess(null));
                srcWrapper = constructor.newInstance(args);
                return srcWrapper;
            }
            Method method = (Method)memberName.reflectAccess;
            if (Modifier.isStatic(method.getModifiers())) {
                assert (method.canAccess(null));
                srcWrapper = method.invoke(null, args);
                return srcWrapper;
            }
            assert (method.canAccess(args[0]));
            Object receiver = args[0];
            Object[] invokeArgs = Arrays.copyOfRange(args, 1, args.length);
            if (memberName.getReferenceKind() == Target_java_lang_invoke_MethodHandleNatives_Constants.REF_invokeSpecial) {
                Target_jdk_internal_reflect_MethodAccessor accessor = SubstrateUtil.cast(method, Target_java_lang_reflect_Method.class).acquireMethodAccessor();
                Object object = SubstrateUtil.cast(accessor, SubstrateMethodAccessor.class).invokeSpecial(receiver, invokeArgs);
                return object;
            }
            Object object = method.invoke(receiver, invokeArgs);
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        finally {
            executable.override = oldOverride;
        }
    }
}

