/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jni.access;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jni.CallVariant;
import com.oracle.svm.core.jni.access.JNIAccessibleClass;
import com.oracle.svm.core.jni.access.JNIAccessibleMember;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Modifier;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.word.BarrieredAccess;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.PointerBase;

public final class JNIAccessibleMethod
extends JNIAccessibleMember {
    public static final int STATICALLY_BOUND_METHOD = -1;
    public static final int VTABLE_OFFSET_NOT_YET_COMPUTED = -2;
    public static final int NEW_OBJECT_INVALID_FOR_ABSTRACT_TYPE = -1;
    private final int modifiers;
    private int vtableOffset = -2;
    private CodePointer nonvirtualTarget;
    private PointerBase newObjectTarget;
    private CodePointer callWrapper;
    private CodePointer varargsWrapper;
    private CodePointer arrayWrapper;
    private CodePointer valistWrapper;
    private CodePointer varargsNonvirtualWrapper;
    private CodePointer arrayNonvirtualWrapper;
    private CodePointer valistNonvirtualWrapper;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static ResolvedJavaField getCallVariantWrapperField(MetaAccessProvider metaAccess, CallVariant variant, boolean nonVirtual) {
        StringBuilder name = new StringBuilder(32);
        if (variant == CallVariant.VARARGS) {
            name.append("varargs");
        } else if (variant == CallVariant.ARRAY) {
            name.append("array");
        } else if (variant == CallVariant.VA_LIST) {
            name.append("valist");
        } else {
            throw VMError.shouldNotReachHereUnexpectedInput((Object)variant);
        }
        if (nonVirtual) {
            name.append("Nonvirtual");
        }
        name.append("Wrapper");
        return metaAccess.lookupJavaField(ReflectionUtil.lookupField(JNIAccessibleMethod.class, (String)name.toString()));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JNIAccessibleMethod(JNIAccessibleClass declaringClass, int modifiers) {
        super(declaringClass);
        this.modifiers = modifiers;
    }

    @AlwaysInline(value="Work around an issue with the LLVM backend with which the return value was accessed incorrectly.")
    @Uninterruptible(reason="Must not throw any exceptions.", callerMustBe=true)
    CodePointer getCallWrapperAddress() {
        return this.callWrapper;
    }

    @AlwaysInline(value="Work around an issue with the LLVM backend with which the return value was accessed incorrectly.")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    CodePointer getJavaCallAddress(Object instance, boolean nonVirtual) {
        if (!nonVirtual) {
            assert (this.vtableOffset != -2);
            if (this.vtableOffset != -1) {
                return (CodePointer)BarrieredAccess.readWord(instance.getClass(), (int)this.vtableOffset, (LocationIdentity)NamedLocationIdentity.FINAL_LOCATION);
            }
        }
        return this.nonvirtualTarget;
    }

    PointerBase getNewObjectAddress() {
        return this.newObjectTarget;
    }

    Class<?> getDeclaringClassObject() {
        return this.getDeclaringClass().getClassObject();
    }

    boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void finishBeforeCompilation(EconomicSet<Class<?>> hidingSubclasses, int vtableEntryOffset, CodePointer nonvirtualEntry, PointerBase newObjectEntry, CodePointer callWrapperEntry, CodePointer varargs, CodePointer array, CodePointer valist, CodePointer varargsNonvirtual, CodePointer arrayNonvirtual, CodePointer valistNonvirtual) {
        assert (this.vtableOffset == -2 && (vtableEntryOffset == -1 || vtableEntryOffset >= 0));
        this.vtableOffset = vtableEntryOffset;
        this.nonvirtualTarget = nonvirtualEntry;
        this.newObjectTarget = newObjectEntry;
        this.callWrapper = callWrapperEntry;
        this.varargsWrapper = varargs;
        this.arrayWrapper = array;
        this.valistWrapper = valist;
        this.varargsNonvirtualWrapper = varargsNonvirtual;
        this.arrayNonvirtualWrapper = arrayNonvirtual;
        this.valistNonvirtualWrapper = valistNonvirtual;
        this.setHidingSubclasses(hidingSubclasses);
    }
}

