/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jni;

import com.oracle.svm.core.handles.PrimitiveArrayView;
import com.oracle.svm.core.jni.headers.JNIMode;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import org.graalvm.word.PointerBase;

public class JNIThreadLocalPrimitiveArrayViews {
    private static final FastThreadLocalObject<ReferencedArrayListNode> referencedArraysListHead = FastThreadLocalFactory.createObject(ReferencedArrayListNode.class, "JNIThreadLocalPrimitiveArrayViews.referencedArraysListHead");

    public static PrimitiveArrayView createArrayView(Object array) {
        PrimitiveArrayView ref = PrimitiveArrayView.createForReading(array);
        referencedArraysListHead.set(new ReferencedArrayListNode(ref, referencedArraysListHead.get()));
        return ref;
    }

    public static <T extends PointerBase> T createArrayViewAndGetAddress(Object array) {
        return JNIThreadLocalPrimitiveArrayViews.createArrayView(array).addressOfArrayElement(0);
    }

    public static void destroyNewestArrayViewByAddress(PointerBase address, int mode) {
        ReferencedArrayListNode previous = null;
        ReferencedArrayListNode current = referencedArraysListHead.get();
        while (current != null) {
            if (current.array.addressOfArrayElement(0) == address) {
                if (previous != null) {
                    previous.next = current.next;
                } else {
                    referencedArraysListHead.set(current.next);
                }
                if (mode == 0 || mode == JNIMode.JNI_COMMIT()) {
                    current.array.syncToHeap();
                }
                if (mode == 0 || mode == JNIMode.JNI_ABORT()) {
                    current.array.close();
                } else {
                    current.array.untrack();
                }
                return;
            }
            previous = current;
            current = current.next;
        }
    }

    static int getCount() {
        int count = 0;
        ReferencedArrayListNode node = referencedArraysListHead.get();
        while (node != null) {
            ++count;
            node = node.next;
        }
        return count;
    }

    private static class ReferencedArrayListNode {
        final PrimitiveArrayView array;
        ReferencedArrayListNode next;

        ReferencedArrayListNode(PrimitiveArrayView array, ReferencedArrayListNode next) {
            this.array = array;
            this.next = next;
        }
    }
}

