/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.jdk.Target_sun_nio_fs_UnixFileSystem;
import com.oracle.svm.core.jdk.Target_sun_nio_fs_UnixPath;
import jdk.internal.util.StaticProperty;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
class UnixFileSystemAccessors {
    UnixFileSystemAccessors() {
    }

    static byte[] getDefaultDirectory(Target_sun_nio_fs_UnixFileSystem that) {
        if (that.needsReinitialization != 0) {
            UnixFileSystemAccessors.reinitialize(that);
        }
        return that.injectedDefaultDirectory;
    }

    static boolean getNeedToResolveAgainstDefaultDirectory(Target_sun_nio_fs_UnixFileSystem that) {
        if (that.needsReinitialization != 0) {
            UnixFileSystemAccessors.reinitialize(that);
        }
        return that.injectedNeedToResolveAgainstDefaultDirectory;
    }

    static Target_sun_nio_fs_UnixPath getRootDirectory(Target_sun_nio_fs_UnixFileSystem that) {
        if (that.needsReinitialization != 0) {
            UnixFileSystemAccessors.reinitialize(that);
        }
        return that.injectedRootDirectory;
    }

    static void setDefaultDirectory(Target_sun_nio_fs_UnixFileSystem that, byte[] value) {
        that.injectedDefaultDirectory = value;
    }

    static void setNeedToResolveAgainstDefaultDirectory(Target_sun_nio_fs_UnixFileSystem that, boolean value) {
        that.injectedNeedToResolveAgainstDefaultDirectory = value;
    }

    static void setRootDirectory(Target_sun_nio_fs_UnixFileSystem that, Target_sun_nio_fs_UnixPath value) {
        that.injectedRootDirectory = value;
    }

    private static synchronized void reinitialize(Target_sun_nio_fs_UnixFileSystem that) {
        if (that.needsReinitialization != 2) {
            return;
        }
        that.needsReinitialization = 1;
        that.originalConstructor(that.provider, StaticProperty.userDir());
        that.needsReinitialization = 0;
    }
}

