/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.jdk.Target_java_io_ObjectStreamClass_Caches;
import com.oracle.svm.core.reflect.serialize.MissingSerializationRegistrationUtils;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.graalvm.compiler.java.LambdaUtils;

@TargetClass(value=ObjectStreamClass.class)
final class Target_java_io_ObjectStreamClass {
    Target_java_io_ObjectStreamClass() {
    }

    @Substitute
    private static boolean hasStaticInitializer(Class<?> cl) {
        return DynamicHub.fromClass(cl).getClassInitializationInfo().hasInitializer();
    }

    @Substitute
    static ObjectStreamClass lookup(Class<?> cl, boolean all) {
        if (!all && !Serializable.class.isAssignableFrom(cl)) {
            return null;
        }
        if (Serializable.class.isAssignableFrom(cl) && !DynamicHub.fromClass(cl).isRegisteredForSerialization()) {
            boolean isLambda = cl.getTypeName().contains(LambdaUtils.LAMBDA_CLASS_NAME_SUBSTRING);
            boolean isProxy = Proxy.isProxyClass(cl);
            if (isProxy || isLambda) {
                String interfaceList = Arrays.stream(cl.getInterfaces()).map(Class::getTypeName).collect(Collectors.joining(", ", "[", "]"));
                if (isProxy) {
                    MissingSerializationRegistrationUtils.missingSerializationRegistration(cl, "proxy type implementing interfaces: " + interfaceList);
                } else {
                    MissingSerializationRegistrationUtils.missingSerializationRegistration(cl, "lambda declared in: " + LambdaUtils.capturingClass((String)cl.getTypeName()), "extending interfaces: " + interfaceList);
                }
            } else {
                MissingSerializationRegistrationUtils.missingSerializationRegistration(cl, "type " + cl.getTypeName());
            }
        }
        return Target_java_io_ObjectStreamClass_Caches.localDescs0.get(cl);
    }
}

