/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.configure.ResourcesRegistry;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import java.util.Optional;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;

@AutomaticallyRegisteredFeature
class SimpleWebServerFeature
implements InternalFeature {
    SimpleWebServerFeature() {
    }

    private static Optional<Module> requiredModule() {
        return ModuleLayer.boot().findModule("jdk.httpserver");
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return JavaVersionUtil.JAVA_SPEC >= 19 && SimpleWebServerFeature.requiredModule().isPresent();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        SimpleWebServerFeature.class.getModule().addReads(SimpleWebServerFeature.requiredModule().get());
        RuntimeClassInitializationSupport rci = (RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class);
        rci.initializeAtRunTime("sun.net.httpserver.simpleserver", "Allocates InetAddress in class initializers");
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        access.registerReachabilityHandler(a -> ((ResourcesRegistry)ImageSingletons.lookup(ResourcesRegistry.class)).addResourceBundles(ConfigurationCondition.alwaysTrue(), "sun.net.httpserver.simpleserver.resources.simpleserver"), new Object[]{access.findClassByName("sun.net.httpserver.simpleserver.SimpleFileServerImpl")});
    }
}

