/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.heap.PhysicalMemory;

final class DirectMemoryAccessors {
    private static final long DIRECT_MEMORY_DURING_INITIALIZATION = 0x1900000L;
    private static volatile boolean initialized;
    private static long directMemory;

    DirectMemoryAccessors() {
    }

    static long getDirectMemory() {
        if (!initialized) {
            return DirectMemoryAccessors.tryInitialize();
        }
        return directMemory;
    }

    private static long tryInitialize() {
        long newDirectMemory = SubstrateOptions.MaxDirectMemorySize.getValue();
        if (newDirectMemory == 0L) {
            if (PhysicalMemory.isInitializationInProgress()) {
                return 0x1900000L;
            }
            newDirectMemory = Runtime.getRuntime().maxMemory();
        }
        directMemory = newDirectMemory;
        initialized = true;
        return newDirectMemory;
    }
}

