/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.DynamicHubCompanion;
import com.oracle.svm.core.hub.Target_java_lang_Class_AnnotationData;
import com.oracle.svm.core.hub.Target_java_lang_Class_ReflectionData;
import java.lang.ref.SoftReference;
import jdk.internal.misc.Unsafe;
import sun.reflect.annotation.AnnotationType;

@TargetClass(className="java.lang.Class", innerClass={"Atomic"})
final class Target_java_lang_Class_Atomic {
    @Delete
    static Unsafe unsafe;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FieldOffset, declClass=DynamicHubCompanion.class, name="reflectionData")
    private static long reflectionDataOffset;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FieldOffset, declClass=DynamicHubCompanion.class, name="annotationType")
    private static long annotationTypeOffset;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FieldOffset, declClass=DynamicHubCompanion.class, name="annotationData")
    private static long annotationDataOffset;

    Target_java_lang_Class_Atomic() {
    }

    @Substitute
    static <T> boolean casReflectionData(DynamicHub clazz, SoftReference<Target_java_lang_Class_ReflectionData<T>> oldData, SoftReference<Target_java_lang_Class_ReflectionData<T>> newData) {
        return Unsafe.getUnsafe().compareAndSetReference(clazz.getCompanion(), reflectionDataOffset, oldData, newData);
    }

    @Substitute
    static boolean casAnnotationType(DynamicHub clazz, AnnotationType oldType, AnnotationType newType) {
        return Unsafe.getUnsafe().compareAndSetReference(clazz.getCompanion(), annotationTypeOffset, oldType, newType);
    }

    @Substitute
    static boolean casAnnotationData(DynamicHub clazz, Target_java_lang_Class_AnnotationData oldData, Target_java_lang_Class_AnnotationData newData) {
        return Unsafe.getUnsafe().compareAndSetReference(clazz.getCompanion(), annotationDataOffset, oldData, newData);
    }
}

