/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.code.RuntimeCodeInfoMemory;
import com.oracle.svm.core.heap.AbstractMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import javax.management.ObjectName;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import sun.management.Util;

public abstract class AbstractMemoryMXBean
extends AbstractMXBean
implements MemoryMXBean {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public AbstractMemoryMXBean() {
    }

    @Override
    public ObjectName getObjectName() {
        return Util.newObjectName("java.lang:type=Memory");
    }

    @Override
    public int getObjectPendingFinalizationCount() {
        return 0;
    }

    @Override
    public MemoryUsage getNonHeapMemoryUsage() {
        RuntimeCodeInfoMemory.SizeCounters counters = RuntimeCodeInfoMemory.singleton().getSizeCounters();
        long used = counters.totalSize().rawValue();
        return new MemoryUsage(-1L, used, used, -1L);
    }

    @Override
    public boolean isVerbose() {
        return SubstrateGCOptions.PrintGC.getValue();
    }

    @Override
    public void setVerbose(boolean value) {
        SubstrateGCOptions.PrintGC.update(value);
    }

    @Override
    public void gc() {
        System.gc();
    }
}

