/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.meta;

import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.word.WordTypes;

public class SubstrateSnippetReflectionProvider
implements SnippetReflectionProvider {
    private WordTypes wordTypes;

    public SubstrateSnippetReflectionProvider(WordTypes wordTypes) {
        this.wordTypes = wordTypes;
    }

    public JavaConstant forObject(Object object) {
        return SubstrateObjectConstant.forObject(object);
    }

    public <T> T asObject(Class<T> type, JavaConstant constant) {
        return SubstrateObjectConstant.asObject(type, constant);
    }

    public JavaConstant forBoxed(JavaKind kind, Object value) {
        return SubstrateObjectConstant.forBoxedValue(kind, value);
    }

    public <T> T getInjectedNodeIntrinsicParameter(Class<T> type) {
        if (type.isAssignableFrom(WordTypes.class)) {
            return type.cast(this.wordTypes);
        }
        return null;
    }

    public Class<?> originalClass(ResolvedJavaType type) {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    public Executable originalMethod(ResolvedJavaMethod method) {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    public Field originalField(ResolvedJavaField field) {
        throw VMError.shouldNotReachHereAtRuntime();
    }
}

