/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.code;

import java.util.Objects;
import jdk.vm.ci.code.Register;

public final class AssignedLocation {
    private static final int NONE = -1;
    private static final AssignedLocation PLACEHOLDER = new AssignedLocation();
    private final Register register;
    private final int stackOffset;

    private static boolean isValidOffset(int i) {
        return i >= 0 || i == -1;
    }

    private void checkClassInvariant() {
        if (!AssignedLocation.isValidOffset(this.stackOffset)) {
            throw new IllegalStateException("Stack offset cannot be < 0 (and not NONE).");
        }
        if (this.assignsToStack() == this.assignsToRegister()) {
            throw new IllegalStateException("Cannot assign to both register and stack.");
        }
    }

    private AssignedLocation() {
        this.register = null;
        this.stackOffset = -1;
    }

    private AssignedLocation(Register register, int stackOffset) {
        this.register = register;
        this.stackOffset = stackOffset;
        this.checkClassInvariant();
    }

    public static AssignedLocation placeholder() {
        return PLACEHOLDER;
    }

    public static AssignedLocation forRegister(Register register) {
        return new AssignedLocation(register, -1);
    }

    public static AssignedLocation forStack(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("Stack offset must be >= 0");
        }
        return new AssignedLocation(null, offset);
    }

    public boolean isPlaceholder() {
        return !this.assignsToRegister() && !this.assignsToStack();
    }

    public boolean assignsToRegister() {
        return this.register != null;
    }

    public boolean assignsToStack() {
        return this.stackOffset >= 0;
    }

    public Register register() {
        if (this.register == null) {
            throw new IllegalStateException("Not a register assignment.");
        }
        return this.register;
    }

    public int stackOffset() {
        if (this.stackOffset == -1) {
            throw new IllegalStateException("Not a stack assignment.");
        }
        return this.stackOffset;
    }

    public String toString() {
        if (this.assignsToRegister()) {
            return "r-" + this.register;
        }
        if (this.assignsToStack()) {
            return "s-" + this.stackOffset;
        }
        return "p";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssignedLocation that = (AssignedLocation)o;
        return this.stackOffset == that.stackOffset && Objects.equals(this.register, that.register);
    }

    public int hashCode() {
        return Objects.hash(this.register, this.stackOffset);
    }
}

