/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.configure.ConfigurationConditionResolver;
import com.oracle.svm.core.configure.ResourceConfigurationParser;
import com.oracle.svm.core.configure.ResourcesRegistry;
import java.net.URI;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

final class ResourceMetadataParser
extends ResourceConfigurationParser {
    ResourceMetadataParser(ConfigurationConditionResolver conditionResolver, ResourcesRegistry registry, boolean strictConfiguration) {
        super(conditionResolver, registry, strictConfiguration);
    }

    @Override
    public void parseAndRegister(Object json, URI origin) {
        Object bundlesJson;
        Object resourcesJson = this.getFromGlobalFile(json, "resources");
        if (resourcesJson != null) {
            List<Object> globsAndBundles = ResourceMetadataParser.asList(resourcesJson, "'resources' section must be a list of glob pattern or bundle descriptors");
            for (Object object : globsAndBundles) {
                EconomicMap<String, Object> globOrBundle = ResourceMetadataParser.asMap(object, "Elements of 'resources' list must be glob pattern or bundle descriptor objects");
                if (globOrBundle.containsKey((Object)"glob")) {
                    this.parseGlobEntry(object, (condition, module, resource) -> this.registry.addResources((ConfigurationCondition)condition, ResourceMetadataParser.globToRegex(module, resource)));
                    continue;
                }
                if (!globOrBundle.containsKey((Object)"bundle")) continue;
                this.parseBundle(globOrBundle, true);
            }
        }
        if ((bundlesJson = this.getFromGlobalFile(json, "bundles")) != null) {
            this.parseBundlesObject(bundlesJson);
        }
    }

    @Override
    protected ConfigurationCondition parseCondition(EconomicMap<String, Object> data) {
        return this.parseCondition(data, true);
    }
}

