/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.codegen;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.DirectivesExtension;
import com.oracle.svm.hosted.c.codegen.CSourceCodeWriter;
import com.oracle.svm.hosted.c.info.ConstantInfo;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.EnumConstantInfo;
import com.oracle.svm.hosted.c.info.InfoTreeVisitor;
import com.oracle.svm.hosted.c.info.NativeCodeInfo;
import com.oracle.svm.hosted.c.info.PointerToInfo;
import com.oracle.svm.hosted.c.info.RawPointerToInfo;
import com.oracle.svm.hosted.c.info.RawStructureInfo;
import com.oracle.svm.hosted.c.info.SizableInfo;
import com.oracle.svm.hosted.c.info.StructBitfieldInfo;
import com.oracle.svm.hosted.c.info.StructFieldInfo;
import com.oracle.svm.hosted.c.info.StructInfo;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.c.CContext;

public class QueryCodeWriter
extends InfoTreeVisitor {
    private static final String formatFloat = "%.15e";
    private static final String formatString = "$%s$";
    private final CSourceCodeWriter writer;
    private final List<Object> elementForLineNumber;
    private final boolean isWindows;
    private final String formatSInt64;
    private final String formatUInt64;
    private final String formatUInt64Hex;
    private final String uInt64;
    private final String sInt64;

    public QueryCodeWriter(Path tempDirectory) {
        this.writer = new CSourceCodeWriter(tempDirectory);
        this.elementForLineNumber = new ArrayList<Object>();
        this.isWindows = Platform.includedIn(Platform.WINDOWS.class);
        String formatL64 = "%" + (this.isWindows ? "ll" : "l");
        this.formatSInt64 = formatL64 + "d";
        this.formatUInt64 = formatL64 + "u";
        this.formatUInt64Hex = formatL64 + "X";
        this.uInt64 = QueryCodeWriter.int64(this.isWindows, true);
        this.sInt64 = QueryCodeWriter.int64(this.isWindows, false);
    }

    private static String int64(boolean isWindows, boolean unsigned) {
        return (unsigned ? "unsigned " : "") + (isWindows ? "long long" : "long");
    }

    public Path write(NativeCodeInfo nativeCodeInfo) {
        nativeCodeInfo.accept(this);
        String srcFileExtension = ".c";
        String sourceFileName = nativeCodeInfo.getName().replaceAll("\\W", "_") + srcFileExtension;
        return this.writer.writeFile(sourceFileName);
    }

    public Object getElementForLineNumber(int lineNumber) {
        int index = lineNumber - 1;
        if (index >= 0 && index < this.elementForLineNumber.size()) {
            return this.elementForLineNumber.get(index);
        }
        return null;
    }

    public String getLine(int lineNumber) {
        return this.writer.getLine(lineNumber);
    }

    @Override
    protected void visitNativeCodeInfo(NativeCodeInfo nativeCodeInfo) {
        List headerFiles;
        List<String> headerSnippet;
        CContext.Directives directives = nativeCodeInfo.getDirectives();
        List macroDefinitions = directives.getMacroDefinitions();
        if (!macroDefinitions.isEmpty()) {
            macroDefinitions.forEach(this.writer::appendMacroDefinition);
            this.writer.appendln();
        }
        this.writer.includeFiles(Arrays.asList("<stdio.h>", "<stddef.h>", "<memory.h>"));
        this.writer.writeCStandardHeaders();
        this.writer.appendln();
        if (this.isWindows) {
            this.writer.appendln("#ifndef bool");
            this.writer.appendln("#define bool char");
            this.writer.appendln("#define false ((bool)0)");
            this.writer.appendln("#define true  ((bool)1)");
            this.writer.appendln("#endif");
            this.writer.appendln("");
        }
        if (directives instanceof DirectivesExtension && !(headerSnippet = ((DirectivesExtension)directives).getHeaderSnippet()).isEmpty()) {
            headerSnippet.forEach(this.writer::appendln);
            this.writer.appendln();
        }
        if (!(headerFiles = directives.getHeaderFiles()).isEmpty()) {
            this.writer.includeFiles(headerFiles);
            this.writer.appendln();
        }
        String functionName = nativeCodeInfo.getName().replaceAll("\\W", "_");
        this.writer.appendln("int " + functionName + "() {");
        this.writer.indent();
        this.processChildren(nativeCodeInfo);
        this.writer.indents().appendln("return 0;");
        this.writer.outdent();
        this.writer.appendln("}");
        this.writer.appendln();
        this.writer.appendln("int main(void) {");
        this.writer.indent();
        this.writer.indents().appendln("return " + functionName + "();");
        this.writer.outdent();
        this.writer.appendln("}");
    }

    @Override
    protected void visitConstantInfo(ConstantInfo constantInfo) {
        switch (constantInfo.getKind()) {
            case INTEGER: {
                this.printUnsignedLong(constantInfo.getSizeInfo(), QueryCodeWriter.sizeOf(constantInfo));
                this.printIsUnsigned(constantInfo.getSignednessInfo(), QueryCodeWriter.isConstUnsigned(constantInfo.getName()));
                this.printLongHex(constantInfo.getValueInfo(), constantInfo.getName());
                break;
            }
            case POINTER: {
                this.printUnsignedLong(constantInfo.getSizeInfo(), QueryCodeWriter.sizeOf(constantInfo));
                this.printLongHex(constantInfo.getValueInfo(), constantInfo.getName());
                break;
            }
            case FLOAT: {
                this.printUnsignedLong(constantInfo.getSizeInfo(), QueryCodeWriter.sizeOf(constantInfo));
                this.printFloat(constantInfo.getValueInfo(), constantInfo.getName());
                break;
            }
            case BYTEARRAY: 
            case STRING: {
                this.printString(constantInfo.getValueInfo(), constantInfo.getName());
                break;
            }
            default: {
                throw VMError.shouldNotReachHereUnexpectedInput((Object)constantInfo.getKind());
            }
        }
    }

    @Override
    protected void visitStructInfo(StructInfo structInfo) {
        if (!structInfo.isIncomplete()) {
            this.printUnsignedLong(structInfo.getSizeInfo(), QueryCodeWriter.sizeOf(structInfo));
        }
        this.processChildren(structInfo);
    }

    @Override
    protected void visitRawStructureInfo(RawStructureInfo info) {
    }

    @Override
    protected void visitStructFieldInfo(StructFieldInfo fieldInfo) {
        this.printUnsignedLong(fieldInfo.getSizeInfo(), QueryCodeWriter.sizeOfField(fieldInfo));
        this.printUnsignedLong(fieldInfo.getOffsetInfo(), QueryCodeWriter.offsetOfField(fieldInfo));
        if (fieldInfo.getKind() == SizableInfo.ElementKind.INTEGER) {
            this.registerElementForCurrentLine(fieldInfo.getParent().getAnnotatedElement());
            this.writer.indents().appendln("{");
            this.writer.indent();
            this.writer.indents().appendln("int is_unsigned;");
            this.writer.indents().appendln(this.uInt64 + " all_bits_set = -1;");
            this.writer.indents().appendln(fieldInfo.getParent().getName() + " fieldHolder;");
            this.writer.indents().appendln("memset(&fieldHolder, 0x0, sizeof(fieldHolder));");
            this.writer.indents().appendln("fieldHolder." + fieldInfo.getName() + " = all_bits_set;");
            this.writer.indents().appendln("is_unsigned = fieldHolder." + fieldInfo.getName() + " > 0;");
            this.printIsUnsigned(fieldInfo.getSignednessInfo(), "is_unsigned");
            this.writer.outdent();
            this.writer.indents().appendln("}");
        }
    }

    @Override
    protected void visitStructBitfieldInfo(StructBitfieldInfo bitfieldInfo) {
        String structName = bitfieldInfo.getParent().getName();
        String bitfieldName = bitfieldInfo.getName();
        this.writer.indents().appendln("{");
        this.writer.indent();
        this.writer.indents().appendln("struct _w {");
        this.registerElementForCurrentLine(bitfieldInfo.getParent().getAnnotatedElement());
        this.writer.indents().appendln("  " + structName + " s;");
        this.writer.indents().appendln("  " + this.sInt64 + " pad;");
        this.writer.indents().appendln("} w;");
        this.writer.indents().appendln("int is_unsigned;");
        this.writer.indents().appendln("char *p;");
        this.writer.indents().appendln("unsigned int byte_offset;");
        this.writer.indents().appendln("int start_bit, end_bit;");
        this.writer.indents().appendln(this.uInt64 + " v;");
        this.writer.indents().appendln(this.uInt64 + " all_bits_set = -1;");
        this.writer.indents().appendln("memset(&w, 0x0, sizeof(w));");
        this.registerElementForCurrentLine(bitfieldInfo.getAnnotatedElement());
        this.writer.indents().appendln("w.s." + bitfieldName + " = all_bits_set;");
        this.writer.indents().appendln("is_unsigned = w.s." + bitfieldName + " > 0;");
        this.writer.indents().appendln("p = (char*)&w.s;");
        this.writer.indents().appendln("byte_offset = 0;");
        this.writer.indents().appendln("while (byte_offset < sizeof(w.s) && *(p + byte_offset) == 0) {");
        this.writer.indents().appendln("  byte_offset++;");
        this.writer.indents().appendln("}");
        this.writer.indents().appendln("start_bit = 0, end_bit = 0;");
        this.writer.indents().appendln("if (byte_offset >= sizeof(w.s)) {");
        this.writer.indents().appendln("  start_bit = end_bit = -1;");
        this.writer.indents().appendln("} else {");
        this.writer.indents().appendln("  v = *((" + this.uInt64 + "*) (p + byte_offset));");
        this.writer.indents().appendln("  while ((v & 0x1) == 0) {");
        this.writer.indents().appendln("    start_bit++;");
        this.writer.indents().appendln("    v = v >> 1;");
        this.writer.indents().appendln("  }");
        this.writer.indents().appendln("  end_bit = start_bit;");
        this.writer.indents().appendln("  while (v != 1) {");
        this.writer.indents().appendln("    end_bit++;");
        this.writer.indents().appendln("    v = v >> 1;");
        this.writer.indents().appendln("  }");
        this.writer.indents().appendln("}");
        this.printUnsignedLong(bitfieldInfo.getByteOffsetInfo(), "byte_offset");
        this.printSignedLong(bitfieldInfo.getStartBitInfo(), "start_bit");
        this.printSignedLong(bitfieldInfo.getEndBitInfo(), "end_bit");
        this.printIsUnsigned(bitfieldInfo.getSignednessInfo(), "is_unsigned");
        this.writer.outdent();
        this.writer.indents().appendln("}");
    }

    @Override
    protected void visitPointerToInfo(PointerToInfo pointerToInfo) {
        String sizeOfExpr = QueryCodeWriter.sizeOf(pointerToInfo);
        sizeOfExpr = pointerToInfo.getKind() == SizableInfo.ElementKind.POINTER && pointerToInfo.getName().startsWith("struct ") ? "sizeof(void *)" : QueryCodeWriter.sizeOf(pointerToInfo);
        this.printUnsignedLong(pointerToInfo.getSizeInfo(), sizeOfExpr);
        if (pointerToInfo.getKind() == SizableInfo.ElementKind.INTEGER) {
            this.registerElementForCurrentLine(pointerToInfo.getAnnotatedElement());
            this.writer.indents().appendln("{");
            this.writer.indent();
            this.writer.indents().appendln("int is_unsigned;");
            this.writer.indents().appendln(this.uInt64 + " all_bits_set = -1;");
            this.writer.indents().appendln(pointerToInfo.getName() + " fieldHolder = all_bits_set;");
            this.writer.indents().appendln("is_unsigned = fieldHolder > 0;");
            this.printIsUnsigned(pointerToInfo.getSignednessInfo(), "is_unsigned");
            this.writer.outdent();
            this.writer.indents().appendln("}");
        }
    }

    @Override
    protected void visitRawPointerToInfo(RawPointerToInfo pointerToInfo) {
    }

    @Override
    protected void visitEnumConstantInfo(EnumConstantInfo constantInfo) {
        assert (constantInfo.getKind() == SizableInfo.ElementKind.INTEGER);
        this.printUnsignedLong(constantInfo.getSizeInfo(), QueryCodeWriter.sizeOf(constantInfo));
        this.printIsUnsigned(constantInfo.getSignednessInfo(), QueryCodeWriter.isConstUnsigned(constantInfo.getName()));
        this.printLongHex(constantInfo.getValueInfo(), constantInfo.getName());
    }

    private void printString(ElementInfo info, String arg) {
        this.registerElementForCurrentLine(info.getAnnotatedElement());
        this.writer.indents().printf(info.getUniqueID() + "=$%s$", arg).semicolon();
    }

    private static String cast(String targetType, String value) {
        return "((" + targetType + ")" + value + ")";
    }

    private void printSignedLong(ElementInfo info, String arg) {
        this.registerElementForCurrentLine(info.getAnnotatedElement());
        this.writer.indents().printf(info.getUniqueID() + "=" + this.formatSInt64, QueryCodeWriter.cast(this.sInt64, arg)).semicolon();
    }

    private void printUnsignedLong(ElementInfo info, String arg) {
        this.registerElementForCurrentLine(info.getAnnotatedElement());
        this.writer.indents().printf(info.getUniqueID() + "=" + this.formatUInt64, QueryCodeWriter.cast(this.uInt64, arg)).semicolon();
    }

    private void printLongHex(ElementInfo info, String arg) {
        this.registerElementForCurrentLine(info.getAnnotatedElement());
        this.writer.indents().printf(info.getUniqueID() + "=" + this.formatUInt64Hex, QueryCodeWriter.cast(this.uInt64, arg)).semicolon();
    }

    private void printFloat(ElementInfo info, String arg) {
        this.registerElementForCurrentLine(info.getAnnotatedElement());
        this.writer.indents().printf(info.getUniqueID() + "=%.15e", arg).semicolon();
    }

    private void printIsUnsigned(ElementInfo info, String arg) {
        this.printString(info, "(" + arg + ") ? \"" + SizableInfo.SignednessValue.UNSIGNED.name() + "\" : \"" + SizableInfo.SignednessValue.SIGNED.name() + "\"");
    }

    private static String sizeOf(ElementInfo element) {
        String elementName = element.getName();
        return elementName.equals("void") ? "1" : "sizeof(" + elementName + ")";
    }

    private static String sizeOfField(StructFieldInfo field) {
        return "sizeof(((" + field.getParent().getName() + " *) 0)->" + field.getName() + ")";
    }

    private static String offsetOfField(StructFieldInfo field) {
        return "offsetof(" + field.getParent().getName() + ", " + field.getName() + ")";
    }

    private static String isConstUnsigned(String symbolName) {
        return "(" + symbolName + ">=0 ? 1 : 0)";
    }

    private void registerElementForCurrentLine(Object element) {
        assert (element != null);
        int currentLineNumber = this.writer.currentLineNumber();
        while (this.elementForLineNumber.size() <= currentLineNumber) {
            this.elementForLineNumber.add(null);
        }
        assert (this.elementForLineNumber.get(currentLineNumber) == null) : "element already registered for this line";
        this.elementForLineNumber.set(currentLineNumber, element);
    }
}

