/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.codegen;

import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.c.libc.HostedLibCBase;
import com.oracle.svm.hosted.c.util.FileUtils;
import com.oracle.svm.util.ClassUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Scanner;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import org.graalvm.compiler.core.riscv64.RISCV64ReflectionUtil;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;

public abstract class CCompilerInvoker {
    public static final String VISUAL_STUDIO_MINIMUM_REQUIRED_VERSION = "Visual Studio 2022 version 17.1.0";
    public final Path tempDirectory;
    public final CompilerInfo compilerInfo;

    protected CCompilerInvoker(Path tempDirectory) {
        this.tempDirectory = tempDirectory;
        try {
            this.compilerInfo = this.getCCompilerInfo();
        }
        catch (UserError.UserException err) {
            throw CCompilerInvoker.addSkipCheckingInfo(err);
        }
    }

    public static CCompilerInvoker create(Path tempDirectory) {
        OS hostOS = OS.getCurrent();
        switch (hostOS) {
            case LINUX: {
                return new LinuxCCompilerInvoker(tempDirectory);
            }
            case DARWIN: {
                return new DarwinCCompilerInvoker(tempDirectory);
            }
            case WINDOWS: {
                return new WindowsCCompilerInvoker(tempDirectory);
            }
        }
        throw UserError.abort("No CCompilerInvoker for operating system %s", hostOS.name());
    }

    public void verifyCompiler() {
        if (SubstrateOptions.CheckToolchain.getValue().booleanValue()) {
            try {
                this.verify();
            }
            catch (UserError.UserException err) {
                throw CCompilerInvoker.addSkipCheckingInfo(err);
            }
        }
    }

    private static UserError.UserException addSkipCheckingInfo(UserError.UserException err) {
        ArrayList<String> messages = new ArrayList<String>();
        err.getMessages().forEach(messages::add);
        messages.add("To prevent native-toolchain checking provide command-line option " + SubstrateOptionsParser.commandArgument(SubstrateOptions.CheckToolchain, "-"));
        return UserError.abort(messages);
    }

    protected InputStream getCompilerErrorStream(Process compilingProcess) {
        return compilingProcess.getErrorStream();
    }

    protected abstract void verify();

    private CompilerInfo getCCompilerInfo() {
        Path compilerPath = this.getCCompilerPath().toAbsolutePath();
        if (!SubstrateOptions.CheckToolchain.getValue().booleanValue()) {
            return new CompilerInfo(compilerPath, null, ClassUtil.getUnqualifiedName(this.getClass()), null, 0, 0, 0, null);
        }
        List<String> compilerCommand = this.createCompilerCommand(compilerPath, this.getVersionInfoOptions(), null, new Path[0]);
        Process compilerProcess = null;
        try {
            CompilerInfo result;
            List<String> lines;
            ProcessBuilder processBuilder = FileUtils.prepareCommand(compilerCommand, this.tempDirectory);
            processBuilder.redirectErrorStream(true);
            processBuilder.environment().put("LC_ALL", "C");
            FileUtils.traceCommand(processBuilder);
            compilerProcess = processBuilder.start();
            try (InputStream inputStream = compilerProcess.getInputStream();){
                lines = FileUtils.readAllLines(inputStream);
                FileUtils.traceCommandOutput(lines);
                result = this.createCompilerInfo(compilerPath, new Scanner(String.join((CharSequence)System.lineSeparator(), lines)));
            }
            compilerProcess.waitFor();
            if (result == null) {
                String errorMessage = "Unable to detect supported %s native software development toolchain.%nQuerying with command '%s' prints:%n%s";
                throw UserError.abort(errorMessage, OS.getCurrent().name(), SubstrateUtil.getShellCommandString(compilerCommand, false), lines.stream().map(str -> "  " + str).collect(Collectors.joining(System.lineSeparator())));
            }
            CompilerInfo compilerInfo = result;
            return compilerInfo;
        }
        catch (InterruptedException ex) {
            throw new InterruptImageBuilding("Interrupted during checking native-compiler " + compilerPath);
        }
        catch (IOException e) {
            throw UserError.abort(e, "Collecting native-compiler info with '%s' failed", SubstrateUtil.getShellCommandString(compilerCommand, false));
        }
        finally {
            if (compilerProcess != null) {
                compilerProcess.destroy();
            }
        }
    }

    protected List<String> getVersionInfoOptions() {
        return Arrays.asList("-v");
    }

    protected abstract CompilerInfo createCompilerInfo(Path var1, Scanner var2);

    protected static String[] guessTargetTriplet(Scanner scanner) {
        while (scanner.findInLine("Target: ") == null) {
            scanner.nextLine();
        }
        scanner.useDelimiter("-");
        String arch = scanner.next();
        String vendor = scanner.next();
        String os = scanner.nextLine();
        os = os.startsWith("-") ? os.substring(1) : os;
        scanner.reset();
        return new String[]{arch, vendor, os};
    }

    protected static Class<? extends Architecture> guessArchitecture(String archStr) {
        switch (archStr) {
            case "x86_64": 
            case "x64": {
                return AMD64.class;
            }
            case "aarch64": 
            case "arm64": {
                return AArch64.class;
            }
            case "riscv64": {
                return RISCV64ReflectionUtil.getArch((boolean)false);
            }
        }
        return null;
    }

    public void compileAndParseError(boolean strict, List<String> compileOptions, Path source, Path target, CompilerErrorHandler handler) {
        List<String> options = strict ? this.createStrictOptions(compileOptions) : compileOptions;
        Process compilingProcess = null;
        try {
            List<String> lines;
            ProcessBuilder compileCommand = FileUtils.prepareCommand(this.createCompilerCommand(options, target.normalize(), source.normalize()), this.tempDirectory);
            FileUtils.traceCommand(compileCommand);
            compilingProcess = compileCommand.start();
            try (InputStream compilerErrors = this.getCompilerErrorStream(compilingProcess);){
                lines = FileUtils.readAllLines(compilerErrors);
                FileUtils.traceCommandOutput(lines);
            }
            boolean errorReported = false;
            for (String line : lines) {
                if (!this.detectError(line)) continue;
                if (handler != null) {
                    handler.handle(compileCommand, source, line);
                }
                errorReported = true;
            }
            int status = compilingProcess.waitFor();
            if (status != 0 && !errorReported && handler != null) {
                handler.handle(compileCommand, source, lines.toString());
            }
        }
        catch (InterruptedException ex) {
            throw new InterruptImageBuilding("Interrupted during C-ABI query code compilation of " + source);
        }
        catch (IOException ex) {
            throw UserError.abort(ex, "Unable to compile C-ABI query code %s. Make sure native software development toolchain is installed on your system.", source);
        }
        finally {
            if (compilingProcess != null) {
                compilingProcess.destroy();
            }
        }
    }

    private List<String> createStrictOptions(List<String> compileOptions) {
        ArrayList<String> strictCompileOptions = new ArrayList<String>(this.compileStrictOptions());
        strictCompileOptions.addAll(compileOptions);
        return strictCompileOptions;
    }

    protected List<String> compileStrictOptions() {
        return Arrays.asList("-Wall", "-Werror");
    }

    protected boolean detectError(String line) {
        return line.contains(": error:") || line.contains(": fatal error:");
    }

    public static Optional<Path> lookupSearchPath(String name) {
        String envPath = System.getenv("PATH");
        if (envPath == null) {
            return Optional.empty();
        }
        return Arrays.stream(envPath.split(File.pathSeparator)).map(entry -> Paths.get(entry, name)).filter(p -> Files.isExecutable(p) && !Files.isDirectory(p, new LinkOption[0])).findFirst();
    }

    public Path getCCompilerPath() {
        Path compilerPath;
        String userDefinedPath = SubstrateOptions.CCompilerPath.getValue();
        if (userDefinedPath != null) {
            compilerPath = Paths.get(userDefinedPath, new String[0]);
        } else {
            String executableName = this.asExecutableName(this.getDefaultCompiler());
            Optional<Path> optCompilerPath = CCompilerInvoker.lookupSearchPath(executableName);
            if (optCompilerPath.isPresent()) {
                compilerPath = optCompilerPath.get();
            } else {
                throw UserError.abort("Default native-compiler executable '%s' not found via environment variable PATH", executableName);
            }
        }
        if (Files.isDirectory(compilerPath, new LinkOption[0]) || !Files.isExecutable(compilerPath)) {
            Object msgSubject = userDefinedPath != null ? SubstrateOptionsParser.commandArgument(SubstrateOptions.CCompilerPath, userDefinedPath) : "Default native-compiler '" + compilerPath + "'";
            throw UserError.abort("%s does not specify a path to an executable.", msgSubject);
        }
        return compilerPath;
    }

    protected abstract String getDefaultCompiler();

    public String asExecutableName(String basename) {
        return basename;
    }

    public List<String> createCompilerCommand(List<String> options, Path target, Path ... input) {
        return this.createCompilerCommand(this.compilerInfo.compilerPath, options, target, input);
    }

    private List<String> createCompilerCommand(Path compilerPath, List<String> options, Path target, Path ... input) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(compilerPath.toString());
        command.addAll(SubstrateOptions.CCompilerOption.getValue().values());
        command.addAll(options);
        if (target != null) {
            command.addAll(this.addTarget(target));
        }
        for (Path elem : input) {
            command.add(elem.toString());
        }
        return command;
    }

    protected List<String> addTarget(Path target) {
        return Arrays.asList("-o", target.toString());
    }

    public static final class CompilerInfo {
        public final Path compilerPath;
        public final String name;
        public final String shortName;
        public final String vendor;
        public final int versionMajor;
        public final int versionMinor0;
        public final int versionMinor1;
        public final String targetArch;

        public CompilerInfo(Path compilerPath, String vendor, String name, String shortName, int versionMajor, int versionMinor0, int versionMinor1, String targetArch) {
            this.compilerPath = compilerPath;
            this.name = name;
            this.vendor = vendor;
            this.shortName = shortName;
            this.versionMajor = versionMajor;
            this.versionMinor0 = versionMinor0;
            this.versionMinor1 = versionMinor1;
            this.targetArch = targetArch;
        }

        public String getShortDescription() {
            return String.format("%s (%s, %s, %d.%d.%d)", this.compilerPath.toFile().getName(), this.vendor, this.targetArch, this.versionMajor, this.versionMinor0, this.versionMinor1);
        }

        public String toCGlobalDataString() {
            return String.join((CharSequence)"|", Arrays.asList(this.shortName, this.vendor, this.targetArch, String.format("%d.%d.%d", this.versionMajor, this.versionMinor0, this.versionMinor1)));
        }

        public void dump(Consumer<String> sink) {
            sink.accept("Name: " + this.name + " (" + this.shortName + ")");
            sink.accept("Vendor: " + this.vendor);
            sink.accept(String.format("Version: %d.%d.%d", this.versionMajor, this.versionMinor0, this.versionMinor1));
            sink.accept("Target architecture: " + this.targetArch);
            sink.accept("Path: " + this.compilerPath);
        }
    }

    private static class LinuxCCompilerInvoker
    extends CCompilerInvoker {
        LinuxCCompilerInvoker(Path tempDirectory) {
            super(tempDirectory);
        }

        @Override
        protected String getDefaultCompiler() {
            if (Platform.includedIn(Platform.LINUX.class)) {
                return HostedLibCBase.singleton().getTargetCompiler();
            }
            return "gcc";
        }

        @Override
        protected CompilerInfo createCompilerInfo(Path compilerPath, Scanner scanner) {
            try {
                if (scanner.findInLine("icc version ") != null) {
                    scanner.useDelimiter("[. ]");
                    int major = scanner.nextInt();
                    int minor0 = scanner.nextInt();
                    int minor1 = scanner.nextInt();
                    return new CompilerInfo(compilerPath, "intel", "Intel(R) C++ Compiler", "icc", major, minor0, minor1, "x86_64");
                }
                if (scanner.findInLine("clang version ") != null) {
                    scanner.useDelimiter("[. -]");
                    int major = scanner.nextInt();
                    int minor0 = scanner.nextInt();
                    int minor1 = scanner.nextInt();
                    String[] triplet = LinuxCCompilerInvoker.guessTargetTriplet(scanner);
                    return new CompilerInfo(compilerPath, "llvm", "Clang C++ Compiler", "clang", major, minor0, minor1, triplet[0]);
                }
                String[] triplet = LinuxCCompilerInvoker.guessTargetTriplet(scanner);
                while (scanner.findInLine("gcc version ") == null) {
                    scanner.nextLine();
                }
                scanner.useDelimiter("[. ]");
                int major = scanner.nextInt();
                int minor0 = scanner.nextInt();
                int minor1 = scanner.nextInt();
                return new CompilerInfo(compilerPath, triplet[1], "GNU project C and C++ compiler", "gcc", major, minor0, minor1, triplet[0]);
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }

        @Override
        protected void verify() {
            Class<?> substrateTargetArch = ((SubstrateTargetDescription)((Object)ImageSingletons.lookup(SubstrateTargetDescription.class))).arch.getClass();
            Class<? extends Architecture> guessed = LinuxCCompilerInvoker.guessArchitecture(this.compilerInfo.targetArch);
            if (guessed == null) {
                UserError.abort("Linux native toolchain (%s) has no matching native-image target architecture.", this.compilerInfo.targetArch);
            }
            if (guessed != substrateTargetArch) {
                UserError.abort("Linux native toolchain (%s) implies native-image target architecture %s but configured native-image target architecture is %s.", this.compilerInfo.targetArch, guessed, substrateTargetArch);
            }
        }
    }

    private static class DarwinCCompilerInvoker
    extends CCompilerInvoker {
        DarwinCCompilerInvoker(Path tempDirectory) {
            super(tempDirectory);
        }

        @Override
        protected String getDefaultCompiler() {
            return "cc";
        }

        @Override
        protected CompilerInfo createCompilerInfo(Path compilerPath, Scanner scanner) {
            try {
                while (scanner.findInLine("Apple (clang|LLVM) version ") == null) {
                    scanner.nextLine();
                }
                scanner.useDelimiter("[. ]");
                int major = scanner.nextInt();
                int minor0 = scanner.nextInt();
                int minor1 = scanner.hasNextInt() ? scanner.nextInt() : 0;
                scanner.reset();
                String[] triplet = DarwinCCompilerInvoker.guessTargetTriplet(scanner);
                return new CompilerInfo(compilerPath, triplet[1], "LLVM", "clang", major, minor0, minor1, triplet[0]);
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }

        @Override
        protected void verify() {
            Class<?> substrateTargetArch = ((SubstrateTargetDescription)((Object)ImageSingletons.lookup(SubstrateTargetDescription.class))).arch.getClass();
            Class<? extends Architecture> guessed = DarwinCCompilerInvoker.guessArchitecture(this.compilerInfo.targetArch);
            if (guessed == null) {
                UserError.abort("Darwin native toolchain (%s) has no matching native-image target architecture.", this.compilerInfo.targetArch);
            }
            if (guessed != substrateTargetArch) {
                UserError.abort("Darwin native toolchain (%s) implies native-image target architecture %s but configured native-image target architecture is %s.", this.compilerInfo.targetArch, guessed, substrateTargetArch);
            }
        }

        @Override
        protected List<String> compileStrictOptions() {
            ArrayList<String> strictOptions = new ArrayList<String>(super.compileStrictOptions());
            strictOptions.add("-Wno-tautological-compare");
            return strictOptions;
        }
    }

    private static class WindowsCCompilerInvoker
    extends CCompilerInvoker {
        WindowsCCompilerInvoker(Path tempDirectory) {
            super(tempDirectory);
        }

        @Override
        public String asExecutableName(String basename) {
            String suffix = ".exe";
            if (basename.endsWith(suffix)) {
                return basename;
            }
            return basename + suffix;
        }

        @Override
        protected String getDefaultCompiler() {
            return "cl";
        }

        @Override
        protected List<String> addTarget(Path target) {
            return Arrays.asList("/Fe" + target.toString());
        }

        @Override
        protected InputStream getCompilerErrorStream(Process compilingProcess) {
            return compilingProcess.getInputStream();
        }

        @Override
        protected List<String> getVersionInfoOptions() {
            return Collections.emptyList();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected CompilerInfo createCompilerInfo(Path compilerPath, Scanner outerScanner) {
            try (Scanner scanner = new Scanner(outerScanner.nextLine());){
                String targetArch = null;
                if (scanner.hasNext("\u7528\u4e8e")) {
                    scanner.next();
                    targetArch = scanner.next();
                }
                if (scanner.findInLine("Microsoft.*\\(R\\) C/C\\+\\+") == null && scanner.findInLine("C/C\\+\\+.*Microsoft.*\\(R\\)") == null) {
                    CompilerInfo compilerInfo = null;
                    return compilerInfo;
                }
                scanner.useDelimiter("\\D");
                while (!scanner.hasNextInt()) {
                    scanner.next();
                }
                int major = scanner.nextInt();
                int minor0 = scanner.nextInt();
                int minor1 = scanner.nextInt();
                if (targetArch == null) {
                    scanner.reset();
                    while (scanner.hasNext()) {
                        targetArch = scanner.next();
                    }
                }
                CompilerInfo compilerInfo = new CompilerInfo(compilerPath, "microsoft", "C/C++ Optimizing Compiler", "cl", major, minor0, minor1, targetArch);
                return compilerInfo;
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }

        @Override
        protected void verify() {
            int minimumMajorVersion = 19;
            int minimumMinorVersion = 31;
            if (this.compilerInfo.versionMajor < minimumMajorVersion || this.compilerInfo.versionMinor0 < minimumMinorVersion) {
                UserError.abort("On Windows, GraalVM Native Image for JDK %s requires %s or later (C/C++ Optimizing Compiler Version %s.%s or later).%nCompiler info detected: %s", JavaVersionUtil.JAVA_SPEC, CCompilerInvoker.VISUAL_STUDIO_MINIMUM_REQUIRED_VERSION, minimumMajorVersion, minimumMinorVersion, this.compilerInfo.getShortDescription());
            }
            if (WindowsCCompilerInvoker.guessArchitecture(this.compilerInfo.targetArch) != AMD64.class) {
                String targetPrefix = this.compilerInfo.targetArch.matches("(.*x|i\\d)86$") ? "32-bit architecture " : "";
                UserError.abort("Native-image building on Windows currently only supports target architecture: %s (%s%s unsupported)", AMD64.class.getSimpleName(), targetPrefix, this.compilerInfo.targetArch);
            }
        }

        @Override
        protected List<String> compileStrictOptions() {
            return Arrays.asList("/WX", "/W4", "/wd4201", "/wd4244", "/wd4245", "/wd4800", "/wd4804", "/wd4214");
        }
    }

    public static interface CompilerErrorHandler {
        public void handle(ProcessBuilder var1, Path var2, String var3);
    }
}

