/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.infrastructure.Universe;
import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;

public class HostedMetaAccess
extends UniverseMetaAccess {
    public HostedMetaAccess(HostedUniverse hUniverse, AnalysisMetaAccess aMetaAccess) {
        super((Universe)hUniverse, (MetaAccessProvider)aMetaAccess);
    }

    public HostedType lookupJavaType(Class<?> clazz) {
        return (HostedType)super.lookupJavaType(clazz);
    }

    public HostedType lookupJavaType(JavaConstant constant) {
        return (HostedType)super.lookupJavaType(constant);
    }

    public Optional<HostedType> optionalLookupJavaType(Class<?> clazz) {
        HostedType result = (HostedType)this.getTypeCacheEntry(clazz);
        if (result != null) {
            return Optional.of(result);
        }
        Optional analysisType = ((AnalysisMetaAccess)this.getWrapped()).optionalLookupJavaType(clazz);
        if (!analysisType.isPresent()) {
            return Optional.empty();
        }
        result = this.getUniverse().optionalLookup((JavaType)analysisType.get());
        return Optional.ofNullable(result);
    }

    public List<? extends ResolvedJavaType> optionalLookupJavaTypes(List<Class<?>> types) {
        return types.stream().map(this::optionalLookupJavaType).flatMap(optType -> optType.isPresent() ? Stream.of((HostedType)optType.get()) : Stream.empty()).collect(Collectors.toList());
    }

    public HostedMethod lookupJavaMethod(Executable reflectionMethod) {
        return (HostedMethod)super.lookupJavaMethod(reflectionMethod);
    }

    public HostedMethod optionalLookupJavaMethod(Executable reflectionMethod) {
        return this.getUniverse().optionalLookup((JavaMethod)this.getWrapped().lookupJavaMethod(reflectionMethod));
    }

    public HostedField lookupJavaField(Field reflectionField) {
        return (HostedField)super.lookupJavaField(reflectionField);
    }

    public HostedField optionalLookupJavaField(Field reflectionField) {
        return this.getUniverse().optionalLookup((JavaField)this.getWrapped().lookupJavaField(reflectionField));
    }

    public JavaConstant encodeDeoptActionAndReason(DeoptimizationAction action, DeoptimizationReason reason, int speculationId) {
        return Deoptimizer.encodeDeoptActionAndReason(action, reason, speculationId);
    }

    public DeoptimizationAction decodeDeoptAction(JavaConstant constant) {
        return Deoptimizer.decodeDeoptAction(constant);
    }

    public DeoptimizationReason decodeDeoptReason(JavaConstant constant) {
        return Deoptimizer.decodeDeoptReason(constant);
    }

    public int decodeDebugId(JavaConstant constant) {
        return Deoptimizer.decodeDebugId(constant);
    }

    public int getArrayBaseOffset(JavaKind elementKind) {
        return ConfigurationValues.getObjectLayout().getArrayBaseOffset(elementKind);
    }

    public int getArrayIndexScale(JavaKind elementKind) {
        return ConfigurationValues.getObjectLayout().getArrayIndexScale(elementKind);
    }

    public HostedUniverse getUniverse() {
        return (HostedUniverse)this.universe;
    }
}

