/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.code.ImageCodeInfo;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.heap.FillerObject;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.DynamicHubCompanion;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.image.ImageHeap;
import com.oracle.svm.core.image.ImageHeapLayouter;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.image.ImageHeapPartition;
import com.oracle.svm.core.jdk.StringInternSupport;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.HostedStringDeduplication;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.config.HybridLayout;
import com.oracle.svm.hosted.image.ImageHeapConnectedComponentsFeature;
import com.oracle.svm.hosted.image.StringInternFeature;
import com.oracle.svm.hosted.meta.HostedArrayClass;
import com.oracle.svm.hosted.meta.HostedClass;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.meta.MaterializedConstantFields;
import com.oracle.svm.hosted.meta.UniverseBuilder;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.core.common.type.CompressibleConstant;
import org.graalvm.compiler.core.common.type.TypedConstant;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.RelocatedPointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public final class NativeImageHeap
implements ImageHeap {
    private final HostedUniverse universe;
    private final AnalysisUniverse aUniverse;
    private final HostedMetaAccess metaAccess;
    private final ObjectLayout objectLayout;
    private final ImageHeapLayouter heapLayouter;
    private final int minInstanceSize;
    private final int minArraySize;
    private final HashMap<JavaConstant, ObjectInfo> objects = new HashMap();
    private final Set<Object> blacklist = Collections.newSetFromMap(new IdentityHashMap());
    private final Map<HostedClass, HybridLayout<?>> hybridLayouts = new HashMap();
    private final Map<String, String> internedStrings = new HashMap<String, String>();
    private final Phase addObjectsPhase = Phase.factory();
    private final Phase internStringsPhase = Phase.factory();
    private final Deque<AddObjectData> addObjectWorklist = new ArrayDeque<AddObjectData>();
    private final Set<Object> knownImmutableObjects = Collections.newSetFromMap(new IdentityHashMap());
    Map<ObjectInfo, ObjectReachabilityInfo> objectReachabilityInfo = null;
    private final int imageHeapOffsetInAddressSpace = Heap.getHeap().getImageHeapOffsetInAddressSpace();

    public NativeImageHeap(AnalysisUniverse aUniverse, HostedUniverse universe, HostedMetaAccess metaAccess, ImageHeapLayouter heapLayouter) {
        this.aUniverse = aUniverse;
        this.universe = universe;
        this.metaAccess = metaAccess;
        this.objectLayout = ConfigurationValues.getObjectLayout();
        this.heapLayouter = heapLayouter;
        this.minInstanceSize = this.objectLayout.getMinImageHeapInstanceSize();
        this.minArraySize = this.objectLayout.getMinImageHeapArraySize();
        assert (this.assertFillerObjectSizes());
        if (ImageHeapConnectedComponentsFeature.Options.PrintImageHeapConnectedComponents.getValue().booleanValue()) {
            this.objectReachabilityInfo = new IdentityHashMap<ObjectInfo, ObjectReachabilityInfo>();
        }
    }

    public Collection<ObjectInfo> getObjects() {
        return this.objects.values();
    }

    public int getObjectCount() {
        return this.objects.size();
    }

    public ObjectInfo getObjectInfo(Object obj) {
        return this.objects.get(SubstrateObjectConstant.forObject(obj));
    }

    public ObjectInfo getConstantInfo(JavaConstant constant) {
        return this.objects.get(NativeImageHeap.uncompress(constant));
    }

    protected HostedUniverse getUniverse() {
        return this.universe;
    }

    protected HostedMetaAccess getMetaAccess() {
        return this.metaAccess;
    }

    protected AnalysisUniverse getAnalysisUniverse() {
        return this.aUniverse;
    }

    protected HybridLayout<?> getHybridLayout(HostedClass clazz) {
        return this.hybridLayouts.get(clazz);
    }

    protected boolean isBlacklisted(Object obj) {
        return this.blacklist.contains(obj);
    }

    protected ObjectLayout getObjectLayout() {
        return this.objectLayout;
    }

    public ImageHeapLayouter getLayouter() {
        return this.heapLayouter;
    }

    @Fold
    static boolean useHeapBase() {
        return SubstrateOptions.SpawnIsolates.getValue() != false && ((CompressEncoding)ImageSingletons.lookup(CompressEncoding.class)).hasBase();
    }

    @Fold
    static boolean spawnIsolates() {
        return SubstrateOptions.SpawnIsolates.getValue() != false && NativeImageHeap.useHeapBase();
    }

    public void addInitialObjects() {
        this.addObjectsPhase.allow();
        this.internStringsPhase.allow();
        this.addStaticFields();
    }

    public void addTrailingObjects() {
        this.processAddObjectWorklist();
        HostedField internedStringsField = (HostedField)StringInternFeature.getInternedStringsField((MetaAccessProvider)this.metaAccess);
        boolean usesInternedStrings = internedStringsField.isAccessed();
        if (usesInternedStrings) {
            this.addObject(this.getMetaAccess().lookupJavaType((Class)String[].class).getHub(), false, (Object)HeapInclusionReason.InternedStringsTable);
            this.internStringsPhase.disallow();
            Object[] imageInternedStrings = this.internedStrings.keySet().toArray(new String[0]);
            Arrays.sort(imageInternedStrings);
            ((StringInternSupport)ImageSingletons.lookup(StringInternSupport.class)).setImageInternedStrings((String[])imageInternedStrings);
            this.addObject(imageInternedStrings, true, (Object)HeapInclusionReason.InternedStringsTable);
            this.processAddObjectWorklist();
        } else {
            this.internStringsPhase.disallow();
        }
        this.addObjectsPhase.disallow();
        assert (this.addObjectWorklist.isEmpty());
    }

    private static Object readObjectField(HostedField field, JavaConstant receiver) {
        return SubstrateObjectConstant.asObject((Constant)field.readStorageValue(receiver));
    }

    private static JavaConstant readConstantField(HostedField field, JavaConstant receiver) {
        return field.readStorageValue(receiver);
    }

    private void addStaticFields() {
        this.addObject(StaticFieldsSupport.getStaticObjectFields(), false, (Object)HeapInclusionReason.StaticObjectFields);
        this.addObject(StaticFieldsSupport.getStaticPrimitiveFields(), false, (Object)HeapInclusionReason.StaticPrimitiveFields);
        for (HostedField field : this.getUniverse().getFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.hasLocation() || field.getType().getStorageKind() != JavaKind.Object || !field.isRead()) continue;
            assert (field.isWritten() || MaterializedConstantFields.singleton().contains(field.wrapped));
            this.addConstant(NativeImageHeap.readConstantField(field, null), false, field);
        }
    }

    public void registerAsImmutable(Object object) {
        assert (this.addObjectsPhase.isBefore()) : "Registering immutable object too late: phase: " + this.addObjectsPhase.toString();
        this.knownImmutableObjects.add(object);
    }

    public void addObject(Object original, boolean immutableFromParent, Object reason) {
        this.addConstant(SubstrateObjectConstant.forObject(original), immutableFromParent, reason);
    }

    public void addConstant(JavaConstant constant, boolean immutableFromParent, Object reason) {
        ObjectInfo existing;
        JavaConstant uncompressed;
        int identityHashCode;
        assert (this.addObjectsPhase.isAllowed()) : "Objects cannot be added at phase: " + this.addObjectsPhase.toString() + " with reason: " + reason;
        if (constant.isNull() || this.metaAccess.isInstanceOf(constant, WordBase.class)) {
            return;
        }
        if (this.metaAccess.isInstanceOf(constant, Class.class)) {
            Object original = SubstrateObjectConstant.asObject((Constant)constant);
            if (original instanceof Class) {
                throw VMError.shouldNotReachHere("Must not have Class in native image heap: " + original);
            }
            assert (original instanceof DynamicHub);
            if (((DynamicHub)original).getClassInitializationInfo() == null) {
                throw NativeImageHeap.reportIllegalType(original, reason);
            }
        }
        VMError.guarantee((identityHashCode = NativeImageHeap.computeIdentityHashCode(uncompressed = NativeImageHeap.uncompress(constant))) != 0, "0 is used as a marker value for 'hash code not yet computed'");
        if (this.metaAccess.isInstanceOf(uncompressed, String.class)) {
            this.handleImageString((String)SubstrateObjectConstant.asObject((Constant)uncompressed));
        }
        if ((existing = this.objects.get(uncompressed)) == null) {
            this.addObjectToImageHeap(uncompressed, immutableFromParent, identityHashCode, reason);
        } else if (this.objectReachabilityInfo != null) {
            this.objectReachabilityInfo.get(existing).addReason(reason);
        }
    }

    private static JavaConstant uncompress(JavaConstant constant) {
        CompressibleConstant compressible;
        if (constant instanceof CompressibleConstant && (compressible = (CompressibleConstant)constant).isCompressed()) {
            return compressible.uncompress();
        }
        return constant;
    }

    private static boolean isCompressed(JavaConstant constant) {
        if (constant instanceof CompressibleConstant) {
            CompressibleConstant compressible = (CompressibleConstant)constant;
            return compressible.isCompressed();
        }
        return false;
    }

    private static int computeIdentityHashCode(JavaConstant constant) {
        return ((TypedConstant)constant).getIdentityHashCode();
    }

    @Override
    public int countDynamicHubs() {
        int count = 0;
        for (ObjectInfo o : this.getObjects()) {
            if (!this.metaAccess.isInstanceOf(o.getConstant(), DynamicHub.class)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public ObjectInfo addFillerObject(int size) {
        if (size >= this.minArraySize) {
            int elementSize = this.objectLayout.getArrayIndexScale(JavaKind.Int);
            int arrayLength = (size - this.minArraySize) / elementSize;
            assert (this.objectLayout.getArraySize(JavaKind.Int, arrayLength, true) == (long)size);
            return this.addLateToImageHeap(new int[arrayLength], (Object)HeapInclusionReason.FillerObject);
        }
        if (size >= this.minInstanceSize) {
            return this.addLateToImageHeap(new FillerObject(), (Object)HeapInclusionReason.FillerObject);
        }
        return null;
    }

    private boolean assertFillerObjectSizes() {
        assert ((long)this.minArraySize == this.objectLayout.getArraySize(JavaKind.Int, 0, true));
        ResolvedJavaType filler = this.metaAccess.lookupJavaType((Class)FillerObject.class);
        UnsignedWord fillerSize = LayoutEncoding.getPureInstanceSize(filler.getHub(), true);
        assert (fillerSize.equal(this.minInstanceSize));
        assert (this.minInstanceSize * 2 >= this.minArraySize) : "otherwise, we might need more than one non-array object";
        return true;
    }

    private void handleImageString(String str) {
        NativeImageHeap.forceHashCodeComputation(str);
        if (HostedStringDeduplication.isInternedString(str)) {
            assert (this.internedStrings.containsKey(str) || this.internStringsPhase.isAllowed()) : "Should not intern string during phase " + this.internStringsPhase.toString();
            this.internedStrings.put(str, str);
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="eager hash field computation")
    private static void forceHashCodeComputation(String str) {
        str.hashCode();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void addObjectToImageHeap(JavaConstant constant, boolean immutableFromParent, int identityHashCode, Object reason) {
        type = this.metaAccess.lookupJavaType(constant);
        hub = type.getHub();
        immutable = immutableFromParent != false || this.isKnownImmutableConstant(constant) != false;
        written = false;
        references = false;
        relocatable = false;
        if (type.isInstanceClass()) {
            clazz = (HostedInstanceClass)type;
            if (clazz.getMonitorFieldOffset() != 0) {
                written = true;
                references = true;
            }
            hybridTypeIDSlotsField = null;
            hybridArrayField = null;
            hybridArray = null;
            if (HybridLayout.isHybrid(clazz)) {
                hybridLayout /* !! */  = this.hybridLayouts.get(clazz);
                if (hybridLayout /* !! */  == null) {
                    hybridLayout /* !! */  = new HybridLayout<T>(clazz, this.objectLayout, (MetaAccessProvider)this.metaAccess);
                    this.hybridLayouts.put(clazz, hybridLayout /* !! */ );
                }
                shouldBlacklist = HybridLayout.canHybridFieldsBeDuplicated(clazz) == false;
                hybridTypeIDSlotsField = hybridLayout /* !! */ .getTypeIDSlotsField();
                if (hybridTypeIDSlotsField != null && shouldBlacklist && (typeIDSlots = NativeImageHeap.readObjectField(hybridTypeIDSlotsField, constant)) != null) {
                    this.blacklist.add(typeIDSlots);
                }
                if ((hybridArray = NativeImageHeap.readObjectField(hybridArrayField = hybridLayout /* !! */ .getArrayField(), constant)) != null && shouldBlacklist) {
                    this.blacklist.add(hybridArray);
                    written = true;
                }
                if (!NativeImageHeap.$assertionsDisabled && hybridArray == null) {
                    throw new AssertionError((Object)("Cannot read value for field " + hybridArrayField.format("%H.%n")));
                }
                size = hybridLayout /* !! */ .getTotalSize(Array.getLength(hybridArray), true);
            } else {
                size = LayoutEncoding.getPureInstanceSize(hub, true).rawValue();
            }
            info = this.addToImageHeap(constant, (HostedClass)clazz, size, identityHashCode, reason);
            try {
                this.recursiveAddObject(hub, false, info);
                fieldsAreImmutable = this.metaAccess.isInstanceOf(constant, String.class);
                for (HostedField field : clazz.getInstanceFields(true)) {
                    fieldRelocatable = false;
                    if (field.isRead() && !field.equals(hybridArrayField) && !field.equals(hybridTypeIDSlotsField)) {
                        if (field.getJavaKind() == JavaKind.Object) {
                            if (!NativeImageHeap.$assertionsDisabled && !field.hasLocation()) {
                                throw new AssertionError();
                            }
                            fieldValueConstant = field.readValue(constant);
                            if (fieldValueConstant.getJavaKind() == JavaKind.Object) {
                                if (NativeImageHeap.spawnIsolates()) {
                                    fieldRelocatable = this.metaAccess.isInstanceOf(fieldValueConstant, RelocatedPointer.class);
                                }
                                this.recursiveAddConstant(fieldValueConstant, fieldsAreImmutable, info);
                                references = true;
                            }
                        }
                        relocatable = relocatable != false || fieldRelocatable != false;
                    }
                    written = written != false || field.isWritten() != false && field.isFinal() == false && fieldRelocatable == false;
                }
                if (!(hybridArray instanceof Object[])) ** GOTO lbl79
                relocatable = this.addArrayElements((Object[])hybridArray, relocatable, info);
                references = true;
            }
            catch (AnalysisError.TypeNotFoundError ex) {
                throw NativeImageHeap.reportIllegalType(ex.getType(), info);
            }
        } else if (type.isArray()) {
            clazz = (HostedArrayClass)type;
            length = this.universe.getConstantReflectionProvider().readArrayLength(constant);
            size = this.objectLayout.getArraySize(type.getComponentType().getStorageKind(), length, true);
            info = this.addToImageHeap(constant, (HostedClass)clazz, size, identityHashCode, reason);
            try {
                this.recursiveAddObject(hub, false, info);
                if (this.metaAccess.isInstanceOf(constant, Object[].class)) {
                    if (constant instanceof ImageHeapConstant) {
                        relocatable = this.addConstantArrayElements(constant, length, false, info);
                    } else {
                        object = SubstrateObjectConstant.asObject((Constant)constant);
                        relocatable = this.addArrayElements((Object[])object, false, info);
                    }
                    references = true;
                }
                written = true;
            }
            catch (AnalysisError.TypeNotFoundError ex) {
                throw NativeImageHeap.reportIllegalType(ex.getType(), info);
            }
        } else {
            throw VMError.shouldNotReachHere();
        }
lbl79:
        // 3 sources

        if (relocatable && !this.isKnownImmutableConstant(constant)) {
            VMError.shouldNotReachHere("Object with relocatable pointers must be explicitly immutable: " + SubstrateObjectConstant.asObject((Constant)constant));
        }
        this.heapLayouter.assignObjectToPartition(info, written == false || immutable != false, references, relocatable);
    }

    private static HostedType requireType(Optional<HostedType> optionalType, Object object, Object reason) {
        if (!optionalType.isPresent() || !optionalType.get().isInstantiated()) {
            throw NativeImageHeap.reportIllegalType(object, reason);
        }
        return optionalType.get();
    }

    static RuntimeException reportIllegalType(Object object, Object reason) {
        StringBuilder msg = new StringBuilder();
        msg.append("Image heap writing found a class not seen during static analysis. ");
        msg.append("Did a static field or an object referenced from a static field change during native image generation? ");
        msg.append("For example, a lazily initialized cache could have been initialized during image generation, in which case ");
        msg.append("you need to force eager initialization of the cache before static analysis or reset the cache using a field ");
        msg.append("value recomputation.").append(System.lineSeparator()).append("    ");
        if (object instanceof DynamicHub) {
            msg.append("class: ").append(((DynamicHub)object).getName());
        } else if (object instanceof ResolvedJavaType) {
            msg.append("class: ").append(((ResolvedJavaType)object).toJavaName(true));
        } else {
            msg.append("object: ").append(object).append("  of class: ").append(object.getClass().getTypeName());
        }
        msg.append(System.lineSeparator()).append("  reachable through:").append(System.lineSeparator());
        NativeImageHeap.fillReasonStack(msg, reason);
        throw UserError.abort("%s", msg);
    }

    private static StringBuilder fillReasonStack(StringBuilder msg, Object reason) {
        if (reason instanceof ObjectInfo) {
            ObjectInfo info = (ObjectInfo)reason;
            msg.append("    object: ").append(info.getObject()).append("  of class: ").append(info.getObject().getClass().getTypeName()).append(System.lineSeparator());
            return NativeImageHeap.fillReasonStack(msg, info.getMainReason());
        }
        return msg.append("    root: ").append(reason).append(System.lineSeparator());
    }

    private boolean isKnownImmutableConstant(JavaConstant constant) {
        if (constant instanceof ImageHeapConstant) {
            return false;
        }
        return this.isKnownImmutable(SubstrateObjectConstant.asObject((Constant)constant));
    }

    private boolean isKnownImmutable(Object obj) {
        if (obj instanceof String) {
            return obj.hashCode() != 0;
        }
        return UniverseBuilder.isKnownImmutableType(obj.getClass()) || this.knownImmutableObjects.contains(obj);
    }

    private ObjectInfo addToImageHeap(Object object, HostedClass clazz, long size, int identityHashCode, Object reason) {
        return this.addToImageHeap(SubstrateObjectConstant.forObject(object), clazz, size, identityHashCode, reason);
    }

    private ObjectInfo addToImageHeap(JavaConstant constant, HostedClass clazz, long size, int identityHashCode, Object reason) {
        ObjectInfo info = new ObjectInfo(constant, size, clazz, identityHashCode, reason);
        assert (!this.objects.containsKey(constant) && !NativeImageHeap.isCompressed(constant));
        this.objects.put(constant, info);
        return info;
    }

    @Override
    public ObjectInfo addLateToImageHeap(Object object, Object reason) {
        assert (!(object instanceof DynamicHub)) : "needs a different identity hashcode";
        assert (!(object instanceof String)) : "needs String interning";
        Optional<HostedType> optionalType = this.getMetaAccess().optionalLookupJavaType(object.getClass());
        HostedType type = NativeImageHeap.requireType(optionalType, object, reason);
        return this.addToImageHeap(object, (HostedClass)type, this.getSize(object, type), System.identityHashCode(object), reason);
    }

    private long getSize(Object object, HostedType type) {
        if (type.isInstanceClass()) {
            HostedInstanceClass clazz = (HostedInstanceClass)type;
            assert (!HybridLayout.isHybrid(clazz));
            return LayoutEncoding.getPureInstanceSize(clazz.getHub(), true).rawValue();
        }
        if (type.isArray()) {
            return this.objectLayout.getArraySize(type.getComponentType().getStorageKind(), Array.getLength(object), true);
        }
        throw VMError.shouldNotReachHere();
    }

    private boolean addArrayElements(Object[] array, boolean otherFieldsRelocatable, Object reason) {
        boolean relocatable = otherFieldsRelocatable;
        for (Object element : array) {
            Object value = this.aUniverse.replaceObject(element);
            if (NativeImageHeap.spawnIsolates()) {
                relocatable = relocatable || value instanceof RelocatedPointer;
            }
            this.recursiveAddObject(value, false, reason);
        }
        return relocatable;
    }

    private boolean addConstantArrayElements(JavaConstant array, int length, boolean otherFieldsRelocatable, Object reason) {
        boolean relocatable = otherFieldsRelocatable;
        for (int idx = 0; idx < length; ++idx) {
            JavaConstant value = this.universe.getConstantReflectionProvider().readArrayElement(array, idx);
            if (NativeImageHeap.spawnIsolates()) {
                relocatable = relocatable || this.metaAccess.isInstanceOf(value, RelocatedPointer.class);
            }
            this.recursiveAddConstant(value, false, reason);
        }
        return relocatable;
    }

    private void recursiveAddObject(Object original, boolean immutableFromParent, Object reason) {
        if (original != null) {
            this.addObjectWorklist.push(new AddObjectData(SubstrateObjectConstant.forObject(original), immutableFromParent, reason));
        }
    }

    private void recursiveAddConstant(JavaConstant constant, boolean immutableFromParent, Object reason) {
        if (constant.isNonNull()) {
            this.addObjectWorklist.push(new AddObjectData(constant, immutableFromParent, reason));
        }
    }

    private void processAddObjectWorklist() {
        while (!this.addObjectWorklist.isEmpty()) {
            AddObjectData data = this.addObjectWorklist.pop();
            this.addConstant(data.original, data.immutableFromParent, data.reason);
        }
    }

    protected static final class Phase {
        private PhaseValue value = PhaseValue.BEFORE;

        public static Phase factory() {
            return new Phase();
        }

        public boolean isBefore() {
            return this.value == PhaseValue.BEFORE;
        }

        public void allow() {
            assert (this.value == PhaseValue.BEFORE) : "Can not allow while in phase " + this.value.toString();
            this.value = PhaseValue.ALLOWED;
        }

        void disallow() {
            assert (this.value == PhaseValue.ALLOWED) : "Can not disallow while in phase " + this.value.toString();
            this.value = PhaseValue.AFTER;
        }

        public boolean isAllowed() {
            return this.value == PhaseValue.ALLOWED;
        }

        public String toString() {
            return this.value.toString();
        }

        protected Phase() {
        }

        private static enum PhaseValue {
            BEFORE,
            ALLOWED,
            AFTER;

        }
    }

    public final class ObjectInfo
    implements ImageHeapObject {
        private final JavaConstant constant;
        private final HostedClass clazz;
        private final long size;
        private final int identityHashCode;
        private ImageHeapPartition partition;
        private long offsetInPartition;
        private final Object reason;

        ObjectInfo(JavaConstant constant, long size, HostedClass clazz, int identityHashCode, Object reason) {
            this.constant = constant;
            this.clazz = clazz;
            this.partition = null;
            this.offsetInPartition = -1L;
            this.size = size;
            this.identityHashCode = identityHashCode;
            this.reason = reason;
            if (NativeImageHeap.this.objectReachabilityInfo != null) {
                NativeImageHeap.this.objectReachabilityInfo.put(this, new ObjectReachabilityInfo(this, reason));
            }
        }

        @Override
        public Object getObject() {
            return SubstrateObjectConstant.asObject((Constant)this.constant);
        }

        @Override
        public Class<?> getObjectClass() {
            return this.clazz.getJavaClass();
        }

        @Override
        public JavaConstant getConstant() {
            return this.constant;
        }

        public HostedClass getClazz() {
            return this.clazz;
        }

        @Override
        public long getOffset() {
            assert (this.offsetInPartition >= 0L);
            assert (this.partition != null);
            return this.partition.getStartOffset() + this.offsetInPartition;
        }

        @Override
        public void setOffsetInPartition(long value) {
            assert (this.offsetInPartition == -1L && value >= 0L);
            this.offsetInPartition = value;
        }

        @Override
        public ImageHeapPartition getPartition() {
            return this.partition;
        }

        @Override
        public void setHeapPartition(ImageHeapPartition value) {
            assert (this.partition == null);
            this.partition = value;
        }

        public int getIndexInBuffer(long index) {
            long result = this.getOffset() + index;
            return NumUtil.safeToInt((long)result);
        }

        public long getAddress() {
            return (long)NativeImageHeap.this.imageHeapOffsetInAddressSpace + this.getOffset();
        }

        public long getAddress(long delta) {
            assert (delta >= 0L && delta < this.getSize()) : "Index: " + delta + " out of bounds: [0 .. " + this.getSize() + ").";
            return this.getAddress() + delta;
        }

        @Override
        public long getSize() {
            return this.size;
        }

        int getIdentityHashCode() {
            return this.identityHashCode;
        }

        Object getMainReason() {
            return this.reason;
        }

        public String toString() {
            StringBuilder result = new StringBuilder(((TypedConstant)this.constant).getType((MetaAccessProvider)NativeImageHeap.this.metaAccess).toJavaName(true)).append(":").append(this.identityHashCode).append(" -> ");
            Object cur = this.getMainReason();
            Object prev = null;
            boolean skipped = false;
            while (cur instanceof ObjectInfo) {
                skipped = prev != null;
                prev = cur;
                cur = ((ObjectInfo)cur).getMainReason();
            }
            if (skipped) {
                result.append("... -> ");
            }
            if (prev != null) {
                result.append(prev);
            } else {
                result.append(cur);
            }
            return result.toString();
        }
    }

    static enum HeapInclusionReason {
        InternedStringsTable,
        FillerObject,
        StaticObjectFields,
        DataSection,
        StaticPrimitiveFields,
        Resource;

    }

    final class ObjectReachabilityInfo {
        private final LinkedHashSet<Object> allReasons = new LinkedHashSet();
        private int objectReachabilityGroup;

        ObjectReachabilityInfo(ObjectInfo info, Object firstReason) {
            this.allReasons.add(firstReason);
            this.objectReachabilityGroup = ObjectReachabilityGroup.getFlagForObjectInfo(info, firstReason, NativeImageHeap.this.objectReachabilityInfo);
        }

        void addReason(Object additionalReason) {
            this.allReasons.add(additionalReason);
            this.objectReachabilityGroup |= ObjectReachabilityGroup.getByReason(additionalReason, NativeImageHeap.this.objectReachabilityInfo);
        }

        Set<Object> getAllReasons() {
            return this.allReasons;
        }

        int getObjectReachabilityGroup() {
            return this.objectReachabilityGroup;
        }

        boolean objectReachableFrom(ObjectReachabilityGroup other) {
            return (this.objectReachabilityGroup & other.flag) != 0;
        }
    }

    static class AddObjectData {
        final JavaConstant original;
        final boolean immutableFromParent;
        final Object reason;

        AddObjectData(JavaConstant original, boolean immutableFromParent, Object reason) {
            this.original = original;
            this.immutableFromParent = immutableFromParent;
            this.reason = reason;
        }
    }

    static enum ObjectReachabilityGroup {
        Resources(2, "Resources byte arrays", "resources"),
        InternedStringsTable(4, "Interned strings table", "internedStringsTable"),
        DynamicHubs(8, "Class data", "classData"),
        ImageCodeInfo(16, "Code metadata", "codeMetadata"),
        MethodOrStaticField(32, "Connected components accessed from method or a static field", "connectedComponents"),
        Other(64, "Other", "other");

        public final int flag;
        public final String description;
        public final String name;

        private ObjectReachabilityGroup(int flag, String description, String name) {
            this.flag = flag;
            this.description = description;
            this.name = name;
        }

        static int getFlagForObjectInfo(ObjectInfo object, Object firstReason, Map<ObjectInfo, ObjectReachabilityInfo> additionalReasonInfoHashMap) {
            int result = 0;
            if (object.getObjectClass().equals(ImageCodeInfo.class)) {
                result |= ObjectReachabilityGroup.ImageCodeInfo.flag;
            }
            if (object.getObject().getClass().equals(DynamicHub.class) || object.getObject().getClass().equals(DynamicHubCompanion.class)) {
                result |= ObjectReachabilityGroup.DynamicHubs.flag;
            }
            return result |= ObjectReachabilityGroup.getByReason(firstReason, additionalReasonInfoHashMap);
        }

        static int getByReason(Object reason, Map<ObjectInfo, ObjectReachabilityInfo> additionalReasonInfoHashMap) {
            if (reason.equals((Object)HeapInclusionReason.InternedStringsTable)) {
                return ObjectReachabilityGroup.InternedStringsTable.flag;
            }
            if (reason.equals((Object)HeapInclusionReason.Resource)) {
                return ObjectReachabilityGroup.Resources.flag;
            }
            if (reason instanceof String || reason instanceof HostedField) {
                return ObjectReachabilityGroup.MethodOrStaticField.flag;
            }
            if (reason instanceof ObjectInfo) {
                ObjectInfo r = (ObjectInfo)reason;
                return additionalReasonInfoHashMap.get(r).getObjectReachabilityGroup();
            }
            return ObjectReachabilityGroup.Other.flag;
        }
    }
}

