/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.stubs;

import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.cpufeature.Stubs;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.graal.RuntimeCPUFeatureRegion;
import java.util.EnumSet;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.Stride;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.replacements.StringLatin1InflateNode;
import org.graalvm.compiler.replacements.StringUTF16CompressNode;
import org.graalvm.compiler.replacements.nodes.AESNode;
import org.graalvm.compiler.replacements.nodes.ArrayCompareToNode;
import org.graalvm.compiler.replacements.nodes.ArrayCopyWithConversionsNode;
import org.graalvm.compiler.replacements.nodes.ArrayEqualsNode;
import org.graalvm.compiler.replacements.nodes.ArrayIndexOfNode;
import org.graalvm.compiler.replacements.nodes.ArrayRegionCompareToNode;
import org.graalvm.compiler.replacements.nodes.ArrayRegionEqualsNode;
import org.graalvm.compiler.replacements.nodes.ArrayRegionEqualsWithMaskNode;
import org.graalvm.compiler.replacements.nodes.BigIntegerMulAddNode;
import org.graalvm.compiler.replacements.nodes.BigIntegerMultiplyToLenNode;
import org.graalvm.compiler.replacements.nodes.BigIntegerSquareToLenNode;
import org.graalvm.compiler.replacements.nodes.CalcStringAttributesNode;
import org.graalvm.compiler.replacements.nodes.CipherBlockChainingAESNode;
import org.graalvm.compiler.replacements.nodes.CounterModeAESNode;
import org.graalvm.compiler.replacements.nodes.EncodeArrayNode;
import org.graalvm.compiler.replacements.nodes.GHASHProcessBlocksNode;
import org.graalvm.compiler.replacements.nodes.HasNegativesNode;
import org.graalvm.compiler.replacements.nodes.VectorizedMismatchNode;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.Pointer;

public class SVMIntrinsicStubsGen {
    @Fold
    public static EnumSet<?> ArrayIndexOfNode_getMinimumFeatures() {
        Architecture arch = ((SubstrateTargetDescription)((Object)ImageSingletons.lookup(SubstrateTargetDescription.class))).arch;
        if (arch instanceof AMD64) {
            return ArrayIndexOfNode.amd64FeaturesSSE41();
        }
        if (arch instanceof AArch64) {
            return ArrayIndexOfNode.aarch64FeaturesNone();
        }
        throw GraalError.shouldNotReachHere();
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf1S1(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S1, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf1S1RTC(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class));
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S1, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1);
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf1S2(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S2, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf1S2RTC(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class));
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S2, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1);
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf1S4(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S4, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf1S4RTC(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class));
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S4, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1);
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf2S1(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S1, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf2S1RTC(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class));
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S1, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf2S2(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S2, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf2S2RTC(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class));
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S2, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf2S4(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S4, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf2S4RTC(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class));
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S4, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfRange1S1(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S1, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchRange, (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfRange1S1RTC(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class));
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S1, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchRange, Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
            return n;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfRange1S2(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(SVMIntrinsicStubsGen.ArrayIndexOfNode_getMinimumFeatures());
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S2, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchRange, SVMIntrinsicStubsGen.ArrayIndexOfNode_getMinimumFeatures(), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
            return n;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfRange1S2RTC(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class));
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S2, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchRange, Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
            return n;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfRange1S4(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(SVMIntrinsicStubsGen.ArrayIndexOfNode_getMinimumFeatures());
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S4, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchRange, SVMIntrinsicStubsGen.ArrayIndexOfNode_getMinimumFeatures(), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
            return n;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfRange1S4RTC(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class));
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S4, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchRange, Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfWithMaskS1(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S1, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.WithMask, (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfWithMaskS1RTC(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class));
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S1, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.WithMask, Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfWithMaskS2(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S2, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.WithMask, (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfWithMaskS2RTC(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class));
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S2, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.WithMask, Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfWithMaskS4(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S4, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.WithMask, (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfWithMaskS4RTC(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class));
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S4, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.WithMask, Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTwoConsecutiveS1(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S1, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.FindTwoConsecutive, (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTwoConsecutiveS1RTC(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class));
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S1, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.FindTwoConsecutive, Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTwoConsecutiveS2(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S2, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.FindTwoConsecutive, (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTwoConsecutiveS2RTC(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class));
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S2, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.FindTwoConsecutive, Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTwoConsecutiveS4(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S4, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.FindTwoConsecutive, (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTwoConsecutiveS4RTC(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class));
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S4, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.FindTwoConsecutive, Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf3S1(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S1, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf3S1RTC(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class));
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S1, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3);
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf3S2(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S2, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf3S2RTC(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class));
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S2, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3);
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf3S4(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S4, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf3S4RTC(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class));
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S4, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3);
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf4S1(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S1, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3, (int)v4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf4S1RTC(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class));
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S1, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3, (int)v4);
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf4S2(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S2, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3, (int)v4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf4S2RTC(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class));
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S2, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3, (int)v4);
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf4S4(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S4, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3, (int)v4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf4S4RTC(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class));
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S4, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3, (int)v4);
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfRange2S1(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S1, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchRange, (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3, (int)v4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfRange2S1RTC(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class));
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S1, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchRange, Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3, (int)v4);
            return n;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfRange2S2(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(SVMIntrinsicStubsGen.ArrayIndexOfNode_getMinimumFeatures());
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S2, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchRange, SVMIntrinsicStubsGen.ArrayIndexOfNode_getMinimumFeatures(), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3, (int)v4);
            return n;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfRange2S2RTC(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class));
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S2, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchRange, Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3, (int)v4);
            return n;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfRange2S4(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(SVMIntrinsicStubsGen.ArrayIndexOfNode_getMinimumFeatures());
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S4, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchRange, SVMIntrinsicStubsGen.ArrayIndexOfNode_getMinimumFeatures(), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3, (int)v4);
            return n;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfRange2S4RTC(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class));
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S4, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.MatchRange, Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3, (int)v4);
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTwoConsecutiveWithMaskS1(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S1, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.FindTwoConsecutiveWithMask, (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3, (int)v4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTwoConsecutiveWithMaskS1RTC(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class));
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S1, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.FindTwoConsecutiveWithMask, Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3, (int)v4);
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTwoConsecutiveWithMaskS2(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S2, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.FindTwoConsecutiveWithMask, (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3, (int)v4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTwoConsecutiveWithMaskS2RTC(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class));
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S2, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.FindTwoConsecutiveWithMask, Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3, (int)v4);
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTwoConsecutiveWithMaskS4(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S4, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.FindTwoConsecutiveWithMask, (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3, (int)v4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTwoConsecutiveWithMaskS4RTC(Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class));
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOf((Stride)Stride.S4, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.FindTwoConsecutiveWithMask, Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2, (int)v3, (int)v4);
            return n;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTableS1(Object array, long arrayOffset, int arrayLength, int fromIndex, byte[] tables) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(SVMIntrinsicStubsGen.ArrayIndexOfNode_getMinimumFeatures());
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOfTable((Stride)Stride.S1, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.Table, SVMIntrinsicStubsGen.ArrayIndexOfNode_getMinimumFeatures(), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (byte[])tables);
            return n;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTableS1RTC(Object array, long arrayOffset, int arrayLength, int fromIndex, byte[] tables) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class));
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOfTable((Stride)Stride.S1, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.Table, Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (byte[])tables);
            return n;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTableS2(Object array, long arrayOffset, int arrayLength, int fromIndex, byte[] tables) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(SVMIntrinsicStubsGen.ArrayIndexOfNode_getMinimumFeatures());
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOfTable((Stride)Stride.S2, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.Table, SVMIntrinsicStubsGen.ArrayIndexOfNode_getMinimumFeatures(), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (byte[])tables);
            return n;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTableS2RTC(Object array, long arrayOffset, int arrayLength, int fromIndex, byte[] tables) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class));
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOfTable((Stride)Stride.S2, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.Table, Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (byte[])tables);
            return n;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTableS4(Object array, long arrayOffset, int arrayLength, int fromIndex, byte[] tables) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(SVMIntrinsicStubsGen.ArrayIndexOfNode_getMinimumFeatures());
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOfTable((Stride)Stride.S4, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.Table, SVMIntrinsicStubsGen.ArrayIndexOfNode_getMinimumFeatures(), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (byte[])tables);
            return n;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTableS4RTC(Object array, long arrayOffset, int arrayLength, int fromIndex, byte[] tables) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class));
        try {
            int n = ArrayIndexOfNode.optimizedArrayIndexOfTable((Stride)Stride.S4, (LIRGeneratorTool.ArrayIndexOfVariant)LIRGeneratorTool.ArrayIndexOfVariant.Table, Stubs.getRuntimeCheckedCPUFeatures(ArrayIndexOfNode.class), (Object)array, (long)arrayOffset, (int)arrayLength, (int)fromIndex, (byte[])tables);
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean longArraysEquals(Pointer array1, long offset1, Pointer array2, long offset2, int length) {
        return ArrayEqualsNode.equals((Pointer)array1, (long)offset1, (Pointer)array2, (long)offset2, (int)length, (JavaKind)JavaKind.Long);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean longArraysEqualsRTC(Pointer array1, long offset1, Pointer array2, long offset2, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayEqualsNode.class));
        try {
            boolean bl = ArrayEqualsNode.equals((Pointer)array1, (long)offset1, (Pointer)array2, (long)offset2, (int)length, (JavaKind)JavaKind.Long, Stubs.getRuntimeCheckedCPUFeatures(ArrayEqualsNode.class));
            return bl;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean floatArraysEquals(Pointer array1, long offset1, Pointer array2, long offset2, int length) {
        return ArrayEqualsNode.equals((Pointer)array1, (long)offset1, (Pointer)array2, (long)offset2, (int)length, (JavaKind)JavaKind.Float);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean floatArraysEqualsRTC(Pointer array1, long offset1, Pointer array2, long offset2, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayEqualsNode.class));
        try {
            boolean bl = ArrayEqualsNode.equals((Pointer)array1, (long)offset1, (Pointer)array2, (long)offset2, (int)length, (JavaKind)JavaKind.Float, Stubs.getRuntimeCheckedCPUFeatures(ArrayEqualsNode.class));
            return bl;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean doubleArraysEquals(Pointer array1, long offset1, Pointer array2, long offset2, int length) {
        return ArrayEqualsNode.equals((Pointer)array1, (long)offset1, (Pointer)array2, (long)offset2, (int)length, (JavaKind)JavaKind.Double);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean doubleArraysEqualsRTC(Pointer array1, long offset1, Pointer array2, long offset2, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayEqualsNode.class));
        try {
            boolean bl = ArrayEqualsNode.equals((Pointer)array1, (long)offset1, (Pointer)array2, (long)offset2, (int)length, (JavaKind)JavaKind.Double, Stubs.getRuntimeCheckedCPUFeatures(ArrayEqualsNode.class));
            return bl;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsS1S1(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionEqualsNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S1, (Stride)Stride.S1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsS1S1RTC(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsNode.class));
        try {
            boolean bl = ArrayRegionEqualsNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S1, (Stride)Stride.S1, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsNode.class));
            return bl;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsS1S2(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionEqualsNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S1, (Stride)Stride.S2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsS1S2RTC(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsNode.class));
        try {
            boolean bl = ArrayRegionEqualsNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S1, (Stride)Stride.S2, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsNode.class));
            return bl;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsS1S4(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionEqualsNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S1, (Stride)Stride.S4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsS1S4RTC(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsNode.class));
        try {
            boolean bl = ArrayRegionEqualsNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S1, (Stride)Stride.S4, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsNode.class));
            return bl;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsS2S1(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionEqualsNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S2, (Stride)Stride.S1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsS2S1RTC(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsNode.class));
        try {
            boolean bl = ArrayRegionEqualsNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S2, (Stride)Stride.S1, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsNode.class));
            return bl;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsS2S2(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionEqualsNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S2, (Stride)Stride.S2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsS2S2RTC(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsNode.class));
        try {
            boolean bl = ArrayRegionEqualsNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S2, (Stride)Stride.S2, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsNode.class));
            return bl;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsS2S4(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionEqualsNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S2, (Stride)Stride.S4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsS2S4RTC(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsNode.class));
        try {
            boolean bl = ArrayRegionEqualsNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S2, (Stride)Stride.S4, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsNode.class));
            return bl;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsS4S1(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionEqualsNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S4, (Stride)Stride.S1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsS4S1RTC(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsNode.class));
        try {
            boolean bl = ArrayRegionEqualsNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S4, (Stride)Stride.S1, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsNode.class));
            return bl;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsS4S2(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionEqualsNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S4, (Stride)Stride.S2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsS4S2RTC(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsNode.class));
        try {
            boolean bl = ArrayRegionEqualsNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S4, (Stride)Stride.S2, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsNode.class));
            return bl;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsS4S4(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionEqualsNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S4, (Stride)Stride.S4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsS4S4RTC(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsNode.class));
        try {
            boolean bl = ArrayRegionEqualsNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S4, (Stride)Stride.S4, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsNode.class));
            return bl;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsDynamicStrides(Object arrayA, long offsetA, Object arrayB, long offsetB, int length, int dynamicStrides) {
        return ArrayRegionEqualsNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (int)dynamicStrides);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsDynamicStridesRTC(Object arrayA, long offsetA, Object arrayB, long offsetB, int length, int dynamicStrides) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsNode.class));
        try {
            boolean bl = ArrayRegionEqualsNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (int)dynamicStrides, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsNode.class));
            return bl;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int byteArrayCompareToByteArray(Pointer arrayA, int lengthA, Pointer arrayB, int lengthB) {
        return ArrayCompareToNode.compareTo((Pointer)arrayA, (int)lengthA, (Pointer)arrayB, (int)lengthB, (Stride)Stride.S1, (Stride)Stride.S1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int byteArrayCompareToByteArrayRTC(Pointer arrayA, int lengthA, Pointer arrayB, int lengthB) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayCompareToNode.class));
        try {
            int n = ArrayCompareToNode.compareTo((Pointer)arrayA, (int)lengthA, (Pointer)arrayB, (int)lengthB, (Stride)Stride.S1, (Stride)Stride.S1, Stubs.getRuntimeCheckedCPUFeatures(ArrayCompareToNode.class));
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int byteArrayCompareToCharArray(Pointer arrayA, int lengthA, Pointer arrayB, int lengthB) {
        return ArrayCompareToNode.compareTo((Pointer)arrayA, (int)lengthA, (Pointer)arrayB, (int)lengthB, (Stride)Stride.S1, (Stride)Stride.S2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int byteArrayCompareToCharArrayRTC(Pointer arrayA, int lengthA, Pointer arrayB, int lengthB) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayCompareToNode.class));
        try {
            int n = ArrayCompareToNode.compareTo((Pointer)arrayA, (int)lengthA, (Pointer)arrayB, (int)lengthB, (Stride)Stride.S1, (Stride)Stride.S2, Stubs.getRuntimeCheckedCPUFeatures(ArrayCompareToNode.class));
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int charArrayCompareToByteArray(Pointer arrayA, int lengthA, Pointer arrayB, int lengthB) {
        return ArrayCompareToNode.compareTo((Pointer)arrayA, (int)lengthA, (Pointer)arrayB, (int)lengthB, (Stride)Stride.S2, (Stride)Stride.S1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int charArrayCompareToByteArrayRTC(Pointer arrayA, int lengthA, Pointer arrayB, int lengthB) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayCompareToNode.class));
        try {
            int n = ArrayCompareToNode.compareTo((Pointer)arrayA, (int)lengthA, (Pointer)arrayB, (int)lengthB, (Stride)Stride.S2, (Stride)Stride.S1, Stubs.getRuntimeCheckedCPUFeatures(ArrayCompareToNode.class));
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int charArrayCompareToCharArray(Pointer arrayA, int lengthA, Pointer arrayB, int lengthB) {
        return ArrayCompareToNode.compareTo((Pointer)arrayA, (int)lengthA, (Pointer)arrayB, (int)lengthB, (Stride)Stride.S2, (Stride)Stride.S2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int charArrayCompareToCharArrayRTC(Pointer arrayA, int lengthA, Pointer arrayB, int lengthB) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayCompareToNode.class));
        try {
            int n = ArrayCompareToNode.compareTo((Pointer)arrayA, (int)lengthA, (Pointer)arrayB, (int)lengthB, (Stride)Stride.S2, (Stride)Stride.S2, Stubs.getRuntimeCheckedCPUFeatures(ArrayCompareToNode.class));
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int arrayRegionCompareToS1S1(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionCompareToNode.compare((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S1, (Stride)Stride.S1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int arrayRegionCompareToS1S1RTC(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionCompareToNode.class));
        try {
            int n = ArrayRegionCompareToNode.compare((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S1, (Stride)Stride.S1, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionCompareToNode.class));
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int arrayRegionCompareToS1S2(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionCompareToNode.compare((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S1, (Stride)Stride.S2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int arrayRegionCompareToS1S2RTC(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionCompareToNode.class));
        try {
            int n = ArrayRegionCompareToNode.compare((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S1, (Stride)Stride.S2, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionCompareToNode.class));
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int arrayRegionCompareToS1S4(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionCompareToNode.compare((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S1, (Stride)Stride.S4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int arrayRegionCompareToS1S4RTC(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionCompareToNode.class));
        try {
            int n = ArrayRegionCompareToNode.compare((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S1, (Stride)Stride.S4, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionCompareToNode.class));
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int arrayRegionCompareToS2S1(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionCompareToNode.compare((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S2, (Stride)Stride.S1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int arrayRegionCompareToS2S1RTC(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionCompareToNode.class));
        try {
            int n = ArrayRegionCompareToNode.compare((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S2, (Stride)Stride.S1, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionCompareToNode.class));
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int arrayRegionCompareToS2S2(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionCompareToNode.compare((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S2, (Stride)Stride.S2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int arrayRegionCompareToS2S2RTC(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionCompareToNode.class));
        try {
            int n = ArrayRegionCompareToNode.compare((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S2, (Stride)Stride.S2, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionCompareToNode.class));
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int arrayRegionCompareToS2S4(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionCompareToNode.compare((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S2, (Stride)Stride.S4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int arrayRegionCompareToS2S4RTC(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionCompareToNode.class));
        try {
            int n = ArrayRegionCompareToNode.compare((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S2, (Stride)Stride.S4, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionCompareToNode.class));
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int arrayRegionCompareToS4S1(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionCompareToNode.compare((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S4, (Stride)Stride.S1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int arrayRegionCompareToS4S1RTC(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionCompareToNode.class));
        try {
            int n = ArrayRegionCompareToNode.compare((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S4, (Stride)Stride.S1, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionCompareToNode.class));
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int arrayRegionCompareToS4S2(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionCompareToNode.compare((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S4, (Stride)Stride.S2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int arrayRegionCompareToS4S2RTC(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionCompareToNode.class));
        try {
            int n = ArrayRegionCompareToNode.compare((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S4, (Stride)Stride.S2, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionCompareToNode.class));
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int arrayRegionCompareToS4S4(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionCompareToNode.compare((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S4, (Stride)Stride.S4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int arrayRegionCompareToS4S4RTC(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionCompareToNode.class));
        try {
            int n = ArrayRegionCompareToNode.compare((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (Stride)Stride.S4, (Stride)Stride.S4, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionCompareToNode.class));
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int arrayRegionCompareToDynamicStrides(Object arrayA, long offsetA, Object arrayB, long offsetB, int length, int dynamicStrides) {
        return ArrayRegionCompareToNode.compare((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (int)dynamicStrides);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int arrayRegionCompareToDynamicStridesRTC(Object arrayA, long offsetA, Object arrayB, long offsetB, int length, int dynamicStrides) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionCompareToNode.class));
        try {
            int n = ArrayRegionCompareToNode.compare((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (int)length, (int)dynamicStrides, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionCompareToNode.class));
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void arrayCopyWithConversionsS1S1(Object arraySrc, long offsetSrc, Object arrayDst, long offsetDst, int length) {
        ArrayCopyWithConversionsNode.arrayCopy((Object)arraySrc, (long)offsetSrc, (Object)arrayDst, (long)offsetDst, (int)length, (Stride)Stride.S1, (Stride)Stride.S1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void arrayCopyWithConversionsS1S1RTC(Object arraySrc, long offsetSrc, Object arrayDst, long offsetDst, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayCopyWithConversionsNode.class));
        try {
            ArrayCopyWithConversionsNode.arrayCopy((Object)arraySrc, (long)offsetSrc, (Object)arrayDst, (long)offsetDst, (int)length, (Stride)Stride.S1, (Stride)Stride.S1, Stubs.getRuntimeCheckedCPUFeatures(ArrayCopyWithConversionsNode.class));
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void arrayCopyWithConversionsS1S2(Object arraySrc, long offsetSrc, Object arrayDst, long offsetDst, int length) {
        ArrayCopyWithConversionsNode.arrayCopy((Object)arraySrc, (long)offsetSrc, (Object)arrayDst, (long)offsetDst, (int)length, (Stride)Stride.S1, (Stride)Stride.S2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void arrayCopyWithConversionsS1S2RTC(Object arraySrc, long offsetSrc, Object arrayDst, long offsetDst, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayCopyWithConversionsNode.class));
        try {
            ArrayCopyWithConversionsNode.arrayCopy((Object)arraySrc, (long)offsetSrc, (Object)arrayDst, (long)offsetDst, (int)length, (Stride)Stride.S1, (Stride)Stride.S2, Stubs.getRuntimeCheckedCPUFeatures(ArrayCopyWithConversionsNode.class));
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void arrayCopyWithConversionsS1S4(Object arraySrc, long offsetSrc, Object arrayDst, long offsetDst, int length) {
        ArrayCopyWithConversionsNode.arrayCopy((Object)arraySrc, (long)offsetSrc, (Object)arrayDst, (long)offsetDst, (int)length, (Stride)Stride.S1, (Stride)Stride.S4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void arrayCopyWithConversionsS1S4RTC(Object arraySrc, long offsetSrc, Object arrayDst, long offsetDst, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayCopyWithConversionsNode.class));
        try {
            ArrayCopyWithConversionsNode.arrayCopy((Object)arraySrc, (long)offsetSrc, (Object)arrayDst, (long)offsetDst, (int)length, (Stride)Stride.S1, (Stride)Stride.S4, Stubs.getRuntimeCheckedCPUFeatures(ArrayCopyWithConversionsNode.class));
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void arrayCopyWithConversionsS2S1(Object arraySrc, long offsetSrc, Object arrayDst, long offsetDst, int length) {
        ArrayCopyWithConversionsNode.arrayCopy((Object)arraySrc, (long)offsetSrc, (Object)arrayDst, (long)offsetDst, (int)length, (Stride)Stride.S2, (Stride)Stride.S1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void arrayCopyWithConversionsS2S1RTC(Object arraySrc, long offsetSrc, Object arrayDst, long offsetDst, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayCopyWithConversionsNode.class));
        try {
            ArrayCopyWithConversionsNode.arrayCopy((Object)arraySrc, (long)offsetSrc, (Object)arrayDst, (long)offsetDst, (int)length, (Stride)Stride.S2, (Stride)Stride.S1, Stubs.getRuntimeCheckedCPUFeatures(ArrayCopyWithConversionsNode.class));
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void arrayCopyWithConversionsS2S2(Object arraySrc, long offsetSrc, Object arrayDst, long offsetDst, int length) {
        ArrayCopyWithConversionsNode.arrayCopy((Object)arraySrc, (long)offsetSrc, (Object)arrayDst, (long)offsetDst, (int)length, (Stride)Stride.S2, (Stride)Stride.S2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void arrayCopyWithConversionsS2S2RTC(Object arraySrc, long offsetSrc, Object arrayDst, long offsetDst, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayCopyWithConversionsNode.class));
        try {
            ArrayCopyWithConversionsNode.arrayCopy((Object)arraySrc, (long)offsetSrc, (Object)arrayDst, (long)offsetDst, (int)length, (Stride)Stride.S2, (Stride)Stride.S2, Stubs.getRuntimeCheckedCPUFeatures(ArrayCopyWithConversionsNode.class));
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void arrayCopyWithConversionsS2S4(Object arraySrc, long offsetSrc, Object arrayDst, long offsetDst, int length) {
        ArrayCopyWithConversionsNode.arrayCopy((Object)arraySrc, (long)offsetSrc, (Object)arrayDst, (long)offsetDst, (int)length, (Stride)Stride.S2, (Stride)Stride.S4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void arrayCopyWithConversionsS2S4RTC(Object arraySrc, long offsetSrc, Object arrayDst, long offsetDst, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayCopyWithConversionsNode.class));
        try {
            ArrayCopyWithConversionsNode.arrayCopy((Object)arraySrc, (long)offsetSrc, (Object)arrayDst, (long)offsetDst, (int)length, (Stride)Stride.S2, (Stride)Stride.S4, Stubs.getRuntimeCheckedCPUFeatures(ArrayCopyWithConversionsNode.class));
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void arrayCopyWithConversionsS4S1(Object arraySrc, long offsetSrc, Object arrayDst, long offsetDst, int length) {
        ArrayCopyWithConversionsNode.arrayCopy((Object)arraySrc, (long)offsetSrc, (Object)arrayDst, (long)offsetDst, (int)length, (Stride)Stride.S4, (Stride)Stride.S1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void arrayCopyWithConversionsS4S1RTC(Object arraySrc, long offsetSrc, Object arrayDst, long offsetDst, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayCopyWithConversionsNode.class));
        try {
            ArrayCopyWithConversionsNode.arrayCopy((Object)arraySrc, (long)offsetSrc, (Object)arrayDst, (long)offsetDst, (int)length, (Stride)Stride.S4, (Stride)Stride.S1, Stubs.getRuntimeCheckedCPUFeatures(ArrayCopyWithConversionsNode.class));
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void arrayCopyWithConversionsS4S2(Object arraySrc, long offsetSrc, Object arrayDst, long offsetDst, int length) {
        ArrayCopyWithConversionsNode.arrayCopy((Object)arraySrc, (long)offsetSrc, (Object)arrayDst, (long)offsetDst, (int)length, (Stride)Stride.S4, (Stride)Stride.S2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void arrayCopyWithConversionsS4S2RTC(Object arraySrc, long offsetSrc, Object arrayDst, long offsetDst, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayCopyWithConversionsNode.class));
        try {
            ArrayCopyWithConversionsNode.arrayCopy((Object)arraySrc, (long)offsetSrc, (Object)arrayDst, (long)offsetDst, (int)length, (Stride)Stride.S4, (Stride)Stride.S2, Stubs.getRuntimeCheckedCPUFeatures(ArrayCopyWithConversionsNode.class));
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void arrayCopyWithConversionsS4S4(Object arraySrc, long offsetSrc, Object arrayDst, long offsetDst, int length) {
        ArrayCopyWithConversionsNode.arrayCopy((Object)arraySrc, (long)offsetSrc, (Object)arrayDst, (long)offsetDst, (int)length, (Stride)Stride.S4, (Stride)Stride.S4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void arrayCopyWithConversionsS4S4RTC(Object arraySrc, long offsetSrc, Object arrayDst, long offsetDst, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayCopyWithConversionsNode.class));
        try {
            ArrayCopyWithConversionsNode.arrayCopy((Object)arraySrc, (long)offsetSrc, (Object)arrayDst, (long)offsetDst, (int)length, (Stride)Stride.S4, (Stride)Stride.S4, Stubs.getRuntimeCheckedCPUFeatures(ArrayCopyWithConversionsNode.class));
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void arrayCopyWithConversionsDynamicStrides(Object arraySrc, long offsetSrc, Object arrayDst, long offsetDst, int length, int stride) {
        ArrayCopyWithConversionsNode.arrayCopy((Object)arraySrc, (long)offsetSrc, (Object)arrayDst, (long)offsetDst, (int)length, (int)stride);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void arrayCopyWithConversionsDynamicStridesRTC(Object arraySrc, long offsetSrc, Object arrayDst, long offsetDst, int length, int stride) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayCopyWithConversionsNode.class));
        try {
            ArrayCopyWithConversionsNode.arrayCopy((Object)arraySrc, (long)offsetSrc, (Object)arrayDst, (long)offsetDst, (int)length, (int)stride, Stubs.getRuntimeCheckedCPUFeatures(ArrayCopyWithConversionsNode.class));
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int stringUTF16Compress(Pointer src, Pointer dst, int len) {
        return StringUTF16CompressNode.stringUTF16Compress((Pointer)src, (Pointer)dst, (int)len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int stringUTF16CompressRTC(Pointer src, Pointer dst, int len) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(StringUTF16CompressNode.class));
        try {
            int n = StringUTF16CompressNode.stringUTF16Compress((Pointer)src, (Pointer)dst, (int)len, Stubs.getRuntimeCheckedCPUFeatures(StringUTF16CompressNode.class));
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void stringLatin1Inflate(Pointer src, Pointer dst, int len) {
        StringLatin1InflateNode.stringLatin1Inflate((Pointer)src, (Pointer)dst, (int)len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void stringLatin1InflateRTC(Pointer src, Pointer dst, int len) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(StringLatin1InflateNode.class));
        try {
            StringLatin1InflateNode.stringLatin1Inflate((Pointer)src, (Pointer)dst, (int)len, Stubs.getRuntimeCheckedCPUFeatures(StringLatin1InflateNode.class));
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean stringCodingHasNegatives(Pointer array, int len) {
        return HasNegativesNode.stringCodingHasNegatives((Pointer)array, (int)len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean stringCodingHasNegativesRTC(Pointer array, int len) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(HasNegativesNode.class));
        try {
            boolean bl = HasNegativesNode.stringCodingHasNegatives((Pointer)array, (int)len, Stubs.getRuntimeCheckedCPUFeatures(HasNegativesNode.class));
            return bl;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int stringCodingEncodeArrayAscii(Pointer src, Pointer dst, int len) {
        return EncodeArrayNode.stringCodingEncodeArray((Pointer)src, (Pointer)dst, (int)len, (LIRGeneratorTool.CharsetName)LIRGeneratorTool.CharsetName.ASCII);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int stringCodingEncodeArrayAsciiRTC(Pointer src, Pointer dst, int len) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(EncodeArrayNode.class));
        try {
            int n = EncodeArrayNode.stringCodingEncodeArray((Pointer)src, (Pointer)dst, (int)len, (LIRGeneratorTool.CharsetName)LIRGeneratorTool.CharsetName.ASCII, Stubs.getRuntimeCheckedCPUFeatures(EncodeArrayNode.class));
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int stringCodingEncodeArrayLatin1(Pointer src, Pointer dst, int len) {
        return EncodeArrayNode.stringCodingEncodeArray((Pointer)src, (Pointer)dst, (int)len, (LIRGeneratorTool.CharsetName)LIRGeneratorTool.CharsetName.ISO_8859_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int stringCodingEncodeArrayLatin1RTC(Pointer src, Pointer dst, int len) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(EncodeArrayNode.class));
        try {
            int n = EncodeArrayNode.stringCodingEncodeArray((Pointer)src, (Pointer)dst, (int)len, (LIRGeneratorTool.CharsetName)LIRGeneratorTool.CharsetName.ISO_8859_1, Stubs.getRuntimeCheckedCPUFeatures(EncodeArrayNode.class));
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int vectorizedMismatch(Pointer arrayA, Pointer arrayB, int length, int stride) {
        return VectorizedMismatchNode.vectorizedMismatch((Pointer)arrayA, (Pointer)arrayB, (int)length, (int)stride);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int vectorizedMismatchRTC(Pointer arrayA, Pointer arrayB, int length, int stride) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(VectorizedMismatchNode.class));
        try {
            int n = VectorizedMismatchNode.vectorizedMismatch((Pointer)arrayA, (Pointer)arrayB, (int)length, (int)stride, Stubs.getRuntimeCheckedCPUFeatures(VectorizedMismatchNode.class));
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsWithMaskS1S2S1(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        return ArrayRegionEqualsWithMaskNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (Pointer)mask, (int)length, (Stride)Stride.S1, (Stride)Stride.S2, (Stride)Stride.S1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsWithMaskS1S2S1RTC(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsWithMaskNode.class));
        try {
            boolean bl = ArrayRegionEqualsWithMaskNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (Pointer)mask, (int)length, (Stride)Stride.S1, (Stride)Stride.S2, (Stride)Stride.S1, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsWithMaskNode.class));
            return bl;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsWithMaskS2S2S1(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        return ArrayRegionEqualsWithMaskNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (Pointer)mask, (int)length, (Stride)Stride.S2, (Stride)Stride.S2, (Stride)Stride.S1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsWithMaskS2S2S1RTC(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsWithMaskNode.class));
        try {
            boolean bl = ArrayRegionEqualsWithMaskNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (Pointer)mask, (int)length, (Stride)Stride.S2, (Stride)Stride.S2, (Stride)Stride.S1, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsWithMaskNode.class));
            return bl;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsWithMaskS1S1(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        return ArrayRegionEqualsWithMaskNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (Pointer)mask, (int)length, (Stride)Stride.S1, (Stride)Stride.S1, (Stride)Stride.S1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsWithMaskS1S1RTC(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsWithMaskNode.class));
        try {
            boolean bl = ArrayRegionEqualsWithMaskNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (Pointer)mask, (int)length, (Stride)Stride.S1, (Stride)Stride.S1, (Stride)Stride.S1, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsWithMaskNode.class));
            return bl;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsWithMaskS1S2(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        return ArrayRegionEqualsWithMaskNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (Pointer)mask, (int)length, (Stride)Stride.S1, (Stride)Stride.S2, (Stride)Stride.S2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsWithMaskS1S2RTC(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsWithMaskNode.class));
        try {
            boolean bl = ArrayRegionEqualsWithMaskNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (Pointer)mask, (int)length, (Stride)Stride.S1, (Stride)Stride.S2, (Stride)Stride.S2, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsWithMaskNode.class));
            return bl;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsWithMaskS1S4(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        return ArrayRegionEqualsWithMaskNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (Pointer)mask, (int)length, (Stride)Stride.S1, (Stride)Stride.S4, (Stride)Stride.S4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsWithMaskS1S4RTC(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsWithMaskNode.class));
        try {
            boolean bl = ArrayRegionEqualsWithMaskNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (Pointer)mask, (int)length, (Stride)Stride.S1, (Stride)Stride.S4, (Stride)Stride.S4, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsWithMaskNode.class));
            return bl;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsWithMaskS2S1(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        return ArrayRegionEqualsWithMaskNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (Pointer)mask, (int)length, (Stride)Stride.S2, (Stride)Stride.S1, (Stride)Stride.S1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsWithMaskS2S1RTC(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsWithMaskNode.class));
        try {
            boolean bl = ArrayRegionEqualsWithMaskNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (Pointer)mask, (int)length, (Stride)Stride.S2, (Stride)Stride.S1, (Stride)Stride.S1, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsWithMaskNode.class));
            return bl;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsWithMaskS2S2(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        return ArrayRegionEqualsWithMaskNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (Pointer)mask, (int)length, (Stride)Stride.S2, (Stride)Stride.S2, (Stride)Stride.S2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsWithMaskS2S2RTC(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsWithMaskNode.class));
        try {
            boolean bl = ArrayRegionEqualsWithMaskNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (Pointer)mask, (int)length, (Stride)Stride.S2, (Stride)Stride.S2, (Stride)Stride.S2, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsWithMaskNode.class));
            return bl;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsWithMaskS2S4(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        return ArrayRegionEqualsWithMaskNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (Pointer)mask, (int)length, (Stride)Stride.S2, (Stride)Stride.S4, (Stride)Stride.S4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsWithMaskS2S4RTC(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsWithMaskNode.class));
        try {
            boolean bl = ArrayRegionEqualsWithMaskNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (Pointer)mask, (int)length, (Stride)Stride.S2, (Stride)Stride.S4, (Stride)Stride.S4, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsWithMaskNode.class));
            return bl;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsWithMaskS4S1(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        return ArrayRegionEqualsWithMaskNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (Pointer)mask, (int)length, (Stride)Stride.S4, (Stride)Stride.S1, (Stride)Stride.S1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsWithMaskS4S1RTC(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsWithMaskNode.class));
        try {
            boolean bl = ArrayRegionEqualsWithMaskNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (Pointer)mask, (int)length, (Stride)Stride.S4, (Stride)Stride.S1, (Stride)Stride.S1, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsWithMaskNode.class));
            return bl;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsWithMaskS4S2(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        return ArrayRegionEqualsWithMaskNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (Pointer)mask, (int)length, (Stride)Stride.S4, (Stride)Stride.S2, (Stride)Stride.S2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsWithMaskS4S2RTC(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsWithMaskNode.class));
        try {
            boolean bl = ArrayRegionEqualsWithMaskNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (Pointer)mask, (int)length, (Stride)Stride.S4, (Stride)Stride.S2, (Stride)Stride.S2, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsWithMaskNode.class));
            return bl;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsWithMaskS4S4(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        return ArrayRegionEqualsWithMaskNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (Pointer)mask, (int)length, (Stride)Stride.S4, (Stride)Stride.S4, (Stride)Stride.S4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsWithMaskS4S4RTC(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsWithMaskNode.class));
        try {
            boolean bl = ArrayRegionEqualsWithMaskNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (Pointer)mask, (int)length, (Stride)Stride.S4, (Stride)Stride.S4, (Stride)Stride.S4, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsWithMaskNode.class));
            return bl;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsWithMaskDynamicStrides(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length, int stride) {
        return ArrayRegionEqualsWithMaskNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (Pointer)mask, (int)length, (int)stride);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static boolean arrayRegionEqualsWithMaskDynamicStridesRTC(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length, int stride) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsWithMaskNode.class));
        try {
            boolean bl = ArrayRegionEqualsWithMaskNode.regionEquals((Object)arrayA, (long)offsetA, (Object)arrayB, (long)offsetB, (Pointer)mask, (int)length, (int)stride, Stubs.getRuntimeCheckedCPUFeatures(ArrayRegionEqualsWithMaskNode.class));
            return bl;
        }
        finally {
            region.leave();
        }
    }

    @Fold
    public static EnumSet<?> CalcStringAttributesNode_getMinimumFeatures() {
        Architecture arch = ((SubstrateTargetDescription)((Object)ImageSingletons.lookup(SubstrateTargetDescription.class))).arch;
        if (arch instanceof AMD64) {
            return CalcStringAttributesNode.minFeaturesAMD64();
        }
        if (arch instanceof AArch64) {
            return CalcStringAttributesNode.minFeaturesAARCH64();
        }
        throw GraalError.shouldNotReachHere();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int calcStringAttributesLatin1(Object array, long offset, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(SVMIntrinsicStubsGen.CalcStringAttributesNode_getMinimumFeatures());
        try {
            int n = CalcStringAttributesNode.intReturnValue((Object)array, (long)offset, (int)length, (LIRGeneratorTool.CalcStringAttributesEncoding)LIRGeneratorTool.CalcStringAttributesEncoding.LATIN1, (boolean)false, SVMIntrinsicStubsGen.CalcStringAttributesNode_getMinimumFeatures());
            return n;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int calcStringAttributesLatin1RTC(Object array, long offset, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(CalcStringAttributesNode.class));
        try {
            int n = CalcStringAttributesNode.intReturnValue((Object)array, (long)offset, (int)length, (LIRGeneratorTool.CalcStringAttributesEncoding)LIRGeneratorTool.CalcStringAttributesEncoding.LATIN1, (boolean)false, Stubs.getRuntimeCheckedCPUFeatures(CalcStringAttributesNode.class));
            return n;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int calcStringAttributesBMP(Object array, long offset, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(SVMIntrinsicStubsGen.CalcStringAttributesNode_getMinimumFeatures());
        try {
            int n = CalcStringAttributesNode.intReturnValue((Object)array, (long)offset, (int)length, (LIRGeneratorTool.CalcStringAttributesEncoding)LIRGeneratorTool.CalcStringAttributesEncoding.BMP, (boolean)false, SVMIntrinsicStubsGen.CalcStringAttributesNode_getMinimumFeatures());
            return n;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int calcStringAttributesBMPRTC(Object array, long offset, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(CalcStringAttributesNode.class));
        try {
            int n = CalcStringAttributesNode.intReturnValue((Object)array, (long)offset, (int)length, (LIRGeneratorTool.CalcStringAttributesEncoding)LIRGeneratorTool.CalcStringAttributesEncoding.BMP, (boolean)false, Stubs.getRuntimeCheckedCPUFeatures(CalcStringAttributesNode.class));
            return n;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int calcStringAttributesUTF32(Object array, long offset, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(SVMIntrinsicStubsGen.CalcStringAttributesNode_getMinimumFeatures());
        try {
            int n = CalcStringAttributesNode.intReturnValue((Object)array, (long)offset, (int)length, (LIRGeneratorTool.CalcStringAttributesEncoding)LIRGeneratorTool.CalcStringAttributesEncoding.UTF_32, (boolean)false, SVMIntrinsicStubsGen.CalcStringAttributesNode_getMinimumFeatures());
            return n;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int calcStringAttributesUTF32RTC(Object array, long offset, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(CalcStringAttributesNode.class));
        try {
            int n = CalcStringAttributesNode.intReturnValue((Object)array, (long)offset, (int)length, (LIRGeneratorTool.CalcStringAttributesEncoding)LIRGeneratorTool.CalcStringAttributesEncoding.UTF_32, (boolean)false, Stubs.getRuntimeCheckedCPUFeatures(CalcStringAttributesNode.class));
            return n;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static long calcStringAttributesUTF8Valid(Object array, long offset, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(SVMIntrinsicStubsGen.CalcStringAttributesNode_getMinimumFeatures());
        try {
            long l = CalcStringAttributesNode.longReturnValue((Object)array, (long)offset, (int)length, (LIRGeneratorTool.CalcStringAttributesEncoding)LIRGeneratorTool.CalcStringAttributesEncoding.UTF_8, (boolean)true, SVMIntrinsicStubsGen.CalcStringAttributesNode_getMinimumFeatures());
            return l;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static long calcStringAttributesUTF8ValidRTC(Object array, long offset, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(CalcStringAttributesNode.class));
        try {
            long l = CalcStringAttributesNode.longReturnValue((Object)array, (long)offset, (int)length, (LIRGeneratorTool.CalcStringAttributesEncoding)LIRGeneratorTool.CalcStringAttributesEncoding.UTF_8, (boolean)true, Stubs.getRuntimeCheckedCPUFeatures(CalcStringAttributesNode.class));
            return l;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static long calcStringAttributesUTF8Unknown(Object array, long offset, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(SVMIntrinsicStubsGen.CalcStringAttributesNode_getMinimumFeatures());
        try {
            long l = CalcStringAttributesNode.longReturnValue((Object)array, (long)offset, (int)length, (LIRGeneratorTool.CalcStringAttributesEncoding)LIRGeneratorTool.CalcStringAttributesEncoding.UTF_8, (boolean)false, SVMIntrinsicStubsGen.CalcStringAttributesNode_getMinimumFeatures());
            return l;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static long calcStringAttributesUTF8UnknownRTC(Object array, long offset, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(CalcStringAttributesNode.class));
        try {
            long l = CalcStringAttributesNode.longReturnValue((Object)array, (long)offset, (int)length, (LIRGeneratorTool.CalcStringAttributesEncoding)LIRGeneratorTool.CalcStringAttributesEncoding.UTF_8, (boolean)false, Stubs.getRuntimeCheckedCPUFeatures(CalcStringAttributesNode.class));
            return l;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static long calcStringAttributesUTF16Valid(Object array, long offset, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(SVMIntrinsicStubsGen.CalcStringAttributesNode_getMinimumFeatures());
        try {
            long l = CalcStringAttributesNode.longReturnValue((Object)array, (long)offset, (int)length, (LIRGeneratorTool.CalcStringAttributesEncoding)LIRGeneratorTool.CalcStringAttributesEncoding.UTF_16, (boolean)true, SVMIntrinsicStubsGen.CalcStringAttributesNode_getMinimumFeatures());
            return l;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static long calcStringAttributesUTF16ValidRTC(Object array, long offset, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(CalcStringAttributesNode.class));
        try {
            long l = CalcStringAttributesNode.longReturnValue((Object)array, (long)offset, (int)length, (LIRGeneratorTool.CalcStringAttributesEncoding)LIRGeneratorTool.CalcStringAttributesEncoding.UTF_16, (boolean)true, Stubs.getRuntimeCheckedCPUFeatures(CalcStringAttributesNode.class));
            return l;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static long calcStringAttributesUTF16Unknown(Object array, long offset, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(SVMIntrinsicStubsGen.CalcStringAttributesNode_getMinimumFeatures());
        try {
            long l = CalcStringAttributesNode.longReturnValue((Object)array, (long)offset, (int)length, (LIRGeneratorTool.CalcStringAttributesEncoding)LIRGeneratorTool.CalcStringAttributesEncoding.UTF_16, (boolean)false, SVMIntrinsicStubsGen.CalcStringAttributesNode_getMinimumFeatures());
            return l;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static long calcStringAttributesUTF16UnknownRTC(Object array, long offset, int length) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(CalcStringAttributesNode.class));
        try {
            long l = CalcStringAttributesNode.longReturnValue((Object)array, (long)offset, (int)length, (LIRGeneratorTool.CalcStringAttributesEncoding)LIRGeneratorTool.CalcStringAttributesEncoding.UTF_16, (boolean)false, Stubs.getRuntimeCheckedCPUFeatures(CalcStringAttributesNode.class));
            return l;
        }
        finally {
            region.leave();
        }
    }

    @Fold
    public static EnumSet<?> AESNode_getMinimumFeatures() {
        Architecture arch = ((SubstrateTargetDescription)((Object)ImageSingletons.lookup(SubstrateTargetDescription.class))).arch;
        if (arch instanceof AMD64) {
            return AESNode.minFeaturesAMD64();
        }
        if (arch instanceof AArch64) {
            return AESNode.minFeaturesAARCH64();
        }
        throw GraalError.shouldNotReachHere();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void aesEncrypt(Pointer from, Pointer to, Pointer key) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(SVMIntrinsicStubsGen.AESNode_getMinimumFeatures());
        try {
            AESNode.apply((Pointer)from, (Pointer)to, (Pointer)key, (AESNode.CryptMode)AESNode.CryptMode.ENCRYPT, SVMIntrinsicStubsGen.AESNode_getMinimumFeatures());
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void aesEncryptRTC(Pointer from, Pointer to, Pointer key) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(AESNode.class));
        try {
            AESNode.apply((Pointer)from, (Pointer)to, (Pointer)key, (AESNode.CryptMode)AESNode.CryptMode.ENCRYPT, Stubs.getRuntimeCheckedCPUFeatures(AESNode.class));
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void aesDecrypt(Pointer from, Pointer to, Pointer key) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(SVMIntrinsicStubsGen.AESNode_getMinimumFeatures());
        try {
            AESNode.apply((Pointer)from, (Pointer)to, (Pointer)key, (AESNode.CryptMode)AESNode.CryptMode.DECRYPT, SVMIntrinsicStubsGen.AESNode_getMinimumFeatures());
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void aesDecryptRTC(Pointer from, Pointer to, Pointer key) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(AESNode.class));
        try {
            AESNode.apply((Pointer)from, (Pointer)to, (Pointer)key, (AESNode.CryptMode)AESNode.CryptMode.DECRYPT, Stubs.getRuntimeCheckedCPUFeatures(AESNode.class));
        }
        finally {
            region.leave();
        }
    }

    @Fold
    public static EnumSet<?> CounterModeAESNode_getMinimumFeatures() {
        Architecture arch = ((SubstrateTargetDescription)((Object)ImageSingletons.lookup(SubstrateTargetDescription.class))).arch;
        if (arch instanceof AMD64) {
            return CounterModeAESNode.minFeaturesAMD64();
        }
        if (arch instanceof AArch64) {
            return CounterModeAESNode.minFeaturesAARCH64();
        }
        throw GraalError.shouldNotReachHere();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int ctrAESCrypt(Pointer inAddr, Pointer outAddr, Pointer kAddr, Pointer counterAddr, int len, Pointer encryptedCounterAddr, Pointer usedPtr) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(SVMIntrinsicStubsGen.CounterModeAESNode_getMinimumFeatures());
        try {
            int n = CounterModeAESNode.apply((Pointer)inAddr, (Pointer)outAddr, (Pointer)kAddr, (Pointer)counterAddr, (int)len, (Pointer)encryptedCounterAddr, (Pointer)usedPtr, SVMIntrinsicStubsGen.CounterModeAESNode_getMinimumFeatures());
            return n;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int ctrAESCryptRTC(Pointer inAddr, Pointer outAddr, Pointer kAddr, Pointer counterAddr, int len, Pointer encryptedCounterAddr, Pointer usedPtr) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(CounterModeAESNode.class));
        try {
            int n = CounterModeAESNode.apply((Pointer)inAddr, (Pointer)outAddr, (Pointer)kAddr, (Pointer)counterAddr, (int)len, (Pointer)encryptedCounterAddr, (Pointer)usedPtr, Stubs.getRuntimeCheckedCPUFeatures(CounterModeAESNode.class));
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Fold
    public static EnumSet<?> CipherBlockChainingAESNode_getMinimumFeatures() {
        Architecture arch = ((SubstrateTargetDescription)((Object)ImageSingletons.lookup(SubstrateTargetDescription.class))).arch;
        if (arch instanceof AMD64) {
            return CipherBlockChainingAESNode.minFeaturesAMD64();
        }
        if (arch instanceof AArch64) {
            return CipherBlockChainingAESNode.minFeaturesAARCH64();
        }
        throw GraalError.shouldNotReachHere();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int cbcAESEncrypt(Pointer from, Pointer to, Pointer key, Pointer r, int len) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(SVMIntrinsicStubsGen.CipherBlockChainingAESNode_getMinimumFeatures());
        try {
            int n = CipherBlockChainingAESNode.apply((Pointer)from, (Pointer)to, (Pointer)key, (Pointer)r, (int)len, (AESNode.CryptMode)AESNode.CryptMode.ENCRYPT, SVMIntrinsicStubsGen.CipherBlockChainingAESNode_getMinimumFeatures());
            return n;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int cbcAESEncryptRTC(Pointer from, Pointer to, Pointer key, Pointer r, int len) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(CipherBlockChainingAESNode.class));
        try {
            int n = CipherBlockChainingAESNode.apply((Pointer)from, (Pointer)to, (Pointer)key, (Pointer)r, (int)len, (AESNode.CryptMode)AESNode.CryptMode.ENCRYPT, Stubs.getRuntimeCheckedCPUFeatures(CipherBlockChainingAESNode.class));
            return n;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int cbcAESDecrypt(Pointer from, Pointer to, Pointer key, Pointer r, int len) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(SVMIntrinsicStubsGen.CipherBlockChainingAESNode_getMinimumFeatures());
        try {
            int n = CipherBlockChainingAESNode.apply((Pointer)from, (Pointer)to, (Pointer)key, (Pointer)r, (int)len, (AESNode.CryptMode)AESNode.CryptMode.DECRYPT, SVMIntrinsicStubsGen.CipherBlockChainingAESNode_getMinimumFeatures());
            return n;
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int cbcAESDecryptRTC(Pointer from, Pointer to, Pointer key, Pointer r, int len) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(CipherBlockChainingAESNode.class));
        try {
            int n = CipherBlockChainingAESNode.apply((Pointer)from, (Pointer)to, (Pointer)key, (Pointer)r, (int)len, (AESNode.CryptMode)AESNode.CryptMode.DECRYPT, Stubs.getRuntimeCheckedCPUFeatures(CipherBlockChainingAESNode.class));
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Fold
    public static EnumSet<?> GHASHProcessBlocksNode_getMinimumFeatures() {
        Architecture arch = ((SubstrateTargetDescription)((Object)ImageSingletons.lookup(SubstrateTargetDescription.class))).arch;
        if (arch instanceof AMD64) {
            return GHASHProcessBlocksNode.minFeaturesAMD64();
        }
        if (arch instanceof AArch64) {
            return GHASHProcessBlocksNode.minFeaturesAARCH64();
        }
        throw GraalError.shouldNotReachHere();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void ghashProcessBlocks(Pointer state, Pointer hashSubkey, Pointer data, int blocks) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(SVMIntrinsicStubsGen.GHASHProcessBlocksNode_getMinimumFeatures());
        try {
            GHASHProcessBlocksNode.apply((Pointer)state, (Pointer)hashSubkey, (Pointer)data, (int)blocks, SVMIntrinsicStubsGen.GHASHProcessBlocksNode_getMinimumFeatures());
        }
        finally {
            region.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void ghashProcessBlocksRTC(Pointer state, Pointer hashSubkey, Pointer data, int blocks) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(GHASHProcessBlocksNode.class));
        try {
            GHASHProcessBlocksNode.apply((Pointer)state, (Pointer)hashSubkey, (Pointer)data, (int)blocks, Stubs.getRuntimeCheckedCPUFeatures(GHASHProcessBlocksNode.class));
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void multiplyToLen(Pointer x, int xlen, Pointer y, int ylen, Pointer z, int zlen) {
        BigIntegerMultiplyToLenNode.apply((Pointer)x, (int)xlen, (Pointer)y, (int)ylen, (Pointer)z, (int)zlen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void multiplyToLenRTC(Pointer x, int xlen, Pointer y, int ylen, Pointer z, int zlen) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(BigIntegerMultiplyToLenNode.class));
        try {
            BigIntegerMultiplyToLenNode.apply((Pointer)x, (int)xlen, (Pointer)y, (int)ylen, (Pointer)z, (int)zlen, Stubs.getRuntimeCheckedCPUFeatures(BigIntegerMultiplyToLenNode.class));
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int mulAdd(Pointer out, Pointer in, int offset, int len, int k) {
        return BigIntegerMulAddNode.apply((Pointer)out, (Pointer)in, (int)offset, (int)len, (int)k);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int mulAddRTC(Pointer out, Pointer in, int offset, int len, int k) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(BigIntegerMulAddNode.class));
        try {
            int n = BigIntegerMulAddNode.apply((Pointer)out, (Pointer)in, (int)offset, (int)len, (int)k, Stubs.getRuntimeCheckedCPUFeatures(BigIntegerMulAddNode.class));
            return n;
        }
        finally {
            region.leave();
        }
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void squareToLen(Pointer x, int len, Pointer z, int zlen) {
        BigIntegerSquareToLenNode.apply((Pointer)x, (int)len, (Pointer)z, (int)zlen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static void squareToLenRTC(Pointer x, int len, Pointer z, int zlen) {
        RuntimeCPUFeatureRegion region = RuntimeCPUFeatureRegion.enterSet(Stubs.getRuntimeCheckedCPUFeatures(BigIntegerSquareToLenNode.class));
        try {
            BigIntegerSquareToLenNode.apply((Pointer)x, (int)len, (Pointer)z, (int)zlen, Stubs.getRuntimeCheckedCPUFeatures(BigIntegerSquareToLenNode.class));
        }
        finally {
            region.leave();
        }
    }
}

