/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.sampler;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.sampler.ProfilingSampler;
import com.oracle.svm.core.sampler.SamplingStackVisitor;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.thread.ThreadListener;
import com.oracle.svm.core.thread.ThreadingSupportImpl;
import com.oracle.svm.core.util.TimeUtils;
import org.graalvm.collections.LockFreePrefixTree;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class SafepointProfilingSampler
implements ProfilingSampler,
ThreadListener {
    private static final int DEFAULT_STACK_SIZE = 8192;
    private final SamplingStackVisitor samplingStackVisitor = new SamplingStackVisitor();
    private final LockFreePrefixTree prefixTree = new LockFreePrefixTree((LockFreePrefixTree.Allocator)new LockFreePrefixTree.ObjectPoolingAllocator());

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SafepointProfilingSampler() {
    }

    @Override
    public void beforeThreadRun() {
        SamplingStackVisitor.StackTrace stackTrace = new SamplingStackVisitor.StackTrace(8192L);
        ThreadingSupportImpl.RecurringCallbackTimer callback = ThreadingSupportImpl.createRecurringCallbackTimer(TimeUtils.millisToNanos(10L), access -> this.sampleThreadStack(stackTrace));
        ThreadingSupportImpl.setRecurringCallback(CurrentIsolate.getCurrentThread(), callback);
    }

    @Override
    public LockFreePrefixTree prefixTree() {
        return this.prefixTree;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate inside the safepoint sampler.")
    private void sampleThreadStack(SamplingStackVisitor.StackTrace stackTrace) {
        stackTrace.reset();
        SafepointProfilingSampler.walkCurrentThread(stackTrace, this.samplingStackVisitor);
        if (stackTrace.overflow) {
            return;
        }
        long[] result = stackTrace.buffer;
        LockFreePrefixTree.Node node = this.prefixTree.root();
        for (int i = stackTrace.num - 1; i >= 0; --i) {
            if (i >= result.length) {
                return;
            }
            if ((node = this.descend(node, result[i])) != null) continue;
            return;
        }
        node.incValue();
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.UNRESTRICTED, reason="Allocations are not allowed in the safepoint sampler, but we keep them unrestricted due to analysis imprecision.")
    private LockFreePrefixTree.Node descend(LockFreePrefixTree.Node node, long result) {
        return node.at(this.prefixTree().allocator(), result);
    }

    @NeverInline(value="Starts a stack walk in the caller frame")
    private static void walkCurrentThread(SamplingStackVisitor.StackTrace data, SamplingStackVisitor visitor) {
        JavaStackWalker.walkCurrentThread(KnownIntrinsics.readStackPointer(), visitor, data);
    }
}

