/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.os.AbstractRawFileOperationSupport;
import com.oracle.svm.core.os.RawFileOperationSupport;
import com.oracle.svm.core.posix.PosixStat;
import com.oracle.svm.core.posix.headers.Errno;
import com.oracle.svm.core.posix.headers.Fcntl;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.util.VMError;
import java.io.File;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class PosixRawFileOperationSupport
extends AbstractRawFileOperationSupport {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public PosixRawFileOperationSupport(boolean useNativeByteOrder) {
        super(useNativeByteOrder);
    }

    @Override
    public RawFileOperationSupport.RawFileDescriptor create(File file, RawFileOperationSupport.FileCreationMode creationMode, RawFileOperationSupport.FileAccessMode accessMode) {
        String path = file.getPath();
        int flags = PosixRawFileOperationSupport.parseMode(creationMode) | PosixRawFileOperationSupport.parseMode(accessMode);
        return PosixRawFileOperationSupport.open0(path, flags);
    }

    @Override
    public RawFileOperationSupport.RawFileDescriptor open(File file, RawFileOperationSupport.FileAccessMode mode) {
        String path = file.getPath();
        int flags = PosixRawFileOperationSupport.parseMode(mode);
        return PosixRawFileOperationSupport.open0(path, flags);
    }

    private static RawFileOperationSupport.RawFileDescriptor open0(String path, int flags) {
        int permissions = PosixStat.S_IRUSR() | PosixStat.S_IWUSR();
        try (CTypeConversion.CCharPointerHolder cPath = CTypeConversion.toCString((CharSequence)path);){
            RawFileOperationSupport.RawFileDescriptor rawFileDescriptor = (RawFileOperationSupport.RawFileDescriptor)WordFactory.signed((int)Fcntl.NoTransitions.open(cPath.get(), flags, permissions));
            return rawFileDescriptor;
        }
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isValid(RawFileOperationSupport.RawFileDescriptor fd) {
        int posixFd = PosixRawFileOperationSupport.getPosixFileDescriptor(fd);
        return posixFd > 0;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean close(RawFileOperationSupport.RawFileDescriptor fd) {
        int posixFd = PosixRawFileOperationSupport.getPosixFileDescriptor(fd);
        int result = Unistd.NoTransitions.close(posixFd);
        return result == 0;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long size(RawFileOperationSupport.RawFileDescriptor fd) {
        int posixFd = PosixRawFileOperationSupport.getPosixFileDescriptor(fd);
        return PosixStat.getSize(posixFd);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long position(RawFileOperationSupport.RawFileDescriptor fd) {
        int posixFd = PosixRawFileOperationSupport.getPosixFileDescriptor(fd);
        return Unistd.NoTransitions.lseek(posixFd, WordFactory.signed((int)0), Unistd.SEEK_CUR()).rawValue();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean seek(RawFileOperationSupport.RawFileDescriptor fd, long position) {
        int posixFd = PosixRawFileOperationSupport.getPosixFileDescriptor(fd);
        SignedWord newPos = Unistd.NoTransitions.lseek(posixFd, WordFactory.signed((long)position), Unistd.SEEK_SET());
        return position == newPos.rawValue();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean write(RawFileOperationSupport.RawFileDescriptor fd, Pointer data, UnsignedWord size) {
        int posixFd = PosixRawFileOperationSupport.getPosixFileDescriptor(fd);
        Pointer position = data;
        UnsignedWord remaining = size;
        while (remaining.aboveThan(0)) {
            SignedWord writtenBytes = Unistd.NoTransitions.write(posixFd, (PointerBase)position, remaining);
            if (writtenBytes.equal(-1)) {
                if (LibC.errno() == Errno.EINTR()) continue;
                return false;
            }
            position = position.add((UnsignedWord)writtenBytes);
            remaining = remaining.subtract((UnsignedWord)writtenBytes);
        }
        return true;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long read(RawFileOperationSupport.RawFileDescriptor fd, Pointer buffer, UnsignedWord bufferSize) {
        SignedWord readBytes;
        int posixFd = PosixRawFileOperationSupport.getPosixFileDescriptor(fd);
        while ((readBytes = Unistd.NoTransitions.read(posixFd, (PointerBase)buffer, bufferSize)).equal(-1) && LibC.errno() == Errno.EINTR()) {
        }
        return readBytes.rawValue();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int getPosixFileDescriptor(RawFileOperationSupport.RawFileDescriptor fd) {
        int result = (int)fd.rawValue();
        assert ((long)result == fd.rawValue());
        return result;
    }

    private static int parseMode(RawFileOperationSupport.FileCreationMode mode) {
        switch (mode) {
            case CREATE: {
                return Fcntl.O_CREAT() | Fcntl.O_EXCL();
            }
            case CREATE_OR_REPLACE: {
                return Fcntl.O_CREAT() | Fcntl.O_TRUNC();
            }
        }
        throw VMError.shouldNotReachHere();
    }

    private static int parseMode(RawFileOperationSupport.FileAccessMode mode) {
        switch (mode) {
            case READ: {
                return Fcntl.O_RDONLY();
            }
            case READ_WRITE: {
                return Fcntl.O_RDWR();
            }
            case WRITE: {
                return Fcntl.O_WRONLY();
            }
        }
        throw VMError.shouldNotReachHere();
    }
}

