/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.heap.AbstractMemoryMXBean;
import java.lang.management.MemoryUsage;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class HeapImplMemoryMXBean
extends AbstractMemoryMXBean {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public HeapImplMemoryMXBean() {
    }

    @Override
    public MemoryUsage getHeapMemoryUsage() {
        long used = HeapImpl.getHeapImpl().getUsedBytes().rawValue();
        long committed = Math.max(used, HeapImpl.getHeapImpl().getCommittedBytes().rawValue());
        long max = GCImpl.getPolicy().getMaximumHeapSize().rawValue();
        if (max != -1L) {
            max = Math.max(committed, max);
        }
        return new MemoryUsage(-1L, used, committed, max);
    }
}

