/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.TypeResult;
import com.oracle.svm.core.configure.ConfigurationConditionResolver;
import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.configure.LegacyResourceConfigurationParser;
import com.oracle.svm.core.configure.ResourceMetadataParser;
import com.oracle.svm.core.configure.ResourcesRegistry;
import com.oracle.svm.core.jdk.localization.LocalizationSupport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.util.json.JSONParserException;

public abstract class ResourceConfigurationParser
extends ConfigurationParser {
    protected final ResourcesRegistry registry;
    protected final ConfigurationConditionResolver conditionResolver;

    public static ResourceConfigurationParser create(boolean strictMetadata, ResourcesRegistry registry, boolean strictConfiguration) {
        if (strictMetadata) {
            return new ResourceMetadataParser(ConfigurationConditionResolver.identityResolver(), registry, strictConfiguration);
        }
        return new LegacyResourceConfigurationParser(ConfigurationConditionResolver.identityResolver(), registry, strictConfiguration);
    }

    protected ResourceConfigurationParser(ConfigurationConditionResolver conditionResolver, ResourcesRegistry registry, boolean strictConfiguration) {
        super(strictConfiguration);
        this.registry = registry;
        this.conditionResolver = conditionResolver;
    }

    protected abstract ConfigurationCondition parseCondition(EconomicMap<String, Object> var1);

    protected void parseBundlesObject(Object bundlesObject) {
        List<Object> bundles = ResourceConfigurationParser.asList(bundlesObject, "Attribute 'bundles' must be a list of bundles");
        for (Object bundle : bundles) {
            this.parseBundle(bundle);
        }
    }

    private void parseBundle(Object bundle) {
        Object classNames;
        List<Locale> asList;
        EconomicMap<String, Object> resource = ResourceConfigurationParser.asMap(bundle, "Elements of 'bundles' list must be a bundle descriptor object");
        this.checkAttributes(resource, "bundle descriptor object", Collections.singletonList("name"), Arrays.asList("locales", "classNames", "condition"));
        String basename = ResourceConfigurationParser.asString(resource.get((Object)"name"));
        TypeResult<ConfigurationCondition> resolvedConfigurationCondition = this.conditionResolver.resolveCondition(this.parseCondition(resource));
        if (!resolvedConfigurationCondition.isPresent()) {
            return;
        }
        Object locales = resource.get((Object)"locales");
        if (locales != null && !(asList = ResourceConfigurationParser.asList(locales, "Attribute 'locales' must be a list of locales").stream().map(ResourceConfigurationParser::parseLocale).collect(Collectors.toList())).isEmpty()) {
            this.registry.addResourceBundles(resolvedConfigurationCondition.get(), basename, asList);
        }
        if ((classNames = resource.get((Object)"classNames")) != null) {
            List<Object> asList2 = ResourceConfigurationParser.asList(classNames, "Attribute 'classNames' must be a list of classes");
            for (Object o : asList2) {
                String className = ResourceConfigurationParser.asString(o);
                this.registry.addClassBasedResourceBundle(resolvedConfigurationCondition.get(), basename, className);
            }
        }
        if (locales == null && classNames == null) {
            this.registry.addResourceBundles(resolvedConfigurationCondition.get(), basename);
        }
    }

    private static Locale parseLocale(Object input) {
        String localeTag = ResourceConfigurationParser.asString(input);
        Locale locale = LocalizationSupport.parseLocaleFromTag(localeTag);
        if (locale == null) {
            throw new JSONParserException(localeTag + " is not a valid locale tag");
        }
        return locale;
    }

    public static String globToRegex(String module, String glob) {
        return (String)(module == null || module.isEmpty() ? "" : module + ":") + ResourceConfigurationParser.globToRegex(glob);
    }

    private static String globToRegex(String glob) {
        Object tmpGlob = glob + "#";
        StringBuilder sb = new StringBuilder();
        int quoteStartIndex = 0;
        Wildcard previousWildcard = Wildcard.START;
        for (int i = 0; i < ((String)tmpGlob).length(); ++i) {
            boolean wildcardEnd;
            boolean wildcardStart;
            char c = ((String)tmpGlob).charAt(i);
            Wildcard currentWildcard = previousWildcard.next(c);
            boolean bl = wildcardStart = previousWildcard == Wildcard.START && currentWildcard != Wildcard.START;
            if (wildcardStart && quoteStartIndex != i) {
                sb.append(Pattern.quote(((String)tmpGlob).substring(quoteStartIndex, i)));
            }
            boolean consecutiveWildcards = previousWildcard == Wildcard.DOUBLE_STAR_SLASH && currentWildcard != Wildcard.START;
            boolean bl2 = wildcardEnd = previousWildcard != Wildcard.START && currentWildcard == Wildcard.START;
            if (wildcardEnd || consecutiveWildcards) {
                sb.append(previousWildcard.regex);
                quoteStartIndex = i;
            }
            previousWildcard = currentWildcard;
        }
        if (quoteStartIndex < ((String)(tmpGlob = ((String)tmpGlob).substring(0, ((String)tmpGlob).length() - 1))).length()) {
            sb.append(Pattern.quote(((String)tmpGlob).substring(quoteStartIndex)));
        }
        return sb.toString();
    }

    protected void parseGlobsObject(Object globsObject) {
        List<Object> globs = ResourceConfigurationParser.asList(globsObject, "Attribute 'globs' must be a list of glob patterns");
        for (Object object : globs) {
            this.parseGlobEntry(object, (condition, module, resource) -> this.registry.addResources((ConfigurationCondition)condition, ResourceConfigurationParser.globToRegex(module, resource)));
        }
    }

    private void parseGlobEntry(Object data, GlobPatternConsumer<ConfigurationCondition> resourceRegistry) {
        EconomicMap<String, Object> globObject = ResourceConfigurationParser.asMap(data, "Elements of 'globs' list must be a glob descriptor objects");
        this.checkAttributes(globObject, "glob resource descriptor object", Collections.singletonList("glob"), List.of("condition", "module"));
        TypeResult<ConfigurationCondition> resolvedConfigurationCondition = this.conditionResolver.resolveCondition(this.parseCondition(globObject));
        if (!resolvedConfigurationCondition.isPresent()) {
            return;
        }
        Object moduleObject = globObject.get((Object)"module");
        String module = ResourceConfigurationParser.asNullableString(moduleObject, "module");
        Object valueObject = globObject.get((Object)"glob");
        String value = ResourceConfigurationParser.asString(valueObject, "glob");
        resourceRegistry.accept(resolvedConfigurationCondition.get(), module, value);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Wildcard {
        START(""){

            @Override
            public Wildcard next(char c) {
                return c == '*' ? STAR : START;
            }
        }
        ,
        STAR("[^/]*"){

            @Override
            public Wildcard next(char c) {
                return c == '*' ? DOUBLE_STAR : START;
            }
        }
        ,
        DOUBLE_STAR(".*"){

            @Override
            public Wildcard next(char c) {
                return c == '/' ? DOUBLE_STAR_SLASH : START;
            }
        }
        ,
        DOUBLE_STAR_SLASH("([^/]*(/|$))*"){

            @Override
            public Wildcard next(char c) {
                return c == '*' ? STAR : START;
            }
        };

        final String regex;

        private Wildcard(String val) {
            this.regex = val;
        }

        public abstract Wildcard next(char var1);
    }

    private static interface GlobPatternConsumer<T> {
        public void accept(T var1, String var2, String var3);
    }
}

