/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.hosted.annotation.AnnotationMemberValue;
import java.util.Collections;
import java.util.List;
import jdk.vm.ci.meta.JavaConstant;
import sun.reflect.annotation.ExceptionProxy;

public final class AnnotationExceptionProxyValue
extends AnnotationMemberValue {
    private final ExceptionProxy exceptionProxy;
    private final JavaConstant objectConstant;

    AnnotationExceptionProxyValue(ExceptionProxy exceptionProxy) {
        this.exceptionProxy = exceptionProxy;
        this.objectConstant = SubstrateObjectConstant.forObject(exceptionProxy);
    }

    public JavaConstant getObjectConstant() {
        return this.objectConstant;
    }

    @Override
    public char getTag() {
        return 'E';
    }

    @Override
    public Object get(Class<?> memberType) {
        return this.exceptionProxy;
    }

    @Override
    public List<Class<?>> getTypes() {
        return Collections.singletonList(this.exceptionProxy.getClass());
    }

    @Override
    public List<JavaConstant> getExceptionProxies() {
        return Collections.singletonList(this.objectConstant);
    }
}

